/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InstrumentedLock
implements Lock {
    private final Lock lock;
    private final Logger logger;
    private final String name;
    private final Timer clock;
    private final long minLoggingGap;
    private final long lockWarningThreshold;
    private volatile long lockAcquireTimestamp;
    private final AtomicLong lastLogTimestamp;
    private final AtomicLong warningsSuppressed = new AtomicLong(0L);

    public InstrumentedLock(String name, Logger logger, long minLoggingGapMs, long lockWarningThresholdMs) {
        this(name, logger, new ReentrantLock(), minLoggingGapMs, lockWarningThresholdMs);
    }

    public InstrumentedLock(String name, Logger logger, Lock lock, long minLoggingGapMs, long lockWarningThresholdMs) {
        this(name, logger, lock, minLoggingGapMs, lockWarningThresholdMs, new Timer());
    }

    @VisibleForTesting
    InstrumentedLock(String name, Logger logger, Lock lock, long minLoggingGapMs, long lockWarningThresholdMs, Timer clock) {
        this.name = name;
        this.lock = lock;
        this.clock = clock;
        this.logger = logger;
        this.minLoggingGap = minLoggingGapMs;
        this.lockWarningThreshold = lockWarningThresholdMs;
        this.lastLogTimestamp = new AtomicLong(clock.monotonicNow() - Math.max(this.minLoggingGap, this.lockWarningThreshold));
    }

    @Override
    public void lock() {
        this.lock.lock();
        this.startLockTiming();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
        this.startLockTiming();
    }

    @Override
    public boolean tryLock() {
        if (this.lock.tryLock()) {
            this.startLockTiming();
            return true;
        }
        return false;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (this.lock.tryLock(time, unit)) {
            this.startLockTiming();
            return true;
        }
        return false;
    }

    @Override
    public void unlock() {
        long localLockReleaseTime = this.clock.monotonicNow();
        long localLockAcquireTime = this.lockAcquireTimestamp;
        this.lock.unlock();
        this.check(localLockAcquireTime, localLockReleaseTime);
    }

    @Override
    public Condition newCondition() {
        return this.lock.newCondition();
    }

    @VisibleForTesting
    void logWarning(long lockHeldTime, long suppressed) {
        this.logger.warn(String.format("Lock held time above threshold: lock identifier: %s lockHeldTimeMs=%d ms. Suppressed %d lock warnings. The stack trace is: %s", this.name, lockHeldTime, suppressed, StringUtils.getStackTrace(Thread.currentThread())));
    }

    protected void startLockTiming() {
        this.lockAcquireTimestamp = this.clock.monotonicNow();
    }

    protected void check(long acquireTime, long releaseTime) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        long lockHeldTime = releaseTime - acquireTime;
        if (this.lockWarningThreshold - lockHeldTime < 0L) {
            long now;
            long localLastLogTs;
            do {
                long deltaSinceLastLog;
                if ((deltaSinceLastLog = (now = this.clock.monotonicNow()) - (localLastLogTs = this.lastLogTimestamp.get())) - this.minLoggingGap >= 0L) continue;
                this.warningsSuppressed.incrementAndGet();
                return;
            } while (!this.lastLogTimestamp.compareAndSet(localLastLogTs, now));
            long suppressed = this.warningsSuppressed.getAndSet(0L);
            this.logWarning(lockHeldTime, suppressed);
        }
    }

    protected Lock getLock() {
        return this.lock;
    }

    protected Timer getTimer() {
        return this.clock;
    }
}

