/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.ByteBufferUtil;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.HasEnhancedByteBufferAccess;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.ByteArrayStrategy;
import org.apache.hadoop.hdfs.ByteBufferStrategy;
import org.apache.hadoop.hdfs.CannotObtainBlockLengthException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.ReadStatistics;
import org.apache.hadoop.hdfs.ReaderStrategy;
import org.apache.hadoop.hdfs.client.impl.BlockReaderFactory;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.shortcircuit.ClientMmap;
import org.apache.hadoop.hdfs.util.IOUtilsClient;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.util.IdentityHashStore;
import org.apache.hadoop.util.StopWatch;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class DFSInputStream
extends FSInputStream
implements ByteBufferReadable,
CanSetDropBehind,
CanSetReadahead,
HasEnhancedByteBufferAccess,
CanUnbuffer,
StreamCapabilities {
    @VisibleForTesting
    public static boolean tcpReadsDisabledForTesting = false;
    private long hedgedReadOpsLoopNumForTesting = 0L;
    protected final DFSClient dfsClient;
    protected AtomicBoolean closed = new AtomicBoolean(false);
    protected final String src;
    protected final boolean verifyChecksum;
    private DatanodeInfo currentNode = null;
    protected LocatedBlock currentLocatedBlock = null;
    protected long pos = 0L;
    protected long blockEnd = -1L;
    private BlockReader blockReader = null;
    protected LocatedBlocks locatedBlocks = null;
    private long lastBlockBeingWrittenLength = 0L;
    private FileEncryptionInfo fileEncryptionInfo = null;
    protected CachingStrategy cachingStrategy;
    protected final ReadStatistics readStatistics = new ReadStatistics();
    protected final Object infoLock = new Object();
    private final long refreshReadBlockIntervals;
    private long locatedBlocksTimeStamp;
    private IdentityHashStore<ByteBuffer, Object> extendedReadBuffers;
    protected int failures = 0;
    private final ConcurrentHashMap<DatanodeInfo, DatanodeInfo> deadNodes = new ConcurrentHashMap();
    private byte[] oneByteBuf;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0).asReadOnlyBuffer();

    private synchronized IdentityHashStore<ByteBuffer, Object> getExtendedReadBuffers() {
        if (this.extendedReadBuffers == null) {
            this.extendedReadBuffers = new IdentityHashStore(0);
        }
        return this.extendedReadBuffers;
    }

    private boolean isPeriodicRefreshEnabled() {
        return this.refreshReadBlockIntervals > 0L;
    }

    void addToDeadNodes(DatanodeInfo dnInfo) {
        this.deadNodes.put(dnInfo, dnInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DFSInputStream(DFSClient dfsClient, String src, boolean verifyChecksum, LocatedBlocks locatedBlocks) throws IOException {
        this.dfsClient = dfsClient;
        this.refreshReadBlockIntervals = this.dfsClient.getRefreshReadBlkLocationsInterval();
        this.setLocatedBlocksTimeStamp();
        this.verifyChecksum = verifyChecksum;
        this.src = src;
        Object object = this.infoLock;
        synchronized (object) {
            this.cachingStrategy = dfsClient.getDefaultReadCachingStrategy();
        }
        this.locatedBlocks = locatedBlocks;
        this.openInfo(false);
    }

    @VisibleForTesting
    long getlastBlockBeingWrittenLengthForTesting() {
        return this.lastBlockBeingWrittenLength;
    }

    @VisibleForTesting
    boolean deadNodesContain(DatanodeInfo nodeInfo) {
        return this.deadNodes.containsKey(nodeInfo);
    }

    @VisibleForTesting
    void setReadTimeStampsForTesting(long timeStamp) {
        this.setLocatedBlocksTimeStamp(timeStamp);
    }

    private void setLocatedBlocksTimeStamp() {
        this.setLocatedBlocksTimeStamp(Time.monotonicNow());
    }

    private void setLocatedBlocksTimeStamp(long timeStamp) {
        this.locatedBlocksTimeStamp = timeStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openInfo(boolean refreshLocatedBlocks) throws IOException {
        DfsClientConf conf = this.dfsClient.getConf();
        Object object = this.infoLock;
        synchronized (object) {
            int retriesForLastBlockLength;
            this.lastBlockBeingWrittenLength = this.fetchLocatedBlocksAndGetLastBlockLength(refreshLocatedBlocks);
            for (retriesForLastBlockLength = conf.getRetryTimesForGetLastBlockLength(); retriesForLastBlockLength > 0 && this.lastBlockBeingWrittenLength == -1L; --retriesForLastBlockLength) {
                DFSClient.LOG.warn("Last block locations not available. Datanodes might not have reported blocks completely. Will retry for " + retriesForLastBlockLength + " times");
                this.waitFor(conf.getRetryIntervalForGetLastBlockLength());
                this.lastBlockBeingWrittenLength = this.fetchLocatedBlocksAndGetLastBlockLength(true);
            }
            if (this.lastBlockBeingWrittenLength == -1L && retriesForLastBlockLength == 0) {
                throw new IOException("Could not obtain the last block locations.");
            }
        }
    }

    private void waitFor(int waitTime) throws IOException {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Interrupted while getting the last block length.");
        }
    }

    private boolean isLocatedBlocksExpired() {
        if (!this.isPeriodicRefreshEnabled()) {
            return false;
        }
        long now = Time.monotonicNow();
        long elapsed = now - this.locatedBlocksTimeStamp;
        return elapsed >= this.refreshReadBlockIntervals;
    }

    private boolean updateBlockLocationsStamp() throws IOException {
        if (!this.isLocatedBlocksExpired()) {
            return false;
        }
        this.deadNodes.clear();
        this.openInfo(true);
        this.setLocatedBlocksTimeStamp();
        return true;
    }

    private long fetchLocatedBlocksAndGetLastBlockLength(boolean refresh) throws IOException {
        LocatedBlocks newInfo = this.locatedBlocks;
        if (this.locatedBlocks == null || refresh) {
            newInfo = this.dfsClient.getLocatedBlocks(this.src, 0L);
        }
        DFSClient.LOG.debug("newInfo = {}", (Object)newInfo);
        if (newInfo == null) {
            throw new IOException("Cannot open filename " + this.src);
        }
        if (this.locatedBlocks != null) {
            Iterator<LocatedBlock> oldIter = this.locatedBlocks.getLocatedBlocks().iterator();
            Iterator<LocatedBlock> newIter = newInfo.getLocatedBlocks().iterator();
            while (oldIter.hasNext() && newIter.hasNext()) {
                if (oldIter.next().getBlock().equals(newIter.next().getBlock())) continue;
                throw new IOException("Blocklist for " + this.src + " has changed!");
            }
        }
        this.locatedBlocks = newInfo;
        long lastBlkBeingWrittenLength = this.getLastBlockLength();
        this.fileEncryptionInfo = this.locatedBlocks.getFileEncryptionInfo();
        return lastBlkBeingWrittenLength;
    }

    private long getLastBlockLength() throws IOException {
        LocatedBlock last;
        long lastBlockBeingWrittenLength = 0L;
        if (!this.locatedBlocks.isLastBlockComplete() && (last = this.locatedBlocks.getLastLocatedBlock()) != null) {
            if (last.getLocations().length == 0) {
                if (last.getBlockSize() == 0L) {
                    return 0L;
                }
                return -1L;
            }
            long len = this.readBlockLength(last);
            last.getBlock().setNumBytes(len);
            lastBlockBeingWrittenLength = len;
        }
        return lastBlockBeingWrittenLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private long readBlockLength(LocatedBlock locatedblock) throws IOException {
        if (!DFSInputStream.$assertionsDisabled && locatedblock == null) {
            throw new AssertionError((Object)"LocatedBlock cannot be null");
        }
        replicaNotFoundCount = locatedblock.getLocations().length;
        conf = this.dfsClient.getConf();
        timeout = conf.getSocketTimeout();
        nodeList = new LinkedList<DatanodeInfo>(Arrays.asList(locatedblock.getLocations()));
        retryList = new LinkedList<DatanodeInfo>();
        isRetry = false;
        sw = new StopWatch();
        while (nodeList.size() > 0) {
            block19: {
                block20: {
                    datanode = nodeList.pop();
                    cdp = null;
                    try {
                        cdp = DFSUtilClient.createClientDatanodeProtocolProxy(datanode, this.dfsClient.getConfiguration(), timeout, conf.isConnectToDnViaHostname(), locatedblock);
                        n = cdp.getReplicaVisibleLength(locatedblock.getBlock());
                        if (n < 0L) break block19;
                        var13_14 = n;
                        if (cdp == null) break block20;
                    }
                    catch (IOException ioe) {
                        try {
                            this.checkInterrupted(ioe);
                            if (ioe instanceof RemoteException) {
                                if (((RemoteException)ioe).unwrapRemoteException() instanceof ReplicaNotFoundException) {
                                    --replicaNotFoundCount;
                                } else if (((RemoteException)ioe).unwrapRemoteException() instanceof RetriableException) {
                                    retryList.add(datanode);
                                }
                            }
                            DFSClient.LOG.debug("Failed to getReplicaVisibleLength from datanode {} for block {}", new Object[]{datanode, locatedblock.getBlock(), ioe});
                            ** if (cdp == null) goto lbl-1000
                        }
                        catch (Throwable var15_15) {
                            if (cdp != null) {
                                RPC.stopProxy(cdp);
                            }
                            throw var15_15;
                        }
lbl-1000:
                        // 1 sources

                        {
                            RPC.stopProxy(cdp);
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    RPC.stopProxy(cdp);
                }
                return var13_14;
            }
            if (cdp != null) {
                RPC.stopProxy(cdp);
            }
            if (nodeList.size() == 0 && retryList.size() > 0) {
                nodeList.addAll(retryList);
                retryList.clear();
                isRetry = true;
            }
            if (isRetry) {
                if (!sw.isRunning()) {
                    sw.start();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted while getting the length.");
                }
            }
            if (!sw.isRunning() || sw.now(TimeUnit.MILLISECONDS) <= (long)timeout) continue;
            break;
        }
        if (replicaNotFoundCount == 0) {
            return 0L;
        }
        throw new CannotObtainBlockLengthException(locatedblock, this.src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileLength() {
        Object object = this.infoLock;
        synchronized (object) {
            return this.locatedBlocks == null ? 0L : this.locatedBlocks.getFileLength() + this.lastBlockBeingWrittenLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shortCircuitForbidden() {
        Object object = this.infoLock;
        synchronized (object) {
            return this.locatedBlocks.isUnderConstruction();
        }
    }

    public synchronized DatanodeInfo getCurrentDatanode() {
        return this.currentNode;
    }

    public synchronized ExtendedBlock getCurrentBlock() {
        if (this.currentLocatedBlock == null) {
            return null;
        }
        return this.currentLocatedBlock.getBlock();
    }

    public List<LocatedBlock> getAllBlocks() throws IOException {
        return this.getBlockRange(0L, this.getFileLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocatedBlock getBlockAt(long offset) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            if (offset < 0L || offset >= this.getFileLength()) {
                throw new IOException("offset < 0 || offset >= getFileLength(), offset=" + offset + ", locatedBlocks=" + this.locatedBlocks);
            }
            LocatedBlock blk = offset >= this.locatedBlocks.getFileLength() ? this.locatedBlocks.getLastLocatedBlock() : this.fetchBlockAt(offset, 0L, true);
            return blk;
        }
    }

    protected LocatedBlock fetchBlockAt(long offset) throws IOException {
        return this.fetchBlockAt(offset, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlock fetchBlockAt(long offset, long length, boolean useCache) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            this.updateBlockLocationsStamp();
            int targetBlockIdx = this.locatedBlocks.findBlock(offset);
            if (targetBlockIdx < 0) {
                targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
                useCache = false;
            }
            if (!useCache) {
                LocatedBlocks newBlocks;
                LocatedBlocks locatedBlocks = newBlocks = length == 0L ? this.dfsClient.getLocatedBlocks(this.src, offset) : this.dfsClient.getLocatedBlocks(this.src, offset, length);
                if (newBlocks == null || newBlocks.locatedBlockCount() == 0) {
                    throw new EOFException("Could not find target position " + offset);
                }
                if (offset >= this.locatedBlocks.getFileLength()) {
                    this.locatedBlocks = newBlocks;
                    this.lastBlockBeingWrittenLength = this.getLastBlockLength();
                } else {
                    this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
                }
            }
            return this.locatedBlocks.get(targetBlockIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocatedBlock> getBlockRange(long offset, long length) throws IOException {
        if (offset >= this.getFileLength()) {
            throw new IOException("Offset: " + offset + " exceeds file length: " + this.getFileLength());
        }
        Object object = this.infoLock;
        synchronized (object) {
            long lengthOfCompleteBlk = this.locatedBlocks.getFileLength();
            boolean readOffsetWithinCompleteBlk = offset < lengthOfCompleteBlk;
            boolean readLengthPastCompleteBlk = offset + length > lengthOfCompleteBlk;
            List<LocatedBlock> blocks = readOffsetWithinCompleteBlk ? this.getFinalizedBlockRange(offset, Math.min(length, lengthOfCompleteBlk - offset)) : new ArrayList<LocatedBlock>(1);
            if (readLengthPastCompleteBlk) {
                blocks.add(this.locatedBlocks.getLastLocatedBlock());
            }
            return blocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocatedBlock> getFinalizedBlockRange(long offset, long length) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            ArrayList<LocatedBlock> blockRange = new ArrayList<LocatedBlock>();
            long remaining = length;
            long curOff = offset;
            while (remaining > 0L) {
                LocatedBlock blk = this.fetchBlockAt(curOff, remaining, true);
                assert (curOff >= blk.getStartOffset()) : "Block not found";
                blockRange.add(blk);
                long bytesRead = blk.getStartOffset() + blk.getBlockSize() - curOff;
                remaining -= bytesRead;
                curOff += bytesRead;
            }
            return blockRange;
        }
    }

    private synchronized DatanodeInfo blockSeekTo(long target) throws IOException {
        if (target >= this.getFileLength()) {
            throw new IOException("Attempted to read past end of file");
        }
        this.closeCurrentBlockReaders();
        int refetchToken = 1;
        int refetchEncryptionKey = 1;
        boolean connectFailedOnce = false;
        while (true) {
            this.updateBlockLocationsStamp();
            LocatedBlock targetBlock = this.getBlockAt(target);
            this.pos = target;
            this.blockEnd = targetBlock.getStartOffset() + targetBlock.getBlockSize() - 1L;
            this.currentLocatedBlock = targetBlock;
            long offsetIntoBlock = target - targetBlock.getStartOffset();
            DNAddrPair retval = this.chooseDataNode(targetBlock, null);
            DatanodeInfo chosenNode = retval.info;
            InetSocketAddress targetAddr = retval.addr;
            StorageType storageType = retval.storageType;
            targetBlock = retval.block;
            try {
                this.blockReader = this.getBlockReader(targetBlock, offsetIntoBlock, targetBlock.getBlockSize() - offsetIntoBlock, targetAddr, storageType, chosenNode);
                if (connectFailedOnce) {
                    DFSClient.LOG.info("Successfully connected to " + targetAddr + " for " + targetBlock.getBlock());
                }
                return chosenNode;
            }
            catch (IOException ex) {
                this.checkInterrupted(ex);
                if (ex instanceof InvalidEncryptionKeyException && refetchEncryptionKey > 0) {
                    DFSClient.LOG.info("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + targetAddr + " : " + ex);
                    --refetchEncryptionKey;
                    this.dfsClient.clearDataEncryptionKey();
                    continue;
                }
                if (refetchToken > 0 && DFSInputStream.tokenRefetchNeeded(ex, targetAddr)) {
                    --refetchToken;
                    this.fetchBlockAt(target);
                    continue;
                }
                connectFailedOnce = true;
                DFSClient.LOG.warn("Failed to connect to {} for file {} for block {}, add to deadNodes and continue. ", new Object[]{targetAddr, this.src, targetBlock.getBlock(), ex});
                this.addToDeadNodes(chosenNode);
                continue;
            }
            break;
        }
    }

    private void checkInterrupted(IOException e) throws IOException {
        if (Thread.currentThread().isInterrupted() && (e instanceof ClosedByInterruptException || e instanceof InterruptedIOException)) {
            DFSClient.LOG.debug("The reading thread has been interrupted.", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockReader getBlockReader(LocatedBlock targetBlock, long offsetInBlock, long length, InetSocketAddress targetAddr, StorageType storageType, DatanodeInfo datanode) throws IOException {
        boolean shortCircuitForbidden;
        CachingStrategy curCachingStrategy;
        ExtendedBlock blk = targetBlock.getBlock();
        Token<BlockTokenIdentifier> accessToken = targetBlock.getBlockToken();
        Object object = this.infoLock;
        synchronized (object) {
            curCachingStrategy = this.cachingStrategy;
            shortCircuitForbidden = this.shortCircuitForbidden();
        }
        return new BlockReaderFactory(this.dfsClient.getConf()).setInetSocketAddress(targetAddr).setRemotePeerFactory(this.dfsClient).setDatanodeInfo(datanode).setStorageType(storageType).setFileName(this.src).setBlock(blk).setBlockToken(accessToken).setStartOffset(offsetInBlock).setVerifyChecksum(this.verifyChecksum).setClientName(this.dfsClient.clientName).setLength(length).setCachingStrategy(curCachingStrategy).setAllowShortCircuitLocalReads(!shortCircuitForbidden).setClientCacheContext(this.dfsClient.getClientContext()).setUserGroupInformation(this.dfsClient.ugi).setConfiguration(this.dfsClient.getConfiguration()).build();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            DFSClient.LOG.debug("DFSInputStream has been closed already");
            return;
        }
        this.dfsClient.checkOpen();
        if (this.extendedReadBuffers != null && !this.extendedReadBuffers.isEmpty()) {
            final StringBuilder builder = new StringBuilder();
            this.extendedReadBuffers.visitAll(new IdentityHashStore.Visitor<ByteBuffer, Object>(){
                private String prefix = "";

                @Override
                public void accept(ByteBuffer k, Object v) {
                    builder.append(this.prefix).append(k);
                    this.prefix = ", ";
                }
            });
            DFSClient.LOG.warn("closing file " + this.src + ", but there are still unreleased ByteBuffers allocated by read().  Please release " + builder.toString() + ".");
        }
        this.closeCurrentBlockReaders();
        super.close();
    }

    @Override
    public synchronized int read() throws IOException {
        int ret;
        if (this.oneByteBuf == null) {
            this.oneByteBuf = new byte[1];
        }
        return (ret = this.read(this.oneByteBuf, 0, 1)) <= 0 ? -1 : this.oneByteBuf[0] & 0xFF;
    }

    private synchronized int readBuffer(ReaderStrategy reader, int len, DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        boolean retryCurrentNode = true;
        while (true) {
            boolean sourceFound;
            IOException ioe;
            try {
                return reader.readFromBlock(this.blockReader, len);
            }
            catch (ChecksumException ce) {
                DFSClient.LOG.warn("Found Checksum error for " + this.getCurrentBlock() + " from " + this.currentNode + " at " + ce.getPos());
                ioe = ce;
                retryCurrentNode = false;
                corruptedBlocks.addCorruptedBlock(this.getCurrentBlock(), this.currentNode);
            }
            catch (IOException e) {
                if (!retryCurrentNode) {
                    DFSClient.LOG.warn("Exception while reading from " + this.getCurrentBlock() + " of " + this.src + " from " + this.currentNode, (Throwable)e);
                }
                ioe = e;
            }
            if (retryCurrentNode) {
                sourceFound = this.seekToBlockSource(this.pos);
            } else {
                this.addToDeadNodes(this.currentNode);
                sourceFound = this.seekToNewSource(this.pos);
            }
            if (!sourceFound) {
                throw ioe;
            }
            retryCurrentNode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int readWithStrategy(ReaderStrategy strategy) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        int len = strategy.getTargetLength();
        DFSUtilClient.CorruptedBlocks corruptedBlocks = new DFSUtilClient.CorruptedBlocks();
        this.failures = 0;
        if (this.pos < this.getFileLength()) {
            int retries = 2;
            while (retries > 0) {
                try {
                    if (this.pos > this.blockEnd || this.currentNode == null || this.updateBlockLocationsStamp()) {
                        this.currentNode = this.blockSeekTo(this.pos);
                    }
                    int realLen = (int)Math.min((long)len, this.blockEnd - this.pos + 1L);
                    Object object = this.infoLock;
                    synchronized (object) {
                        if (this.locatedBlocks.isLastBlockComplete()) {
                            realLen = (int)Math.min((long)realLen, this.locatedBlocks.getFileLength() - this.pos);
                        }
                    }
                    int result = this.readBuffer(strategy, realLen, corruptedBlocks);
                    if (result >= 0) {
                        this.pos += (long)result;
                    } else {
                        throw new IOException("Unexpected EOS from the reader");
                    }
                    IOUtilsClient.updateReadStatistics(this.readStatistics, result, this.blockReader);
                    this.dfsClient.updateFileSystemReadStats(this.blockReader.getNetworkDistance(), result);
                    if (this.readStatistics.getBlockType() == BlockType.STRIPED) {
                        this.dfsClient.updateFileSystemECReadStats(result);
                    }
                    int n = result;
                    return n;
                }
                catch (ChecksumException ce) {
                    throw ce;
                }
                catch (IOException e) {
                    this.checkInterrupted(e);
                    if (retries == 1) {
                        DFSClient.LOG.warn("DFS Read", (Throwable)e);
                    }
                    this.blockEnd = -1L;
                    if (this.currentNode != null) {
                        this.addToDeadNodes(this.currentNode);
                    }
                    if (--retries != 0) continue;
                    throw e;
                }
                finally {
                    this.reportCheckSumFailure(corruptedBlocks, this.getCurrentBlockLocationsLength(), false);
                }
            }
        }
        return -1;
    }

    protected int getCurrentBlockLocationsLength() {
        int len = 0;
        if (this.currentLocatedBlock == null) {
            DFSClient.LOG.info("Found null currentLocatedBlock. pos={}, blockEnd={}, fileLength={}", new Object[]{this.pos, this.blockEnd, this.getFileLength()});
        } else {
            len = this.currentLocatedBlock.getLocations().length;
        }
        return len;
    }

    @Override
    public synchronized int read(@Nonnull byte[] buf, int off, int len) throws IOException {
        this.validatePositionedReadArgs(this.pos, buf, off, len);
        if (len == 0) {
            return 0;
        }
        ByteArrayStrategy byteArrayReader = new ByteArrayStrategy(buf, off, len, this.readStatistics, this.dfsClient);
        return this.readWithStrategy(byteArrayReader);
    }

    @Override
    public synchronized int read(ByteBuffer buf) throws IOException {
        ByteBufferStrategy byteBufferReader = new ByteBufferStrategy(buf, this.readStatistics, this.dfsClient);
        return this.readWithStrategy(byteBufferReader);
    }

    private DNAddrPair chooseDataNode(LocatedBlock block, Collection<DatanodeInfo> ignoredNodes) throws IOException {
        return this.chooseDataNode(block, ignoredNodes, true);
    }

    private DNAddrPair chooseDataNode(LocatedBlock block, Collection<DatanodeInfo> ignoredNodes, boolean refetchIfRequired) throws IOException {
        while (true) {
            DNAddrPair result;
            if ((result = this.getBestNodeDNAddrPair(block, ignoredNodes)) != null) {
                return result;
            }
            if (!refetchIfRequired) break;
            block = this.refetchLocations(block, ignoredNodes);
        }
        return null;
    }

    private LocatedBlock refetchLocations(LocatedBlock block, Collection<DatanodeInfo> ignoredNodes) throws IOException {
        String errMsg = DFSInputStream.getBestNodeDNAddrPairErrorString(block.getLocations(), this.deadNodes, ignoredNodes);
        String blockInfo = block.getBlock() + " file=" + this.src;
        if (this.failures >= this.dfsClient.getConf().getMaxBlockAcquireFailures()) {
            String description = "Could not obtain block: " + blockInfo;
            DFSClient.LOG.warn(description + errMsg + ". Throwing a BlockMissingException");
            throw new BlockMissingException(this.src, description + errMsg, block.getStartOffset());
        }
        DatanodeInfo[] nodes = block.getLocations();
        if (nodes == null || nodes.length == 0) {
            DFSClient.LOG.info("No node available for " + blockInfo);
        }
        DFSClient.LOG.info("Could not obtain " + block.getBlock() + " from any node: " + errMsg + ". Will get new block locations from namenode and retry...");
        try {
            int timeWindow = this.dfsClient.getConf().getTimeWindow();
            double waitTime = (double)(timeWindow * this.failures) + (double)(timeWindow * (this.failures + 1)) * ThreadLocalRandom.current().nextDouble();
            DFSClient.LOG.warn("DFS chooseDataNode: got # " + (this.failures + 1) + " IOException, will wait for " + waitTime + " msec.");
            Thread.sleep((long)waitTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Interrupted while choosing DataNode for read.");
        }
        this.deadNodes.clear();
        this.openInfo(true);
        block = this.refreshLocatedBlock(block);
        ++this.failures;
        return block;
    }

    protected DNAddrPair getBestNodeDNAddrPair(LocatedBlock block, Collection<DatanodeInfo> ignoredNodes) {
        DatanodeInfo[] nodes = block.getLocations();
        StorageType[] storageTypes = block.getStorageTypes();
        DatanodeID chosenNode = null;
        StorageType storageType = null;
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (this.deadNodes.containsKey(nodes[i]) || ignoredNodes != null && ignoredNodes.contains(nodes[i])) continue;
                chosenNode = nodes[i];
                if (storageTypes == null || i >= storageTypes.length) break;
                storageType = storageTypes[i];
                break;
            }
        }
        if (chosenNode == null) {
            this.reportLostBlock(block, ignoredNodes);
            return null;
        }
        String dnAddr = chosenNode.getXferAddr(this.dfsClient.getConf().isConnectToDnViaHostname());
        DFSClient.LOG.debug("Connecting to datanode {}", (Object)dnAddr);
        InetSocketAddress targetAddr = NetUtils.createSocketAddr(dnAddr);
        return new DNAddrPair((DatanodeInfo)chosenNode, targetAddr, storageType, block);
    }

    protected void reportLostBlock(LocatedBlock lostBlock, Collection<DatanodeInfo> ignoredNodes) {
        Object[] nodes = lostBlock.getLocations();
        DFSClient.LOG.warn("No live nodes contain block " + lostBlock.getBlock() + " after checking nodes = " + Arrays.toString(nodes) + ", ignoredNodes = " + ignoredNodes);
    }

    private static String getBestNodeDNAddrPairErrorString(DatanodeInfo[] nodes, AbstractMap<DatanodeInfo, DatanodeInfo> deadNodes, Collection<DatanodeInfo> ignoredNodes) {
        StringBuilder errMsgr = new StringBuilder(" No live nodes contain current block ");
        errMsgr.append("Block locations:");
        for (DatanodeInfo datanode : nodes) {
            errMsgr.append(" ");
            errMsgr.append(datanode.toString());
        }
        errMsgr.append(" Dead nodes: ");
        for (DatanodeInfo datanode : deadNodes.keySet()) {
            errMsgr.append(" ");
            errMsgr.append(datanode.toString());
        }
        if (ignoredNodes != null) {
            errMsgr.append(" Ignored nodes: ");
            for (DatanodeInfo datanode : ignoredNodes) {
                errMsgr.append(" ");
                errMsgr.append(datanode.toString());
            }
        }
        return errMsgr.toString();
    }

    protected void fetchBlockByteRange(LocatedBlock block, long start, long end, ByteBuffer buf, DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        while (true) {
            DNAddrPair addressPair = this.chooseDataNode(block, null);
            block = addressPair.block;
            try {
                this.actualGetFromOneDataNode(addressPair, start, end, buf, corruptedBlocks);
                return;
            }
            catch (IOException e) {
                this.checkInterrupted(e);
                continue;
            }
            break;
        }
    }

    private Callable<ByteBuffer> getFromOneDataNode(final DNAddrPair datanode, LocatedBlock block, final long start, final long end, final ByteBuffer bb, final DFSUtilClient.CorruptedBlocks corruptedBlocks, int hedgedReadId) {
        return new Callable<ByteBuffer>(){

            @Override
            public ByteBuffer call() throws Exception {
                DFSClientFaultInjector.get().sleepBeforeHedgedGet();
                DFSInputStream.this.actualGetFromOneDataNode(datanode, start, end, bb, corruptedBlocks);
                return bb;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actualGetFromOneDataNode(DNAddrPair datanode, long startInBlk, long endInBlk, ByteBuffer buf, DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        DFSClientFaultInjector.get().startFetchFromDatanode();
        int refetchToken = 1;
        int refetchEncryptionKey = 1;
        int len = (int)(endInBlk - startInBlk + 1L);
        LocatedBlock block = datanode.block;
        while (true) {
            BlockReader reader = null;
            try {
                int ret;
                DFSClientFaultInjector.get().fetchFromDatanodeException();
                reader = this.getBlockReader(block, startInBlk, len, datanode.addr, datanode.storageType, datanode.info);
                ByteBuffer tmp = buf.duplicate();
                tmp.limit(tmp.position() + len);
                tmp = tmp.slice();
                int nread = 0;
                while ((ret = reader.read(tmp)) > 0) {
                    nread += ret;
                }
                buf.position(buf.position() + nread);
                IOUtilsClient.updateReadStatistics(this.readStatistics, nread, reader);
                this.dfsClient.updateFileSystemReadStats(reader.getNetworkDistance(), nread);
                if (this.readStatistics.getBlockType() == BlockType.STRIPED) {
                    this.dfsClient.updateFileSystemECReadStats(nread);
                }
                if (nread != len) {
                    throw new IOException("truncated return from reader.read(): excpected " + len + ", got " + nread);
                }
                DFSClientFaultInjector.get().readFromDatanodeDelay();
                return;
            }
            catch (ChecksumException e) {
                String msg = "fetchBlockByteRange(). Got a checksum exception for " + this.src + " at " + block.getBlock() + ":" + e.getPos() + " from " + datanode.info;
                DFSClient.LOG.warn(msg);
                corruptedBlocks.addCorruptedBlock(block.getBlock(), datanode.info);
                this.addToDeadNodes(datanode.info);
                throw new IOException(msg);
            }
            catch (IOException e) {
                this.checkInterrupted(e);
                if (e instanceof InvalidEncryptionKeyException && refetchEncryptionKey > 0) {
                    DFSClient.LOG.info("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + datanode.addr + " : " + e);
                    --refetchEncryptionKey;
                    this.dfsClient.clearDataEncryptionKey();
                } else if (refetchToken > 0 && DFSInputStream.tokenRefetchNeeded(e, datanode.addr)) {
                    --refetchToken;
                    try {
                        this.fetchBlockAt(block.getStartOffset());
                    }
                    catch (IOException msg) {}
                } else {
                    String msg = "Failed to connect to " + datanode.addr + " for file " + this.src + " for block " + block.getBlock() + ":" + e;
                    DFSClient.LOG.warn("Connection failure: " + msg, (Throwable)e);
                    this.addToDeadNodes(datanode.info);
                    throw new IOException(msg);
                }
                block = this.refreshLocatedBlock(block);
                continue;
            }
            finally {
                if (reader == null) continue;
                reader.close();
                continue;
            }
            break;
        }
    }

    protected LocatedBlock refreshLocatedBlock(LocatedBlock block) throws IOException {
        return this.getBlockAt(block.getStartOffset());
    }

    private void hedgedFetchBlockByteRange(LocatedBlock block, long start, long end, ByteBuffer buf, DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        DfsClientConf conf = this.dfsClient.getConf();
        ArrayList<Future<ByteBuffer>> futures = new ArrayList<Future<ByteBuffer>>();
        ExecutorCompletionService<ByteBuffer> hedgedService = new ExecutorCompletionService<ByteBuffer>(this.dfsClient.getHedgedReadsThreadPool());
        ArrayList<DatanodeInfo> ignored = new ArrayList<DatanodeInfo>();
        int len = (int)(end - start + 1L);
        int hedgedReadId = 0;
        while (true) {
            ByteBuffer bb;
            ++this.hedgedReadOpsLoopNumForTesting;
            DNAddrPair chosenNode = null;
            if (futures.isEmpty()) {
                chosenNode = this.chooseDataNode(block, ignored);
                block = chosenNode.block;
                bb = ByteBuffer.allocate(len);
                Callable<ByteBuffer> getFromDataNodeCallable = this.getFromOneDataNode(chosenNode, block, start, end, bb, corruptedBlocks, hedgedReadId++);
                Future<ByteBuffer> firstRequest = hedgedService.submit(getFromDataNodeCallable);
                futures.add(firstRequest);
                Future future = null;
                try {
                    future = hedgedService.poll(conf.getHedgedReadThresholdMillis(), TimeUnit.MILLISECONDS);
                    if (future != null) {
                        ByteBuffer result = (ByteBuffer)future.get();
                        result.flip();
                        buf.put(result);
                        return;
                    }
                    DFSClient.LOG.debug("Waited {}ms to read from {}; spawning hedged read", (Object)conf.getHedgedReadThresholdMillis(), (Object)chosenNode.info);
                    this.dfsClient.getHedgedReadMetrics().incHedgedReadOps();
                }
                catch (ExecutionException e) {
                    futures.remove(future);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted while waiting for reading task");
                }
                ignored.add(chosenNode.info);
                continue;
            }
            boolean refetch = false;
            try {
                chosenNode = this.chooseDataNode(block, ignored, false);
                if (chosenNode != null) {
                    block = chosenNode.block;
                    bb = ByteBuffer.allocate(len);
                    Callable<ByteBuffer> getFromDataNodeCallable = this.getFromOneDataNode(chosenNode, block, start, end, bb, corruptedBlocks, hedgedReadId++);
                    Future<ByteBuffer> oneMoreRequest = hedgedService.submit(getFromDataNodeCallable);
                    futures.add(oneMoreRequest);
                } else {
                    refetch = true;
                }
            }
            catch (IOException ioe) {
                DFSClient.LOG.debug("Failed getting node for hedged read: {}", (Object)ioe.getMessage());
            }
            try {
                ByteBuffer result = this.getFirstToComplete(hedgedService, futures);
                this.cancelAll(futures);
                this.dfsClient.getHedgedReadMetrics().incHedgedReadWins();
                result.flip();
                buf.put(result);
                return;
            }
            catch (InterruptedException interruptedException) {
                if (refetch) {
                    this.refetchLocations(block, ignored);
                }
                if (chosenNode == null || chosenNode.info == null) continue;
                ignored.add(chosenNode.info);
                continue;
            }
            break;
        }
    }

    @VisibleForTesting
    public long getHedgedReadOpsLoopNumForTesting() {
        return this.hedgedReadOpsLoopNumForTesting;
    }

    private ByteBuffer getFirstToComplete(CompletionService<ByteBuffer> hedgedService, ArrayList<Future<ByteBuffer>> futures) throws InterruptedException {
        if (futures.isEmpty()) {
            throw new InterruptedException("let's retry");
        }
        Future<ByteBuffer> future = null;
        try {
            future = hedgedService.take();
            ByteBuffer bb = future.get();
            futures.remove(future);
            return bb;
        }
        catch (CancellationException | ExecutionException e) {
            futures.remove(future);
            throw new InterruptedException("let's retry");
        }
    }

    private void cancelAll(List<Future<ByteBuffer>> futures) {
        for (Future<ByteBuffer> future : futures) {
            future.cancel(false);
        }
    }

    protected static boolean tokenRefetchNeeded(IOException ex, InetSocketAddress targetAddr) {
        if (ex instanceof InvalidBlockTokenException || ex instanceof SecretManager.InvalidToken) {
            DFSClient.LOG.debug("Access token was invalid when connecting to {}: {}", (Object)targetAddr, (Object)ex);
            return true;
        }
        return false;
    }

    @Override
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.validatePositionedReadArgs(position, buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer, offset, length);
        return this.pread(position, bb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pread(long position, ByteBuffer buffer) throws IOException {
        int length;
        this.dfsClient.checkOpen();
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        this.failures = 0;
        long filelen = this.getFileLength();
        if (position < 0L || position >= filelen) {
            return -1;
        }
        int realLen = length = buffer.remaining();
        if (position + (long)length > filelen) {
            realLen = (int)(filelen - position);
        }
        List<LocatedBlock> blockRange = this.getBlockRange(position, realLen);
        int remaining = realLen;
        DFSUtilClient.CorruptedBlocks corruptedBlocks = new DFSUtilClient.CorruptedBlocks();
        for (LocatedBlock blk : blockRange) {
            long targetStart = position - blk.getStartOffset();
            int bytesToRead = (int)Math.min((long)remaining, blk.getBlockSize() - targetStart);
            long targetEnd = targetStart + (long)bytesToRead - 1L;
            try {
                if (this.dfsClient.isHedgedReadsEnabled() && !blk.isStriped()) {
                    this.hedgedFetchBlockByteRange(blk, targetStart, targetEnd, buffer, corruptedBlocks);
                } else {
                    this.fetchBlockByteRange(blk, targetStart, targetEnd, buffer, corruptedBlocks);
                }
            }
            finally {
                this.reportCheckSumFailure(corruptedBlocks, blk.getLocations().length, false);
            }
            remaining -= bytesToRead;
            position += (long)bytesToRead;
        }
        assert (remaining == 0) : "Wrong number of bytes read.";
        return realLen;
    }

    protected void reportCheckSumFailure(DFSUtilClient.CorruptedBlocks corruptedBlocks, int dataNodeCount, boolean isStriped) {
        Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap = corruptedBlocks.getCorruptionMap();
        if (corruptedBlockMap == null) {
            return;
        }
        ArrayList<LocatedBlock> reportList = new ArrayList<LocatedBlock>(corruptedBlockMap.size());
        for (Map.Entry<ExtendedBlock, Set<DatanodeInfo>> entry : corruptedBlockMap.entrySet()) {
            ExtendedBlock blk = entry.getKey();
            Set<DatanodeInfo> dnSet = entry.getValue();
            if (!isStriped && (dnSet.size() >= dataNodeCount || dnSet.size() <= 0) && (dataNodeCount != 1 || dnSet.size() != dataNodeCount)) continue;
            DatanodeInfo[] locs = new DatanodeInfo[dnSet.size()];
            int i = 0;
            for (DatanodeInfo dn : dnSet) {
                locs[i++] = dn;
            }
            reportList.add(new LocatedBlock(blk, locs));
        }
        if (reportList.size() > 0) {
            this.dfsClient.reportChecksumFailure(this.src, reportList.toArray(new LocatedBlock[reportList.size()]));
        }
        corruptedBlockMap.clear();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > 0L) {
            long fileLen;
            long curPos = this.getPos();
            if (n + curPos > (fileLen = this.getFileLength())) {
                n = fileLen - curPos;
            }
            this.seek(curPos + n);
            return n;
        }
        return n < 0L ? -1L : 0L;
    }

    @Override
    public synchronized void seek(long targetPos) throws IOException {
        int diff;
        if (targetPos > this.getFileLength()) {
            throw new EOFException("Cannot seek after EOF");
        }
        if (targetPos < 0L) {
            throw new EOFException("Cannot seek to negative offset");
        }
        if (this.closed.get()) {
            throw new IOException("Stream is closed!");
        }
        boolean done = false;
        if (this.pos <= targetPos && targetPos <= this.blockEnd && (diff = (int)(targetPos - this.pos)) <= this.blockReader.available()) {
            try {
                this.pos += this.blockReader.skip(diff);
                if (this.pos != targetPos) {
                    String errMsg = "BlockReader failed to seek to " + targetPos + ". Instead, it seeked to " + this.pos + ".";
                    DFSClient.LOG.warn(errMsg);
                    throw new IOException(errMsg);
                }
                done = true;
            }
            catch (IOException e) {
                DFSClient.LOG.debug("Exception while seek to {} from {} of {} from {}", new Object[]{targetPos, this.getCurrentBlock(), this.src, this.currentNode, e});
                this.checkInterrupted(e);
            }
        }
        if (!done) {
            this.pos = targetPos;
            this.blockEnd = -1L;
        }
    }

    private boolean seekToBlockSource(long targetPos) throws IOException {
        this.currentNode = this.blockSeekTo(targetPos);
        return true;
    }

    @Override
    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        if (this.currentNode == null) {
            return this.seekToBlockSource(targetPos);
        }
        boolean markedDead = this.deadNodes.containsKey(this.currentNode);
        this.addToDeadNodes(this.currentNode);
        DatanodeInfo oldNode = this.currentNode;
        DatanodeInfo newNode = this.blockSeekTo(targetPos);
        if (!markedDead) {
            this.deadNodes.remove(oldNode);
        }
        if (!oldNode.getDatanodeUuid().equals(newNode.getDatanodeUuid())) {
            this.currentNode = newNode;
            return true;
        }
        return false;
    }

    @Override
    public synchronized long getPos() {
        return this.pos;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        long remaining = this.getFileLength() - this.pos;
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark/reset not supported");
    }

    public ReadStatistics getReadStatistics() {
        return this.readStatistics;
    }

    public void clearReadStatistics() {
        this.readStatistics.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEncryptionInfo getFileEncryptionInfo() {
        Object object = this.infoLock;
        synchronized (object) {
            return this.fileEncryptionInfo;
        }
    }

    protected void closeCurrentBlockReaders() {
        if (this.blockReader == null) {
            return;
        }
        try {
            this.blockReader.close();
        }
        catch (IOException e) {
            DFSClient.LOG.error("error closing blockReader", (Throwable)e);
        }
        this.blockReader = null;
        this.blockEnd = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setReadahead(Long readahead) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            this.cachingStrategy = new CachingStrategy.Builder(this.cachingStrategy).setReadahead(readahead).build();
        }
        this.closeCurrentBlockReaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setDropBehind(Boolean dropBehind) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            this.cachingStrategy = new CachingStrategy.Builder(this.cachingStrategy).setDropBehind(dropBehind).build();
        }
        this.closeCurrentBlockReaders();
    }

    @Override
    public synchronized ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        if (maxLength == 0) {
            return EMPTY_BUFFER;
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("can't read a negative number of bytes.");
        }
        if (this.blockReader == null || this.blockEnd == -1L) {
            if (this.pos >= this.getFileLength()) {
                return null;
            }
            if (!this.seekToBlockSource(this.pos) || this.blockReader == null) {
                throw new IOException("failed to allocate new BlockReader at position " + this.pos);
            }
        }
        ByteBuffer buffer = null;
        if (this.dfsClient.getConf().getShortCircuitConf().isShortCircuitMmapEnabled()) {
            buffer = this.tryReadZeroCopy(maxLength, opts);
        }
        if (buffer != null) {
            return buffer;
        }
        buffer = ByteBufferUtil.fallbackRead(this, bufferPool, maxLength);
        if (buffer != null) {
            this.getExtendedReadBuffers().put(buffer, bufferPool);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ByteBuffer tryReadZeroCopy(int maxLength, EnumSet<ReadOption> opts) throws IOException {
        ByteBuffer buffer;
        int length;
        long length63;
        long curPos = this.pos;
        long curEnd = this.blockEnd;
        long blockStartInFile = this.currentLocatedBlock.getStartOffset();
        long blockPos = curPos - blockStartInFile;
        if (curPos + (long)maxLength <= curEnd + 1L) {
            length63 = maxLength;
        } else {
            length63 = 1L + curEnd - curPos;
            if (length63 <= 0L) {
                DFSClient.LOG.debug("Unable to perform a zero-copy read from offset {} of {}; {} bytes left in block. blockPos={}; curPos={};curEnd={}", new Object[]{curPos, this.src, length63, blockPos, curPos, curEnd});
                return null;
            }
            DFSClient.LOG.debug("Reducing read length from {} to {} to avoid going more than one byte past the end of the block.  blockPos={};  curPos={}; curEnd={}", new Object[]{maxLength, length63, blockPos, curPos, curEnd});
        }
        if (blockPos + length63 <= Integer.MAX_VALUE) {
            length = (int)length63;
        } else {
            long length31 = Integer.MAX_VALUE - blockPos;
            if (length31 <= 0L) {
                DFSClient.LOG.debug("Unable to perform a zero-copy read from offset {}  of {}; 31-bit MappedByteBuffer limit exceeded.  blockPos={}, curEnd={}", new Object[]{curPos, this.src, blockPos, curEnd});
                return null;
            }
            length = (int)length31;
            DFSClient.LOG.debug("Reducing read length from {} to {} to avoid 31-bit limit.  blockPos={}; curPos={}; curEnd={}", new Object[]{maxLength, length, blockPos, curPos, curEnd});
        }
        ClientMmap clientMmap = this.blockReader.getClientMmap(opts);
        if (clientMmap == null) {
            DFSClient.LOG.debug("unable to perform a zero-copy read from offset {} of {}; BlockReader#getClientMmap returned null.", (Object)curPos, (Object)this.src);
            return null;
        }
        boolean success = false;
        try {
            this.seek(curPos + (long)length);
            buffer = clientMmap.getMappedByteBuffer().asReadOnlyBuffer();
            buffer.position((int)blockPos);
            buffer.limit((int)(blockPos + (long)length));
            this.getExtendedReadBuffers().put(buffer, clientMmap);
            this.readStatistics.addZeroCopyBytes(length);
            DFSClient.LOG.debug("readZeroCopy read {} bytes from offset {} via the zero-copy read path.  blockEnd = {}", new Object[]{length, curPos, this.blockEnd});
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeQuietly((Closeable)clientMmap);
            }
        }
        return buffer;
    }

    @Override
    public synchronized void releaseBuffer(ByteBuffer buffer) {
        if (buffer == EMPTY_BUFFER) {
            return;
        }
        Object val = this.getExtendedReadBuffers().remove(buffer);
        if (val == null) {
            throw new IllegalArgumentException("tried to release a buffer that was not created by this stream, " + buffer);
        }
        if (val instanceof ClientMmap) {
            IOUtils.closeQuietly((Closeable)((ClientMmap)val));
        } else if (val instanceof ByteBufferPool) {
            ((ByteBufferPool)val).putBuffer(buffer);
        }
    }

    @Override
    public synchronized void unbuffer() {
        this.closeCurrentBlockReaders();
    }

    @Override
    public boolean hasCapability(String capability) {
        switch (StringUtils.toLowerCase(capability)) {
            case "in:readahead": 
            case "dropbehind": 
            case "in:unbuffer": {
                return true;
            }
        }
        return false;
    }

    static final class DNAddrPair {
        final DatanodeInfo info;
        final InetSocketAddress addr;
        final StorageType storageType;
        final LocatedBlock block;

        DNAddrPair(DatanodeInfo info, InetSocketAddress addr, StorageType storageType, LocatedBlock block) {
            this.info = info;
            this.addr = addr;
            this.storageType = storageType;
            this.block = block;
        }
    }
}

