/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BBPartHandle;
import org.apache.hadoop.fs.BBUploadHandle;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MultipartUploader;
import org.apache.hadoop.fs.MultipartUploaderFactory;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.PartHandle;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.UploadHandle;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.shaded.com.google.common.base.Charsets;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemMultipartUploader
extends MultipartUploader {
    private final FileSystem fs;

    public FileSystemMultipartUploader(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public UploadHandle initialize(Path filePath) throws IOException {
        Path collectorPath = this.createCollectorPath(filePath);
        this.fs.mkdirs(collectorPath, FsPermission.getDirDefault());
        ByteBuffer byteBuffer = ByteBuffer.wrap(collectorPath.toString().getBytes(Charsets.UTF_8));
        return BBUploadHandle.from(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartHandle putPart(Path filePath, InputStream inputStream, int partNumber, UploadHandle uploadId, long lengthInBytes) throws IOException {
        this.checkPutArguments(filePath, inputStream, partNumber, uploadId, lengthInBytes);
        byte[] uploadIdByteArray = uploadId.toByteArray();
        this.checkUploadId(uploadIdByteArray);
        Path collectorPath = new Path(new String(uploadIdByteArray, 0, uploadIdByteArray.length, Charsets.UTF_8));
        Path partPath = Path.mergePaths(collectorPath, Path.mergePaths(new Path("/"), new Path(Integer.toString(partNumber) + ".part")));
        try (Object fsDataOutputStream = this.fs.createFile(partPath).build();){
            org.apache.hadoop.shaded.org.apache.commons.compress.utils.IOUtils.copy((InputStream)inputStream, fsDataOutputStream, (int)4096);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(LOG, inputStream);
            throw throwable;
        }
        IOUtils.cleanupWithLogger(LOG, inputStream);
        return BBPartHandle.from(ByteBuffer.wrap(partPath.toString().getBytes(Charsets.UTF_8)));
    }

    private Path createCollectorPath(Path filePath) {
        String uuid = UUID.randomUUID().toString();
        return Path.mergePaths(filePath.getParent(), Path.mergePaths(new Path(filePath.getName().split("\\.")[0]), Path.mergePaths(new Path("_multipart_" + uuid), new Path("/"))));
    }

    private PathHandle getPathHandle(Path filePath) throws IOException {
        FileStatus status = this.fs.getFileStatus(filePath);
        return this.fs.getPathHandle(status, new Options.HandleOpt[0]);
    }

    private long totalPartsLen(List<Path> partHandles) throws IOException {
        long totalLen = 0L;
        for (Path p : partHandles) {
            totalLen += this.fs.getFileStatus(p).getLen();
        }
        return totalLen;
    }

    @Override
    public PathHandle complete(Path filePath, Map<Integer, PartHandle> handleMap, UploadHandle multipartUploadId) throws IOException {
        boolean emptyFile;
        this.checkUploadId(multipartUploadId.toByteArray());
        this.checkPartHandles(handleMap);
        ArrayList<Map.Entry<Integer, PartHandle>> handles = new ArrayList<Map.Entry<Integer, PartHandle>>(handleMap.entrySet());
        handles.sort(Comparator.comparingInt(Map.Entry::getKey));
        List<Path> partHandles = handles.stream().map(pair -> {
            byte[] byteArray = ((PartHandle)pair.getValue()).toByteArray();
            return new Path(new String(byteArray, 0, byteArray.length, Charsets.UTF_8));
        }).collect(Collectors.toList());
        byte[] uploadIdByteArray = multipartUploadId.toByteArray();
        Path collectorPath = new Path(new String(uploadIdByteArray, 0, uploadIdByteArray.length, Charsets.UTF_8));
        boolean bl = emptyFile = this.totalPartsLen(partHandles) == 0L;
        if (emptyFile) {
            this.fs.create(filePath).close();
        } else {
            Path filePathInsideCollector = Path.mergePaths(collectorPath, new Path("/" + filePath.getName()));
            this.fs.create(filePathInsideCollector).close();
            this.fs.concat(filePathInsideCollector, partHandles.toArray(new Path[handles.size()]));
            this.fs.rename(filePathInsideCollector, filePath, Options.Rename.OVERWRITE);
        }
        this.fs.delete(collectorPath, true);
        return this.getPathHandle(filePath);
    }

    @Override
    public void abort(Path filePath, UploadHandle uploadId) throws IOException {
        byte[] uploadIdByteArray = uploadId.toByteArray();
        this.checkUploadId(uploadIdByteArray);
        Path collectorPath = new Path(new String(uploadIdByteArray, 0, uploadIdByteArray.length, Charsets.UTF_8));
        this.fs.getFileStatus(collectorPath);
        this.fs.delete(collectorPath, true);
    }

    public static class Factory
    extends MultipartUploaderFactory {
        @Override
        protected MultipartUploader createMultipartUploader(FileSystem fs, Configuration conf) {
            if (fs.getScheme().equals("file")) {
                return new FileSystemMultipartUploader(fs);
            }
            return null;
        }
    }
}

