/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteRequestsTable<T>
implements Iterable<AMRMClientImpl.ResourceRequestInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteRequestsTable.class);
    private Map<Priority, Map<String, Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>>> remoteRequestsTable = new HashMap<Priority, Map<String, Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>>>();

    RemoteRequestsTable() {
    }

    @Override
    public Iterator<AMRMClientImpl.ResourceRequestInfo> iterator() {
        return new RequestInfoIterator(this.remoteRequestsTable.values().iterator());
    }

    AMRMClientImpl.ResourceRequestInfo get(Priority priority, String location, ExecutionType execType, Resource capability) {
        TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo> capabilityMap = this.getCapabilityMap(priority, location, execType);
        if (capabilityMap == null) {
            return null;
        }
        return capabilityMap.get(capability);
    }

    void put(Priority priority, String resourceName, ExecutionType execType, Resource capability, AMRMClientImpl.ResourceRequestInfo resReqInfo) {
        TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo<Object>> capabilityMap;
        Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>> execTypeMap;
        Map<String, Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>> locationMap = this.remoteRequestsTable.get(priority);
        if (locationMap == null) {
            locationMap = new HashMap<String, Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>>();
            this.remoteRequestsTable.put(priority, locationMap);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added priority=" + priority);
            }
        }
        if ((execTypeMap = locationMap.get(resourceName)) == null) {
            execTypeMap = new HashMap<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>();
            locationMap.put(resourceName, execTypeMap);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added resourceName=" + resourceName);
            }
        }
        if ((capabilityMap = execTypeMap.get((Object)execType)) == null) {
            capabilityMap = new TreeMap(new AMRMClientImpl.ResourceReverseComparator());
            execTypeMap.put(execType, capabilityMap);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added Execution Type=" + (Object)((Object)execType));
            }
        }
        capabilityMap.put(capability, resReqInfo);
    }

    AMRMClientImpl.ResourceRequestInfo remove(Priority priority, String resourceName, ExecutionType execType, Resource capability) {
        AMRMClientImpl.ResourceRequestInfo retVal = null;
        Map<String, Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>> locationMap = this.remoteRequestsTable.get(priority);
        if (locationMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No such priority=" + priority);
            }
            return null;
        }
        Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>> execTypeMap = locationMap.get(resourceName);
        if (execTypeMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No such resourceName=" + resourceName);
            }
            return null;
        }
        TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo> capabilityMap = execTypeMap.get((Object)execType);
        if (capabilityMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No such Execution Type=" + (Object)((Object)execType));
            }
            return null;
        }
        retVal = capabilityMap.remove(capability);
        if (capabilityMap.size() == 0) {
            execTypeMap.remove((Object)execType);
            if (execTypeMap.size() == 0) {
                locationMap.remove(resourceName);
                if (locationMap.size() == 0) {
                    this.remoteRequestsTable.remove(priority);
                }
            }
        }
        return retVal;
    }

    Map<String, Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>> getLocationMap(Priority priority) {
        return this.remoteRequestsTable.get(priority);
    }

    Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>> getExecutionTypeMap(Priority priority, String location) {
        Map<String, Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>> locationMap = this.getLocationMap(priority);
        if (locationMap == null) {
            return null;
        }
        return locationMap.get(location);
    }

    TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo> getCapabilityMap(Priority priority, String location, ExecutionType execType) {
        Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>> executionTypeMap = this.getExecutionTypeMap(priority, location);
        if (executionTypeMap == null) {
            return null;
        }
        return executionTypeMap.get((Object)execType);
    }

    List<AMRMClientImpl.ResourceRequestInfo> getAllResourceRequestInfos(Priority priority, Collection<String> locations) {
        LinkedList<AMRMClientImpl.ResourceRequestInfo> retList = new LinkedList<AMRMClientImpl.ResourceRequestInfo>();
        for (String location : locations) {
            for (ExecutionType eType : ExecutionType.values()) {
                TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo> capabilityMap = this.getCapabilityMap(priority, location, eType);
                if (capabilityMap == null) continue;
                retList.addAll(capabilityMap.values());
            }
        }
        return retList;
    }

    List<AMRMClientImpl.ResourceRequestInfo> getMatchingRequests(Priority priority, String resourceName, ExecutionType executionType, Resource capability) {
        LinkedList<AMRMClientImpl.ResourceRequestInfo> list = new LinkedList<AMRMClientImpl.ResourceRequestInfo>();
        TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo> capabilityMap = this.getCapabilityMap(priority, resourceName, executionType);
        if (capabilityMap != null) {
            AMRMClientImpl.ResourceRequestInfo resourceRequestInfo = capabilityMap.get(capability);
            if (resourceRequestInfo != null) {
                list.add(resourceRequestInfo);
            } else {
                list.addAll(capabilityMap.tailMap(capability).values());
            }
        }
        return list;
    }

    AMRMClientImpl.ResourceRequestInfo addResourceRequest(Long allocationRequestId, Priority priority, String resourceName, ExecutionTypeRequest execTypeReq, Resource capability, T req, boolean relaxLocality, String labelExpression) {
        AMRMClientImpl.ResourceRequestInfo resourceRequestInfo = this.get(priority, resourceName, execTypeReq.getExecutionType(), capability);
        if (resourceRequestInfo == null) {
            resourceRequestInfo = new AMRMClientImpl.ResourceRequestInfo(allocationRequestId, priority, resourceName, capability, relaxLocality);
            this.put(priority, resourceName, execTypeReq.getExecutionType(), capability, resourceRequestInfo);
        }
        resourceRequestInfo.remoteRequest.setExecutionTypeRequest(execTypeReq);
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() + 1);
        if (relaxLocality) {
            resourceRequestInfo.containerRequests.add(req);
        }
        if ("*".equals(resourceName)) {
            resourceRequestInfo.remoteRequest.setNodeLabelExpression(labelExpression);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding request to ask " + resourceRequestInfo.remoteRequest);
        }
        return resourceRequestInfo;
    }

    AMRMClientImpl.ResourceRequestInfo decResourceRequest(Priority priority, String resourceName, ExecutionTypeRequest execTypeReq, Resource capability, T req) {
        AMRMClientImpl.ResourceRequestInfo resourceRequestInfo = this.get(priority, resourceName, execTypeReq.getExecutionType(), capability);
        if (resourceRequestInfo == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not decrementing resource as ResourceRequestInfo withpriority=" + priority + ", resourceName=" + resourceName + ", executionType=" + execTypeReq + ", capability=" + capability + " is not present in request table");
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("BEFORE decResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers());
        }
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() - 1);
        resourceRequestInfo.containerRequests.remove(req);
        if (resourceRequestInfo.remoteRequest.getNumContainers() < 0) {
            resourceRequestInfo.remoteRequest.setNumContainers(0);
        }
        return resourceRequestInfo;
    }

    boolean isEmpty() {
        return this.remoteRequestsTable.isEmpty();
    }

    class RequestInfoIterator
    implements Iterator<AMRMClientImpl.ResourceRequestInfo> {
        private Iterator<Map<String, Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>>> iLocMap;
        private Iterator<Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>> iExecTypeMap;
        private Iterator<TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>> iCapMap;
        private Iterator<AMRMClientImpl.ResourceRequestInfo> iResReqInfo;

        public RequestInfoIterator(Iterator<Map<String, Map<ExecutionType, TreeMap<Resource, AMRMClientImpl.ResourceRequestInfo>>>> iLocationMap) {
            this.iLocMap = iLocationMap;
            this.iExecTypeMap = this.iLocMap.hasNext() ? this.iLocMap.next().values().iterator() : new LinkedList().iterator();
            this.iCapMap = this.iExecTypeMap.hasNext() ? this.iExecTypeMap.next().values().iterator() : new LinkedList().iterator();
            this.iResReqInfo = this.iCapMap.hasNext() ? this.iCapMap.next().values().iterator() : new LinkedList().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iLocMap.hasNext() || this.iExecTypeMap.hasNext() || this.iCapMap.hasNext() || this.iResReqInfo.hasNext();
        }

        @Override
        public AMRMClientImpl.ResourceRequestInfo next() {
            if (!this.iResReqInfo.hasNext()) {
                if (!this.iCapMap.hasNext()) {
                    if (!this.iExecTypeMap.hasNext()) {
                        this.iExecTypeMap = this.iLocMap.next().values().iterator();
                    }
                    this.iCapMap = this.iExecTypeMap.next().values().iterator();
                }
                this.iResReqInfo = this.iCapMap.next().values().iterator();
            }
            return this.iResReqInfo.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supportedfor this iterator !!");
        }
    }
}

