/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;

public class DirectFileOutputCommitter
extends FileOutputCommitter {
    private static final Log LOG = LogFactory.getLog(DirectFileOutputCommitter.class);
    private final Path outputPath;
    private final boolean directWrite;

    public DirectFileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.outputPath = outputPath;
        this.directWrite = DirectFileOutputCommitter.isDirectWrite(outputPath, context);
    }

    public DirectFileOutputCommitter(Path outputPath, JobContext context) throws IOException {
        super(outputPath, context);
        this.outputPath = outputPath;
        this.directWrite = DirectFileOutputCommitter.isDirectWrite(outputPath, context);
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        if (this.directWrite) {
            LOG.info((Object)"Nothing to setup since the outputs are written directly.");
        } else {
            super.setupJob(context);
        }
    }

    @Override
    public void cleanupJob(JobContext context) throws IOException {
        if (this.directWrite) {
            LOG.info((Object)"Nothing to clean up since no temporary files were written.");
        } else {
            super.cleanupJob(context);
        }
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
        if (!this.directWrite) {
            super.setupTask(context);
        }
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        if (this.directWrite) {
            LOG.info((Object)"Commit should not be called since this task doesnt have any commitable files. Also needsTaskCommit returns false");
        } else {
            super.commitTask(context);
        }
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        if (this.directWrite) {
            if (this.hasOutputPath()) {
                this.cleanupJob(context);
                if (context.getConfiguration().getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", true)) {
                    Path markerPath = new Path(this.outputPath, "_SUCCESS");
                    FileSystem fs = markerPath.getFileSystem(context.getConfiguration());
                    fs.create(markerPath).close();
                }
            }
        } else {
            super.commitJob(context);
        }
    }

    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
        if (this.directWrite) {
            LOG.info((Object)"Nothing to clean up on abort since there are no temporary files written");
        } else {
            super.abortTask(context);
        }
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        if (this.directWrite) {
            return false;
        }
        return super.needsTaskCommit(context);
    }

    @Override
    public Path getWorkPath() throws IOException {
        if (this.directWrite) {
            return this.outputPath;
        }
        return super.getWorkPath();
    }

    private static boolean isDirectWrite(Path outputPath, JobContext context) throws IOException {
        if (outputPath == null) {
            return false;
        }
        FileSystem fileSystem = outputPath.getFileSystem(context.getConfiguration());
        boolean directWrite = DirectFileOutputCommitter.isDirectWrite(context.getConfiguration(), fileSystem);
        LOG.info((Object)("Direct Write: " + (directWrite ? "ENABLED" : "DISABLED")));
        return directWrite;
    }

    private static boolean isDirectWrite(Configuration c, FileSystem fs) {
        return c.getBoolean("mapred.output.direct." + fs.getClass().getSimpleName(), false);
    }
}

