/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.staging;

import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.shaded.com.google.common.base.Objects;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;

public class StagedFileMetadata
implements Serializable,
ObjectInputValidation {
    private static final long serialVersionUID = 0L;
    private final Path destinationPath;
    private final Serializable stagingMetadata;

    public StagedFileMetadata(@Nonnull Path destinationPath, @Nonnull Serializable stagingMetadata) {
        Preconditions.checkNotNull((Object)destinationPath, (Object)"destinationPath cannot be null");
        Preconditions.checkNotNull((Object)stagingMetadata, (Object)"stagingMetadata cannot be null");
        this.destinationPath = destinationPath;
        this.stagingMetadata = stagingMetadata;
    }

    public Path getDestinationPath() {
        return this.destinationPath;
    }

    public Serializable getStagingMetadata() {
        return this.stagingMetadata;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.destinationPath == null) {
            throw new InvalidObjectException("No destinationPath in deserialized StagedFileMetadata");
        }
        if (this.stagingMetadata == null) {
            throw new InvalidObjectException("No stagingMetadata in deserialized StagedFileMetadata");
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.destinationPath, this.stagingMetadata});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StagedFileMetadata other = (StagedFileMetadata)obj;
        return this.destinationPath.equals(other.destinationPath) && this.stagingMetadata.equals(other.stagingMetadata);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("destinationPath", (Object)this.destinationPath).add("stagingMetadata", (Object)this.getStagingMetadataString()).toString();
    }

    protected String getStagingMetadataString() {
        return this.stagingMetadata.toString();
    }
}

