/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.MultiByteBufferReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.util.ByteBufferIOUtils;

class DefaultMultiByteBufferReader
implements MultiByteBufferReadable {
    private final InputStream in;
    private static final int COPY_BUFFER_SIZE = 8192;
    private final byte[] copyBuffer;

    public DefaultMultiByteBufferReader(InputStream in) {
        if (!(in instanceof Seekable)) {
            throw new IllegalArgumentException("in is not an instance of Seekable");
        }
        this.in = in;
        this.copyBuffer = new byte[8192];
    }

    @Override
    public void readFullyIntoBuffers(long position, List<ByteBuffer> byteBuffers) throws IOException {
        ByteBufferIOUtils.validateReadIntoBuffers(position, byteBuffers);
        ((Seekable)((Object)this.in)).seek(position);
        for (ByteBuffer byteBuffer : byteBuffers) {
            ByteBufferIOUtils.readFully(this.in, byteBuffer, this.copyBuffer);
        }
    }
}

