/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.azurebfs.services.AbfsLease;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatistics;
import org.apache.hadoop.fs.azurebfs.services.AbfsStreamContext;

public class AbfsOutputStreamContext
extends AbfsStreamContext {
    private int writeBufferSize;
    private boolean enableFlush;
    private boolean enableSmallWriteOptimization;
    private boolean disableOutputStreamFlush;
    private AbfsOutputStreamStatistics streamStatistics;
    private boolean isAppendBlob;
    private int writeMaxConcurrentRequestCount;
    private int maxWriteRequestsToQueue;
    private AbfsLease lease;

    public AbfsOutputStreamContext(long sasTokenRenewPeriodForStreamsInSeconds) {
        super(sasTokenRenewPeriodForStreamsInSeconds);
    }

    public AbfsOutputStreamContext withWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    public AbfsOutputStreamContext enableFlush(boolean enableFlush) {
        this.enableFlush = enableFlush;
        return this;
    }

    public AbfsOutputStreamContext enableSmallWriteOptimization(boolean enableSmallWriteOptimization) {
        this.enableSmallWriteOptimization = enableSmallWriteOptimization;
        return this;
    }

    public AbfsOutputStreamContext disableOutputStreamFlush(boolean disableOutputStreamFlush) {
        this.disableOutputStreamFlush = disableOutputStreamFlush;
        return this;
    }

    public AbfsOutputStreamContext withStreamStatistics(AbfsOutputStreamStatistics streamStatistics) {
        this.streamStatistics = streamStatistics;
        return this;
    }

    public AbfsOutputStreamContext withAppendBlob(boolean isAppendBlob) {
        this.isAppendBlob = isAppendBlob;
        return this;
    }

    public AbfsOutputStreamContext build() {
        return this;
    }

    public AbfsOutputStreamContext withWriteMaxConcurrentRequestCount(int writeMaxConcurrentRequestCount) {
        this.writeMaxConcurrentRequestCount = writeMaxConcurrentRequestCount;
        return this;
    }

    public AbfsOutputStreamContext withMaxWriteRequestsToQueue(int maxWriteRequestsToQueue) {
        this.maxWriteRequestsToQueue = maxWriteRequestsToQueue;
        return this;
    }

    public AbfsOutputStreamContext withLease(AbfsLease lease) {
        this.lease = lease;
        return this;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public boolean isEnableFlush() {
        return this.enableFlush;
    }

    public boolean isDisableOutputStreamFlush() {
        return this.disableOutputStreamFlush;
    }

    public AbfsOutputStreamStatistics getStreamStatistics() {
        return this.streamStatistics;
    }

    public boolean isAppendBlob() {
        return this.isAppendBlob;
    }

    public int getWriteMaxConcurrentRequestCount() {
        return this.writeMaxConcurrentRequestCount;
    }

    public int getMaxWriteRequestsToQueue() {
        return this.maxWriteRequestsToQueue;
    }

    public boolean isEnableSmallWriteOptimization() {
        return this.enableSmallWriteOptimization;
    }

    public AbfsLease getLease() {
        return this.lease;
    }

    public String getLeaseId() {
        if (this.lease == null) {
            return null;
        }
        return this.lease.getLeaseID();
    }
}

