/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.microsoft.azure.storage.StorageException;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureFileSystemThreadPoolExecutor;
import org.apache.hadoop.fs.azure.AzureFileSystemThreadTask;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.BlobMaterialization;
import org.apache.hadoop.fs.azure.FileMetadata;
import org.apache.hadoop.fs.azure.NativeAzureFileSystemHelper;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.RemoteWasbAuthorizerImpl;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.azure.WasbAuthorizationException;
import org.apache.hadoop.fs.azure.WasbAuthorizationOperations;
import org.apache.hadoop.fs.azure.WasbAuthorizerInterface;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemMetricsSystem;
import org.apache.hadoop.fs.azure.security.RemoteWasbDelegationTokenManager;
import org.apache.hadoop.fs.azure.security.WasbDelegationTokenManager;
import org.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import org.apache.hadoop.fs.impl.StoreImplementationUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class NativeAzureFileSystem
extends FileSystem {
    private static final int USER_WX_PERMISION = 192;
    private static final String USER_HOME_DIR_PREFIX_DEFAULT = "/user";
    private static final String TRAILING_PERIOD_PLACEHOLDER = "[[.]]";
    private static final Pattern TRAILING_PERIOD_PLACEHOLDER_PATTERN = Pattern.compile("\\[\\[\\.\\]\\](?=$|/)");
    private static final Pattern TRAILING_PERIOD_PATTERN = Pattern.compile("\\.(?=$|/)");
    public static final Logger LOG = LoggerFactory.getLogger(NativeAzureFileSystem.class);
    static final String AZURE_TEMP_EXPIRY_PROPERTY_NAME = "fs.azure.fsck.temp.expiry.seconds";
    private static final int AZURE_TEMP_EXPIRY_DEFAULT = 3600;
    static final String PATH_DELIMITER = "/";
    static final String AZURE_TEMP_FOLDER = "_$azuretmpfolder$";
    private static final int AZURE_LIST_ALL = -1;
    private static final int AZURE_UNBOUNDED_DEPTH = -1;
    private static final String AZURE_DEFAULT_GROUP_PROPERTY_NAME = "fs.azure.permissions.supergroup";
    static final String AZURE_DEFAULT_GROUP_DEFAULT = "supergroup";
    public static final String AZURE_CHOWN_USERLIST_PROPERTY_NAME = "fs.azure.chown.allowed.userlist";
    static final String AZURE_CHOWN_USERLIST_PROPERTY_DEFAULT_VALUE = "*";
    public static final String AZURE_DAEMON_USERLIST_PROPERTY_NAME = "fs.azure.daemon.userlist";
    static final String AZURE_DAEMON_USERLIST_PROPERTY_DEFAULT_VALUE = "*";
    public static final String AZURE_CHMOD_USERLIST_PROPERTY_NAME = "fs.azure.chmod.allowed.userlist";
    static final String AZURE_CHMOD_USERLIST_PROPERTY_DEFAULT_VALUE = "*";
    static final String AZURE_RINGBUFFER_CAPACITY_PROPERTY_NAME = "fs.azure.ring.buffer.capacity";
    static final String AZURE_OUTPUT_STREAM_BUFFER_SIZE_PROPERTY_NAME = "fs.azure.output.stream.buffer.size";
    public static final String SKIP_AZURE_METRICS_PROPERTY_NAME = "fs.azure.skip.metrics";
    public static final String APPEND_SUPPORT_ENABLE_PROPERTY_NAME = "fs.azure.enable.append.support";
    public static final String RETURN_URI_AS_CANONICAL_SERVICE_NAME_PROPERTY_NAME = "fs.azure.override.canonical.service.name";
    public static final String AZURE_RENAME_THREADS = "fs.azure.rename.threads";
    public static final int DEFAULT_AZURE_RENAME_THREADS = 0;
    public static final String AZURE_DELETE_THREADS = "fs.azure.delete.threads";
    public static final int DEFAULT_AZURE_DELETE_THREADS = 0;
    private int deleteThreadCount = 0;
    private int renameThreadCount = 0;
    private URI uri;
    private NativeFileSystemStore store;
    private AzureNativeFileSystemStore actualStore;
    private Path workingDir;
    private AzureFileSystemInstrumentation instrumentation;
    private String metricsSourceName;
    private boolean isClosed = false;
    private static boolean suppressRetryPolicy = false;
    private static AtomicInteger metricsSourceNameCounter = new AtomicInteger();
    private boolean appendSupportEnabled = false;
    private boolean returnUriAsCanonicalServiceName = false;
    private DelegationTokenAuthenticatedURL authURL;
    private DelegationTokenAuthenticatedURL.Token authToken = new DelegationTokenAuthenticatedURL.Token();
    private String credServiceUrl;
    private List<String> chownAllowedUsers;
    private List<String> chmodAllowedUsers;
    private List<String> daemonUsers;
    public static final String KEY_AZURE_AUTHORIZATION = "fs.azure.authorization";
    private static final boolean DEFAULT_AZURE_AUTHORIZATION = false;
    private boolean azureAuthorization = false;
    private boolean kerberosSupportEnabled = false;
    private WasbAuthorizerInterface authorizer = null;
    private UserGroupInformation ugi;
    private WasbDelegationTokenManager wasbDelegationTokenManager;

    public String getScheme() {
        return "wasb";
    }

    public String getCanonicalServiceName() {
        if (this.returnUriAsCanonicalServiceName) {
            return this.getUri().toString();
        }
        return super.getCanonicalServiceName();
    }

    public NativeAzureFileSystem() {
    }

    public NativeAzureFileSystem(NativeFileSystemStore store) {
        this.store = store;
    }

    @VisibleForTesting
    static void suppressRetryPolicy() {
        suppressRetryPolicy = true;
    }

    @VisibleForTesting
    static void resumeRetryPolicy() {
        suppressRetryPolicy = false;
    }

    @VisibleForTesting
    public static String newMetricsSourceName() {
        int number = metricsSourceNameCounter.incrementAndGet();
        String baseName = "AzureFileSystemMetrics";
        if (number == 1) {
            return "AzureFileSystemMetrics";
        }
        return "AzureFileSystemMetrics" + number;
    }

    private static boolean isWasbScheme(String scheme) {
        return scheme != null && (scheme.equalsIgnoreCase("asv") || scheme.equalsIgnoreCase("asvs") || scheme.equalsIgnoreCase("wasb") || scheme.equalsIgnoreCase("wasbs"));
    }

    private static URI reconstructAuthorityIfNeeded(URI uri, Configuration conf) {
        URI defaultUri;
        if (null == uri.getAuthority() && (defaultUri = FileSystem.getDefaultUri((Configuration)conf)) != null && NativeAzureFileSystem.isWasbScheme(defaultUri.getScheme())) {
            try {
                return new URI(uri.getScheme(), defaultUri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new Error("Bad URI construction", e);
            }
        }
        return uri;
    }

    protected void checkPath(Path path) {
        super.checkPath(new Path(NativeAzureFileSystem.reconstructAuthorityIfNeeded(path.toUri(), this.getConf())));
    }

    public void initialize(URI uri, Configuration conf) throws IOException, IllegalArgumentException {
        if (null == (uri = NativeAzureFileSystem.reconstructAuthorityIfNeeded(uri, conf)).getAuthority()) {
            String errMsg = String.format("Cannot initialize WASB file system, URI authority not recognized.", new Object[0]);
            throw new IllegalArgumentException(errMsg);
        }
        super.initialize(uri, conf);
        if (this.store == null) {
            this.store = this.createDefaultStore(conf);
        }
        this.instrumentation = new AzureFileSystemInstrumentation(conf);
        if (!conf.getBoolean(SKIP_AZURE_METRICS_PROPERTY_NAME, false)) {
            AzureFileSystemMetricsSystem.fileSystemStarted();
            this.metricsSourceName = NativeAzureFileSystem.newMetricsSourceName();
            String sourceDesc = "Azure Storage Volume File System metrics";
            AzureFileSystemMetricsSystem.registerSource(this.metricsSourceName, sourceDesc, this.instrumentation);
        }
        this.store.initialize(uri, conf, this.instrumentation);
        this.setConf(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path(USER_HOME_DIR_PREFIX_DEFAULT, UserGroupInformation.getCurrentUser().getShortUserName()).makeQualified(this.getUri(), this.getWorkingDirectory());
        this.appendSupportEnabled = conf.getBoolean(APPEND_SUPPORT_ENABLE_PROPERTY_NAME, false);
        LOG.debug("NativeAzureFileSystem. Initializing.");
        LOG.debug("  blockSize  = {}", (Object)this.store.getHadoopBlockSize());
        this.deleteThreadCount = conf.getInt(AZURE_DELETE_THREADS, 0);
        this.renameThreadCount = conf.getInt(AZURE_RENAME_THREADS, 0);
        boolean useSecureMode = conf.getBoolean("fs.azure.secure.mode", false);
        this.azureAuthorization = useSecureMode && conf.getBoolean(KEY_AZURE_AUTHORIZATION, false);
        this.kerberosSupportEnabled = conf.getBoolean("fs.azure.enable.kerberos.support", false);
        if (this.azureAuthorization) {
            this.authorizer = new RemoteWasbAuthorizerImpl();
            this.authorizer.init(conf);
            this.chmodAllowedUsers = Arrays.asList(conf.getTrimmedStrings(AZURE_CHMOD_USERLIST_PROPERTY_NAME, new String[]{"*"}));
            this.chownAllowedUsers = Arrays.asList(conf.getTrimmedStrings(AZURE_CHOWN_USERLIST_PROPERTY_NAME, new String[]{"*"}));
            this.daemonUsers = Arrays.asList(conf.getTrimmedStrings(AZURE_DAEMON_USERLIST_PROPERTY_NAME, new String[]{"*"}));
        }
        if (UserGroupInformation.isSecurityEnabled() && this.kerberosSupportEnabled) {
            this.wasbDelegationTokenManager = new RemoteWasbDelegationTokenManager(conf);
        }
        this.returnUriAsCanonicalServiceName = conf.getBoolean(RETURN_URI_AS_CANONICAL_SERVICE_NAME_PROPERTY_NAME, false);
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + this.ugi.getShortUserName()));
    }

    @VisibleForTesting
    public void updateWasbAuthorizer(WasbAuthorizerInterface authorizer) {
        this.authorizer = authorizer;
    }

    private NativeFileSystemStore createDefaultStore(Configuration conf) {
        this.actualStore = new AzureNativeFileSystemStore();
        if (suppressRetryPolicy) {
            this.actualStore.suppressRetryPolicy();
        }
        return this.actualStore;
    }

    private static String encodeTrailingPeriod(String toEncode) {
        Matcher matcher = TRAILING_PERIOD_PATTERN.matcher(toEncode);
        return matcher.replaceAll(TRAILING_PERIOD_PLACEHOLDER);
    }

    private static String decodeTrailingPeriod(String toDecode) {
        Matcher matcher = TRAILING_PERIOD_PLACEHOLDER_PATTERN.matcher(toDecode);
        return matcher.replaceAll(".");
    }

    @VisibleForTesting
    public String pathToKey(Path path) {
        URI tmpUri = path.toUri();
        String pathUri = tmpUri.getPath();
        Path newPath = path;
        if ("".equals(pathUri)) {
            newPath = new Path(tmpUri.toString() + PATH_DELIMITER);
        }
        if (!newPath.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String key = null;
        key = newPath.toUri().getPath();
        key = NativeAzureFileSystem.removeTrailingSlash(key);
        if ((key = NativeAzureFileSystem.encodeTrailingPeriod(key)).length() == 1) {
            return key;
        }
        return key.substring(1);
    }

    private static String removeTrailingSlash(String key) {
        if (key.length() == 0 || key.length() == 1) {
            return key;
        }
        if (key.charAt(key.length() - 1) == '/') {
            return key.substring(0, key.length() - 1);
        }
        return key;
    }

    static Path keyToPath(String key) {
        if (key.equals(PATH_DELIMITER)) {
            return new Path(PATH_DELIMITER);
        }
        return new Path(PATH_DELIMITER + NativeAzureFileSystem.decodeTrailingPeriod(key));
    }

    @VisibleForTesting
    public Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    @VisibleForTesting
    public AzureNativeFileSystemStore getStore() {
        return this.actualStore;
    }

    NativeFileSystemStore getStoreInterface() {
        return this.store;
    }

    private void performAuthCheck(Path requestingAccessForPath, WasbAuthorizationOperations accessType, String operation, Path originalPath) throws WasbAuthorizationException, IOException {
        if (this.azureAuthorization && this.authorizer != null) {
            requestingAccessForPath = requestingAccessForPath.makeQualified(this.getUri(), this.getWorkingDirectory());
            originalPath = originalPath.makeQualified(this.getUri(), this.getWorkingDirectory());
            String owner = this.getOwnerForPath(requestingAccessForPath);
            if (!this.authorizer.authorize(requestingAccessForPath.toString(), accessType.toString(), owner)) {
                throw new WasbAuthorizationException(operation + " operation for Path : " + originalPath.toString() + " not allowed");
            }
        }
    }

    public AzureFileSystemInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        if (!this.appendSupportEnabled) {
            throw new UnsupportedOperationException("Append Support not enabled");
        }
        LOG.debug("Opening file: {} for append", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        this.performAuthCheck(absolutePath, WasbAuthorizationOperations.WRITE, "append", absolutePath);
        String key = this.pathToKey(absolutePath);
        FileMetadata meta = null;
        try {
            meta = this.store.retrieveMetadata(key);
        }
        catch (Exception ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException(String.format("%s is not found", key));
            }
            throw ex;
        }
        if (meta == null) {
            throw new FileNotFoundException(f.toString());
        }
        if (meta.isDirectory()) {
            throw new FileNotFoundException(f.toString() + " is a directory not a file.");
        }
        if (this.store.isPageBlobKey(key)) {
            throw new IOException("Append not supported for Page Blobs");
        }
        DataOutputStream appendStream = null;
        try {
            appendStream = this.store.retrieveAppendStream(key, bufferSize);
        }
        catch (Exception ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException(String.format("%s is not found", key));
            }
            throw ex;
        }
        return new FSDataOutputStream((OutputStream)appendStream, this.statistics);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, permission, overwrite, true, bufferSize, replication, blockSize, progress, null);
    }

    public SelfRenewingLease acquireLease(Path path) throws AzureException {
        String fullKey = this.pathToKey(this.makeAbsolute(path));
        return this.getStore().acquireLease(fullKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent = f.getParent();
        SelfRenewingLease lease = null;
        if (this.store.isAtomicRenameKey(this.pathToKey(f))) {
            try {
                lease = this.acquireLease(parent);
            }
            catch (AzureException e) {
                String errorCode = "";
                try {
                    StorageException e2 = (StorageException)e.getCause();
                    errorCode = e2.getErrorCode();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (errorCode.equals("BlobNotFound")) {
                    throw new FileNotFoundException("Cannot create file " + f.getName() + " because parent folder does not exist.");
                }
                LOG.warn("Got unexpected exception trying to get lease on {} . {}", (Object)this.pathToKey(parent), (Object)e.getMessage());
                throw e;
            }
        }
        if (!this.exists(parent)) {
            try {
                lease.free();
                throw new FileNotFoundException("Cannot create file " + f.getName() + " because parent folder does not exist.");
            }
            catch (Exception e) {
                LOG.warn("Unable to free lease because: {}", (Object)e.getMessage());
            }
            throw new FileNotFoundException("Cannot create file " + f.getName() + " because parent folder does not exist.");
        }
        FSDataOutputStream out = null;
        try {
            out = this.create(f, permission, overwrite, false, bufferSize, replication, blockSize, progress, lease);
        }
        catch (Throwable throwable) {
            try {
                if (lease == null) throw throwable;
                lease.free();
                throw throwable;
            }
            catch (Exception e) {
                NativeAzureFileSystemHelper.cleanup(LOG, out);
                String msg = "Unable to free lease on " + parent.toUri();
                LOG.error(msg);
                throw new IOException(msg, e);
            }
        }
        try {
            if (lease == null) return out;
            lease.free();
            return out;
        }
        catch (Exception e) {
            NativeAzureFileSystemHelper.cleanup(LOG, (Closeable)out);
            String msg = "Unable to free lease on " + parent.toUri();
            LOG.error(msg);
            throw new IOException(msg, e);
        }
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        EnumSet<CreateFlag> createflags = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        boolean overwrite = flags.containsAll(createflags);
        return this.createNonRecursive(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.createNonRecursive(f, FsPermission.getFileDefault(), overwrite, bufferSize, replication, blockSize, progress);
    }

    private FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, boolean createParent, int bufferSize, short replication, long blockSize, Progressable progress, SelfRenewingLease parentFolderLease) throws FileAlreadyExistsException, IOException {
        LOG.debug("Creating file: {}", (Object)f.toString());
        if (this.containsColon(f)) {
            throw new IOException("Cannot create file " + f + " through WASB that has colons in the name");
        }
        Path absolutePath = this.makeAbsolute(f);
        Path ancestor = this.getAncestor(absolutePath);
        this.performAuthCheck(ancestor, WasbAuthorizationOperations.WRITE, "create", absolutePath);
        return this.createInternal(f, permission, overwrite, parentFolderLease);
    }

    protected FSDataOutputStream createInternal(Path f, FsPermission permission, boolean overwrite, SelfRenewingLease parentFolderLease) throws FileAlreadyExistsException, IOException {
        OutputStream bufOutStream;
        Path parentFolder;
        Path absolutePath = this.makeAbsolute(f);
        String key = this.pathToKey(absolutePath);
        FileMetadata existingMetadata = this.store.retrieveMetadata(key);
        if (existingMetadata != null) {
            if (existingMetadata.isDirectory()) {
                throw new FileAlreadyExistsException("Cannot create file " + f + "; already exists as a directory.");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException("File already exists:" + f);
            }
            this.performAuthCheck(absolutePath, WasbAuthorizationOperations.WRITE, "create", absolutePath);
        }
        if ((parentFolder = absolutePath.getParent()) != null && parentFolder.getParent() != null) {
            String parentKey = this.pathToKey(parentFolder);
            FileMetadata parentMetadata = this.store.retrieveMetadata(parentKey);
            if (parentMetadata != null && parentMetadata.isDirectory() && parentMetadata.getBlobMaterialization() == BlobMaterialization.Explicit) {
                if (parentFolderLease != null) {
                    this.store.updateFolderLastModifiedTime(parentKey, parentFolderLease);
                } else {
                    this.updateParentFolderLastModifiedTime(key);
                }
            } else {
                Path firstExisting = parentFolder.getParent();
                FileMetadata metadata = this.store.retrieveMetadata(this.pathToKey(firstExisting));
                while (metadata == null) {
                    firstExisting = firstExisting.getParent();
                    metadata = this.store.retrieveMetadata(this.pathToKey(firstExisting));
                }
                this.mkdirs(parentFolder, metadata.getPermission(), true);
            }
        }
        FsPermission masked = this.applyUMask(permission, UMaskApplyMode.NewFile);
        PermissionStatus permissionStatus = this.createPermissionStatus(masked);
        if (this.store.isPageBlobKey(key)) {
            bufOutStream = this.store.storefile(key, permissionStatus, key);
        } else {
            String keyEncoded = NativeAzureFileSystem.encodeKey(key);
            this.store.storeEmptyLinkFile(key, keyEncoded, permissionStatus);
            bufOutStream = new NativeAzureFsOutputStream(this.store.storefile(keyEncoded, permissionStatus, key), key, keyEncoded);
        }
        FSDataOutputStream fsOut = new FSDataOutputStream(bufOutStream, this.statistics);
        this.instrumentation.fileCreated();
        return fsOut;
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.delete(f, recursive, false);
    }

    private boolean deleteWithAuthEnabled(Path f, boolean recursive, boolean skipParentFolderLastModifiedTimeUpdate) throws IOException {
        LOG.debug("Deleting file: {}", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        Path parentPath = absolutePath.getParent();
        if (parentPath != null) {
            this.performAuthCheck(parentPath, WasbAuthorizationOperations.WRITE, "delete", absolutePath);
        } else {
            this.performAuthCheck(absolutePath, WasbAuthorizationOperations.WRITE, "delete", absolutePath);
        }
        String key = this.pathToKey(absolutePath);
        FileMetadata metaFile = null;
        try {
            metaFile = this.store.retrieveMetadata(key);
        }
        catch (IOException e) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                return false;
            }
            throw e;
        }
        if (null == metaFile) {
            return false;
        }
        FileMetadata parentMetadata = null;
        String parentKey = null;
        if (parentPath != null) {
            parentKey = this.pathToKey(parentPath);
            try {
                parentMetadata = this.store.retrieveMetadata(parentKey);
            }
            catch (IOException e) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
                if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                    throw new IOException("File " + f + " has a parent directory " + parentPath + " whose metadata cannot be retrieved. Can't resolve");
                }
                throw e;
            }
            if (parentMetadata == null) {
                throw new IOException("File " + f + " has a parent directory " + parentPath + " whose metadata cannot be retrieved. Can't resolve");
            }
            if (!parentMetadata.isDirectory()) {
                throw new AzureException("File " + f + " has a parent directory " + parentPath + " which is also a file. Can't resolve.");
            }
        }
        if (!metaFile.isDirectory()) {
            if (parentPath != null && parentPath.getParent() != null) {
                if (parentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                    LOG.debug("Found an implicit parent directory while trying to delete the file {}. Creating the directory blob for it in {}.", (Object)f, (Object)parentKey);
                    this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
                } else if (!skipParentFolderLastModifiedTimeUpdate) {
                    this.updateParentFolderLastModifiedTime(key);
                }
            }
            if (this.isStickyBitCheckViolated(metaFile, parentMetadata)) {
                throw new WasbAuthorizationException(String.format("%s has sticky bit set. File %s cannot be deleted.", parentPath, f));
            }
            try {
                if (!this.store.delete(key)) {
                    return false;
                }
                this.instrumentation.fileDeleted();
            }
            catch (IOException e) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
                if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                    return false;
                }
                throw e;
            }
        }
        LOG.debug("Directory Delete encountered: {}", (Object)f);
        if (parentPath != null && parentPath.getParent() != null && parentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
            LOG.debug("Found an implicit parent directory while trying to delete the directory {}. Creating the directory blob for it in {}. ", (Object)f, (Object)parentKey);
            this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
        }
        if (!metaFile.getKey().equals(PATH_DELIMITER) && this.isStickyBitCheckViolated(metaFile, parentMetadata)) {
            throw new WasbAuthorizationException(String.format("%s has sticky bit set. File %s cannot be deleted.", parentPath, f));
        }
        ArrayList<FileMetadata> fileMetadataList = new ArrayList<FileMetadata>();
        boolean isPartialDelete = false;
        long start = Time.monotonicNow();
        try {
            isPartialDelete = this.getFolderContentsToDelete(metaFile, fileMetadataList);
        }
        catch (IOException e) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                return false;
            }
            throw e;
        }
        long end = Time.monotonicNow();
        LOG.debug("Time taken to list {} blobs for delete operation: {} ms", (Object)fileMetadataList.size(), (Object)(end - start));
        FileMetadata[] contents = fileMetadataList.toArray(new FileMetadata[fileMetadataList.size()]);
        if (contents.length > 0 && !recursive) {
            throw new IOException("Non-recursive delete of non-empty directory " + f);
        }
        AzureFileSystemThreadTask task = new AzureFileSystemThreadTask(){

            @Override
            public boolean execute(FileMetadata file) throws IOException {
                if (!NativeAzureFileSystem.this.deleteFile(file.getKey(), file.isDirectory())) {
                    LOG.warn("Attempt to delete non-existent {} {}", (Object)(file.isDirectory() ? "directory" : "file"), (Object)file.getKey());
                }
                return true;
            }
        };
        AzureFileSystemThreadPoolExecutor executor = this.getThreadPoolExecutor(this.deleteThreadCount, "AzureBlobDeleteThread", "Delete", key, AZURE_DELETE_THREADS);
        if (!executor.executeParallel(contents, task)) {
            LOG.error("Failed to delete files / subfolders in blob {}", (Object)key);
            return false;
        }
        if (metaFile.getKey().equals(PATH_DELIMITER)) {
            LOG.error("Cannot delete root directory {}", (Object)f);
            return false;
        }
        if (isPartialDelete || this.store.retrieveMetadata(metaFile.getKey()) != null && !this.deleteFile(metaFile.getKey(), metaFile.isDirectory())) {
            LOG.error("Failed delete directory : {}", (Object)f);
            return false;
        }
        Path parent = absolutePath.getParent();
        if (parent != null && parent.getParent() != null && !skipParentFolderLastModifiedTimeUpdate) {
            this.updateParentFolderLastModifiedTime(key);
        }
        LOG.debug("Delete Successful for : {}", (Object)f);
        return true;
    }

    private boolean deleteWithoutAuth(Path f, boolean recursive, boolean skipParentFolderLastModifiedTimeUpdate) throws IOException {
        FileMetadata[] contents;
        LOG.debug("Deleting file: {}", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        Path parentPath = absolutePath.getParent();
        String key = this.pathToKey(absolutePath);
        FileMetadata metaFile = null;
        try {
            metaFile = this.store.retrieveMetadata(key);
        }
        catch (IOException e) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                return false;
            }
            throw e;
        }
        if (null == metaFile) {
            return false;
        }
        if (!metaFile.isDirectory()) {
            if (parentPath.getParent() != null) {
                String parentKey = this.pathToKey(parentPath);
                FileMetadata parentMetadata = null;
                try {
                    parentMetadata = this.store.retrieveMetadata(parentKey);
                }
                catch (IOException e) {
                    Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
                    if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                        throw new IOException("File " + f + " has a parent directory " + parentPath + " whose metadata cannot be retrieved. Can't resolve");
                    }
                    throw e;
                }
                if (parentMetadata == null) {
                    throw new IOException("File " + f + " has a parent directory " + parentPath + " whose metadata cannot be retrieved. Can't resolve");
                }
                if (!parentMetadata.isDirectory()) {
                    throw new AzureException("File " + f + " has a parent directory " + parentPath + " which is also a file. Can't resolve.");
                }
                if (parentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                    LOG.debug("Found an implicit parent directory while trying to delete the file {}. Creating the directory blob for it in {}.", (Object)f, (Object)parentKey);
                    this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
                } else if (!skipParentFolderLastModifiedTimeUpdate) {
                    this.updateParentFolderLastModifiedTime(key);
                }
            }
            try {
                if (!this.store.delete(key)) {
                    return false;
                }
                this.instrumentation.fileDeleted();
            }
            catch (IOException e) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
                if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                    return false;
                }
                throw e;
            }
        }
        LOG.debug("Directory Delete encountered: {}", (Object)f);
        if (parentPath.getParent() != null) {
            String parentKey = this.pathToKey(parentPath);
            FileMetadata parentMetadata = null;
            try {
                parentMetadata = this.store.retrieveMetadata(parentKey);
            }
            catch (IOException e) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
                if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                    throw new IOException("File " + f + " has a parent directory " + parentPath + " whose metadata cannot be retrieved. Can't resolve");
                }
                throw e;
            }
            if (parentMetadata == null) {
                throw new IOException("File " + f + " has a parent directory " + parentPath + " whose metadata cannot be retrieved. Can't resolve");
            }
            if (parentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                LOG.debug("Found an implicit parent directory while trying to delete the directory {}. Creating the directory blob for it in {}. ", (Object)f, (Object)parentKey);
                this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
            }
        }
        long start = Time.monotonicNow();
        try {
            contents = this.store.list(key, -1, -1);
        }
        catch (IOException e) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                return false;
            }
            throw e;
        }
        long end = Time.monotonicNow();
        LOG.debug("Time taken to list {} blobs for delete operation: {} ms", (Object)contents.length, (Object)(end - start));
        if (contents.length > 0 && !recursive) {
            throw new IOException("Non-recursive delete of non-empty directory " + f);
        }
        AzureFileSystemThreadTask task = new AzureFileSystemThreadTask(){

            @Override
            public boolean execute(FileMetadata file) throws IOException {
                if (!NativeAzureFileSystem.this.deleteFile(file.getKey(), file.isDirectory())) {
                    LOG.warn("Attempt to delete non-existent {} {}", (Object)(file.isDirectory() ? "directory" : "file"), (Object)file.getKey());
                }
                return true;
            }
        };
        AzureFileSystemThreadPoolExecutor executor = this.getThreadPoolExecutor(this.deleteThreadCount, "AzureBlobDeleteThread", "Delete", key, AZURE_DELETE_THREADS);
        if (!executor.executeParallel(contents, task)) {
            LOG.error("Failed to delete files / subfolders in blob {}", (Object)key);
            return false;
        }
        if (this.store.retrieveMetadata(metaFile.getKey()) != null && !this.deleteFile(metaFile.getKey(), metaFile.isDirectory())) {
            LOG.error("Failed delete directory : {}", (Object)f);
            return false;
        }
        Path parent = absolutePath.getParent();
        if (parent != null && parent.getParent() != null && !skipParentFolderLastModifiedTimeUpdate) {
            this.updateParentFolderLastModifiedTime(key);
        }
        LOG.debug("Delete Successful for : {}", (Object)f);
        return true;
    }

    public boolean delete(Path f, boolean recursive, boolean skipParentFolderLastModifiedTimeUpdate) throws IOException {
        if (this.azureAuthorization) {
            return this.deleteWithAuthEnabled(f, recursive, skipParentFolderLastModifiedTimeUpdate);
        }
        return this.deleteWithoutAuth(f, recursive, skipParentFolderLastModifiedTimeUpdate);
    }

    public AzureFileSystemThreadPoolExecutor getThreadPoolExecutor(int threadCount, String threadNamePrefix, String operation, String key, String config) {
        return new AzureFileSystemThreadPoolExecutor(threadCount, threadNamePrefix, operation, key, config);
    }

    private boolean getFolderContentsToDelete(FileMetadata folderToDelete, ArrayList<FileMetadata> finalList) throws IOException {
        boolean maxListingDepth = true;
        Stack<FileMetadata> foldersToProcess = new Stack<FileMetadata>();
        HashMap<String, FileMetadata> folderContentsMap = new HashMap<String, FileMetadata>();
        boolean isPartialDelete = false;
        Path pathToDelete = this.makeAbsolute(folderToDelete.getPath());
        foldersToProcess.push(folderToDelete);
        while (!foldersToProcess.empty()) {
            FileMetadata currentFolder = (FileMetadata)((Object)foldersToProcess.pop());
            Path currentPath = this.makeAbsolute(currentFolder.getPath());
            boolean canDeleteChildren = true;
            try {
                this.performAuthCheck(currentPath, WasbAuthorizationOperations.WRITE, "delete", pathToDelete);
            }
            catch (WasbAuthorizationException we) {
                LOG.debug("Authorization check failed for {}", (Object)currentPath);
                canDeleteChildren = false;
            }
            if (canDeleteChildren) {
                FileMetadata[] fileMetadataList;
                for (FileMetadata childItem : fileMetadataList = this.store.list(currentFolder.getKey(), -1, 1)) {
                    if (this.isStickyBitCheckViolated(childItem, currentFolder, false)) {
                        canDeleteChildren = false;
                        Path filePath = this.makeAbsolute(childItem.getPath());
                        LOG.error("User does not have permissions to delete {}. Parent directory has sticky bit set.", (Object)filePath);
                        continue;
                    }
                    if (childItem.isDirectory()) {
                        foldersToProcess.push(childItem);
                    }
                    folderContentsMap.put(childItem.getKey(), childItem);
                }
            } else {
                LOG.error("Authorization check failed. Files or folders under {} will not be processed for deletion.", (Object)currentPath);
            }
            if (canDeleteChildren) continue;
            String pathToRemove = currentFolder.getKey();
            while (!pathToRemove.equals(folderToDelete.getKey())) {
                if (folderContentsMap.containsKey(pathToRemove)) {
                    LOG.debug("Cannot delete {} since some of its contents cannot be deleted", (Object)pathToRemove);
                    folderContentsMap.remove(pathToRemove);
                }
                Path parentPath = NativeAzureFileSystem.keyToPath(pathToRemove).getParent();
                pathToRemove = this.pathToKey(parentPath);
            }
            isPartialDelete = true;
        }
        for (Map.Entry entry : folderContentsMap.entrySet()) {
            finalList.add((FileMetadata)((Object)entry.getValue()));
        }
        return isPartialDelete;
    }

    private boolean isStickyBitCheckViolated(FileMetadata metaData, FileMetadata parentMetadata, boolean throwOnException) throws IOException {
        try {
            return this.isStickyBitCheckViolated(metaData, parentMetadata);
        }
        catch (FileNotFoundException ex) {
            if (throwOnException) {
                throw ex;
            }
            LOG.debug("Encountered FileNotFoundException while performing stickybit check operation for {}", (Object)metaData.getKey());
            return true;
        }
    }

    private boolean isStickyBitCheckViolated(FileMetadata metaData, FileMetadata parentMetadata) throws IOException {
        if (!this.azureAuthorization) {
            return false;
        }
        if (parentMetadata == null) {
            throw new FileNotFoundException(String.format("Parent metadata for '%s' not found!", metaData.getKey()));
        }
        if (!parentMetadata.getPermission().getStickyBit()) {
            return false;
        }
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        String parentDirectoryOwner = parentMetadata.getOwner();
        String currentFileOwner = metaData.getOwner();
        return !parentDirectoryOwner.equalsIgnoreCase(currentUser) && !currentFileOwner.equalsIgnoreCase(currentUser);
    }

    @VisibleForTesting
    boolean deleteFile(String path, boolean isDir) throws IOException {
        if (!this.store.delete(path)) {
            return false;
        }
        if (isDir) {
            this.instrumentation.directoryDeleted();
        } else {
            this.instrumentation.fileDeleted();
        }
        return true;
    }

    public FileStatus getFileStatus(Path f) throws FileNotFoundException, IOException {
        LOG.debug("Getting the file status for {}", (Object)f.toString());
        return this.getFileStatusInternal(f);
    }

    protected boolean existsInternal(Path f) throws IOException {
        try {
            this.getFileStatusInternal(f);
            return true;
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
    }

    private FileStatus getFileStatusInternal(Path f) throws FileNotFoundException, IOException {
        Path absolutePath = this.makeAbsolute(f);
        String key = this.pathToKey(absolutePath);
        if (key.length() == 0) {
            return new FileStatus(0L, true, 1, this.store.getHadoopBlockSize(), 0L, 0L, FsPermission.getDefault(), "", "", absolutePath.makeQualified(this.getUri(), this.getWorkingDirectory()));
        }
        FileMetadata meta = null;
        try {
            meta = this.store.retrieveMetadata(key);
        }
        catch (Exception ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException(String.format("%s is not found", key));
            }
            throw ex;
        }
        if (meta != null) {
            if (meta.isDirectory()) {
                LOG.debug("Path {} is a folder.", (Object)f.toString());
                if (this.conditionalRedoFolderRename(f)) {
                    throw new FileNotFoundException(absolutePath + ": No such file or directory.");
                }
                return this.updateFileStatusPath(meta, absolutePath);
            }
            LOG.debug("Found the path: {} as a file.", (Object)f.toString());
            return this.updateFileStatusPath(meta, absolutePath);
        }
        throw new FileNotFoundException(absolutePath + ": No such file or directory.");
    }

    private boolean conditionalRedoFolderRename(Path f) throws IOException {
        if (f.getName().equals("")) {
            return false;
        }
        Path absoluteRenamePendingFile = this.renamePendingFilePath(f);
        if (this.existsInternal(absoluteRenamePendingFile)) {
            FolderRenamePending pending = new FolderRenamePending(absoluteRenamePendingFile, this);
            pending.redo();
            return true;
        }
        return false;
    }

    private Path renamePendingFilePath(Path f) {
        Path absPath = this.makeAbsolute(f);
        String key = this.pathToKey(absPath);
        key = key + "-RenamePending.json";
        return NativeAzureFileSystem.keyToPath(key);
    }

    public URI getUri() {
        return this.uri;
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        LOG.debug("Listing status for {}", (Object)f.toString());
        Path absolutePath = this.makeAbsolute(f);
        this.performAuthCheck(absolutePath, WasbAuthorizationOperations.READ, "liststatus", absolutePath);
        String key = this.pathToKey(absolutePath);
        FileMetadata meta = null;
        try {
            meta = this.store.retrieveMetadata(key);
        }
        catch (IOException ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException(String.format("%s is not found", f));
            }
            throw ex;
        }
        if (meta == null) {
            LOG.debug("Did not find any metadata for path: {}", (Object)key);
            throw new FileNotFoundException(f + " is not found");
        }
        if (!meta.isDirectory()) {
            LOG.debug("Found path as a file");
            return new FileStatus[]{this.updateFileStatusPath(meta, absolutePath)};
        }
        FileStatus[] listing = this.listWithErrorHandling(key, -1, 1);
        boolean renamed = this.conditionalRedoFolderRenames((FileMetadata[])listing);
        if (renamed) {
            listing = this.listWithErrorHandling(key, -1, 1);
        }
        FileStatus[] result = null;
        if (key.equals(PATH_DELIMITER)) {
            ArrayList<FileMetadata> status = new ArrayList<FileMetadata>(listing.length);
            for (FileStatus fileMetadata : listing) {
                if (fileMetadata.isDirectory()) {
                    if (fileMetadata.getKey().equals(AZURE_TEMP_FOLDER)) continue;
                    status.add(this.updateFileStatusPath((FileMetadata)fileMetadata, fileMetadata.getPath()));
                    continue;
                }
                status.add(this.updateFileStatusPath((FileMetadata)fileMetadata, fileMetadata.getPath()));
            }
            result = status.toArray(new FileMetadata[0]);
        } else {
            for (int i = 0; i < listing.length; ++i) {
                FileMetadata fileMetadata = listing[i];
                listing[i] = this.updateFileStatusPath(fileMetadata, fileMetadata.getPath());
            }
            result = listing;
        }
        LOG.debug("Found path as a directory with {} files in it.", (Object)result.length);
        return result;
    }

    private FileMetadata[] listWithErrorHandling(String prefix, int maxListingCount, int maxListingDepth) throws IOException {
        try {
            return this.store.list(prefix, maxListingCount, maxListingDepth);
        }
        catch (IOException ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException(String.format("%s is not found", prefix));
            }
            throw ex;
        }
    }

    private boolean conditionalRedoFolderRenames(FileMetadata[] listing) throws IllegalArgumentException, IOException {
        boolean renamed = false;
        for (FileMetadata fileMetadata : listing) {
            Path subpath = fileMetadata.getPath();
            if (!this.isRenamePendingFile(subpath)) continue;
            FolderRenamePending pending = new FolderRenamePending(subpath, this);
            pending.redo();
            renamed = true;
        }
        return renamed;
    }

    private boolean isRenamePendingFile(Path path) {
        return path.toString().endsWith("-RenamePending.json");
    }

    private FileMetadata updateFileStatusPath(FileMetadata meta, Path path) {
        meta.setPath(path.makeQualified(this.getUri(), this.getWorkingDirectory()));
        meta.removeKey();
        return meta;
    }

    private FsPermission applyUMask(FsPermission permission, UMaskApplyMode applyMode) {
        FsPermission newPermission = new FsPermission(permission);
        if (applyMode == UMaskApplyMode.NewFile || applyMode == UMaskApplyMode.NewDirectory) {
            newPermission = newPermission.applyUMask(FsPermission.getUMask((Configuration)this.getConf()));
        }
        return newPermission;
    }

    @VisibleForTesting
    PermissionStatus createPermissionStatus(FsPermission permission) throws IOException {
        return new PermissionStatus(UserGroupInformation.getCurrentUser().getShortUserName(), this.getConf().get(AZURE_DEFAULT_GROUP_PROPERTY_NAME, AZURE_DEFAULT_GROUP_DEFAULT), permission);
    }

    private Path getAncestor(Path f) throws IOException {
        Path current = f;
        Path parent = current.getParent();
        while (parent != null) {
            String currentKey = this.pathToKey(current);
            FileMetadata currentMetadata = this.store.retrieveMetadata(currentKey);
            if (currentMetadata != null && currentMetadata.isDirectory()) {
                Path ancestor = currentMetadata.getPath();
                LOG.debug("Found ancestor {}, for path: {}", (Object)ancestor.toString(), (Object)f.toString());
                return ancestor;
            }
            current = parent;
            parent = current.getParent();
        }
        return new Path(PATH_DELIMITER);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mkdirs(f, permission, false);
    }

    public boolean mkdirs(Path f, FsPermission permission, boolean noUmask) throws IOException {
        Path ancestor;
        LOG.debug("Creating directory: {}", (Object)f.toString());
        if (this.containsColon(f)) {
            throw new IOException("Cannot create directory " + f + " through WASB that has colons in the name");
        }
        Path absolutePath = this.makeAbsolute(f);
        if (absolutePath.equals((Object)(ancestor = this.getAncestor(absolutePath)))) {
            return true;
        }
        this.performAuthCheck(ancestor, WasbAuthorizationOperations.WRITE, "mkdirs", absolutePath);
        PermissionStatus permissionStatus = null;
        permissionStatus = noUmask ? this.createPermissionStatus(this.applyUMask(FsPermission.createImmutable((short)((short)(permission.toShort() | 0xC0))), UMaskApplyMode.NewDirectoryNoUmask)) : this.createPermissionStatus(this.applyUMask(permission, UMaskApplyMode.NewDirectory));
        ArrayList<String> keysToCreateAsFolder = new ArrayList<String>();
        Path current = absolutePath;
        Path parent = current.getParent();
        while (parent != null) {
            String currentKey = this.pathToKey(current);
            FileMetadata currentMetadata = this.store.retrieveMetadata(currentKey);
            if (currentMetadata != null && !currentMetadata.isDirectory()) {
                throw new FileAlreadyExistsException("Cannot create directory " + f + " because " + current + " is an existing file.");
            }
            if (currentMetadata == null) {
                keysToCreateAsFolder.add(currentKey);
            }
            current = parent;
            parent = current.getParent();
        }
        for (String currentKey : keysToCreateAsFolder) {
            this.store.storeEmptyFolder(currentKey, permissionStatus);
        }
        this.instrumentation.directoryCreated();
        return true;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws FileNotFoundException, IOException {
        InputStream inputStream;
        LOG.debug("Opening file: {}", (Object)f.toString());
        Path absolutePath = this.makeAbsolute(f);
        this.performAuthCheck(absolutePath, WasbAuthorizationOperations.READ, "read", absolutePath);
        String key = this.pathToKey(absolutePath);
        FileMetadata meta = null;
        try {
            meta = this.store.retrieveMetadata(key);
        }
        catch (Exception ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException(String.format("%s is not found", key));
            }
            throw ex;
        }
        if (meta == null) {
            throw new FileNotFoundException(f.toString());
        }
        if (meta.isDirectory()) {
            throw new FileNotFoundException(f.toString() + " is a directory not a file.");
        }
        try {
            inputStream = this.store.retrieve(key);
        }
        catch (Exception ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException(String.format("%s is not found", key));
            }
            throw ex;
        }
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new NativeAzureFsInputStream(inputStream, key, meta.getLen()), bufferSize));
    }

    public boolean rename(Path src, Path dst) throws FileNotFoundException, IOException {
        FolderRenamePending renamePending = null;
        LOG.debug("Moving {} to {}", (Object)src, (Object)dst);
        if (this.containsColon(dst)) {
            throw new IOException("Cannot rename to file " + dst + " through WASB that has colons in the name");
        }
        Path absoluteSrcPath = this.makeAbsolute(src);
        Path srcParentFolder = absoluteSrcPath.getParent();
        if (srcParentFolder == null) {
            return false;
        }
        String srcKey = this.pathToKey(absoluteSrcPath);
        if (srcKey.length() == 0) {
            return false;
        }
        this.performAuthCheck(srcParentFolder, WasbAuthorizationOperations.WRITE, "rename", absoluteSrcPath);
        if (this.azureAuthorization) {
            try {
                this.performStickyBitCheckForRenameOperation(absoluteSrcPath, srcParentFolder);
            }
            catch (FileNotFoundException ex) {
                return false;
            }
            catch (IOException ex) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
                if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                    LOG.debug("Encountered FileNotFound Exception when performing sticky bit check on {}. Failing rename", (Object)srcKey);
                    return false;
                }
                throw ex;
            }
        }
        Path absoluteDstPath = this.makeAbsolute(dst);
        Path dstParentFolder = absoluteDstPath.getParent();
        String dstKey = this.pathToKey(absoluteDstPath);
        FileMetadata dstMetadata = null;
        try {
            dstMetadata = this.store.retrieveMetadata(dstKey);
        }
        catch (IOException ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException) {
                if (NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                    LOG.debug("BlobNotFound exception encountered for Destination key : {}. Swallowing the exception to handle race condition gracefully", (Object)dstKey);
                }
            }
            throw ex;
        }
        if (dstMetadata != null && dstMetadata.isDirectory()) {
            this.performAuthCheck(absoluteDstPath, WasbAuthorizationOperations.WRITE, "rename", absoluteDstPath);
            dstKey = this.pathToKey(this.makeAbsolute(new Path(dst, src.getName())));
            LOG.debug("Destination {}  is a directory, adjusted the destination to be {}", (Object)dst, (Object)dstKey);
        } else {
            if (dstMetadata != null) {
                LOG.debug("Destination {} is an already existing file, failing the rename.", (Object)dst);
                return false;
            }
            FileMetadata parentOfDestMetadata = null;
            try {
                parentOfDestMetadata = this.store.retrieveMetadata(this.pathToKey(absoluteDstPath.getParent()));
            }
            catch (IOException ex) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
                if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                    LOG.debug("Parent of destination {} doesn't exists. Failing rename", (Object)dst);
                    return false;
                }
                throw ex;
            }
            if (parentOfDestMetadata == null) {
                LOG.debug("Parent of the destination {} doesn't exist, failing the rename.", (Object)dst);
                return false;
            }
            if (!parentOfDestMetadata.isDirectory()) {
                LOG.debug("Parent of the destination {} is a file, failing the rename.", (Object)dst);
                return false;
            }
            this.performAuthCheck(dstParentFolder, WasbAuthorizationOperations.WRITE, "rename", absoluteDstPath);
        }
        FileMetadata srcMetadata = null;
        try {
            srcMetadata = this.store.retrieveMetadata(srcKey);
        }
        catch (IOException ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                LOG.debug("Source {} doesn't exists. Failing rename", (Object)src);
                return false;
            }
            throw ex;
        }
        if (srcMetadata == null) {
            LOG.debug("Source {} doesn't exist, failing the rename.", (Object)src);
            return false;
        }
        if (!srcMetadata.isDirectory()) {
            LOG.debug("Source {} found as a file, renaming.", (Object)src);
            try {
                this.store.rename(srcKey, dstKey, false, null, false);
            }
            catch (IOException ex) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
                if (innerException instanceof StorageException) {
                    if (NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                        LOG.debug("BlobNotFoundException encountered. Failing rename", (Object)src);
                        return false;
                    }
                    if (NativeAzureFileSystemHelper.isBlobAlreadyExistsConflict((StorageException)innerException)) {
                        LOG.debug("Destination BlobAlreadyExists. Failing rename", (Object)src);
                        return false;
                    }
                }
                throw ex;
            }
        } else {
            renamePending = this.prepareAtomicFolderRename(srcKey, dstKey);
            renamePending.execute();
            LOG.debug("Renamed {} to {} successfully.", (Object)src, (Object)dst);
            renamePending.cleanup();
            return true;
        }
        this.updateParentFolderLastModifiedTime(srcKey);
        this.updateParentFolderLastModifiedTime(dstKey);
        LOG.debug("Renamed {} to {} successfully.", (Object)src, (Object)dst);
        return true;
    }

    private void updateParentFolderLastModifiedTime(String key) throws IOException {
        String parentKey;
        FileMetadata parentMetadata;
        Path parent = this.makeAbsolute(NativeAzureFileSystem.keyToPath(key)).getParent();
        if (parent != null && parent.getParent() != null && (parentMetadata = this.store.retrieveMetadata(parentKey = this.pathToKey(parent))) != null) {
            if (parentMetadata.isDirectory() && parentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
            }
            if (this.store.isAtomicRenameKey(parentKey)) {
                SelfRenewingLease lease = null;
                try {
                    lease = this.leaseSourceFolder(parentKey);
                    this.store.updateFolderLastModifiedTime(parentKey, lease);
                }
                catch (AzureException e) {
                    String errorCode = "";
                    try {
                        StorageException e2 = (StorageException)e.getCause();
                        errorCode = e2.getErrorCode();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (errorCode.equals("BlobNotFound")) {
                        throw new FileNotFoundException("Folder does not exist: " + parentKey);
                    }
                    LOG.warn("Got unexpected exception trying to get lease on {}. {}", (Object)parentKey, (Object)e.getMessage());
                    throw e;
                }
                finally {
                    try {
                        if (lease != null) {
                            lease.free();
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Unable to free lease on {}", (Object)parentKey, (Object)e);
                    }
                }
            }
            this.store.updateFolderLastModifiedTime(parentKey, null);
        }
    }

    @VisibleForTesting
    FolderRenamePending prepareAtomicFolderRename(String srcKey, String dstKey) throws IOException {
        if (this.store.isAtomicRenameKey(srcKey)) {
            SelfRenewingLease lease = this.leaseSourceFolder(srcKey);
            FolderRenamePending renamePending = new FolderRenamePending(srcKey, dstKey, lease, this);
            renamePending.writeFile(this);
            return renamePending;
        }
        FolderRenamePending renamePending = new FolderRenamePending(srcKey, dstKey, null, this);
        return renamePending;
    }

    private SelfRenewingLease leaseSourceFolder(String srcKey) throws AzureException {
        return this.store.acquireLease(srcKey);
    }

    private void performStickyBitCheckForRenameOperation(Path srcPath, Path srcParentPath) throws FileNotFoundException, WasbAuthorizationException, IOException {
        String srcKey = this.pathToKey(srcPath);
        FileMetadata srcMetadata = null;
        srcMetadata = this.store.retrieveMetadata(srcKey);
        if (srcMetadata == null) {
            LOG.debug("Source {} doesn't exist. Failing rename.", (Object)srcPath);
            throw new FileNotFoundException(String.format("%s does not exist.", srcPath));
        }
        String parentkey = this.pathToKey(srcParentPath);
        FileMetadata parentMetadata = this.store.retrieveMetadata(parentkey);
        if (parentMetadata == null) {
            LOG.debug("Path {} doesn't exist, failing rename.", (Object)srcParentPath);
            throw new FileNotFoundException(String.format("%s does not exist.", parentkey));
        }
        if (this.isStickyBitCheckViolated(srcMetadata, parentMetadata)) {
            throw new WasbAuthorizationException(String.format("Rename operation for %s is not permitted. Details : Stickybit check failed.", srcPath));
        }
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = this.makeAbsolute(newDir);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setPermission(Path p, FsPermission permission) throws FileNotFoundException, IOException {
        UserGroupInformation currentUgi;
        Path absolutePath = this.makeAbsolute(p);
        String key = this.pathToKey(absolutePath);
        FileMetadata metadata = null;
        try {
            metadata = this.store.retrieveMetadata(key);
        }
        catch (IOException ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException(String.format("File %s doesn't exists.", p));
            }
            throw ex;
        }
        if (metadata == null) {
            throw new FileNotFoundException("File doesn't exist: " + p);
        }
        if (this.azureAuthorization && !this.isAllowedUser((currentUgi = UserGroupInformation.getCurrentUser()).getShortUserName(), this.chmodAllowedUsers) && !this.isAllowedUser(currentUgi.getShortUserName(), this.daemonUsers)) {
            String owner = metadata.getOwner();
            if (!currentUgi.getShortUserName().equals(owner)) {
                throw new WasbAuthorizationException(String.format("user '%s' does not have the privilege to change the permission of files/folders.", currentUgi.getShortUserName()));
            }
        }
        permission = this.applyUMask(permission, metadata.isDirectory() ? UMaskApplyMode.ChangeExistingDirectory : UMaskApplyMode.ChangeExistingFile);
        if (metadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
            this.store.storeEmptyFolder(key, this.createPermissionStatus(permission));
        } else if (!metadata.getPermission().equals((Object)permission)) {
            this.store.changePermissionStatus(key, new PermissionStatus(metadata.getOwner(), metadata.getGroup(), permission));
        }
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        UserGroupInformation currentUgi;
        Path absolutePath = this.makeAbsolute(p);
        String key = this.pathToKey(absolutePath);
        FileMetadata metadata = null;
        try {
            metadata = this.store.retrieveMetadata(key);
        }
        catch (IOException ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException(String.format("File %s doesn't exists.", p));
            }
            throw ex;
        }
        if (metadata == null) {
            throw new FileNotFoundException("File doesn't exist: " + p);
        }
        if (this.azureAuthorization && username != null && !this.isAllowedUser((currentUgi = UserGroupInformation.getCurrentUser()).getShortUserName(), this.chownAllowedUsers)) {
            throw new WasbAuthorizationException(String.format("user '%s' does not have the privilege to change the ownership of files/folders.", currentUgi.getShortUserName()));
        }
        PermissionStatus newPermissionStatus = new PermissionStatus(username == null ? metadata.getOwner() : username, groupname == null ? metadata.getGroup() : groupname, metadata.getPermission());
        if (metadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
            this.store.storeEmptyFolder(key, newPermissionStatus);
        } else {
            this.store.changePermissionStatus(key, newPermissionStatus);
        }
    }

    public void setXAttr(Path path, String xAttrName, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        FileMetadata metadata;
        Path absolutePath = this.makeAbsolute(path);
        this.performAuthCheck(absolutePath, WasbAuthorizationOperations.WRITE, "setXAttr", absolutePath);
        String key = this.pathToKey(absolutePath);
        try {
            metadata = this.store.retrieveMetadata(key);
        }
        catch (IOException ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException("File " + path + " doesn't exists.");
            }
            throw ex;
        }
        if (metadata == null) {
            throw new FileNotFoundException("File doesn't exist: " + path);
        }
        boolean xAttrExists = this.store.retrieveAttribute(key, xAttrName) != null;
        XAttrSetFlag.validate((String)xAttrName, (boolean)xAttrExists, flag);
        this.store.storeAttribute(key, xAttrName, value);
    }

    public byte[] getXAttr(Path path, String xAttrName) throws IOException {
        FileMetadata metadata;
        Path absolutePath = this.makeAbsolute(path);
        this.performAuthCheck(absolutePath, WasbAuthorizationOperations.READ, "getXAttr", absolutePath);
        String key = this.pathToKey(absolutePath);
        try {
            metadata = this.store.retrieveMetadata(key);
        }
        catch (IOException ex) {
            Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
            if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                throw new FileNotFoundException("File " + path + " doesn't exists.");
            }
            throw ex;
        }
        if (metadata == null) {
            throw new FileNotFoundException("File doesn't exist: " + path);
        }
        return this.store.retrieveAttribute(key, xAttrName);
    }

    private boolean isAllowedUser(String username, List<String> userList) {
        boolean shouldSkipUserCheck;
        if (null == userList || userList.isEmpty()) {
            return false;
        }
        boolean bl = shouldSkipUserCheck = userList.size() == 1 && userList.get(0).equals("*");
        if (!shouldSkipUserCheck) {
            Preconditions.checkArgument((!userList.contains("*") ? 1 : 0) != 0, (Object)"User list must contain either '*' or a list of user names, but not both.");
            return userList.contains(username);
        }
        return true;
    }

    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        super.close();
        this.store.close();
        long startTime = System.currentTimeMillis();
        if (!this.getConf().getBoolean(SKIP_AZURE_METRICS_PROPERTY_NAME, false)) {
            AzureFileSystemMetricsSystem.unregisterSource(this.metricsSourceName);
            AzureFileSystemMetricsSystem.fileSystemClosed();
        }
        LOG.debug("Submitting metrics when file system closed took {} ms.", (Object)(System.currentTimeMillis() - startTime));
        this.isClosed = true;
    }

    public synchronized Token<?> getDelegationToken(String renewer) throws IOException {
        if (this.kerberosSupportEnabled) {
            return this.wasbDelegationTokenManager.getDelegationToken(renewer);
        }
        return super.getDelegationToken(renewer);
    }

    public void access(Path path, FsAction mode) throws IOException {
        if (this.azureAuthorization && this.authorizer != null) {
            try {
                this.getFileStatus(path);
                switch (mode) {
                    case READ: 
                    case READ_EXECUTE: {
                        this.performAuthCheck(path, WasbAuthorizationOperations.READ, "access", path);
                        break;
                    }
                    case WRITE: 
                    case WRITE_EXECUTE: {
                        this.performAuthCheck(path, WasbAuthorizationOperations.WRITE, "access", path);
                        break;
                    }
                    case READ_WRITE: 
                    case ALL: {
                        this.performAuthCheck(path, WasbAuthorizationOperations.READ, "access", path);
                        this.performAuthCheck(path, WasbAuthorizationOperations.WRITE, "access", path);
                        break;
                    }
                }
            }
            catch (WasbAuthorizationException wae) {
                throw new AccessControlException((Throwable)wae);
            }
        } else {
            super.access(path, mode);
        }
    }

    private boolean containsColon(Path p) {
        return p.toUri().getPath().toString().contains(":");
    }

    private void handleFilesWithDanglingTempData(Path root, DanglingFileHandler handler) throws IOException {
        FileMetadata[] listing;
        long cutoffForDangling = new Date().getTime() - (long)(this.getConf().getInt(AZURE_TEMP_EXPIRY_PROPERTY_NAME, 3600) * 1000);
        for (FileMetadata file : listing = this.store.list(this.pathToKey(root), -1, -1)) {
            FileMetadata linkMetadata;
            String link;
            if (file.isDirectory() || (link = this.store.getLinkInFileMetadata(file.getKey())) == null || (linkMetadata = this.store.retrieveMetadata(link)) == null || linkMetadata.getModificationTime() < cutoffForDangling) continue;
            handler.handleFile(file, linkMetadata);
        }
    }

    public void recoverFilesWithDanglingTempData(Path root, Path destination) throws IOException {
        LOG.debug("Recovering files with dangling temp data in {}", (Object)root);
        this.handleFilesWithDanglingTempData(root, new DanglingFileRecoverer(destination));
    }

    public void deleteFilesWithDanglingTempData(Path root) throws IOException {
        LOG.debug("Deleting files with dangling temp data in {}", (Object)root);
        this.handleFilesWithDanglingTempData(root, new DanglingFileDeleter());
    }

    protected void finalize() throws Throwable {
        LOG.debug("finalize() called.");
        this.close();
        super.finalize();
    }

    private static String encodeKey(String aKey) {
        String fileName = aKey.substring(aKey.lastIndexOf(PATH_DELIMITER) + 1, aKey.length());
        String filePrefix = "_$azuretmpfolder$/" + UUID.randomUUID().toString();
        String randomizedKey = filePrefix + fileName;
        return randomizedKey;
    }

    @VisibleForTesting
    public String getOwnerForPath(Path absolutePath) throws IOException {
        String owner;
        block4: {
            owner = "";
            FileMetadata meta = null;
            String key = this.pathToKey(absolutePath);
            try {
                meta = this.store.retrieveMetadata(key);
                if (meta != null) {
                    owner = meta.getOwner();
                    LOG.debug("Retrieved '{}' as owner for path - {}", (Object)owner, (Object)absolutePath);
                } else {
                    LOG.debug("Cannot find file/folder - '{}'. Returning owner as empty string", (Object)absolutePath);
                }
            }
            catch (IOException ex) {
                boolean isfileNotFoundException;
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(ex);
                boolean bl = isfileNotFoundException = innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException);
                if (isfileNotFoundException) break block4;
                String errorMsg = "Could not retrieve owner information for path - " + absolutePath;
                LOG.error(errorMsg);
                throw new IOException(errorMsg, ex);
            }
        }
        return owner;
    }

    @VisibleForTesting
    void updateChownAllowedUsers(List<String> chownAllowedUsers) {
        this.chownAllowedUsers = chownAllowedUsers;
    }

    @VisibleForTesting
    void updateChmodAllowedUsers(List<String> chmodAllowedUsers) {
        this.chmodAllowedUsers = chmodAllowedUsers;
    }

    @VisibleForTesting
    void updateDaemonUsers(List<String> daemonUsers) {
        this.daemonUsers = daemonUsers;
    }

    public boolean hasPathCapability(Path path, String capability) throws IOException {
        switch (PathCapabilitiesSupport.validatePathCapabilityArgs((Path)path, (String)capability)) {
            case "fs.capability.paths.permissions": {
                return true;
            }
            case "fs.capability.paths.append": {
                return this.appendSupportEnabled;
            }
        }
        return super.hasPathCapability(path, capability);
    }

    private class DanglingFileRecoverer
    extends DanglingFileHandler {
        private final Path destination;

        DanglingFileRecoverer(Path destination) {
            this.destination = destination;
        }

        @Override
        void handleFile(FileMetadata file, FileMetadata tempFile) throws IOException {
            LOG.debug("Recovering {}", (Object)file.getKey());
            String finalDestinationKey = NativeAzureFileSystem.this.pathToKey(new Path(this.destination, file.getKey()));
            NativeAzureFileSystem.this.store.rename(tempFile.getKey(), finalDestinationKey);
            if (!finalDestinationKey.equals(file.getKey())) {
                NativeAzureFileSystem.this.store.delete(file.getKey());
            }
        }
    }

    private class DanglingFileDeleter
    extends DanglingFileHandler {
        private DanglingFileDeleter() {
        }

        @Override
        void handleFile(FileMetadata file, FileMetadata tempFile) throws IOException {
            LOG.debug("Deleting dangling file {}", (Object)file.getKey());
            NativeAzureFileSystem.this.store.delete(file.getKey());
            NativeAzureFileSystem.this.store.delete(tempFile.getKey());
        }
    }

    private abstract class DanglingFileHandler {
        private DanglingFileHandler() {
        }

        abstract void handleFile(FileMetadata var1, FileMetadata var2) throws IOException;
    }

    private static enum UMaskApplyMode {
        NewFile,
        NewDirectory,
        NewDirectoryNoUmask,
        ChangeExistingFile,
        ChangeExistingDirectory;

    }

    public class NativeAzureFsOutputStream
    extends OutputStream
    implements Syncable,
    StreamCapabilities {
        private String key;
        private String keyEncoded;
        private OutputStream out;

        public NativeAzureFsOutputStream(OutputStream out, String aKey, String anEncodedKey) throws IOException {
            if (null == out) {
                throw new IllegalArgumentException("Illegal argument: the output stream is null.");
            }
            if (null == aKey || 0 == aKey.length()) {
                throw new IllegalArgumentException("Illegal argument the key string is null or empty");
            }
            if (null == anEncodedKey || 0 == anEncodedKey.length()) {
                throw new IllegalArgumentException("Illegal argument the encoded key string is null or empty");
            }
            this.out = out;
            this.setKey(aKey);
            this.setEncodedKey(anEncodedKey);
        }

        @InterfaceAudience.LimitedPrivate(value={"HDFS"})
        public OutputStream getOutStream() {
            return this.out;
        }

        public void hflush() throws IOException {
            if (this.out instanceof Syncable) {
                ((Syncable)this.out).hflush();
            } else {
                this.flush();
            }
        }

        public void hsync() throws IOException {
            if (this.out instanceof Syncable) {
                ((Syncable)this.out).hsync();
            } else {
                this.flush();
            }
        }

        public boolean hasCapability(String capability) {
            return StoreImplementationUtils.hasCapability((OutputStream)this.out, (String)capability);
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.out != null) {
                this.out.close();
                try {
                    this.restoreKey();
                }
                finally {
                    this.out = null;
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.checkOpen();
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                if (e.getCause() instanceof StorageException) {
                    StorageException storageExcp = (StorageException)e.getCause();
                    LOG.error("Encountered Storage Exception for write on Blob : {} Exception details: {} Error Code : {}", new Object[]{this.key, e.getMessage(), storageExcp.getErrorCode()});
                }
                throw e;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.checkOpen();
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                if (e.getCause() instanceof StorageException) {
                    StorageException storageExcp = (StorageException)e.getCause();
                    LOG.error("Encountered Storage Exception for write on Blob : {} Exception details: {} Error Code : {}", new Object[]{this.key, e.getMessage(), storageExcp.getErrorCode()});
                }
                throw e;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkOpen();
            try {
                this.out.write(b, off, len);
            }
            catch (IOException e) {
                if (e.getCause() instanceof StorageException) {
                    StorageException storageExcp = (StorageException)e.getCause();
                    LOG.error("Encountered Storage Exception for write on Blob : {} Exception details: {} Error Code : {}", new Object[]{this.key, e.getMessage(), storageExcp.getErrorCode()});
                }
                throw e;
            }
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getEncodedKey() {
            return this.keyEncoded;
        }

        public void setEncodedKey(String anEncodedKey) {
            this.keyEncoded = anEncodedKey;
        }

        private void restoreKey() throws IOException {
            NativeAzureFileSystem.this.store.rename(this.getEncodedKey(), this.getKey());
        }

        private void checkOpen() throws IOException {
            if (this.out == null) {
                throw new IOException("Stream is closed!");
            }
        }
    }

    private class NativeAzureFsInputStream
    extends FSInputStream {
        private InputStream in;
        private final String key;
        private long pos = 0L;
        private boolean closed = false;
        private boolean isPageBlob;
        private long fileLength;

        NativeAzureFsInputStream(InputStream in, String key, long fileLength) {
            this.in = in;
            this.key = key;
            this.isPageBlob = NativeAzureFileSystem.this.store.isPageBlobKey(key);
            this.fileLength = fileLength;
        }

        public synchronized int available() throws IOException {
            if (this.isPageBlob) {
                return this.in.available();
            }
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            long remaining = this.fileLength - this.pos;
            return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
        }

        public synchronized int read() throws FileNotFoundException, IOException {
            try {
                int result = 0;
                result = this.in.read();
                if (result != -1) {
                    ++this.pos;
                    if (NativeAzureFileSystem.this.statistics != null) {
                        NativeAzureFileSystem.this.statistics.incrementBytesRead(1L);
                    }
                }
                return result;
            }
            catch (EOFException e) {
                return -1;
            }
            catch (IOException e) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
                if (innerException instanceof StorageException) {
                    LOG.error("Encountered Storage Exception for read on Blob : {} Exception details: {} Error Code : {}", new Object[]{this.key, e, ((StorageException)innerException).getErrorCode()});
                    if (NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                        throw new FileNotFoundException(String.format("%s is not found", this.key));
                    }
                }
                throw e;
            }
        }

        public synchronized int read(byte[] b, int off, int len) throws FileNotFoundException, IOException {
            try {
                int result = 0;
                result = this.in.read(b, off, len);
                if (result > 0) {
                    this.pos += (long)result;
                }
                if (null != NativeAzureFileSystem.this.statistics && result > 0) {
                    NativeAzureFileSystem.this.statistics.incrementBytesRead((long)result);
                }
                return result;
            }
            catch (IOException e) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
                if (innerException instanceof StorageException) {
                    LOG.error("Encountered Storage Exception for read on Blob : {} Exception details: {} Error Code : {}", new Object[]{this.key, e, ((StorageException)innerException).getErrorCode()});
                    if (NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                        throw new FileNotFoundException(String.format("%s is not found", this.key));
                    }
                }
                throw e;
            }
        }

        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                IOUtils.closeStream((Closeable)this.in);
                this.in = null;
            }
        }

        public synchronized void seek(long pos) throws FileNotFoundException, EOFException, IOException {
            try {
                this.checkNotClosed();
                if (pos < 0L) {
                    throw new EOFException("Cannot seek to a negative offset");
                }
                if (this.pos > pos) {
                    if (this.in instanceof Seekable) {
                        ((Seekable)this.in).seek(pos);
                        this.pos = pos;
                    } else {
                        IOUtils.closeStream((Closeable)this.in);
                        this.in = NativeAzureFileSystem.this.store.retrieve(this.key);
                        this.pos = this.in.skip(pos);
                    }
                } else {
                    this.pos += this.in.skip(pos - this.pos);
                }
                LOG.debug("Seek to position {}. Bytes skipped {}", (Object)pos, (Object)this.pos);
            }
            catch (IOException e) {
                Throwable innerException = NativeAzureFileSystemHelper.checkForAzureStorageException(e);
                if (innerException instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)innerException)) {
                    throw new FileNotFoundException(String.format("%s is not found", this.key));
                }
                throw e;
            }
            catch (IndexOutOfBoundsException e) {
                throw new EOFException("Attempted to seek or read past the end of the file");
            }
        }

        public synchronized long getPos() throws IOException {
            return this.pos;
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed!");
            }
        }
    }

    public static class Secure
    extends NativeAzureFileSystem {
        @Override
        public String getScheme() {
            return "wasbs";
        }
    }

    public static class FolderRenamePending {
        private SelfRenewingLease folderLease;
        private String srcKey;
        private String dstKey;
        private FileMetadata[] fileMetadata = null;
        private ArrayList<String> fileStrings = null;
        private NativeAzureFileSystem fs;
        private static final int MAX_RENAME_PENDING_FILE_SIZE = 10000000;
        private static final int FORMATTING_BUFFER = 10000;
        private boolean committed;
        public static final String SUFFIX = "-RenamePending.json";
        private static final ObjectReader READER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).readerFor(JsonNode.class);

        public FolderRenamePending(String srcKey, String dstKey, SelfRenewingLease lease, NativeAzureFileSystem fs) throws IOException {
            this.srcKey = srcKey;
            this.dstKey = dstKey;
            this.folderLease = lease;
            this.fs = fs;
            long start = Time.monotonicNow();
            this.fileMetadata = fs.getStoreInterface().list(srcKey, -1, -1);
            long end = Time.monotonicNow();
            LOG.debug("Time taken to list {} blobs for rename operation is: {} ms", (Object)this.fileMetadata.length, (Object)(end - start));
            this.committed = true;
        }

        public FolderRenamePending(Path redoFile, NativeAzureFileSystem fs) throws IllegalArgumentException, IOException {
            this.fs = fs;
            Path f = redoFile;
            FSDataInputStream input = fs.open(f);
            byte[] bytes = new byte[10000000];
            int l = input.read(bytes);
            if (l <= 0) {
                LOG.error("Deleting empty rename pending file " + redoFile + " -- no data available");
                this.deleteRenamePendingFile(fs, redoFile);
                return;
            }
            if (l == 10000000) {
                throw new IOException("Error reading pending rename file contents -- maximum file size exceeded");
            }
            String contents = new String(bytes, 0, l, Charset.forName("UTF-8"));
            JsonNode json = null;
            try {
                json = (JsonNode)READER.readValue(contents);
                this.committed = true;
            }
            catch (JsonMappingException e) {
                this.committed = false;
            }
            catch (JsonParseException e) {
                this.committed = false;
            }
            catch (IOException e) {
                this.committed = false;
            }
            if (!this.committed) {
                LOG.error("Deleting corruped rename pending file {} \n {}", (Object)redoFile, (Object)contents);
                this.deleteRenamePendingFile(fs, redoFile);
                return;
            }
            ArrayList<String> fileStrList = new ArrayList<String>();
            JsonNode oldFolderName = json.get("OldFolderName");
            JsonNode newFolderName = json.get("NewFolderName");
            if (oldFolderName == null || newFolderName == null) {
                this.committed = false;
            } else {
                this.srcKey = oldFolderName.textValue();
                this.dstKey = newFolderName.textValue();
                if (this.srcKey == null || this.dstKey == null) {
                    this.committed = false;
                } else {
                    JsonNode fileList = json.get("FileList");
                    if (fileList == null) {
                        this.committed = false;
                    } else {
                        for (int i = 0; i < fileList.size(); ++i) {
                            fileStrList.add(fileList.get(i).textValue());
                        }
                    }
                }
            }
            this.fileStrings = fileStrList;
        }

        public FileMetadata[] getFiles() {
            return this.fileMetadata;
        }

        public SelfRenewingLease getFolderLease() {
            return this.folderLease;
        }

        @VisibleForTesting
        void deleteRenamePendingFile(FileSystem fs, Path redoFile) throws IOException {
            try {
                fs.delete(redoFile, false);
            }
            catch (IOException e) {
                Throwable t = e.getCause();
                if (t != null && t instanceof StorageException && "BlobNotFound".equals(((StorageException)t).getErrorCode())) {
                    LOG.warn("rename pending file " + redoFile + " is already deleted");
                }
                throw e;
            }
        }

        public void writeFile(NativeAzureFileSystem fs) throws IOException {
            Path path = this.getRenamePendingFilePath();
            LOG.debug("Preparing to write atomic rename state to {}", (Object)path.toString());
            FSDataOutputStream output = null;
            String contents = this.makeRenamePendingFileContents();
            try {
                output = fs.createInternal(path, FsPermission.getFileDefault(), false, null);
                output.write(contents.getBytes(Charset.forName("UTF-8")));
            }
            catch (IOException e) {
                try {
                    throw new IOException("Unable to write RenamePending file for folder rename from " + this.srcKey + " to " + this.dstKey, e);
                }
                catch (Throwable throwable) {
                    NativeAzureFileSystemHelper.cleanup(LOG, output);
                    throw throwable;
                }
            }
            NativeAzureFileSystemHelper.cleanup(LOG, (Closeable)output);
        }

        public String makeRenamePendingFileContents() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = sdf.format(new Date());
            StringBuilder builder = new StringBuilder();
            builder.append("[\n");
            for (int i = 0; i != this.fileMetadata.length; ++i) {
                if (i > 0) {
                    builder.append(",\n");
                }
                builder.append("    ");
                String noPrefix = StringUtils.removeStart((String)this.fileMetadata[i].getKey(), (String)(this.srcKey + NativeAzureFileSystem.PATH_DELIMITER));
                builder.append(this.quote(noPrefix));
                if (builder.length() < 9990000) continue;
                LOG.error("Internal error: Exceeded maximum rename pending file size of {} bytes.", (Object)10000000);
                return "exceeded maximum rename pending file size";
            }
            builder.append("\n  ]");
            String fileList = builder.toString();
            String contents = "{\n  FormatVersion: \"1.0\",\n  OperationUTCTime: \"" + time + "\",\n  OldFolderName: " + this.quote(this.srcKey) + ",\n  NewFolderName: " + this.quote(this.dstKey) + ",\n  FileList: " + fileList + "\n}\n";
            return contents;
        }

        private String quote(String string) {
            if (string == null || string.length() == 0) {
                return "\"\"";
            }
            char c = '\u0000';
            int len = string.length();
            StringBuilder sb = new StringBuilder(len + 4);
            sb.append('\"');
            block9: for (int i = 0; i < len; ++i) {
                c = string.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        sb.append('\\');
                        sb.append(c);
                        continue block9;
                    }
                    case '/': {
                        sb.append('\\');
                        sb.append(c);
                        continue block9;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block9;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block9;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block9;
                    }
                    default: {
                        if (c < ' ') {
                            String t = "000" + Integer.toHexString(c);
                            sb.append("\\u" + t.substring(t.length() - 4));
                            continue block9;
                        }
                        sb.append(c);
                    }
                }
            }
            sb.append('\"');
            return sb.toString();
        }

        public String getSrcKey() {
            return this.srcKey;
        }

        public String getDstKey() {
            return this.dstKey;
        }

        public FileMetadata getSourceMetadata() throws IOException {
            return this.fs.getStoreInterface().retrieveMetadata(this.srcKey);
        }

        public void execute() throws IOException {
            AzureFileSystemThreadTask task = new AzureFileSystemThreadTask(){

                @Override
                public boolean execute(FileMetadata file) throws IOException {
                    this.renameFile(file);
                    return true;
                }
            };
            AzureFileSystemThreadPoolExecutor executor = this.fs.getThreadPoolExecutor(this.fs.renameThreadCount, "AzureBlobRenameThread", "Rename", this.getSrcKey(), NativeAzureFileSystem.AZURE_RENAME_THREADS);
            executor.executeParallel(this.getFiles(), task);
            FileMetadata srcMetadata2 = this.getSourceMetadata();
            if (srcMetadata2.getBlobMaterialization() == BlobMaterialization.Explicit) {
                this.fs.getStoreInterface().rename(this.getSrcKey(), this.getDstKey(), false, this.folderLease);
            }
            this.fs.updateParentFolderLastModifiedTime(this.srcKey);
            this.fs.updateParentFolderLastModifiedTime(this.dstKey);
        }

        @VisibleForTesting
        void renameFile(FileMetadata file) throws IOException {
            if (file.getBlobMaterialization() == BlobMaterialization.Explicit) {
                String srcName = file.getKey();
                String suffix = srcName.substring(this.getSrcKey().length());
                String dstName = this.getDstKey() + suffix;
                boolean acquireLease = this.fs.getStoreInterface().isAtomicRenameKey(srcName);
                this.fs.getStoreInterface().rename(srcName, dstName, acquireLease, null);
            }
        }

        public void cleanup() throws IOException {
            if (this.fs.getStoreInterface().isAtomicRenameKey(this.srcKey)) {
                this.fs.delete(this.getRenamePendingFilePath(), false);
            }
        }

        private Path getRenamePendingFilePath() {
            String fileName = this.srcKey + SUFFIX;
            Path fileNamePath = NativeAzureFileSystem.keyToPath(fileName);
            Path path = this.fs.makeAbsolute(fileNamePath);
            return path;
        }

        public void redo() throws IOException {
            if (!this.committed) {
                return;
            }
            SelfRenewingLease lease = null;
            boolean sourceFolderGone = false;
            try {
                lease = this.fs.leaseSourceFolder(this.srcKey);
            }
            catch (AzureException e) {
                Object errorCode = "";
                try {
                    StorageException se = (StorageException)e.getCause();
                    errorCode = se.getErrorCode();
                }
                catch (Exception se) {
                    // empty catch block
                }
                if (((String)errorCode).equals("BlobNotFound")) {
                    sourceFolderGone = true;
                }
                throw new IOException("Unexpected error when trying to lease source folder name during folder rename redo", e);
            }
            if (!sourceFolderGone) {
                Path dst = this.fullPath(this.dstKey);
                if (!this.fs.existsInternal(dst)) {
                    this.fs.mkdirs(dst);
                }
                for (String fileName : this.fileStrings) {
                    this.finishSingleFileRename(fileName);
                }
                try {
                    FileMetadata srcMetaData = this.getSourceMetadata();
                    if (srcMetaData.getBlobMaterialization() == BlobMaterialization.Explicit) {
                        this.fs.getStoreInterface().rename(this.getSrcKey(), this.getDstKey(), false, lease);
                    }
                    this.fs.getStoreInterface().delete(this.srcKey, lease);
                }
                catch (Exception e) {
                    LOG.info("Unable to delete source folder during folder rename redo. If the source folder is already gone, this is not an error condition. Continuing with redo.", (Throwable)e);
                }
                this.fs.updateParentFolderLastModifiedTime(this.srcKey);
                this.fs.updateParentFolderLastModifiedTime(this.dstKey);
            }
            this.fs.delete(this.getRenamePendingFilePath(), false);
        }

        private void finishSingleFileRename(String fileName) throws IOException {
            Path srcFile = this.fullPath(this.srcKey, fileName);
            Path dstFile = this.fullPath(this.dstKey, fileName);
            String srcName = this.fs.pathToKey(srcFile);
            String dstName = this.fs.pathToKey(dstFile);
            boolean srcExists = this.fs.getStoreInterface().explicitFileExists(srcName);
            boolean dstExists = this.fs.getStoreInterface().explicitFileExists(dstName);
            if (srcExists) {
                this.fs.getStoreInterface().rename(srcName, dstName, true, null);
            } else if (srcExists || !dstExists) {
                LOG.warn("Attempting to complete rename of file " + this.srcKey + NativeAzureFileSystem.PATH_DELIMITER + fileName + " during folder rename redo, and file was not found in source or destination " + this.dstKey + NativeAzureFileSystem.PATH_DELIMITER + fileName + ". This must mean the rename of this file has already completed");
            }
        }

        private Path fullPath(String folderKey, String fileName) {
            return new Path(new Path(this.fs.getUri()), NativeAzureFileSystem.PATH_DELIMITER + folderKey + NativeAzureFileSystem.PATH_DELIMITER + fileName);
        }

        private Path fullPath(String fileKey) {
            return new Path(new Path(this.fs.getUri()), NativeAzureFileSystem.PATH_DELIMITER + fileKey);
        }
    }
}

