/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.impl.ExecutingStoreOperation;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.ITtlTimeProvider;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.DurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImportOperation
extends ExecutingStoreOperation<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(ImportOperation.class);
    private final S3AFileSystem filesystem;
    private final MetadataStore store;
    private final S3AFileStatus status;
    private final boolean authoritative;
    private final boolean verbose;
    private final Set<Path> dirCache = new HashSet<Path>();

    ImportOperation(S3AFileSystem filesystem, MetadataStore store, S3AFileStatus status, boolean authoritative, boolean verbose) {
        super(filesystem.createStoreContext());
        this.verbose = verbose;
        Preconditions.checkState((!filesystem.hasMetadataStore() ? 1 : 0) != 0, (Object)"Source filesystem for import has a metadata store");
        this.filesystem = filesystem;
        this.store = store;
        this.status = status;
        this.authoritative = authoritative;
    }

    private S3AFileSystem getFilesystem() {
        return this.filesystem;
    }

    private MetadataStore getStore() {
        return this.store;
    }

    private FileStatus getStatus() {
        return this.status;
    }

    @Override
    public Long execute() throws IOException {
        long items;
        if (this.status.isFile()) {
            PathMetadata meta = new PathMetadata(this.status);
            this.getStore().put(meta, null);
            items = 1L;
        } else {
            try (DurationInfo ignored = new DurationInfo(LOG, "Importing %s", new Object[]{this.getStatus().getPath()});){
                items = this.importDir();
            }
        }
        return items;
    }

    private long importDir() throws IOException {
        Preconditions.checkArgument((boolean)this.status.isDirectory());
        long totalCountOfEntriesWritten = 0L;
        Path basePath = this.status.getPath();
        MetadataStore ms = this.getStore();
        LOG.info("Importing directory {}", (Object)basePath);
        try (BulkOperationState operationState = ms.initiateBulkWrite(BulkOperationState.OperationType.Import, basePath);){
            long countOfFilesWritten = 0L;
            long countOfDirsWritten = 0L;
            RemoteIterator<S3ALocatedFileStatus> it = this.getFilesystem().listFilesAndEmptyDirectoriesForceNonAuth(basePath, true);
            while (it.hasNext()) {
                String t;
                S3AFileStatus child;
                S3ALocatedFileStatus located = (S3ALocatedFileStatus)((Object)it.next());
                Path path = located.getPath();
                boolean isDirectory = located.isDirectory();
                if (isDirectory) {
                    child = DynamoDBMetadataStore.makeDirStatus(path, located.getOwner());
                    this.dirCache.add(path);
                    ++countOfDirsWritten;
                } else {
                    child = located.toS3AFileStatus();
                }
                int parentsWritten = this.putParentsIfNotPresent(child, operationState);
                LOG.debug("Wrote {} parent entries", (Object)parentsWritten);
                if (!isDirectory) {
                    S3AFileStatus existingStatus;
                    PathMetadata existingEntry = S3Guard.getWithTtl(ms, path, null, false, true);
                    if (existingEntry != null && (existingStatus = existingEntry.getFileStatus()).isFile()) {
                        String existingEtag = existingStatus.getETag();
                        String childEtag = child.getETag();
                        if (child.getModificationTime() != existingStatus.getModificationTime() || existingStatus.getLen() != child.getLen() || existingEtag == null || !existingEtag.equals(childEtag)) {
                            if (childEtag.equals(existingEtag)) {
                                child.setVersionId(existingStatus.getVersionId());
                            }
                        } else {
                            child = null;
                        }
                    }
                    if (child != null) {
                        ++countOfFilesWritten;
                    }
                }
                if (child == null) continue;
                String string = t = isDirectory ? "Dir " : "File";
                if (this.verbose) {
                    LOG.info("{} {}", (Object)t, (Object)path);
                } else {
                    LOG.debug("{} {}", (Object)t, (Object)path);
                }
                S3Guard.putWithTtl(ms, new PathMetadata(child), this.getFilesystem().getTtlTimeProvider(), operationState);
                ++totalCountOfEntriesWritten;
            }
            LOG.info("Updated S3Guard with {} files and {} directory entries", (Object)countOfFilesWritten, (Object)countOfDirsWritten);
            if (this.authoritative) {
                LOG.info("Marking directory tree {} as authoritative", (Object)basePath);
                ms.markAsAuthoritative(basePath, operationState);
            }
        }
        return totalCountOfEntriesWritten;
    }

    private int putParentsIfNotPresent(FileStatus fileStatus, @Nullable BulkOperationState operationState) throws IOException {
        Preconditions.checkNotNull((Object)fileStatus);
        int count = 0;
        for (Path parent = fileStatus.getPath().getParent(); parent != null; parent = parent.getParent()) {
            if (this.dirCache.contains(parent)) {
                return count;
            }
            ITtlTimeProvider timeProvider = this.getFilesystem().getTtlTimeProvider();
            PathMetadata pmd = S3Guard.getWithTtl(this.getStore(), parent, timeProvider, false, true);
            if (pmd == null || pmd.isDeleted()) {
                S3AFileStatus dir = DynamoDBMetadataStore.makeDirStatus(parent, fileStatus.getOwner());
                S3Guard.putWithTtl(this.getStore(), new PathMetadata(dir), timeProvider, operationState);
                ++count;
            }
            this.dirCache.add(parent);
        }
        return count;
    }
}

