/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.slf4j.Logger;

public class DefaultS3ClientFactory
extends Configured
implements S3ClientFactory {
    protected static final Logger LOG = S3AFileSystem.LOG;

    @Override
    public AmazonS3 createS3Client(URI name, String bucket, AWSCredentialsProvider credentials) throws IOException {
        Configuration conf = this.getConf();
        ClientConfiguration awsConf = S3AUtils.createAwsConf(this.getConf(), bucket);
        return DefaultS3ClientFactory.configureAmazonS3Client(this.newAmazonS3Client(credentials, awsConf), conf);
    }

    protected AmazonS3 newAmazonS3Client(AWSCredentialsProvider credentials, ClientConfiguration awsConf) {
        return new AmazonS3Client(credentials, awsConf);
    }

    private static AmazonS3 configureAmazonS3Client(AmazonS3 s3, Configuration conf) throws IllegalArgumentException {
        String endPoint = conf.getTrimmed("fs.s3a.endpoint", "");
        if (!endPoint.isEmpty()) {
            try {
                s3.setEndpoint(endPoint);
            }
            catch (IllegalArgumentException e) {
                String msg = "Incorrect endpoint: " + e.getMessage();
                LOG.error(msg);
                throw new IllegalArgumentException(msg, e);
            }
        }
        return DefaultS3ClientFactory.applyS3ClientOptions(s3, conf);
    }

    private static AmazonS3 applyS3ClientOptions(AmazonS3 s3, Configuration conf) {
        boolean pathStyleAccess = conf.getBoolean("fs.s3a.path.style.access", false);
        if (pathStyleAccess) {
            LOG.debug("Enabling path style access!");
            s3.setS3ClientOptions(S3ClientOptions.builder().setPathStyleAccess(true).build());
        }
        return s3;
    }
}

