/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.DefaultS3ClientFactory;
import org.apache.hadoop.fs.s3a.S3ClientFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class Constants {
    public static final String HADOOP_TMP_DIR = "hadoop.tmp.dir";
    public static final int MULTIPART_MIN_SIZE = 0x500000;
    public static final String ACCESS_KEY = "fs.s3a.access.key";
    public static final String SECRET_KEY = "fs.s3a.secret.key";
    public static final String AWS_CREDENTIALS_PROVIDER = "fs.s3a.aws.credentials.provider";
    public static final String S3A_SECURITY_CREDENTIAL_PROVIDER_PATH = "fs.s3a.security.credential.provider.path";
    public static final String SESSION_TOKEN = "fs.s3a.session.token";
    public static final String ASSUMED_ROLE_ARN = "fs.s3a.assumed.role.arn";
    public static final String ASSUMED_ROLE_SESSION_NAME = "fs.s3a.assumed.role.session.name";
    public static final String ASSUMED_ROLE_SESSION_DURATION = "fs.s3a.assumed.role.session.duration";
    public static final String ASSUMED_ROLE_STS_ENDPOINT = "fs.s3a.assumed.role.sts.endpoint";
    public static final String ASSUMED_ROLE_STS_ENDPOINT_REGION = "fs.s3a.assumed.role.sts.endpoint.region";
    public static final String ASSUMED_ROLE_STS_ENDPOINT_REGION_DEFAULT = "us-west-1";
    public static final String ASSUMED_ROLE_SESSION_DURATION_DEFAULT = "30m";
    public static final String ASSUMED_ROLE_CREDENTIALS_PROVIDER = "fs.s3a.assumed.role.credentials.provider";
    public static final String ASSUMED_ROLE_POLICY = "fs.s3a.assumed.role.policy";
    public static final String ASSUMED_ROLE_CREDENTIALS_DEFAULT = "org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider";
    public static final String MAXIMUM_CONNECTIONS = "fs.s3a.connection.maximum";
    public static final int DEFAULT_MAXIMUM_CONNECTIONS = 15;
    public static final String SECURE_CONNECTIONS = "fs.s3a.connection.ssl.enabled";
    public static final boolean DEFAULT_SECURE_CONNECTIONS = true;
    public static final String ENDPOINT = "fs.s3a.endpoint";
    public static final String PATH_STYLE_ACCESS = "fs.s3a.path.style.access";
    public static final String PROXY_HOST = "fs.s3a.proxy.host";
    public static final String PROXY_PORT = "fs.s3a.proxy.port";
    public static final String PROXY_USERNAME = "fs.s3a.proxy.username";
    public static final String PROXY_PASSWORD = "fs.s3a.proxy.password";
    public static final String PROXY_DOMAIN = "fs.s3a.proxy.domain";
    public static final String PROXY_WORKSTATION = "fs.s3a.proxy.workstation";
    public static final String MAX_ERROR_RETRIES = "fs.s3a.attempts.maximum";
    public static final int DEFAULT_MAX_ERROR_RETRIES = 20;
    public static final String ESTABLISH_TIMEOUT = "fs.s3a.connection.establish.timeout";
    public static final int DEFAULT_ESTABLISH_TIMEOUT = 50000;
    public static final String SOCKET_TIMEOUT = "fs.s3a.connection.timeout";
    public static final int DEFAULT_SOCKET_TIMEOUT = 200000;
    public static final String SOCKET_SEND_BUFFER = "fs.s3a.socket.send.buffer";
    public static final int DEFAULT_SOCKET_SEND_BUFFER = 8192;
    public static final String SOCKET_RECV_BUFFER = "fs.s3a.socket.recv.buffer";
    public static final int DEFAULT_SOCKET_RECV_BUFFER = 8192;
    public static final String MAX_PAGING_KEYS = "fs.s3a.paging.maximum";
    public static final int DEFAULT_MAX_PAGING_KEYS = 5000;
    public static final String MAX_THREADS = "fs.s3a.threads.max";
    public static final int DEFAULT_MAX_THREADS = 10;
    public static final String KEEPALIVE_TIME = "fs.s3a.threads.keepalivetime";
    public static final int DEFAULT_KEEPALIVE_TIME = 60;
    public static final String MAX_TOTAL_TASKS = "fs.s3a.max.total.tasks";
    public static final int DEFAULT_MAX_TOTAL_TASKS = 5;
    public static final String MULTIPART_SIZE = "fs.s3a.multipart.size";
    public static final long DEFAULT_MULTIPART_SIZE = 0x6400000L;
    public static final String MIN_MULTIPART_THRESHOLD = "fs.s3a.multipart.threshold";
    public static final long DEFAULT_MIN_MULTIPART_THRESHOLD = Integer.MAX_VALUE;
    public static final String ENABLE_MULTI_DELETE = "fs.s3a.multiobjectdelete.enable";
    public static final String BUFFER_DIR = "fs.s3a.buffer.dir";
    @Deprecated
    public static final String FAST_UPLOAD = "fs.s3a.fast.upload";
    @Deprecated
    public static final boolean DEFAULT_FAST_UPLOAD = false;
    @Deprecated
    public static final String FAST_BUFFER_SIZE = "fs.s3a.fast.buffer.size";
    public static final int DEFAULT_FAST_BUFFER_SIZE = 0x100000;
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BUFFER = "fs.s3a.fast.upload.buffer";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BUFFER_DISK = "disk";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BUFFER_ARRAY = "array";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BYTEBUFFER = "bytebuffer";
    @InterfaceStability.Unstable
    public static final String DEFAULT_FAST_UPLOAD_BUFFER = "disk";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_ACTIVE_BLOCKS = "fs.s3a.fast.upload.active.blocks";
    @InterfaceStability.Unstable
    public static final int DEFAULT_FAST_UPLOAD_ACTIVE_BLOCKS = 4;
    public static final String CANNED_ACL = "fs.s3a.acl.default";
    public static final String DEFAULT_CANNED_ACL = "";
    public static final String PURGE_EXISTING_MULTIPART = "fs.s3a.multipart.purge";
    public static final boolean DEFAULT_PURGE_EXISTING_MULTIPART = false;
    public static final String PURGE_EXISTING_MULTIPART_AGE = "fs.s3a.multipart.purge.age";
    public static final long DEFAULT_PURGE_EXISTING_MULTIPART_AGE = 86400L;
    public static final String SERVER_SIDE_ENCRYPTION_ALGORITHM = "fs.s3a.server-side-encryption-algorithm";
    @Deprecated
    public static final String SERVER_SIDE_ENCRYPTION_AES256 = "AES256";
    public static final String SERVER_SIDE_ENCRYPTION_KEY = "fs.s3a.server-side-encryption.key";
    public static final String SIGNING_ALGORITHM = "fs.s3a.signing-algorithm";
    public static final String S3N_FOLDER_SUFFIX = "_$folder$";
    public static final String FS_S3A_BLOCK_SIZE = "fs.s3a.block.size";
    public static final String FS_S3A = "s3a";
    public static final String FS_S3A_PREFIX = "fs.s3a.";
    public static final String FS_S3A_BUCKET_PREFIX = "fs.s3a.bucket.";
    public static final int S3A_DEFAULT_PORT = -1;
    public static final String USER_AGENT_PREFIX = "fs.s3a.user.agent.prefix";
    public static final String METADATASTORE_AUTHORITATIVE = "fs.s3a.metadatastore.authoritative";
    public static final boolean DEFAULT_METADATASTORE_AUTHORITATIVE = false;
    public static final String READAHEAD_RANGE = "fs.s3a.readahead.range";
    public static final long DEFAULT_READAHEAD_RANGE = 65536L;
    @InterfaceStability.Unstable
    public static final String INPUT_FADVISE = "fs.s3a.experimental.input.fadvise";
    @InterfaceStability.Unstable
    public static final String INPUT_FADV_NORMAL = "normal";
    @InterfaceStability.Unstable
    public static final String INPUT_FADV_SEQUENTIAL = "sequential";
    @InterfaceStability.Unstable
    public static final String INPUT_FADV_RANDOM = "random";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String S3_CLIENT_FACTORY_IMPL = "fs.s3a.s3.client.factory.impl";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final Class<? extends S3ClientFactory> DEFAULT_S3_CLIENT_FACTORY_IMPL = DefaultS3ClientFactory.class;
    @InterfaceAudience.Private
    public static final int MAX_MULTIPART_COUNT = 10000;
    public static final String S3_METADATA_STORE_IMPL = "fs.s3a.metadatastore.impl";
    @InterfaceStability.Unstable
    public static final String S3GUARD_CLI_PRUNE_AGE = "fs.s3a.s3guard.cli.prune.age";
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_REGION_KEY = "fs.s3a.s3guard.ddb.region";
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_TABLE_NAME_KEY = "fs.s3a.s3guard.ddb.table";
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_TABLE_TAG = "fs.s3a.s3guard.ddb.table.tag.";
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_TEST_TABLE_NAME_KEY = "fs.s3a.s3guard.ddb.test.table";
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_TABLE_CREATE_KEY = "fs.s3a.s3guard.ddb.table.create";
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_TABLE_CAPACITY_READ_KEY = "fs.s3a.s3guard.ddb.table.capacity.read";
    public static final long S3GUARD_DDB_TABLE_CAPACITY_READ_DEFAULT = 500L;
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_TABLE_CAPACITY_WRITE_KEY = "fs.s3a.s3guard.ddb.table.capacity.write";
    public static final long S3GUARD_DDB_TABLE_CAPACITY_WRITE_DEFAULT = 100L;
    public static final int S3GUARD_DDB_BATCH_WRITE_REQUEST_LIMIT = 25;
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_MAX_RETRIES = "fs.s3a.s3guard.ddb.max.retries";
    public static final int S3GUARD_DDB_MAX_RETRIES_DEFAULT = 20;
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_THROTTLE_RETRY_INTERVAL = "fs.s3a.s3guard.ddb.throttle.retry.interval";
    public static final String S3GUARD_DDB_THROTTLE_RETRY_INTERVAL_DEFAULT = "100ms";
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_BACKGROUND_SLEEP_MSEC_KEY = "fs.s3a.s3guard.ddb.background.sleep";
    public static final int S3GUARD_DDB_BACKGROUND_SLEEP_MSEC_DEFAULT = 25;
    @InterfaceStability.Unstable
    public static final String S3GUARD_METASTORE_NULL = "org.apache.hadoop.fs.s3a.s3guard.NullMetadataStore";
    @InterfaceStability.Unstable
    public static final String S3GUARD_METASTORE_LOCAL = "org.apache.hadoop.fs.s3a.s3guard.LocalMetadataStore";
    @InterfaceStability.Unstable
    public static final String S3GUARD_METASTORE_LOCAL_MAX_RECORDS = "fs.s3a.s3guard.local.max_records";
    public static final int DEFAULT_S3GUARD_METASTORE_LOCAL_MAX_RECORDS = 256;
    @InterfaceStability.Unstable
    public static final String S3GUARD_METASTORE_LOCAL_ENTRY_TTL = "fs.s3a.s3guard.local.ttl";
    public static final int DEFAULT_S3GUARD_METASTORE_LOCAL_ENTRY_TTL = 10000;
    @InterfaceStability.Unstable
    public static final String S3GUARD_METASTORE_DYNAMO = "org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore";
    @InterfaceStability.Unstable
    public static final String FAIL_INJECT_INCONSISTENCY_KEY = "fs.s3a.failinject.inconsistency.key.substring";
    @InterfaceStability.Unstable
    public static final String FAIL_INJECT_INCONSISTENCY_MSEC = "fs.s3a.failinject.inconsistency.msec";
    @InterfaceStability.Unstable
    public static final String FAIL_INJECT_INCONSISTENCY_PROBABILITY = "fs.s3a.failinject.inconsistency.probability";
    @InterfaceStability.Unstable
    public static final String LIST_VERSION = "fs.s3a.list.version";
    @InterfaceStability.Unstable
    public static final int DEFAULT_LIST_VERSION = 2;
    @InterfaceStability.Unstable
    public static final String FAIL_INJECT_THROTTLE_PROBABILITY = "fs.s3a.failinject.throttle.probability";
    @InterfaceStability.Unstable
    public static final String FAIL_INJECT_CLIENT_FACTORY = "org.apache.hadoop.fs.s3a.InconsistentS3ClientFactory";
    public static final String RETRY_LIMIT = "fs.s3a.retry.limit";
    public static final int RETRY_LIMIT_DEFAULT = 20;
    public static final String RETRY_INTERVAL = "fs.s3a.retry.interval";
    public static final String RETRY_INTERVAL_DEFAULT = "500ms";
    public static final String RETRY_THROTTLE_LIMIT = "fs.s3a.retry.throttle.limit";
    public static final int RETRY_THROTTLE_LIMIT_DEFAULT = 20;
    public static final String RETRY_THROTTLE_INTERVAL = "fs.s3a.retry.throttle.interval";
    public static final String RETRY_THROTTLE_INTERVAL_DEFAULT = "500ms";
    public static final String ETAG_CHECKSUM_ENABLED = "fs.s3a.etag.checksum.enabled";
    public static final boolean ETAG_CHECKSUM_ENABLED_DEFAULT = false;
    public static final String CHANGE_DETECT_SOURCE = "fs.s3a.change.detection.source";
    public static final String CHANGE_DETECT_SOURCE_ETAG = "etag";
    public static final String CHANGE_DETECT_SOURCE_VERSION_ID = "versionid";
    public static final String CHANGE_DETECT_SOURCE_DEFAULT = "etag";
    public static final String CHANGE_DETECT_MODE = "fs.s3a.change.detection.mode";
    public static final String CHANGE_DETECT_MODE_CLIENT = "client";
    public static final String CHANGE_DETECT_MODE_SERVER = "server";
    public static final String CHANGE_DETECT_MODE_WARN = "warn";
    public static final String CHANGE_DETECT_MODE_NONE = "none";
    public static final String CHANGE_DETECT_MODE_DEFAULT = "server";
    public static final String CHANGE_DETECT_REQUIRE_VERSION = "fs.s3a.change.detection.version.required";
    public static final boolean CHANGE_DETECT_REQUIRE_VERSION_DEFAULT = true;

    private Constants() {
    }
}

