/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication;

import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.AmazonECRClientBuilder;
import com.amazonaws.services.ecr.model.AmazonECRException;
import com.amazonaws.services.ecr.model.AuthorizationData;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.security.DockerCredentialTokenIdentifier;
import org.apache.hadoop.yarn.util.DockerClientConfigHandler;
import org.apache.hadoop.yarn.util.DockerClientCredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcrDockerClientCredentialProvider
implements DockerClientCredentialProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EcrDockerClientCredentialProvider.class);
    private static final String NM_DOCKER_ENABLE_ECR_AUTO_AUTHENTICATION = "yarn.nodemanager.runtime.linux.docker.ecr-auto-authentication.enabled";
    private static final boolean DEFAULT_NM_DOCKER_ENABLE_ECR_AUTO_AUTHENTICATION = false;
    public static final String ECR_IMAGE_PATTERN = "^[0-9]+\\.dkr\\.ecr\\.[a-zA-Z0-9\\-]+.amazonaws.com([a-z0-9_./-]+)(:[\\w.-]+)?$";
    private static final Pattern ecrImagePattern = Pattern.compile("^[0-9]+\\.dkr\\.ecr\\.[a-zA-Z0-9\\-]+.amazonaws.com([a-z0-9_./-]+)(:[\\w.-]+)?$");
    private Configuration conf;
    private String clientConfig;
    private Path nmApplicationPrivateDir;
    private String imageName;
    private String applicationId;

    public void init(Configuration conf, String clientConfig, Path nmApplicationPrivateDir, String imageName, String applicationId) {
        this.conf = conf;
        this.clientConfig = clientConfig;
        this.nmApplicationPrivateDir = nmApplicationPrivateDir;
        this.imageName = imageName;
        this.applicationId = applicationId;
    }

    public Credentials getCredential() throws IOException {
        boolean enableEcrAutoAuthentication = this.conf.getBoolean(NM_DOCKER_ENABLE_ECR_AUTO_AUTHENTICATION, false);
        if (enableEcrAutoAuthentication && this.checkEcrImageName(this.imageName)) {
            File ecrTokenCachePath = new File(this.nmApplicationPrivateDir + "/ecr-token-cache");
            return this.getEcrCredential(ecrTokenCachePath, this.imageName, this.applicationId);
        }
        if (this.clientConfig == null || this.clientConfig.isEmpty()) {
            return null;
        }
        Path configFile = new Path(this.clientConfig);
        return DockerClientConfigHandler.readCredentialsFromConfigFile((Path)configFile, (Configuration)this.conf, (String)this.applicationId);
    }

    private Credentials getEcrCredential(File ecrTokenCachePath, String ecrImageName, String applicationId) throws IOException {
        Credentials credentials = new Credentials();
        String registryCred = null;
        if (ecrTokenCachePath.exists()) {
            registryCred = FileUtils.readFileToString((File)ecrTokenCachePath, (Charset)StandardCharsets.UTF_8);
        }
        if (registryCred == null || registryCred.isEmpty()) {
            try {
                AmazonECR ecr = (AmazonECR)AmazonECRClientBuilder.standard().build();
                GetAuthorizationTokenRequest tokenRequest = new GetAuthorizationTokenRequest();
                GetAuthorizationTokenResult getAuthTokenResult = ecr.getAuthorizationToken(tokenRequest);
                AuthorizationData authData = (AuthorizationData)getAuthTokenResult.getAuthorizationData().get(0);
                registryCred = authData.getAuthorizationToken();
            }
            catch (AmazonECRException e) {
                throw new IOException("Failed to get ecr authorization token: " + e.getErrorMessage());
            }
            if (registryCred == null || registryCred.isEmpty()) {
                throw new IOException("Failed to get ecr authorization token");
            }
            FileUtils.deleteQuietly((File)ecrTokenCachePath);
            FileUtils.writeStringToFile((File)ecrTokenCachePath, (String)registryCred, (Charset)StandardCharsets.UTF_8);
        }
        DockerCredentialTokenIdentifier tokenId = new DockerCredentialTokenIdentifier(ecrImageName, applicationId);
        Token token = new Token(tokenId.getBytes(), registryCred.getBytes(Charset.forName("UTF-8")), tokenId.getKind(), new Text(ecrImageName));
        credentials.addToken(new Text(ecrImageName + "-" + applicationId), token);
        LOG.info("Got token from AmazonECR");
        return credentials;
    }

    private boolean checkEcrImageName(String imageName) {
        return ecrImagePattern.matcher(imageName).matches();
    }
}

