/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AWSSecurityTokenServiceException;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider;
import org.apache.hadoop.fs.s3a.auth.STSClientFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AssumedRoleCredentialProvider
implements AWSCredentialsProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AssumedRoleCredentialProvider.class);
    public static final String NAME = "org.apache.hadoop.fs.s3a.auth.AssumedRoleCredentialProvider";
    static final String E_FORBIDDEN_PROVIDER = "AssumedRoleCredentialProvider cannot be in fs.s3a.assumed.role.credentials.provider";
    public static final String E_NO_ROLE = "Unset property fs.s3a.assumed.role.arn";
    private final STSAssumeRoleSessionCredentialsProvider stsProvider;
    private final String sessionName;
    private final long duration;
    private final String arn;
    private final AWSCredentialProviderList credentialsToSTS;
    private final Invoker invoker;

    public AssumedRoleCredentialProvider(URI fsUri, Configuration conf) throws IOException {
        this.arn = conf.getTrimmed("fs.s3a.assumed.role.arn", "");
        if (StringUtils.isEmpty((CharSequence)this.arn)) {
            throw new IOException(E_NO_ROLE);
        }
        Class<?>[] awsClasses = S3AUtils.loadAWSProviderClasses(conf, "fs.s3a.assumed.role.credentials.provider", SimpleAWSCredentialsProvider.class);
        this.credentialsToSTS = new AWSCredentialProviderList();
        for (Class<?> aClass : awsClasses) {
            if (this.getClass().equals(aClass)) {
                throw new IOException(E_FORBIDDEN_PROVIDER);
            }
            this.credentialsToSTS.add(S3AUtils.createAWSCredentialProvider(conf, aClass, fsUri));
        }
        LOG.debug("Credentials to obtain role credentials: {}", (Object)this.credentialsToSTS);
        this.sessionName = conf.getTrimmed("fs.s3a.assumed.role.session.name", AssumedRoleCredentialProvider.buildSessionName());
        this.duration = conf.getTimeDuration("fs.s3a.assumed.role.session.duration", "30m", TimeUnit.SECONDS);
        String policy = conf.getTrimmed("fs.s3a.assumed.role.policy", "");
        LOG.debug("{}", (Object)this);
        STSAssumeRoleSessionCredentialsProvider.Builder builder = new STSAssumeRoleSessionCredentialsProvider.Builder(this.arn, this.sessionName);
        builder.withRoleSessionDurationSeconds((int)this.duration);
        if (StringUtils.isNotEmpty((CharSequence)policy)) {
            LOG.debug("Scope down policy {}", (Object)policy);
            builder.withScopeDownPolicy(policy);
        }
        String endpoint = conf.get("fs.s3a.assumed.role.sts.endpoint", "");
        String region = conf.get("fs.s3a.assumed.role.sts.endpoint.region", "us-west-1");
        AWSSecurityTokenServiceClientBuilder stsbuilder = STSClientFactory.builder(conf, fsUri.getHost(), this.credentialsToSTS, endpoint, region);
        builder.withStsClient((AWSSecurityTokenService)stsbuilder.build());
        this.stsProvider = builder.build();
        this.invoker = new Invoker(new S3ARetryPolicy(conf), this::operationRetried);
        this.getCredentials();
    }

    public AWSCredentials getCredentials() {
        try {
            return (AWSCredentials)this.invoker.retryUntranslated("getCredentials", true, () -> ((STSAssumeRoleSessionCredentialsProvider)this.stsProvider).getCredentials());
        }
        catch (IOException e) {
            throw new AmazonClientException("getCredentials failed: " + e, (Throwable)e);
        }
        catch (AWSSecurityTokenServiceException e) {
            LOG.error("Failed to get credentials for role {}", (Object)this.arn, (Object)e);
            throw e;
        }
    }

    public void refresh() {
        this.stsProvider.refresh();
    }

    @Override
    public void close() {
        S3AUtils.closeAutocloseables(LOG, new AutoCloseable[]{this.stsProvider, this.credentialsToSTS});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AssumedRoleCredentialProvider{");
        sb.append("role='").append(this.arn).append('\'');
        sb.append(", session'").append(this.sessionName).append('\'');
        sb.append(", duration=").append(this.duration);
        sb.append('}');
        return sb.toString();
    }

    static String buildSessionName() throws IOException {
        return AssumedRoleCredentialProvider.sanitize(UserGroupInformation.getCurrentUser().getShortUserName());
    }

    @VisibleForTesting
    static String sanitize(String session) {
        StringBuilder r = new StringBuilder(session.length());
        for (char c : session.toCharArray()) {
            if ("abcdefghijklmnopqrstuvwxyz0123456789,.@-".contains(Character.toString(c).toLowerCase(Locale.ENGLISH))) {
                r.append(c);
                continue;
            }
            r.append('-');
        }
        return r.toString();
    }

    public void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        if (retries == 0) {
            LOG.info("Retried {}", (Object)text);
        }
    }
}

