/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.GroovyClassLoader;
import groovyjarjarantlr4.v4.runtime.tree.ParseTreeVisitor;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarpicocli.CommandLine;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.groovy.io.StringBuilderWriter;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ant.FileSystemCompilerFacade;
import org.codehaus.groovy.ant.LoggingHelper;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceExtensionHandler;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.tools.ErrorReporter;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;

public class Groovyc
extends MatchingTask {
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final LoggingHelper log = new LoggingHelper((Task)this);
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private Path compileSourcepath;
    private String encoding;
    private boolean stacktrace;
    private boolean verbose;
    private boolean includeAntRuntime = true;
    private boolean includeJavaRuntime;
    private boolean fork;
    private File forkJavaHome;
    private String forkedExecutable;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    private String scriptExtension = "*.groovy";
    private String targetBytecode;
    protected boolean failOnError = true;
    protected boolean listFiles;
    protected File[] compileList = EMPTY_FILE_ARRAY;
    private String updatedProperty;
    private String errorProperty;
    private boolean taskSuccess = true;
    private boolean includeDestClasses = true;
    protected CompilerConfiguration configuration;
    private Javac javac;
    private boolean jointCompilation;
    private final List<File> temporaryFiles = new ArrayList<File>(2);
    private File stubDir;
    private boolean keepStubs;
    private boolean forceLookupUnnamedFiles;
    private String scriptBaseClass;
    private String configscript;
    private Set<String> scriptExtensions = new LinkedHashSet<String>();
    private boolean parameters;
    private boolean previewFeatures;

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setScriptExtension(String scriptExtension) {
        this.scriptExtension = scriptExtension.startsWith("*.") ? scriptExtension : (scriptExtension.startsWith(".") ? "*" + scriptExtension : "*." + scriptExtension);
    }

    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public void setTargetBytecode(String version) {
        this.targetBytecode = Arrays.asList(CompilerConfiguration.ALLOWED_JDKS).contains(version) ? version : null;
    }

    public String getTargetBytecode() {
        return this.targetBytecode;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSourcepath(Path sourcepath) {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = sourcepath;
        } else {
            this.compileSourcepath.append(sourcepath);
        }
    }

    public Path getSourcepath() {
        return this.compileSourcepath;
    }

    public Path createSourcepath() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public void setSourcepathRef(Reference r) {
        this.createSourcepath().setRefid(r);
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setListfiles(boolean list) {
        this.listFiles = list;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProceed(boolean proceed) {
        this.failOnError = !proceed;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setMemoryInitialSize(String memoryInitialSize) {
        this.memoryInitialSize = memoryInitialSize;
    }

    public String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public void setMemoryMaximumSize(String memoryMaximumSize) {
        this.memoryMaximumSize = memoryMaximumSize;
    }

    public String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setFork(boolean f) {
        this.fork = f;
    }

    public void setJavaHome(File home) {
        this.forkJavaHome = home;
    }

    public void setExecutable(String forkExecPath) {
        this.forkedExecutable = forkExecPath;
    }

    public String getExecutable() {
        return this.forkedExecutable;
    }

    public void setUpdatedProperty(String updatedProperty) {
        this.updatedProperty = updatedProperty;
    }

    public void setErrorProperty(String errorProperty) {
        this.errorProperty = errorProperty;
    }

    public void setIncludeDestClasses(boolean includeDestClasses) {
        this.includeDestClasses = includeDestClasses;
    }

    public boolean isIncludeDestClasses() {
        return this.includeDestClasses;
    }

    public boolean getTaskSuccess() {
        return this.taskSuccess;
    }

    public void addConfiguredJavac(Javac javac) {
        this.javac = javac;
        this.jointCompilation = true;
    }

    public void setStacktrace(boolean stacktrace) {
        this.stacktrace = stacktrace;
    }

    @Deprecated
    public void setIndy(boolean indy) {
        if (!indy) {
            throw new BuildException("Disabling indy is no longer supported!", this.getLocation());
        }
    }

    @Deprecated
    public boolean getIndy() {
        return true;
    }

    public void setScriptBaseClass(String scriptBaseClass) {
        this.scriptBaseClass = scriptBaseClass;
    }

    public String getScriptBaseClass() {
        return this.scriptBaseClass;
    }

    public String getConfigscript() {
        return this.configscript;
    }

    public void setConfigscript(String configscript) {
        this.configscript = configscript;
    }

    public void setStubdir(File stubDir) {
        this.jointCompilation = true;
        this.stubDir = stubDir;
    }

    public File getStubdir() {
        return this.stubDir;
    }

    public void setKeepStubs(boolean keepStubs) {
        this.keepStubs = keepStubs;
    }

    public boolean getKeepStubs() {
        return this.keepStubs;
    }

    public void setForceLookupUnnamedFiles(boolean forceLookupUnnamedFiles) {
        this.forceLookupUnnamedFiles = forceLookupUnnamedFiles;
    }

    public boolean getForceLookupUnnamedFiles() {
        return this.forceLookupUnnamedFiles;
    }

    public void setParameters(boolean parameters) {
        this.parameters = parameters;
    }

    public boolean getParameters() {
        return this.parameters;
    }

    public void setPreviewFeatures(boolean previewFeatures) {
        this.previewFeatures = previewFeatures;
    }

    public boolean getPreviewFeatures() {
        return this.previewFeatures;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        this.loadRegisteredScriptExtensions();
        if (this.javac != null) {
            this.jointCompilation = true;
        }
        for (String filename : this.src.list()) {
            File file = this.getProject().resolveFile(filename);
            if (!file.exists()) {
                throw new BuildException("srcdir \"" + file.getPath() + "\" does not exist!", this.getLocation());
            }
            if (file.isDirectory()) {
                DirectoryScanner ds = this.getDirectoryScanner(file);
                this.scanDir(file, this.destDir != null ? this.destDir : file, ds.getIncludedFiles());
                continue;
            }
            this.compileList = Arrays.copyOf(this.compileList, this.compileList.length + 1);
            this.compileList[this.compileList.length - 1] = file;
        }
        this.compile();
        if (this.taskSuccess && this.compileList.length > 0 && this.updatedProperty != null) {
            this.getProject().setNewProperty(this.updatedProperty, "true");
        }
    }

    protected void resetFileLists() {
        this.compileList = EMPTY_FILE_ARRAY;
        this.scriptExtensions = new LinkedHashSet<String>();
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper gpm = new GlobPatternMapper();
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        for (String extension : this.getScriptExtensions()) {
            gpm.setFrom("*." + extension);
            gpm.setTo("*.class");
            this.addToCompileList(sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)gpm));
        }
        if (this.jointCompilation) {
            gpm.setFrom("*.java");
            gpm.setTo("*.class");
            this.addToCompileList(sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)gpm));
        }
    }

    protected void addToCompileList(File[] newFiles) {
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    public File[] getFileList() {
        return (File[])this.compileList.clone();
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null || this.src.isEmpty()) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
        }
        if (this.encoding != null && !Charset.isSupported(this.encoding)) {
            throw new BuildException("encoding \"" + this.encoding + "\" not supported.", this.getLocation());
        }
    }

    private void listFiles() {
        if (this.listFiles) {
            for (File srcFile : this.compileList) {
                this.log.info(srcFile.getAbsolutePath());
            }
        }
    }

    private List<String> extractJointOptions(Path classpath) {
        ArrayList<String> jointOptions = new ArrayList<String>();
        if (!this.jointCompilation) {
            return jointOptions;
        }
        if (this.javac.getDebug()) {
            jointOptions.add("-Fg" + Optional.ofNullable(this.javac.getDebugLevel()).map(level -> ":" + level).orElse(""));
        } else {
            jointOptions.add("-Fg:none");
        }
        if (this.javac.getDeprecation()) {
            jointOptions.add("-Fdeprecation");
        }
        if (this.javac.getNowarn()) {
            jointOptions.add("-Fnowarn");
        }
        if (this.javac.getVerbose()) {
            jointOptions.add("-Fverbose");
        }
        RuntimeConfigurable rc = this.javac.getRuntimeConfigurableWrapper();
        for (Map.Entry e : rc.getAttributeMap().entrySet()) {
            String key = (String)e.getKey();
            if (key.equals("depend") || key.equals("encoding") || key.equals("extdirs") || key.equals("nativeheaderdir") || key.equals("release") || key.equals("source") || key.equals("target")) {
                if (key.equals("nativeheaderdir")) {
                    key = "h";
                } else if (key.equals("release")) {
                    key = "-" + key;
                }
                jointOptions.add("-J" + key + "=" + this.getProject().replaceProperties(e.getValue().toString()));
                continue;
            }
            if (key.contains("classpath")) {
                if (key.startsWith("boot")) {
                    jointOptions.add("-Jbootclasspath=" + this.javac.getBootclasspath());
                    continue;
                }
                classpath.add(this.javac.getClasspath());
                continue;
            }
            if (key.contains("module") && key.contains("path")) {
                if (key.startsWith("upgrade")) {
                    jointOptions.add("-J-upgrade-module-path=" + this.javac.getUpgrademodulepath());
                    continue;
                }
                if (key.contains("source")) {
                    jointOptions.add("-J-module-source-path=" + this.javac.getModulesourcepath());
                    continue;
                }
                jointOptions.add("-J-module-path=" + this.javac.getModulepath());
                continue;
            }
            if (key.contains("debug") || key.equals("deprecation") || key.equals("nowarn") || key.equals("verbose")) continue;
            this.log.warn("The option " + key + " cannot be set on the contained <javac> element. The option will be ignored.");
        }
        for (RuntimeConfigurable childrc : Collections.list(rc.getChildren())) {
            if (!childrc.getElementTag().equals("compilerarg")) continue;
            for (Map.Entry e : childrc.getAttributeMap().entrySet()) {
                String key = (String)e.getKey();
                if (!key.equals("value")) continue;
                String value = this.getProject().replaceProperties(e.getValue().toString());
                StringTokenizer st = new StringTokenizer(value, " ");
                while (st.hasMoreTokens()) {
                    String option = st.nextToken();
                    jointOptions.add(option.replaceFirst("^-(W|X|proc:)", "-F$1"));
                }
            }
        }
        return jointOptions;
    }

    private void doForkCommandLineList(List<String> commandLineList, Path classpath, String separator) {
        String[] bootstrapClasspath;
        if (this.forkedExecutable != null && !this.forkedExecutable.isEmpty()) {
            commandLineList.add(this.forkedExecutable);
        } else {
            String javaHome = this.forkJavaHome != null ? this.forkJavaHome.getPath() : System.getProperty("java.home");
            commandLineList.add(javaHome + separator + "bin" + separator + "java");
        }
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        if (loader instanceof AntClassLoader) {
            bootstrapClasspath = ((AntClassLoader)loader).getClasspath().split(File.pathSeparator);
        } else {
            Class[] bootstrapClasses = new Class[]{FileSystemCompilerFacade.class, FileSystemCompiler.class, ParseTreeVisitor.class, ClassVisitor.class, CommandLine.class};
            bootstrapClasspath = (String[])Arrays.stream(bootstrapClasses).map(Groovyc::getLocation).map(uri -> new File((URI)uri).getAbsolutePath()).distinct().toArray(String[]::new);
        }
        if (bootstrapClasspath.length > 0) {
            commandLineList.add("-classpath");
            commandLineList.add(this.getClasspathRelative(bootstrapClasspath));
        }
        if (this.memoryInitialSize != null && !this.memoryInitialSize.isEmpty()) {
            commandLineList.add("-Xms" + this.memoryInitialSize);
        }
        if (this.memoryMaximumSize != null && !this.memoryMaximumSize.isEmpty()) {
            commandLineList.add("-Xmx" + this.memoryMaximumSize);
        }
        if (this.targetBytecode != null) {
            commandLineList.add("-Dgroovy.target.bytecode=" + this.targetBytecode);
        }
        if (!this.getScriptExtension().equals("*.groovy")) {
            String tmpExtension = this.getScriptExtension();
            if (tmpExtension.startsWith("*.")) {
                tmpExtension = tmpExtension.substring(1);
            }
            commandLineList.add("-Dgroovy.default.scriptExtension=" + tmpExtension);
        }
        commandLineList.add(FileSystemCompilerFacade.class.getName());
        commandLineList.add("--classpath");
        if (this.includeAntRuntime) {
            classpath.addExisting(new Path(this.getProject()).concatSystemClasspath("last"));
        }
        if (this.includeJavaRuntime) {
            classpath.addJavaRuntime();
        }
        commandLineList.add(this.getClasspathRelative(classpath.list()));
        if (this.forceLookupUnnamedFiles) {
            commandLineList.add("--forceLookupUnnamedFiles");
        }
    }

    private String getClasspathRelative(String[] classpath) {
        String baseDir = this.getProject().getBaseDir().getAbsolutePath();
        StringBuilder sb = new StringBuilder();
        for (String next : classpath) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            if (next.startsWith(baseDir)) {
                sb.append(".").append(next, baseDir.length(), next.length());
                continue;
            }
            sb.append(next);
        }
        return sb.toString();
    }

    private static URI getLocation(Class<?> clazz) {
        try {
            return clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void doNormalCommandLineList(List<String> commandLineList, List<String> jointOptions, Path classpath) {
        if (!this.fork && !classpath.isEmpty()) {
            commandLineList.add("--classpath");
            commandLineList.add(classpath.toString());
        }
        if (this.jointCompilation) {
            commandLineList.add("-j");
            commandLineList.addAll(jointOptions);
        }
        if (this.destDir != null) {
            commandLineList.add("-d");
            commandLineList.add(this.destDir.getPath());
        }
        if (this.encoding != null) {
            commandLineList.add("--encoding");
            commandLineList.add(this.encoding);
        }
        if (this.stacktrace) {
            commandLineList.add("-e");
        }
        if (this.parameters) {
            commandLineList.add("--parameters");
        }
        if (this.previewFeatures) {
            commandLineList.add("--enable-preview");
        }
        if (this.scriptBaseClass != null) {
            commandLineList.add("-b");
            commandLineList.add(this.scriptBaseClass);
        }
        if (this.configscript != null) {
            commandLineList.add("--configscript");
            commandLineList.add(this.configscript);
        }
    }

    private void addSourceFiles(List<String> commandLineList) {
        int count = 0;
        if (this.fork) {
            for (File file : this.compileList) {
                count += file.getPath().length();
            }
            for (Object e : commandLineList) {
                count += e.toString().length();
            }
            count += this.compileList.length;
            count += commandLineList.size();
        }
        if (this.fork && count > Short.MAX_VALUE) {
            try {
                File tempFile = File.createTempFile("groovyc-files-", ".txt");
                this.temporaryFiles.add(tempFile);
                PrintWriter printWriter = this.printWriter(tempFile);
                for (File srcFile : this.compileList) {
                    printWriter.println(srcFile.getPath());
                }
                printWriter.close();
                commandLineList.add("@" + tempFile.getPath());
            }
            catch (IOException e) {
                this.log.error("Error creating file list", e);
            }
        } else {
            for (File file : this.compileList) {
                commandLineList.add(file.getPath());
            }
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="This is only used to store filenames when exceeding a particular length limit when in fork mode")
    private PrintWriter printWriter(File tempFile) throws IOException {
        return new PrintWriter(new FileWriter(tempFile));
    }

    private String[] makeCommandLine(List<String> commandLineList) {
        CharSequence[] commandLine = commandLineList.toArray(EMPTY_STRING_ARRAY);
        this.log.verbose("Compilation arguments:\n" + String.join((CharSequence)"\n", commandLine));
        return commandLine;
    }

    private void runForked(String[] commandLine) {
        Execute executor = new Execute();
        executor.setAntRun(this.getProject());
        executor.setWorkingDirectory(this.getProject().getBaseDir());
        executor.setCommandline(commandLine);
        try {
            executor.execute();
        }
        catch (IOException ioe) {
            throw new BuildException("Error running forked groovyc.", (Throwable)ioe);
        }
        int returnCode = executor.getExitValue();
        if (returnCode != 0) {
            this.taskSuccess = false;
            if (this.errorProperty != null) {
                this.getProject().setNewProperty(this.errorProperty, "true");
            }
            if (this.failOnError) {
                throw new BuildException("Forked groovyc returned error code: " + returnCode);
            }
            this.log.error("Forked groovyc returned error code: " + returnCode);
        }
    }

    private void runCompiler(String[] commandLine) {
        block12: {
            try {
                String[] fileNames;
                boolean fileNameErrors;
                FileSystemCompiler.CompilationOptions options = new FileSystemCompiler.CompilationOptions();
                FileSystemCompiler.configureParser((FileSystemCompiler.CompilationOptions)options).parseArgs(commandLine);
                this.configuration = options.toCompilerConfiguration();
                this.configuration.setScriptExtensions(this.getScriptExtensions());
                String tmpExtension = this.getScriptExtension();
                if (tmpExtension.startsWith("*.")) {
                    tmpExtension = tmpExtension.substring(1);
                }
                this.configuration.setDefaultScriptExtension(tmpExtension);
                if (this.targetBytecode != null) {
                    this.configuration.setTargetBytecode(this.targetBytecode);
                }
                boolean bl = fileNameErrors = (fileNames = options.generateFileNames()) == null || !FileSystemCompiler.validateFiles((String[])fileNames);
                if (fileNameErrors) break block12;
                try (GroovyClassLoader loader = this.buildClassLoaderFor();){
                    FileSystemCompiler.doCompilation((CompilerConfiguration)this.configuration, (CompilationUnit)this.makeCompileUnit(loader), (String[])fileNames, (boolean)this.forceLookupUnnamedFiles);
                }
            }
            catch (Exception e) {
                Throwable t = e;
                if (e.getClass() == RuntimeException.class && e.getCause() != null) {
                    t = e.getCause();
                }
                StringBuilderWriter writer = new StringBuilderWriter();
                new ErrorReporter(t, false).write(new PrintWriter((Writer)writer));
                this.log.error(writer.toString());
                this.taskSuccess = false;
                if (this.errorProperty != null) {
                    this.getProject().setNewProperty(this.errorProperty, "true");
                }
                if (!this.failOnError) break block12;
                throw new BuildException("Compilation Failed", t, this.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compile() {
        if (this.compileList.length == 0) {
            return;
        }
        try {
            this.log.info("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            this.listFiles();
            Path classpath = Optional.ofNullable(this.getClasspath()).orElse(new Path(this.getProject()));
            List<String> jointOptions = this.extractJointOptions(classpath);
            ArrayList<String> commandLineList = new ArrayList<String>();
            if (this.fork) {
                this.doForkCommandLineList(commandLineList, classpath, File.separator);
            }
            this.doNormalCommandLineList(commandLineList, jointOptions, classpath);
            this.addSourceFiles(commandLineList);
            String[] commandLine = this.makeCommandLine(commandLineList);
            if (this.fork) {
                this.runForked(commandLine);
            } else {
                this.runCompiler(commandLine);
            }
        }
        finally {
            for (File temporaryFile : this.temporaryFiles) {
                try {
                    FileSystemCompiler.deleteRecursive((File)temporaryFile);
                }
                catch (Throwable t) {
                    System.err.println("error: could not delete temp files - " + temporaryFile.getPath());
                }
            }
        }
    }

    @Deprecated
    protected CompilationUnit makeCompileUnit() {
        return this.makeCompileUnit(this.buildClassLoaderFor());
    }

    protected CompilationUnit makeCompileUnit(GroovyClassLoader loader) {
        Map options = this.configuration.getJointCompilationOptions();
        if (options != null) {
            if (this.keepStubs) {
                options.put("keepStubs", Boolean.TRUE);
            }
            if (this.stubDir != null) {
                options.put("stubDir", this.stubDir);
            } else {
                try {
                    File tempStubDir = DefaultGroovyStaticMethods.createTempDir(null, (String)"groovy-generated-", (String)"-java-source");
                    this.temporaryFiles.add(tempStubDir);
                    options.put("stubDir", tempStubDir);
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
            return new JavaAwareCompilationUnit(this.configuration, loader);
        }
        return new CompilationUnit(this.configuration, null, loader);
    }

    protected GroovyClassLoader buildClassLoaderFor() {
        if (this.fork) {
            throw new GroovyBugError("Cannot use Groovyc#buildClassLoaderFor() for forked compilation");
        }
        if (!this.getIncludeantruntime()) {
            throw new IllegalArgumentException("The includeAntRuntime=false option is not compatible with fork=false");
        }
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        if (loader instanceof AntClassLoader) {
            AntClassLoader antLoader = (AntClassLoader)loader;
            String[] pathElm = antLoader.getClasspath().split(File.pathSeparator, -1);
            List classpath = this.configuration.getClasspath();
            for (String cpEntry : classpath) {
                boolean found = false;
                for (String path : pathElm) {
                    if (!cpEntry.equals(path)) continue;
                    found = true;
                    break;
                }
                if (found || !new File(cpEntry).exists()) continue;
                try {
                    antLoader.addPathElement(cpEntry);
                }
                catch (BuildException e) {
                    this.log.warn("The classpath entry " + cpEntry + " is not a valid Java resource");
                }
            }
        }
        GroovyClassLoader groovyLoader = AccessController.doPrivileged(() -> new GroovyClassLoader(loader, this.configuration));
        if (!this.forceLookupUnnamedFiles) {
            groovyLoader.setResourceLoader(filename -> null);
        }
        return groovyLoader;
    }

    private Set<String> getScriptExtensions() {
        return this.scriptExtensions;
    }

    private void loadRegisteredScriptExtensions() {
        if (this.scriptExtensions.isEmpty()) {
            this.scriptExtensions.add(this.getScriptExtension().substring(2));
            Path classpath = Optional.ofNullable(this.getClasspath()).orElse(new Path(this.getProject()));
            try (GroovyClassLoader loader = new GroovyClassLoader(((Object)((Object)this)).getClass().getClassLoader());){
                for (String element : classpath.list()) {
                    loader.addClasspath(element);
                }
                this.scriptExtensions.addAll(SourceExtensionHandler.getRegisteredExtensions((ClassLoader)loader));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

