/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.extensions.config.converter.secure;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Locale;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class PBECipher {
    private static final int SPICE_SIZE = 16;
    private static final int SALT_SIZE = 8;
    private static final int CHUNK_SIZE = 16;
    private static final String DIGEST_ALG = "SHA-256";
    private static final String KEY_ALG = "AES";
    private static final String CIPHER_ALG = "AES/CBC/PKCS5Padding";
    private final MessageDigest digester;
    private final SecureRandom secureRandom;

    PBECipher() {
        try {
            this.digester = MessageDigest.getInstance(DIGEST_ALG);
            boolean onLinux = System.getProperty("os.name", "blah").toLowerCase(Locale.ROOT).contains("linux");
            this.secureRandom = !onLinux ? new SecureRandom() : null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private byte[] getSalt(int numBytes) {
        if (this.secureRandom != null) {
            this.secureRandom.setSeed(System.currentTimeMillis());
            return this.secureRandom.generateSeed(numBytes);
        }
        byte[] res = new byte[numBytes];
        new Random(System.currentTimeMillis()).nextBytes(res);
        return res;
    }

    String encrypt64(String clearText, byte[] password) {
        try {
            byte[] clearBytes = clearText.getBytes(StandardCharsets.UTF_8);
            byte[] salt = this.getSalt(8);
            if (this.secureRandom != null) {
                new SecureRandom().nextBytes(salt);
            }
            Cipher cipher = this.createCipher(password, salt, 1);
            byte[] encryptedBytes = cipher.doFinal(clearBytes);
            int len = encryptedBytes.length;
            byte padLen = (byte)(16 - (8 + len + 1) % 16);
            int totalLen = 8 + len + padLen + 1;
            byte[] allEncryptedBytes = this.getSalt(totalLen);
            System.arraycopy(salt, 0, allEncryptedBytes, 0, 8);
            allEncryptedBytes[8] = padLen;
            System.arraycopy(encryptedBytes, 0, allEncryptedBytes, 9, len);
            byte[] encryptedTextBytes = Base64.getEncoder().encode(allEncryptedBytes);
            return new String(encryptedTextBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    String decrypt64(String encryptedText, byte[] password) {
        try {
            byte[] allEncryptedBytes = Base64.getDecoder().decode(encryptedText.getBytes());
            int totalLen = allEncryptedBytes.length;
            byte[] salt = new byte[8];
            System.arraycopy(allEncryptedBytes, 0, salt, 0, 8);
            byte padLen = allEncryptedBytes[8];
            byte[] encryptedBytes = new byte[totalLen - 8 - 1 - padLen];
            System.arraycopy(allEncryptedBytes, 9, encryptedBytes, 0, encryptedBytes.length);
            Cipher cipher = this.createCipher(password, salt, 2);
            byte[] clearBytes = cipher.doFinal(encryptedBytes);
            return new String(clearBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Cipher createCipher(byte[] pwdAsBytes, byte[] inputSalt, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        this.digester.reset();
        byte[] keyAndIv = new byte[32];
        byte[] salt = inputSalt == null || inputSalt.length == 0 ? null : inputSalt;
        int currentPos = 0;
        while (currentPos < keyAndIv.length) {
            int stillNeed;
            byte[] result;
            this.digester.update(pwdAsBytes);
            if (salt != null) {
                this.digester.update(salt, 0, 8);
            }
            if ((result = this.digester.digest()).length > (stillNeed = keyAndIv.length - currentPos)) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result, 0, b, 0, b.length);
                result = b;
            }
            System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
            if ((currentPos += result.length) >= keyAndIv.length) continue;
            this.digester.reset();
            this.digester.update(result);
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(keyAndIv, 0, key, 0, key.length);
        System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
        Cipher cipher = Cipher.getInstance(CIPHER_ALG);
        cipher.init(mode, (Key)new SecretKeySpec(key, KEY_ALG), new IvParameterSpec(iv));
        return cipher;
    }
}

