/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.buildutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class Txt2Html
extends Task {
    private File todir;
    private List<FileSet> filesets = new LinkedList<FileSet>();

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        int count = 0;
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            File basedir = ds.getBasedir();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File from = new File(basedir, files[i]);
                File to = new File(this.todir, files[i] + ".html");
                if (to.exists() && from.lastModified() <= to.lastModified()) continue;
                this.log("Converting file '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath(), 3);
                try {
                    this.convert(from, to);
                }
                catch (IOException e) {
                    throw new BuildException("Could not convert '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'", (Throwable)e);
                }
                ++count;
            }
            if (count <= 0) continue;
            this.log("Converted " + count + " file" + (count > 1 ? "s" : "") + " to " + this.todir.getAbsolutePath());
        }
    }

    private void convert(File from, File to) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(from));
        PrintWriter out = new PrintWriter(new FileWriter(to));
        out.println("<html><body><pre>");
        while ((line = in.readLine()) != null) {
            StringBuffer result = new StringBuffer();
            int len = line.length();
            block5: for (int i = 0; i < len; ++i) {
                char c = line.charAt(i);
                switch (c) {
                    case '&': {
                        result.append("&amp;");
                        continue block5;
                    }
                    case '<': {
                        result.append("&lt;");
                        continue block5;
                    }
                    default: {
                        result.append(c);
                    }
                }
            }
            out.println(result.toString());
        }
        out.println("</pre></body></html>");
        out.close();
        in.close();
    }
}

