/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.query.EntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.uddi.api_v3.Name;

/*
 * Exception performing whole class analysis ignored.
 */
public class FindEntityByNamesQuery
extends EntityQuery {
    private static Log log = LogFactory.getLog(FindEntityByNamesQuery.class);
    private String entityName;
    private String entityAlias;
    private String keyName;
    private String entityField;
    private String entityNameChild;
    private String entityAliasChild;
    private String selectSQL;

    public FindEntityByNamesQuery(String entityName, String entityAlias, String keyName, String entityField, String entityNameChild) {
        this.entityName = entityName;
        this.entityAlias = entityAlias;
        this.keyName = keyName;
        this.entityField = entityField;
        this.entityNameChild = entityNameChild;
        this.entityAliasChild = FindEntityByNamesQuery.buildAlias((String)entityNameChild);
        StringBuilder sql = new StringBuilder(200);
        sql.append("select distinct " + entityAlias + "." + keyName + " from " + entityName + " " + entityAlias + " ");
        this.selectSQL = sql.toString();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getEntityField() {
        return this.entityField;
    }

    public String getEntityNameChild() {
        return this.entityNameChild;
    }

    public String getEntityAliasChild() {
        return this.entityAliasChild;
    }

    public String getSelectSQL() {
        return this.selectSQL;
    }

    public List<?> select(EntityManager em, FindQualifiers fq, List<Name> names, List<?> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (names == null || names.size() == 0) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(this.selectSQL);
        this.appendConditions(dynamicQry, fq, names);
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindEntityByNamesQuery.getQueryResult((EntityManager)em, (DynamicQuery)dynamicQry, keysIn, (String)(this.entityAlias + "." + this.keyName));
    }

    public void appendConditions(DynamicQuery qry, FindQualifiers fq, List<Name> names) {
        this.appendJoinTables(qry, fq, names);
        qry.AND().pad().openParen().pad();
        String namePredicate = DynamicQuery.PREDICATE_EQUALS;
        if (fq.isApproximateMatch()) {
            namePredicate = DynamicQuery.PREDICATE_LIKE;
        }
        int count = 0;
        for (Name n : names) {
            String tempNamePredicate;
            String nameTerm = this.entityAliasChild + ".name";
            String nameValue = n.getValue();
            if (fq.isCaseInsensitiveMatch()) {
                nameTerm = "upper(" + this.entityAliasChild + ".name)";
                nameValue = n.getValue().toUpperCase();
            }
            String string = tempNamePredicate = nameValue.indexOf("%") > -1 ? DynamicQuery.PREDICATE_LIKE : namePredicate;
            if (n.getLang() == null || n.getLang().length() == 0) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(nameTerm, (Object)nameValue, tempNamePredicate)});
            } else {
                String langValue = n.getLang().endsWith(DynamicQuery.WILDCARD) ? n.getLang().toUpperCase() : n.getLang().toUpperCase() + DynamicQuery.WILDCARD;
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(nameTerm, (Object)nameValue, tempNamePredicate), new DynamicQuery.Parameter("upper(" + this.entityAliasChild + ".langCode)", (Object)langValue, DynamicQuery.PREDICATE_LIKE)});
            }
            if (count + 1 < names.size()) {
                qry.OR().pad();
            }
            ++count;
        }
        qry.closeParen().pad();
    }

    public void appendJoinTables(DynamicQuery qry, FindQualifiers fq, List<Name> names) {
        qry.comma().pad().append(this.entityNameChild + " " + this.entityAliasChild).pad();
        qry.WHERE().pad().openParen().pad();
        qry.append(this.entityAlias + "." + this.keyName + " = " + this.entityAliasChild + "." + this.entityField + "." + this.keyName + " ");
        qry.closeParen().pad();
    }
}

