/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.model;

import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Query;
import javax.persistence.Transient;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.validation.ValidateUDDIKey;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@MappedSuperclass
public class UddiEntityPublisher
implements PersistenceCapable {
    protected String authorizedName;
    private List<String> keyGeneratorKeys = null;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$juddi$model$UddiEntityPublisher;
    private transient Object pcDetachedState;

    public UddiEntityPublisher() {
    }

    public UddiEntityPublisher(String authorizedName) {
        this.authorizedName = authorizedName;
    }

    @Id
    @Column(name="authorized_name", nullable=false, length=255)
    public String getAuthorizedName() {
        if (this.pcStateManager == null) {
            return this.pcgetAuthorizedName();
        }
        int n = pcInheritedFieldCount + 0;
        this.pcStateManager.accessingField(n);
        return this.pcgetAuthorizedName();
    }

    public void setAuthorizedName(String string) {
        if (this.pcStateManager == null) {
            this.pcsetAuthorizedName(string);
            return;
        }
        this.pcStateManager.settingStringField((PersistenceCapable)this, pcInheritedFieldCount + 0, this.pcgetAuthorizedName(), string, 0);
    }

    @Transient
    public List<String> getKeyGeneratorKeys() {
        return this.keyGeneratorKeys;
    }

    public void setKeyGeneratorKeys(List<String> keyGeneratorKeys) {
        this.keyGeneratorKeys = keyGeneratorKeys;
    }

    public void populateKeyGeneratorKeys(EntityManager em) {
        DynamicQuery getKeysQuery = new DynamicQuery();
        getKeysQuery.append("select t.entityKey from Tmodel t").pad().WHERE().pad();
        DynamicQuery.Parameter pubParam = new DynamicQuery.Parameter("t.authorizedName", (Object)this.getAuthorizedName(), DynamicQuery.PREDICATE_EQUALS);
        DynamicQuery.Parameter keyParam = new DynamicQuery.Parameter("UPPER(t.entityKey)", (Object)(DynamicQuery.WILDCARD + "keygenerator").toUpperCase(), DynamicQuery.PREDICATE_LIKE);
        getKeysQuery.appendGroupedAnd(new DynamicQuery.Parameter[]{pubParam, keyParam});
        Query qry = getKeysQuery.buildJPAQuery(em);
        this.keyGeneratorKeys = qry.getResultList();
    }

    public boolean isOwner(UddiEntity entity) {
        boolean ret = false;
        if (entity != null && entity.getAuthorizedName().equals(this.getAuthorizedName())) {
            ret = true;
        }
        return ret;
    }

    public boolean isValidPublisherKey(EntityManager em, String key) {
        if (key == null) {
            return false;
        }
        if (this.keyGeneratorKeys == null) {
            this.populateKeyGeneratorKeys(em);
        }
        String keyPartition = key.substring(0, key.lastIndexOf(":"));
        for (String keyGenKey : this.keyGeneratorKeys) {
            String keyGenPartition = keyGenKey.substring(0, keyGenKey.lastIndexOf(":"));
            if (!keyGenPartition.equalsIgnoreCase(keyPartition)) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyGeneratorAvailable(EntityManager em, String keygenKey) throws DispositionReportFaultMessage {
        ValidateUDDIKey.validateUDDIv3KeyGeneratorKey((String)keygenKey);
        String partition = keygenKey.toUpperCase().substring(0, keygenKey.lastIndexOf(":"));
        StringTokenizer tokenizer = new StringTokenizer(partition, ":");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount < 2) {
            return false;
        }
        String domainPartition = (String)tokenizer.nextElement() + ":" + (String)tokenizer.nextElement();
        if (tokenCount > 2) {
            Vector<DynamicQuery.Parameter> params = new Vector<DynamicQuery.Parameter>(0);
            DynamicQuery.Parameter pubParam = new DynamicQuery.Parameter("t.authorizedName", (Object)this.getAuthorizedName(), DynamicQuery.PREDICATE_EQUALS);
            int requiredCount = 0;
            params.add(new DynamicQuery.Parameter("UPPER(t.entityKey)", (Object)(domainPartition + ":" + "keygenerator").toUpperCase(), DynamicQuery.PREDICATE_EQUALS));
            ++requiredCount;
            String subPartition = domainPartition;
            while (tokenizer.hasMoreElements() && tokenizer.countTokens() != 1) {
                String nextToken = (String)tokenizer.nextElement();
                subPartition = subPartition + ":" + nextToken;
                DynamicQuery.Parameter param = new DynamicQuery.Parameter("UPPER(t.entityKey)", (Object)(subPartition + ":" + "keygenerator").toUpperCase(), DynamicQuery.PREDICATE_EQUALS);
                params.add(param);
                ++requiredCount;
            }
            DynamicQuery checkParentKeyQry = new DynamicQuery();
            checkParentKeyQry.append("select COUNT(t.entityKey) from Tmodel t").pad();
            checkParentKeyQry.WHERE().pad().appendGroupedAnd(new DynamicQuery.Parameter[]{pubParam});
            checkParentKeyQry.AND().pad().appendGroupedOr(params.toArray(new DynamicQuery.Parameter[0]));
            Query qry = checkParentKeyQry.buildJPAQuery(em);
            Number resultCount = (Number)qry.getSingleResult();
            if (resultCount.longValue() != (long)requiredCount) {
                return false;
            }
        } else {
            DynamicQuery.Parameter notPubParam = new DynamicQuery.Parameter("t.authorizedName", (Object)this.getAuthorizedName(), DynamicQuery.PREDICATE_NOTEQUALS);
            DynamicQuery.Parameter keyParam = new DynamicQuery.Parameter("UPPER(t.entityKey)", (Object)(domainPartition + ":" + "keygenerator").toUpperCase(), DynamicQuery.PREDICATE_EQUALS);
            DynamicQuery checkDomainKeyQry = new DynamicQuery();
            checkDomainKeyQry.append("select t.entityKey from Tmodel t").pad();
            checkDomainKeyQry.WHERE().pad().appendGroupedAnd(new DynamicQuery.Parameter[]{notPubParam, keyParam});
            Query qry = checkDomainKeyQry.buildJPAQuery(em);
            List obj = qry.getResultList();
            if (obj != null && obj.size() > 0) {
                return false;
            }
        }
        return true;
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"authorizedName"};
        Class[] classArray = new Class[1];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = UddiEntityPublisher.class$((String)"java.lang.String"));
        classArray[0] = clazz;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26};
        Class clazz2 = class$Lorg$apache$juddi$model$UddiEntityPublisher != null ? class$Lorg$apache$juddi$model$UddiEntityPublisher : (class$Lorg$apache$juddi$model$UddiEntityPublisher = UddiEntityPublisher.class$((String)"org.apache.juddi.model.UddiEntityPublisher"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, null, (PersistenceCapable)new UddiEntityPublisher());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.pcsetAuthorizedName(null);
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        UddiEntityPublisher uddiEntityPublisher = new UddiEntityPublisher();
        if (bl) {
            uddiEntityPublisher.pcClearFields();
        }
        uddiEntityPublisher.pcStateManager = stateManager;
        uddiEntityPublisher.pcCopyKeyFieldsFromObjectId(object);
        return uddiEntityPublisher;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        UddiEntityPublisher uddiEntityPublisher = new UddiEntityPublisher();
        if (bl) {
            uddiEntityPublisher.pcClearFields();
        }
        uddiEntityPublisher.pcStateManager = stateManager;
        return uddiEntityPublisher;
    }

    protected static int pcGetManagedFieldCount() {
        return 1;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcsetAuthorizedName(this.pcStateManager.replaceStringField((PersistenceCapable)this, n));
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.pcgetAuthorizedName());
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(UddiEntityPublisher uddiEntityPublisher, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcsetAuthorizedName(uddiEntityPublisher.pcgetAuthorizedName());
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        UddiEntityPublisher uddiEntityPublisher = (UddiEntityPublisher)object;
        if (uddiEntityPublisher.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(uddiEntityPublisher, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(0 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.pcsetAuthorizedName(stringId.getId());
    }

    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$juddi$model$UddiEntityPublisher != null ? class$Lorg$apache$juddi$model$UddiEntityPublisher : (class$Lorg$apache$juddi$model$UddiEntityPublisher = UddiEntityPublisher.class$((String)"org.apache.juddi.model.UddiEntityPublisher"));
        return clazz;
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new StringId(this.pcGetIDOwningClass(), (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new StringId(this.pcGetIDOwningClass(), this.pcgetAuthorizedName());
    }

    protected String pcgetAuthorizedName() {
        return this.authorizedName;
    }

    protected void pcsetAuthorizedName(String string) {
        this.authorizedName = string;
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

