/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.DeletePublisher;
import org.apache.juddi.api_v3.SavePublisher;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.keygen.KeyGenerator;
import org.apache.juddi.keygen.KeyGeneratorFactory;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.PublisherAssertion;
import org.apache.juddi.model.PublisherAssertionId;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.AssertionNotFoundException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.InvalidProjectionException;
import org.apache.juddi.v3.error.KeyUnavailableException;
import org.apache.juddi.v3.error.UserMismatchException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.apache.juddi.validation.ValidateUDDIKey;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.Address;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ValidatePublish
extends ValidateUDDIApi {
    private Log log = LogFactory.getLog(this.getClass());

    public ValidatePublish(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateDeleteBusiness(EntityManager em, DeleteBusiness body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getBusinessKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(BusinessEntity.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", entityKey));
            }
            if (!this.publisher.isOwner((UddiEntity)obj)) {
                throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
            }
            ++i;
        }
    }

    public void validateDeleteService(EntityManager em, DeleteService body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getServiceKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(BusinessService.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", entityKey));
            }
            if (!this.publisher.isOwner((UddiEntity)obj)) {
                throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
            }
            ++i;
        }
    }

    public void validateDeleteBinding(EntityManager em, DeleteBinding body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getBindingKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(BindingTemplate.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BindingTemplateNotFound", entityKey));
            }
            if (!this.publisher.isOwner((UddiEntity)obj)) {
                throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
            }
            ++i;
        }
    }

    public void validateDeleteTModel(EntityManager em, DeleteTModel body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getTModelKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(Tmodel.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", entityKey));
            }
            if (!this.publisher.isOwner((UddiEntity)obj)) {
                throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
            }
            ++i;
        }
    }

    public void validateDeletePublisherAssertions(EntityManager em, DeletePublisherAssertions body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getPublisherAssertion();
        if (entityList == null || entityList.size() == 0) {
            throw new AssertionNotFoundException(new ErrorMessage("errors.pubassertion.NoPubAssertions"));
        }
        for (org.uddi.api_v3.PublisherAssertion entity : entityList) {
            this.validatePublisherAssertion(em, entity);
            PublisherAssertionId pubAssertionId = new PublisherAssertionId(entity.getFromKey(), entity.getToKey());
            Object obj = em.find(PublisherAssertion.class, (Object)pubAssertionId);
            if (obj == null) {
                throw new AssertionNotFoundException(new ErrorMessage("errors.pubassertion.AssertionNotFound", entity.getFromKey() + ", " + entity.getToKey()));
            }
            PublisherAssertion pubAssertion = (PublisherAssertion)obj;
            KeyedReference keyedRef = entity.getKeyedReference();
            if (keyedRef == null) {
                throw new AssertionNotFoundException(new ErrorMessage("errors.pubassertion.AssertionNotFound", entity.getFromKey() + ", " + entity.getToKey()));
            }
            if (pubAssertion.getTmodelKey().equalsIgnoreCase(keyedRef.getTModelKey()) && pubAssertion.getKeyName().equalsIgnoreCase(keyedRef.getKeyName()) && pubAssertion.getKeyValue().equalsIgnoreCase(keyedRef.getKeyValue())) continue;
            throw new AssertionNotFoundException(new ErrorMessage("errors.pubassertion.AssertionNotFound", entity.getFromKey() + ", " + entity.getToKey()));
        }
    }

    public void validateSaveBusiness(EntityManager em, SaveBusiness body, Configuration config) throws DispositionReportFaultMessage {
        if (config == null) {
            try {
                config = AppConfig.getConfiguration();
            }
            catch (ConfigurationException ce) {
                this.log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
            }
        }
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getBusinessEntity();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savebusiness.NoInput"));
        }
        for (org.uddi.api_v3.BusinessEntity entity : entityList) {
            this.validateBusinessEntity(em, entity, config);
        }
    }

    public void validateSaveService(EntityManager em, SaveService body, Configuration config) throws DispositionReportFaultMessage {
        if (config == null) {
            try {
                config = AppConfig.getConfiguration();
            }
            catch (ConfigurationException ce) {
                this.log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
            }
        }
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getBusinessService();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.saveservice.NoInput"));
        }
        for (org.uddi.api_v3.BusinessService entity : entityList) {
            this.validateBusinessService(em, entity, null, config);
        }
    }

    public void validateSaveBinding(EntityManager em, SaveBinding body, Configuration config) throws DispositionReportFaultMessage {
        if (config == null) {
            try {
                config = AppConfig.getConfiguration();
            }
            catch (ConfigurationException ce) {
                this.log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
            }
        }
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getBindingTemplate();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savebinding.NoInput"));
        }
        for (org.uddi.api_v3.BindingTemplate entity : entityList) {
            this.validateBindingTemplate(em, entity, null, config);
        }
    }

    public void validateSaveTModel(EntityManager em, SaveTModel body, Configuration config) throws DispositionReportFaultMessage {
        if (config == null) {
            try {
                config = AppConfig.getConfiguration();
            }
            catch (ConfigurationException ce) {
                this.log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
            }
        }
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getTModel();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savetmodel.NoInput"));
        }
        for (TModel entity : entityList) {
            this.validateTModel(em, entity, config);
        }
    }

    public void validateAddPublisherAssertions(EntityManager em, AddPublisherAssertions body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getPublisherAssertion();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.addpublisherassertions.NoInput"));
        }
        for (org.uddi.api_v3.PublisherAssertion entity : entityList) {
            this.validatePublisherAssertion(em, entity);
        }
    }

    public void validateSetPublisherAssertions(EntityManager em, Holder<List<org.uddi.api_v3.PublisherAssertion>> body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = (List)body.value;
        if (entityList != null && entityList.size() > 0) {
            for (org.uddi.api_v3.PublisherAssertion entity : entityList) {
                this.validatePublisherAssertion(em, entity);
            }
        }
    }

    public void validateBusinessEntity(EntityManager em, org.uddi.api_v3.BusinessEntity businessEntity, Configuration config) throws DispositionReportFaultMessage {
        if (businessEntity == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessentity.NullInput"));
        }
        boolean entityExists = false;
        String entityKey = businessEntity.getBusinessKey();
        if (entityKey == null || entityKey.length() == 0) {
            KeyGenerator keyGen = KeyGeneratorFactory.getKeyGenerator();
            entityKey = keyGen.generate();
            businessEntity.setBusinessKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            businessEntity.setBusinessKey(entityKey);
            Object obj = em.find(BusinessEntity.class, (Object)entityKey);
            if (obj != null) {
                entityExists = true;
                if (!this.publisher.isOwner((UddiEntity)obj)) {
                    throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
                }
            } else {
                ValidateUDDIKey.validateUDDIv3Key((String)entityKey);
                if (!this.publisher.isValidPublisherKey(em, entityKey)) {
                    throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                }
            }
        }
        if (!entityExists && !ValidatePublish.isUniqueKey((EntityManager)em, (String)entityKey)) {
            throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.KeyExists", entityKey));
        }
        this.validateNames(businessEntity.getName());
        this.validateDiscoveryUrls(businessEntity.getDiscoveryURLs());
        this.validateContacts(businessEntity.getContacts());
        this.validateCategoryBag(businessEntity.getCategoryBag(), config);
        this.validateIdentifierBag(businessEntity.getIdentifierBag(), config);
        this.validateBusinessServices(em, businessEntity.getBusinessServices(), businessEntity, config);
    }

    public void validateBusinessServices(EntityManager em, BusinessServices businessServices, org.uddi.api_v3.BusinessEntity parent, Configuration config) throws DispositionReportFaultMessage {
        if (businessServices == null) {
            return;
        }
        List businessServiceList = businessServices.getBusinessService();
        if (businessServiceList == null || businessServiceList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessservices.NoInput"));
        }
        for (org.uddi.api_v3.BusinessService businessService : businessServiceList) {
            this.validateBusinessService(em, businessService, parent, config);
        }
    }

    public void validateBusinessService(EntityManager em, org.uddi.api_v3.BusinessService businessService, org.uddi.api_v3.BusinessEntity parent, Configuration config) throws DispositionReportFaultMessage {
        String parentKey;
        if (businessService == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessservice.NullInput"));
        }
        String entityKey = businessService.getServiceKey();
        if (entityKey != null && entityKey.length() > 0) {
            entityKey = entityKey.toLowerCase();
            businessService.setServiceKey(entityKey);
        }
        if ((parentKey = businessService.getBusinessKey()) != null && parentKey.length() > 0) {
            parentKey = parentKey.toLowerCase();
            businessService.setBusinessKey(parentKey);
        }
        boolean isProjection = false;
        if (parent != null) {
            if (parentKey != null && parentKey.length() > 0) {
                if (!parentKey.equalsIgnoreCase(parent.getBusinessKey())) {
                    if (entityKey == null || entityKey.length() == 0) {
                        throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceKeyNotProvidedWithProjection", parentKey + ", " + parent.getBusinessKey()));
                    }
                    isProjection = true;
                }
            } else {
                parentKey = parent.getBusinessKey();
            }
        }
        if (isProjection) {
            Object obj = em.find(BusinessService.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ProjectedServiceNotFound", parentKey + ", " + entityKey));
            }
            BusinessService bs = (BusinessService)obj;
            if (!businessService.getBusinessKey().equalsIgnoreCase(bs.getBusinessEntity().getEntityKey())) {
                throw new InvalidProjectionException(new ErrorMessage("errors.invalidprojection.ParentMismatch", businessService.getBusinessKey() + ", " + bs.getBusinessEntity().getEntityKey()));
            }
            obj = null;
        } else {
            boolean entityExists = false;
            if (entityKey == null || entityKey.length() == 0) {
                KeyGenerator keyGen = KeyGeneratorFactory.getKeyGenerator();
                entityKey = keyGen.generate();
                businessService.setServiceKey(entityKey);
            } else {
                Object obj = em.find(BusinessService.class, (Object)entityKey);
                if (obj != null) {
                    entityExists = true;
                    BusinessService bs = (BusinessService)obj;
                    if (parentKey == null || parentKey.length() == 0) {
                        parentKey = bs.getBusinessEntity().getEntityKey();
                        businessService.setBusinessKey(parentKey);
                    }
                    if (!this.publisher.isOwner((UddiEntity)obj)) {
                        throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
                    }
                    if (!parentKey.equalsIgnoreCase(bs.getBusinessEntity().getEntityKey())) {
                        if (!this.publisher.isOwner((UddiEntity)bs.getBusinessEntity())) {
                            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.businessservice.ParentMismatch", parentKey + ", " + bs.getBusinessEntity().getEntityKey()));
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Services moved from business " + bs.getBusinessEntity() + " to " + businessService.getBusinessKey()));
                        }
                    }
                } else {
                    ValidateUDDIKey.validateUDDIv3Key((String)entityKey);
                    if (!this.publisher.isValidPublisherKey(em, entityKey)) {
                        throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                    }
                }
            }
            if (!(entityExists || parentKey != null && parentKey.length() != 0)) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentBusinessNotFound", parentKey));
            }
            if (parentKey != null && parent == null) {
                Object parentTemp = em.find(BusinessEntity.class, (Object)parentKey);
                if (parentTemp == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentBusinessNotFound", parentKey));
                }
                if (!this.publisher.isOwner((UddiEntity)parentTemp)) {
                    throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwnerParent", parentKey));
                }
            }
            if (!entityExists && !ValidatePublish.isUniqueKey((EntityManager)em, (String)entityKey)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.KeyExists", entityKey));
            }
            this.validateNames(businessService.getName());
            this.validateCategoryBag(businessService.getCategoryBag(), config);
            this.validateBindingTemplates(em, businessService.getBindingTemplates(), businessService, config);
        }
    }

    public void validateBindingTemplates(EntityManager em, BindingTemplates bindingTemplates, org.uddi.api_v3.BusinessService parent, Configuration config) throws DispositionReportFaultMessage {
        if (bindingTemplates == null) {
            return;
        }
        List bindingTemplateList = bindingTemplates.getBindingTemplate();
        if (bindingTemplateList == null || bindingTemplateList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplates.NoInput"));
        }
        for (org.uddi.api_v3.BindingTemplate bindingTemplate : bindingTemplateList) {
            this.validateBindingTemplate(em, bindingTemplate, parent, config);
        }
    }

    public void validateBindingTemplate(EntityManager em, org.uddi.api_v3.BindingTemplate bindingTemplate, org.uddi.api_v3.BusinessService parent, Configuration config) throws DispositionReportFaultMessage {
        String parentKey;
        if (bindingTemplate == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplate.NullInput"));
        }
        String entityKey = bindingTemplate.getBindingKey();
        if (entityKey != null && entityKey.length() > 0) {
            entityKey = entityKey.toLowerCase();
            bindingTemplate.setBindingKey(entityKey);
        }
        if ((parentKey = bindingTemplate.getServiceKey()) != null && parentKey.length() > 0) {
            parentKey = parentKey.toLowerCase();
            bindingTemplate.setServiceKey(parentKey);
        }
        if (parent != null) {
            if (parentKey != null && parentKey.length() > 0) {
                if (!parentKey.equalsIgnoreCase(parent.getServiceKey())) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.bindingtemplate.ParentMismatch", parentKey + ", " + parent.getBusinessKey()));
                }
            } else {
                parentKey = parent.getServiceKey();
            }
        }
        boolean entityExists = false;
        if (entityKey == null || entityKey.length() == 0) {
            KeyGenerator keyGen = KeyGeneratorFactory.getKeyGenerator();
            entityKey = keyGen.generate();
            bindingTemplate.setBindingKey(entityKey);
        } else {
            Object obj = em.find(BindingTemplate.class, (Object)entityKey);
            if (obj != null) {
                entityExists = true;
                BindingTemplate bt = (BindingTemplate)obj;
                if (parentKey == null || parentKey.length() == 0) {
                    parentKey = bt.getBusinessService().getEntityKey();
                    bindingTemplate.setServiceKey(parentKey);
                }
                if (!parentKey.equalsIgnoreCase(bt.getBusinessService().getEntityKey())) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.bindingtemplate.ParentMismatch", parentKey + ", " + bt.getBusinessService().getEntityKey()));
                }
                if (!this.publisher.isOwner((UddiEntity)obj)) {
                    throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
                }
            } else {
                ValidateUDDIKey.validateUDDIv3Key((String)entityKey);
                if (!this.publisher.isValidPublisherKey(em, entityKey)) {
                    throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                }
            }
        }
        if (!(entityExists || parentKey != null && parentKey.length() != 0)) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentServiceNotFound", parentKey));
        }
        if (parentKey != null && parent == null) {
            Object parentTemp = em.find(BusinessService.class, (Object)parentKey);
            if (parentTemp == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentBusinessNotFound", parentKey));
            }
            if (!this.publisher.isOwner((UddiEntity)parentTemp)) {
                throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwnerParent", parentKey));
            }
        }
        if (!entityExists && !ValidatePublish.isUniqueKey((EntityManager)em, (String)entityKey)) {
            throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.KeyExists", entityKey));
        }
        if (bindingTemplate.getAccessPoint() == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplate.NoAccessPoint"));
        }
        this.validateCategoryBag(bindingTemplate.getCategoryBag(), config);
        this.validateTModelInstanceDetails(bindingTemplate.getTModelInstanceDetails());
    }

    public void validateTModel(EntityManager em, TModel tModel, Configuration config) throws DispositionReportFaultMessage {
        if (tModel == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.NullInput"));
        }
        boolean entityExists = false;
        String entityKey = tModel.getTModelKey();
        if (entityKey == null || entityKey.length() == 0) {
            KeyGenerator keyGen = KeyGeneratorFactory.getKeyGenerator();
            entityKey = keyGen.generate();
            tModel.setTModelKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            tModel.setTModelKey(entityKey);
            Object obj = em.find(Tmodel.class, (Object)entityKey);
            if (obj != null) {
                entityExists = true;
                if (!this.publisher.isOwner((UddiEntity)obj)) {
                    throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
                }
            } else if (entityKey.toUpperCase().contains("keygenerator".toUpperCase())) {
                ValidateUDDIKey.validateUDDIv3KeyGeneratorTModel((TModel)tModel);
                String rootPublisherStr = "root";
                try {
                    rootPublisherStr = AppConfig.getConfiguration().getString("juddi.root.publisher");
                }
                catch (ConfigurationException ce) {
                    this.log.error((Object)"Could not read the root publisher setting in the configuration.");
                }
                if (this.publisher.getAuthorizedName().equals(rootPublisherStr)) {
                    throw new FatalErrorException(new ErrorMessage("errors.tmodel.keygenerator.RootKeyGen"));
                }
                if (!this.publisher.isKeyGeneratorAvailable(em, entityKey)) {
                    throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                }
            } else {
                ValidateUDDIKey.validateUDDIv3Key((String)entityKey);
                if (!this.publisher.isValidPublisherKey(em, entityKey)) {
                    throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                }
            }
        }
        if (!entityExists && !ValidatePublish.isUniqueKey((EntityManager)em, (String)entityKey)) {
            throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.KeyExists", entityKey));
        }
        if (tModel.getName() == null || tModel.getName().equals("")) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.NoName"));
        }
        this.validateCategoryBag(tModel.getCategoryBag(), config);
        this.validateIdentifierBag(tModel.getIdentifierBag(), config);
        List overviewDocList = tModel.getOverviewDoc();
        if (overviewDocList != null) {
            for (OverviewDoc overviewDoc : overviewDocList) {
                this.validateOverviewDoc(overviewDoc);
            }
        }
    }

    public void validatePublisherAssertion(EntityManager em, org.uddi.api_v3.PublisherAssertion pubAssertion) throws DispositionReportFaultMessage {
        if (pubAssertion == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.NullInput"));
        }
        KeyedReference keyedRef = pubAssertion.getKeyedReference();
        if (keyedRef == null || keyedRef.getTModelKey() == null || keyedRef.getTModelKey().length() == 0 || keyedRef.getKeyName() == null || keyedRef.getKeyName().length() == 0 || keyedRef.getKeyValue() == null || keyedRef.getKeyValue().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.BlankKeyedRef"));
        }
        String fromKey = pubAssertion.getFromKey();
        if (fromKey == null || fromKey.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.BlankFromKey"));
        }
        String toKey = pubAssertion.getToKey();
        if (toKey == null || toKey.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.BlankToKey"));
        }
        if (fromKey.equalsIgnoreCase(toKey)) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.pubassertion.SameBusinessKey"));
        }
        fromKey = fromKey.toLowerCase();
        pubAssertion.setFromKey(fromKey);
        toKey = toKey.toLowerCase();
        pubAssertion.setToKey(toKey);
        Object fromObj = em.find(BusinessEntity.class, (Object)fromKey);
        if (fromObj == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", fromKey));
        }
        Object toObj = em.find(BusinessEntity.class, (Object)pubAssertion.getToKey());
        if (toObj == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", toKey));
        }
        if (!this.publisher.isOwner((UddiEntity)fromObj) && !this.publisher.isOwner((UddiEntity)toObj)) {
            throw new UserMismatchException(new ErrorMessage("errors.pubassertion.UserMismatch", fromKey + " & " + toKey));
        }
        try {
            this.validateKeyedReference(pubAssertion.getKeyedReference(), AppConfig.getConfiguration());
        }
        catch (ConfigurationException ce) {
            this.log.error((Object)("Could not optain config. " + ce.getMessage()), (Throwable)ce);
        }
    }

    public void validateNames(List<Name> names) throws DispositionReportFaultMessage {
        if (names == null || names.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.names.NoInput"));
        }
        for (Name n : names) {
            if (n.getValue() != null && n.getValue().length() != 0) continue;
            throw new ValueNotAllowedException(new ErrorMessage("errors.names.NoValue"));
        }
    }

    public void validateContacts(Contacts contacts) throws DispositionReportFaultMessage {
        if (contacts == null) {
            return;
        }
        List contactList = contacts.getContact();
        if (contactList == null || contactList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.contacts.NoInput"));
        }
        for (Contact contact : contactList) {
            this.validateContact(contact);
        }
    }

    public void validateContact(Contact contact) throws DispositionReportFaultMessage {
        if (contact == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.contact.NullInput"));
        }
        List pnameList = contact.getPersonName();
        if (pnameList == null || pnameList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.contact.NoPersonName"));
        }
        List addressList = contact.getAddress();
        if (addressList != null) {
            for (Address address : addressList) {
                if (address == null) continue;
                if (address.getTModelKey() != null) {
                    address.setTModelKey(address.getTModelKey().toLowerCase());
                }
                if (address.getAddressLine() != null && address.getAddressLine().size() != 0) continue;
                throw new ValueNotAllowedException(new ErrorMessage("errors.contact.NoAddressLine"));
            }
        }
    }

    public void validateDiscoveryUrls(DiscoveryURLs discUrls) throws DispositionReportFaultMessage {
        if (discUrls == null) {
            return;
        }
        List discUrlList = discUrls.getDiscoveryURL();
        if (discUrlList == null || discUrlList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.discurls.NoInput"));
        }
    }

    public void validateCategoryBag(CategoryBag categories, Configuration config) throws DispositionReportFaultMessage {
        if (categories == null) {
            return;
        }
        List elems = categories.getKeyedReference();
        List groups = categories.getKeyedReferenceGroup();
        if (groups.size() == 0 && elems.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.categorybag.NoInput"));
        }
        for (KeyedReferenceGroup group : groups) {
            this.validateKeyedReferenceGroup(group, config);
        }
        for (KeyedReference elem : elems) {
            this.validateKeyedReference(elem, config);
        }
    }

    public void validateIdentifierBag(IdentifierBag identifiers, Configuration config) throws DispositionReportFaultMessage {
        if (identifiers == null) {
            return;
        }
        List keyedRefList = identifiers.getKeyedReference();
        if (keyedRefList == null || keyedRefList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.identifierbag.NoInput"));
        }
        for (KeyedReference keyedRef : keyedRefList) {
            this.validateKeyedReference(keyedRef, config);
        }
    }

    public void validateKeyedReferenceGroup(KeyedReferenceGroup krg, Configuration config) throws DispositionReportFaultMessage {
        if (krg.getTModelKey() == null || krg.getTModelKey().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
        }
        String tmodelKey = krg.getTModelKey().toLowerCase();
        krg.setTModelKey(tmodelKey);
        List keyedRefs = krg.getKeyedReference();
        if (keyedRefs != null && keyedRefs.size() > 0) {
            for (KeyedReference keyedRef : keyedRefs) {
                this.validateKeyedReference(keyedRef, config);
            }
        }
    }

    public void validateKeyedReference(KeyedReference kr, Configuration config) throws DispositionReportFaultMessage {
        String tmodelKey = kr.getTModelKey();
        if (tmodelKey == null || tmodelKey.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
        }
        tmodelKey = tmodelKey.toLowerCase();
        kr.setTModelKey(tmodelKey);
        if (kr.getKeyValue() == null || kr.getKeyValue().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoKeyValue"));
        }
        String rootPublisherStr = config.getString("juddi.root.publisher");
        if ("uddi:uddi.org:categorization:nodes".equalsIgnoreCase(kr.getTModelKey()) && !rootPublisherStr.equals(this.publisher.getAuthorizedName())) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NodeCategoryTModel", "uddi:uddi.org:categorization:nodes"));
        }
    }

    public void validateTModelInstanceDetails(TModelInstanceDetails tmodelInstDetails) throws DispositionReportFaultMessage {
        if (tmodelInstDetails == null) {
            return;
        }
        List tmodelInstInfoList = tmodelInstDetails.getTModelInstanceInfo();
        if (tmodelInstInfoList == null || tmodelInstInfoList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodelinstdetails.NoInput"));
        }
        for (TModelInstanceInfo tmodelInstInfo : tmodelInstInfoList) {
            this.validateTModelInstanceInfo(tmodelInstInfo);
        }
    }

    public void validateTModelInstanceInfo(TModelInstanceInfo tmodelInstInfo) throws DispositionReportFaultMessage {
        if (tmodelInstInfo == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodelinstinfo.NullInput"));
        }
        if (tmodelInstInfo.getTModelKey() == null || tmodelInstInfo.getTModelKey().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodelinstinfo.NoTModelKey"));
        }
        tmodelInstInfo.setTModelKey(tmodelInstInfo.getTModelKey().toLowerCase());
        this.validateInstanceDetails(tmodelInstInfo.getInstanceDetails());
    }

    public void validateInstanceDetails(InstanceDetails instDetails) throws DispositionReportFaultMessage {
        if (instDetails == null) {
            return;
        }
        List elems = instDetails.getOverviewDoc();
        if (instDetails.getInstanceParms() == null && elems.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.instdetails.NoOverviewOrParms"));
        }
    }

    public void validateOverviewDoc(OverviewDoc overviewDoc) throws DispositionReportFaultMessage {
        if (overviewDoc == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.overviewdoc.NullInput"));
        }
        List elems = overviewDoc.getDescription();
        if ((elems == null || elems.size() == 0) && overviewDoc.getOverviewURL() == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.overviewdoc.NoDescOrUrl"));
        }
    }

    public void validateRegisteredInfo(GetRegisteredInfo body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getInfoSelection() == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.getregisteredinfo.NoInfoSelection"));
        }
    }

    public void validateDeletePublisher(EntityManager em, DeletePublisher body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getPublisherId();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.deletepublisher.AdminReqd"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(Publisher.class, (Object)entityKey);
            if (obj != null) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.PublisherNotFound", entityKey));
        }
    }

    public void validateSavePublisher(EntityManager em, SavePublisher body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getPublisher();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savepublisher.NoInput"));
        }
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.savepublisher.AdminReqd"));
        }
        for (org.apache.juddi.api_v3.Publisher entity : entityList) {
            this.validatePublisher(em, entity);
        }
    }

    public void validatePublisher(EntityManager em, org.apache.juddi.api_v3.Publisher publisher) throws DispositionReportFaultMessage {
        if (publisher == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.publisher.NullInput"));
        }
        String authorizedName = publisher.getAuthorizedName();
        if (authorizedName == null || authorizedName.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.publisher.NoAuthorizedName"));
        }
        String publisherName = publisher.getPublisherName();
        if (publisherName == null || publisherName.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.publisher.NoPublisherName"));
        }
    }

    public void validateAdminDeleteTModel(EntityManager em, DeleteTModel body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getTModelKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        if (!((Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.AdminReqd"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(Tmodel.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", entityKey));
            }
            if (this.publisher.isOwner((UddiEntity)obj)) continue;
            throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
        }
    }
}

