/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.error.AuthenticationException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.UnknownUserException;

public class JUDDIAuthenticator
implements Authenticator {
    private Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticate(String authorizedName, String credential) throws AuthenticationException {
        if (authorizedName == null || "".equals(authorizedName)) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)authorizedName);
            if (publisher == null) {
                this.log.warn((Object)"Publisher was not found, adding the publisher in on the fly.");
                publisher = new Publisher();
                publisher.setAuthorizedName(authorizedName);
                publisher.setIsAdmin("false");
                publisher.setIsEnabled("true");
                publisher.setMaxBindingsPerService(Integer.valueOf(199));
                publisher.setMaxBusinesses(Integer.valueOf(100));
                publisher.setMaxServicesPerBusiness(Integer.valueOf(100));
                publisher.setMaxTmodels(Integer.valueOf(100));
                publisher.setPublisherName("Unknown");
                em.persist((Object)publisher);
                tx.commit();
            }
            String string = authorizedName;
            return string;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UddiEntityPublisher identify(String authInfo, String authorizedName) throws AuthenticationException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)authorizedName);
            if (publisher == null) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
            }
            Publisher publisher2 = publisher;
            return publisher2;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

