/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.subscription.notify;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.subscription.notify.Notifier;
import org.apache.juddi.v3.client.UDDIService;
import org.apache.juddi.v3.client.UDDIServiceWSDL;
import org.uddi.api_v3.DispositionReport;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;

public class HTTPNotifier
implements Notifier {
    private static String SUBR_V3_NAMESPACE = "urn:uddi-org:v3_service";
    private static String SUBSCRIPTION_LISTENER_SERVICE = "UDDISubscriptionListenerImplPort";
    Log log = LogFactory.getLog(this.getClass());
    UDDISubscriptionListenerPortType subscriptionListenerPort = null;

    public HTTPNotifier(BindingTemplate bindingTemplate) throws IOException {
        String accessPointUrl = bindingTemplate.getAccessPointUrl().toLowerCase();
        if (!accessPointUrl.startsWith("http")) {
            this.log.warn((Object)("http accessPointUrl for bindingTemplate " + bindingTemplate.getEntityKey() + " should start with 'http' or 'https'"));
        }
        if (AccessPointType.WSDL_DEPLOYMENT.toString().equalsIgnoreCase(bindingTemplate.getAccessPointType())) {
            QName qName = new QName(SUBR_V3_NAMESPACE, SUBSCRIPTION_LISTENER_SERVICE);
            Service service = Service.create((URL)new URL(bindingTemplate.getAccessPointUrl()), (QName)qName);
            this.subscriptionListenerPort = (UDDISubscriptionListenerPortType)service.getPort(UDDISubscriptionListenerPortType.class);
        } else if (AccessPointType.END_POINT.toString().equalsIgnoreCase(bindingTemplate.getAccessPointType())) {
            URL tmpWSDLFile = new UDDIServiceWSDL().getWSDLFilePath(UDDIServiceWSDL.WSDLEndPointType.SUBSCRIPTION_LISTENER, accessPointUrl);
            UDDIService uddiService = new UDDIService(tmpWSDLFile);
            this.subscriptionListenerPort = uddiService.getUDDISubscriptionListenerPort();
        }
    }

    public DispositionReport notifySubscriptionListener(NotifySubscriptionListener body) throws DispositionReportFaultMessage, RemoteException {
        return this.subscriptionListenerPort.notifySubscriptionListener(body);
    }
}

