/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.query.FindEntityByCategoryQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.query.util.KeyedRefTModelComparator;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.KeyedReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FindEntityByCombinedCategoryQuery
extends FindEntityByCategoryQuery {
    private static Log log = LogFactory.getLog(FindEntityByCombinedCategoryQuery.class);
    private static final String ENTITY_KEYEDREFERENCE = "KeyedReference";
    private static final String ALIAS_KEYEDREFERENCE = FindEntityByCombinedCategoryQuery.buildAlias((String)"KeyedReference");
    private static final String FIELD_CATEGORYBAG = "categoryBag";
    private String joinClause;
    private String currentAlias;
    protected String entityNameChild2;
    protected String entityAliasChild2;

    public FindEntityByCombinedCategoryQuery(String entityName, String entityAlias, String keyName, String entityField, String entityNameChild) {
        super(entityName, entityAlias, keyName, entityField, entityNameChild);
    }

    public FindEntityByCombinedCategoryQuery(String entityName, String entityAlias, String keyName, String entityField, String entityNameChild, String entityNameChild2) {
        super(entityName, entityAlias, keyName, entityField, entityNameChild);
        this.entityNameChild2 = entityNameChild2;
        this.entityAliasChild2 = FindEntityByCombinedCategoryQuery.buildAlias((String)entityNameChild2);
        this.selectSQL = "";
    }

    public String getEntityNameChild2() {
        return this.entityNameChild2;
    }

    public String getEntityAliasChild2() {
        return this.entityAliasChild2;
    }

    public List<?> select(EntityManager em, FindQualifiers fq, CategoryBag categoryBag, List<?> keysIn, DynamicQuery.Parameter ... restrictions) {
        ArrayList<String> idsTwo;
        ArrayList<String> idsOne;
        List list;
        DynamicQuery dynamicQry;
        ArrayList<KeyedReference> keyedRefs;
        StringBuffer queryOne = new StringBuffer(200);
        StringBuffer queryTwo = new StringBuffer(200);
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (categoryBag == null) {
            return keysIn;
        }
        List categories = categoryBag.getKeyedReference();
        if (categories == null || categories.size() == 0) {
            return keysIn;
        }
        queryOne.append("select " + this.entityAlias + "." + this.keyName + ", " + this.entityAliasChild + ".id " + "from " + this.entityName + " " + this.entityAlias + ", " + this.entityNameChild + " " + this.entityAliasChild + " ");
        ArrayList aggregatedResultsOne = new ArrayList();
        ArrayList aggregatedResultsTwo = new ArrayList();
        for (KeyedReference elem : categories) {
            keyedRefs = new ArrayList<KeyedReference>(0);
            if (elem instanceof KeyedReference) {
                keyedRefs.add(elem);
            }
            dynamicQry = new DynamicQuery(queryOne.toString());
            this.currentAlias = this.entityAliasChild;
            this.joinClause = this.entityAlias + "." + this.keyName + " = " + this.entityAliasChild + "." + this.entityField + "." + this.keyName + " ";
            this.appendConditions(dynamicQry, fq, keyedRefs);
            if (restrictions != null && restrictions.length > 0) {
                dynamicQry.AND().pad().appendGroupedAnd(restrictions);
            }
            if (keyedRefs.size() == 0) continue;
            list = FindEntityByCombinedCategoryQuery.getQueryResult((EntityManager)em, (DynamicQuery)dynamicQry, keysIn, (String)(this.entityAlias + "." + this.keyName));
            aggregatedResultsOne.addAll(list);
        }
        queryTwo.append("select  " + this.entityAlias + "." + this.keyName + ", " + this.entityAliasChild2 + ".id " + "from " + this.entityName + " " + this.entityAlias + ", " + this.entityNameChild + " " + this.entityAliasChild + ", " + this.entityNameChild2 + " " + this.entityAliasChild2 + " ");
        for (KeyedReference elem : categories) {
            keyedRefs = new ArrayList(0);
            if (elem instanceof KeyedReference) {
                keyedRefs.add(elem);
            }
            dynamicQry = new DynamicQuery(queryTwo.toString());
            this.currentAlias = this.entityAliasChild2;
            this.joinClause = "BusinessEntity".equals(this.entityName) ? this.entityAlias + ".entityKey" + " = " + this.entityAliasChild + "." + this.entityField + ".entityKey" + " and " + this.entityAliasChild + "." + this.entityField + ".entityKey" + " = " + this.entityAliasChild2 + ".businessService.businessEntity.entityKey" : this.entityAlias + ".entityKey" + " = " + this.entityAliasChild + "." + this.entityField + ".entityKey" + " and " + this.entityAliasChild + "." + this.entityField + ".entityKey" + " = " + this.entityAliasChild2 + ".bindingTemplate.businessService.entityKey";
            this.appendConditions(dynamicQry, fq, keyedRefs);
            if (restrictions != null && restrictions.length > 0) {
                dynamicQry.AND().pad().appendGroupedAnd(restrictions);
            }
            if (keyedRefs.size() == 0) continue;
            list = FindEntityByCombinedCategoryQuery.getQueryResult((EntityManager)em, (DynamicQuery)dynamicQry, keysIn, (String)(this.entityAlias + "." + this.keyName));
            aggregatedResultsTwo.addAll(list);
        }
        ArrayList results = new ArrayList();
        if ("BusinessService".equals(this.entityName)) {
            String id;
            idsOne = new ArrayList<String>();
            idsTwo = new ArrayList<String>();
            for (Object[] l : aggregatedResultsOne) {
                id = (String)l[0];
                idsOne.add(id);
            }
            for (Object[] l : aggregatedResultsTwo) {
                id = (String)l[0];
                idsTwo.add(id);
            }
            results.addAll(idsOne);
            results.retainAll(idsTwo);
        } else if ("BusinessEntity".equals(this.entityName)) {
            String id;
            idsOne = new ArrayList();
            idsTwo = new ArrayList();
            for (Object[] l : aggregatedResultsOne) {
                id = (String)l[0];
                idsOne.add(id);
            }
            for (Object[] l : aggregatedResultsTwo) {
                id = (String)l[0];
                idsTwo.add(id);
            }
            results.addAll(idsOne);
            results.retainAll(idsTwo);
        }
        return results;
    }

    public void appendConditions(DynamicQuery qry, FindQualifiers fq, List<KeyedReference> keyedRefs) {
        this.appendJoinTables(qry, fq, keyedRefs);
        qry.AND().pad().openParen().pad();
        String predicate = DynamicQuery.PREDICATE_EQUALS;
        if (fq.isApproximateMatch()) {
            predicate = DynamicQuery.PREDICATE_LIKE;
        }
        Collections.sort(keyedRefs, new KeyedRefTModelComparator());
        String prevTModelKey = null;
        int count = 0;
        int tblCount = -1;
        for (KeyedReference keyedRef : keyedRefs) {
            String tmodelKey = keyedRef.getTModelKey();
            String keyValue = keyedRef.getKeyValue();
            String keyName = keyedRef.getKeyName();
            if (fq.isApproximateMatch()) {
                // empty if block
            }
            if (fq.isOrLikeKeys()) {
                if (count == 0) {
                    qry.openParen().pad();
                    ++tblCount;
                } else if (!tmodelKey.equals(prevTModelKey)) {
                    qry.closeParen().pad().AND().pad().openParen().pad();
                    ++tblCount;
                } else {
                    qry.OR().pad();
                }
            } else {
                ++tblCount;
            }
            String keyValueTerm = (fq.isOrAllKeys() ? ALIAS_KEYEDREFERENCE + "0" : ALIAS_KEYEDREFERENCE + tblCount) + ".keyValue";
            String keyNameTerm = (fq.isOrAllKeys() ? ALIAS_KEYEDREFERENCE + "0" : ALIAS_KEYEDREFERENCE + tblCount) + ".keyName";
            String tmodelKeyTerm = (fq.isOrAllKeys() ? ALIAS_KEYEDREFERENCE + "0" : ALIAS_KEYEDREFERENCE + tblCount) + ".tmodelKeyRef";
            if (fq.isCaseInsensitiveMatch()) {
                keyValueTerm = "upper(" + keyValueTerm + ")";
                keyValue = keyValue.toUpperCase();
                keyNameTerm = "upper(" + keyNameTerm + ")";
                keyName = keyName.toUpperCase();
            }
            if ("uddi:uddi.org:categorization:general_keywords".equalsIgnoreCase(tmodelKey)) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(tmodelKeyTerm, (Object)tmodelKey, DynamicQuery.PREDICATE_EQUALS), new DynamicQuery.Parameter(keyValueTerm, (Object)keyValue, predicate), new DynamicQuery.Parameter(keyNameTerm, (Object)keyName, predicate)});
            } else {
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(tmodelKeyTerm, (Object)tmodelKey, DynamicQuery.PREDICATE_EQUALS), new DynamicQuery.Parameter(keyValueTerm, (Object)keyValue, predicate)});
            }
            if (count + 1 < keyedRefs.size()) {
                if (fq.isOrAllKeys()) {
                    qry.OR().pad();
                } else if (!fq.isOrLikeKeys()) {
                    qry.AND().pad();
                }
            }
            if (fq.isOrLikeKeys() && count + 1 == keyedRefs.size()) {
                qry.closeParen().pad();
            }
            prevTModelKey = tmodelKey;
            ++count;
        }
        qry.closeParen().pad();
    }

    public void appendJoinTables(DynamicQuery qry, FindQualifiers fq, List<KeyedReference> keyedRefs) {
        if (keyedRefs != null & keyedRefs.size() > 0) {
            Collections.sort(keyedRefs, new KeyedRefTModelComparator());
            StringBuffer thetaJoins = new StringBuffer(200);
            int tblCount = 0;
            int count = 0;
            String curTModelKey = null;
            String prevTModelKey = null;
            for (KeyedReference kr : keyedRefs) {
                curTModelKey = kr.getTModelKey();
                if (count != 0) {
                    if (!(fq.isOrAllKeys() || fq.isOrLikeKeys() && curTModelKey.equals(prevTModelKey))) {
                        qry.comma().pad().append("KeyedReference " + ALIAS_KEYEDREFERENCE + ++tblCount).pad();
                        thetaJoins.append(ALIAS_KEYEDREFERENCE + (tblCount - 1) + "." + "categoryBag" + ".id = " + ALIAS_KEYEDREFERENCE + tblCount + "." + "categoryBag" + ".id ");
                    }
                } else {
                    qry.comma().pad().append("KeyedReference " + ALIAS_KEYEDREFERENCE + tblCount).pad();
                    thetaJoins.append(DynamicQuery.OPERATOR_AND + " ");
                    thetaJoins.append(this.currentAlias + ".id = " + ALIAS_KEYEDREFERENCE + tblCount + "." + "categoryBag" + ".id ");
                    thetaJoins.append(DynamicQuery.OPERATOR_AND + " ");
                }
                prevTModelKey = curTModelKey;
                ++count;
            }
            qry.WHERE().pad().openParen().pad();
            qry.append(this.joinClause).pad();
            String thetaJoinsStr = thetaJoins.toString();
            if (thetaJoinsStr.endsWith(DynamicQuery.OPERATOR_AND + " ")) {
                thetaJoinsStr = thetaJoinsStr.substring(0, thetaJoinsStr.length() - (DynamicQuery.OPERATOR_AND + " ").length());
            }
            qry.append(thetaJoinsStr);
            qry.closeParen().pad();
        }
    }
}

