/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.mapping;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.apache.juddi.model.Address;
import org.apache.juddi.model.AddressLine;
import org.apache.juddi.model.BindingCategoryBag;
import org.apache.juddi.model.BindingDescr;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessCategoryBag;
import org.apache.juddi.model.BusinessDescr;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessIdentifier;
import org.apache.juddi.model.BusinessName;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.CategoryBag;
import org.apache.juddi.model.Clerk;
import org.apache.juddi.model.ClientSubscriptionInfo;
import org.apache.juddi.model.Contact;
import org.apache.juddi.model.ContactDescr;
import org.apache.juddi.model.DiscoveryUrl;
import org.apache.juddi.model.Email;
import org.apache.juddi.model.InstanceDetailsDescr;
import org.apache.juddi.model.KeyedReference;
import org.apache.juddi.model.OverviewDocDescr;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.PublisherAssertion;
import org.apache.juddi.model.PublisherAssertionId;
import org.apache.juddi.model.ServiceCategoryBag;
import org.apache.juddi.model.ServiceDescr;
import org.apache.juddi.model.ServiceName;
import org.apache.juddi.model.ServiceProjection;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.TmodelCategoryBag;
import org.apache.juddi.model.TmodelDescr;
import org.apache.juddi.model.TmodelIdentifier;
import org.apache.juddi.model.TmodelInstanceInfo;
import org.apache.juddi.model.TmodelInstanceInfoDescr;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.Phone;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.sub_v3.ObjectFactory;
import org.uddi.sub_v3.Subscription;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class MappingApiToModel {
    private static Log logger = LogFactory.getLog(MappingApiToModel.class);

    public static void mapPublisher(org.apache.juddi.api_v3.Publisher apiPublisher, Publisher modelPublisher) throws DispositionReportFaultMessage {
        modelPublisher.setAuthorizedName(apiPublisher.getAuthorizedName());
        modelPublisher.setPublisherName(apiPublisher.getPublisherName());
        modelPublisher.setEmailAddress(apiPublisher.getEmailAddress());
        modelPublisher.setIsAdmin(apiPublisher.getIsAdmin());
        modelPublisher.setIsEnabled(apiPublisher.getIsEnabled());
        modelPublisher.setMaxBindingsPerService(apiPublisher.getMaxBindingsPerService());
        modelPublisher.setMaxBusinesses(apiPublisher.getMaxBusinesses());
        modelPublisher.setMaxServicesPerBusiness(apiPublisher.getMaxServicePerBusiness());
        modelPublisher.setMaxTmodels(apiPublisher.getMaxTModels());
    }

    public static void mapBusinessEntity(org.uddi.api_v3.BusinessEntity apiBusinessEntity, BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelBusinessEntity.setEntityKey(apiBusinessEntity.getBusinessKey());
        MappingApiToModel.mapBusinessNames((List)apiBusinessEntity.getName(), (List)modelBusinessEntity.getBusinessNames(), (BusinessEntity)modelBusinessEntity);
        MappingApiToModel.mapBusinessDescriptions((List)apiBusinessEntity.getDescription(), (List)modelBusinessEntity.getBusinessDescrs(), (BusinessEntity)modelBusinessEntity);
        MappingApiToModel.mapDiscoveryUrls((DiscoveryURLs)apiBusinessEntity.getDiscoveryURLs(), (List)modelBusinessEntity.getDiscoveryUrls(), (BusinessEntity)modelBusinessEntity);
        MappingApiToModel.mapContacts((Contacts)apiBusinessEntity.getContacts(), (List)modelBusinessEntity.getContacts(), (BusinessEntity)modelBusinessEntity);
        MappingApiToModel.mapBusinessIdentifiers((IdentifierBag)apiBusinessEntity.getIdentifierBag(), (List)modelBusinessEntity.getBusinessIdentifiers(), (BusinessEntity)modelBusinessEntity);
        if (apiBusinessEntity.getCategoryBag() != null) {
            modelBusinessEntity.setCategoryBag(new BusinessCategoryBag(modelBusinessEntity));
            MappingApiToModel.mapCategoryBag((org.uddi.api_v3.CategoryBag)apiBusinessEntity.getCategoryBag(), (CategoryBag)modelBusinessEntity.getCategoryBag());
        }
        MappingApiToModel.mapBusinessServices((BusinessServices)apiBusinessEntity.getBusinessServices(), (List)modelBusinessEntity.getBusinessServices(), (List)modelBusinessEntity.getServiceProjections(), (BusinessEntity)modelBusinessEntity);
    }

    public static void mapBusinessNames(List<Name> apiNameList, List<BusinessName> modelNameList, BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelNameList.clear();
        for (Name apiName : apiNameList) {
            modelNameList.add(new BusinessName(modelBusinessEntity, apiName.getLang(), apiName.getValue()));
        }
    }

    public static void mapBusinessDescriptions(List<Description> apiDescList, List<BusinessDescr> modelDescList, BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new BusinessDescr(modelBusinessEntity, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapDiscoveryUrls(DiscoveryURLs apiDiscUrls, List<DiscoveryUrl> modelDiscUrlList, BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelDiscUrlList.clear();
        if (apiDiscUrls != null) {
            List apiDiscUrlList = apiDiscUrls.getDiscoveryURL();
            for (DiscoveryURL apiDiscUrl : apiDiscUrlList) {
                modelDiscUrlList.add(new DiscoveryUrl(modelBusinessEntity, apiDiscUrl.getUseType(), apiDiscUrl.getValue()));
            }
        }
    }

    public static void mapContacts(Contacts apiContacts, List<Contact> modelContactList, BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelContactList.clear();
        if (apiContacts != null) {
            List apiContactList = apiContacts.getContact();
            for (org.uddi.api_v3.Contact apiContact : apiContactList) {
                Contact modelContact = new Contact(modelBusinessEntity);
                modelContact.setUseType(apiContact.getUseType());
                MappingApiToModel.mapPersonNames((List)apiContact.getPersonName(), (List)modelContact.getPersonNames(), (Contact)modelContact, (String)modelBusinessEntity.getEntityKey());
                MappingApiToModel.mapContactDescriptions((List)apiContact.getDescription(), (List)modelContact.getContactDescrs(), (Contact)modelContact, (String)modelBusinessEntity.getEntityKey());
                MappingApiToModel.mapContactEmails((List)apiContact.getEmail(), (List)modelContact.getEmails(), (Contact)modelContact, (String)modelBusinessEntity.getEntityKey());
                MappingApiToModel.mapContactPhones((List)apiContact.getPhone(), (List)modelContact.getPhones(), (Contact)modelContact, (String)modelBusinessEntity.getEntityKey());
                MappingApiToModel.mapContactAddresses((List)apiContact.getAddress(), (List)modelContact.getAddresses(), (Contact)modelContact, (String)modelBusinessEntity.getEntityKey());
                modelContactList.add(modelContact);
            }
        }
    }

    public static void mapContactDescriptions(List<Description> apiDescList, List<ContactDescr> modelDescList, Contact modelContact, String businessKey) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new ContactDescr(modelContact, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapPersonNames(List<PersonName> apiPersonNameList, List<org.apache.juddi.model.PersonName> modelPersonNameList, Contact modelContact, String businessKey) throws DispositionReportFaultMessage {
        modelPersonNameList.clear();
        for (PersonName apiPersonName : apiPersonNameList) {
            modelPersonNameList.add(new org.apache.juddi.model.PersonName(modelContact, apiPersonName.getLang(), apiPersonName.getValue()));
        }
    }

    public static void mapContactEmails(List<org.uddi.api_v3.Email> apiEmailList, List<Email> modelEmailList, Contact modelContact, String businessKey) throws DispositionReportFaultMessage {
        modelEmailList.clear();
        for (org.uddi.api_v3.Email apiEmail : apiEmailList) {
            modelEmailList.add(new Email(modelContact, apiEmail.getUseType(), apiEmail.getValue()));
        }
    }

    public static void mapContactPhones(List<Phone> apiPhoneList, List<org.apache.juddi.model.Phone> modelPhoneList, Contact modelContact, String businessKey) throws DispositionReportFaultMessage {
        modelPhoneList.clear();
        for (Phone apiPhone : apiPhoneList) {
            modelPhoneList.add(new org.apache.juddi.model.Phone(modelContact, apiPhone.getUseType(), apiPhone.getValue()));
        }
    }

    public static void mapContactAddresses(List<org.uddi.api_v3.Address> apiAddressList, List<Address> modelAddressList, Contact modelContact, String businessKey) throws DispositionReportFaultMessage {
        modelAddressList.clear();
        for (org.uddi.api_v3.Address apiAddress : apiAddressList) {
            Address modelAddress = new Address(modelContact);
            modelAddress.setSortCode(apiAddress.getSortCode());
            modelAddress.setTmodelKey(apiAddress.getTModelKey());
            modelAddress.setUseType(apiAddress.getUseType());
            MappingApiToModel.mapAddressLines((List)apiAddress.getAddressLine(), (List)modelAddress.getAddressLines(), (Address)modelAddress, (String)businessKey, (Long)modelContact.getId());
            modelAddressList.add(modelAddress);
        }
    }

    public static void mapAddressLines(List<org.uddi.api_v3.AddressLine> apiAddressLineList, List<AddressLine> modelAddressLineList, Address modelAddress, String businessKey, Long contactId) throws DispositionReportFaultMessage {
        modelAddressLineList.clear();
        for (org.uddi.api_v3.AddressLine apiAddressLine : apiAddressLineList) {
            modelAddressLineList.add(new AddressLine(modelAddress, apiAddressLine.getValue(), apiAddressLine.getKeyName(), apiAddressLine.getKeyValue()));
        }
    }

    public static void mapBusinessIdentifiers(IdentifierBag apiIdentifierBag, List<BusinessIdentifier> modelIdentifierList, BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelIdentifierList.clear();
        if (apiIdentifierBag != null) {
            List apiKeyedRefList = apiIdentifierBag.getKeyedReference();
            for (org.uddi.api_v3.KeyedReference apiKeyedRef : apiKeyedRefList) {
                modelIdentifierList.add(new BusinessIdentifier(modelBusinessEntity, apiKeyedRef.getTModelKey(), apiKeyedRef.getKeyName(), apiKeyedRef.getKeyValue()));
            }
        }
    }

    public static void mapBusinessServices(BusinessServices apiBusinessServices, List<BusinessService> modelBusinessServiceList, List<ServiceProjection> modelServiceProjectionList, BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelBusinessServiceList.clear();
        if (apiBusinessServices != null) {
            List apiBusinessServiceList = apiBusinessServices.getBusinessService();
            for (org.uddi.api_v3.BusinessService apiBusinessService : apiBusinessServiceList) {
                BusinessService modelBusinessService = new BusinessService();
                if (apiBusinessService.getBusinessKey() != null && apiBusinessService.getBusinessKey().length() > 0 && !modelBusinessEntity.getEntityKey().equalsIgnoreCase(apiBusinessService.getBusinessKey())) {
                    modelBusinessService.setEntityKey(apiBusinessService.getServiceKey());
                    ServiceProjection modelServiceProjection = new ServiceProjection(modelBusinessEntity, modelBusinessService);
                    modelServiceProjectionList.add(modelServiceProjection);
                    continue;
                }
                MappingApiToModel.mapBusinessService((org.uddi.api_v3.BusinessService)apiBusinessService, (BusinessService)modelBusinessService, (BusinessEntity)modelBusinessEntity);
                modelBusinessServiceList.add(modelBusinessService);
            }
        }
    }

    public static void mapBusinessService(org.uddi.api_v3.BusinessService apiBusinessService, BusinessService modelBusinessService, BusinessEntity modelBusinessEntity) throws DispositionReportFaultMessage {
        modelBusinessService.setBusinessEntity(modelBusinessEntity);
        modelBusinessService.setEntityKey(apiBusinessService.getServiceKey());
        MappingApiToModel.mapServiceNames((List)apiBusinessService.getName(), (List)modelBusinessService.getServiceNames(), (BusinessService)modelBusinessService);
        MappingApiToModel.mapServiceDescriptions((List)apiBusinessService.getDescription(), (List)modelBusinessService.getServiceDescrs(), (BusinessService)modelBusinessService);
        if (apiBusinessService.getCategoryBag() != null) {
            modelBusinessService.setCategoryBag(new ServiceCategoryBag(modelBusinessService));
            MappingApiToModel.mapCategoryBag((org.uddi.api_v3.CategoryBag)apiBusinessService.getCategoryBag(), (CategoryBag)modelBusinessService.getCategoryBag());
        }
        MappingApiToModel.mapBindingTemplates((BindingTemplates)apiBusinessService.getBindingTemplates(), (List)modelBusinessService.getBindingTemplates(), (BusinessService)modelBusinessService);
    }

    public static void mapServiceNames(List<Name> apiNameList, List<ServiceName> modelNameList, BusinessService modelBusinessService) throws DispositionReportFaultMessage {
        modelNameList.clear();
        for (Name apiName : apiNameList) {
            modelNameList.add(new ServiceName(modelBusinessService, apiName.getLang(), apiName.getValue()));
        }
    }

    public static void mapServiceDescriptions(List<Description> apiDescList, List<ServiceDescr> modelDescList, BusinessService modelBusinessService) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new ServiceDescr(modelBusinessService, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapBindingTemplates(BindingTemplates apiBindingTemplates, List<BindingTemplate> modelBindingTemplateList, BusinessService modelBusinessService) throws DispositionReportFaultMessage {
        modelBindingTemplateList.clear();
        if (apiBindingTemplates != null) {
            List apiBindingTemplateList = apiBindingTemplates.getBindingTemplate();
            for (org.uddi.api_v3.BindingTemplate apiBindingTemplate : apiBindingTemplateList) {
                BindingTemplate modelBindingTemplate = new BindingTemplate();
                MappingApiToModel.mapBindingTemplate((org.uddi.api_v3.BindingTemplate)apiBindingTemplate, (BindingTemplate)modelBindingTemplate, (BusinessService)modelBusinessService);
                modelBindingTemplateList.add(modelBindingTemplate);
            }
        }
    }

    public static void mapBindingTemplate(org.uddi.api_v3.BindingTemplate apiBindingTemplate, BindingTemplate modelBindingTemplate, BusinessService modelBusinessService) throws DispositionReportFaultMessage {
        modelBindingTemplate.setBusinessService(modelBusinessService);
        modelBindingTemplate.setEntityKey(apiBindingTemplate.getBindingKey());
        modelBindingTemplate.setAccessPointType(apiBindingTemplate.getAccessPoint().getUseType());
        modelBindingTemplate.setAccessPointUrl(apiBindingTemplate.getAccessPoint().getValue());
        if (apiBindingTemplate.getHostingRedirector() != null) {
            modelBindingTemplate.setHostingRedirector(apiBindingTemplate.getHostingRedirector().getBindingKey());
        }
        MappingApiToModel.mapBindingDescriptions((List)apiBindingTemplate.getDescription(), (List)modelBindingTemplate.getBindingDescrs(), (BindingTemplate)modelBindingTemplate);
        if (apiBindingTemplate.getCategoryBag() != null) {
            modelBindingTemplate.setCategoryBag(new BindingCategoryBag(modelBindingTemplate));
            MappingApiToModel.mapCategoryBag((org.uddi.api_v3.CategoryBag)apiBindingTemplate.getCategoryBag(), (CategoryBag)modelBindingTemplate.getCategoryBag());
        }
        MappingApiToModel.mapTModelInstanceDetails((TModelInstanceDetails)apiBindingTemplate.getTModelInstanceDetails(), (List)modelBindingTemplate.getTmodelInstanceInfos(), (BindingTemplate)modelBindingTemplate);
    }

    public static void mapBindingDescriptions(List<Description> apiDescList, List<BindingDescr> modelDescList, BindingTemplate modelBindingTemplate) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new BindingDescr(modelBindingTemplate, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapCategoryBag(org.uddi.api_v3.CategoryBag apiCategoryBag, CategoryBag modelCategoryBag) throws DispositionReportFaultMessage {
        if (apiCategoryBag != null) {
            List krList = apiCategoryBag.getKeyedReference();
            for (org.uddi.api_v3.KeyedReference elem : krList) {
                if (!(elem instanceof org.uddi.api_v3.KeyedReference)) continue;
                List modelKeyedReferences = modelCategoryBag.getKeyedReferences();
                org.uddi.api_v3.KeyedReference apiKeyedReference = elem;
                modelKeyedReferences.add(new KeyedReference(modelCategoryBag, apiKeyedReference.getTModelKey(), apiKeyedReference.getKeyName(), apiKeyedReference.getKeyValue()));
            }
            List krgList = apiCategoryBag.getKeyedReferenceGroup();
            for (KeyedReferenceGroup elem : krgList) {
                if (!(elem instanceof KeyedReferenceGroup)) continue;
                KeyedReferenceGroup apiKeyedReferenceGroup = elem;
                org.apache.juddi.model.KeyedReferenceGroup modelKeyedReferenceGroup = new org.apache.juddi.model.KeyedReferenceGroup();
                List modelKeyedReferenceGroups = modelCategoryBag.getKeyedReferenceGroups();
                MappingApiToModel.mapKeyedReferenceGroup((KeyedReferenceGroup)apiKeyedReferenceGroup, (org.apache.juddi.model.KeyedReferenceGroup)modelKeyedReferenceGroup, (CategoryBag)modelCategoryBag);
                modelKeyedReferenceGroups.add(modelKeyedReferenceGroup);
            }
        }
    }

    public static void mapKeyedReferenceGroup(KeyedReferenceGroup apiKeyedReferenceGroup, org.apache.juddi.model.KeyedReferenceGroup modelKeyedReferenceGroup, CategoryBag modelCategoryBag) throws DispositionReportFaultMessage {
        if (apiKeyedReferenceGroup != null) {
            modelKeyedReferenceGroup.setCategoryBag(modelCategoryBag);
            modelKeyedReferenceGroup.setTmodelKey(apiKeyedReferenceGroup.getTModelKey());
            if (apiKeyedReferenceGroup.getKeyedReference() != null) {
                List modelKeyedReferences = modelKeyedReferenceGroup.getKeyedReferences();
                for (org.uddi.api_v3.KeyedReference apiKeyedReference : apiKeyedReferenceGroup.getKeyedReference()) {
                    modelKeyedReferences.add(new KeyedReference(modelKeyedReferenceGroup, apiKeyedReference.getTModelKey(), apiKeyedReference.getKeyName(), apiKeyedReference.getKeyValue()));
                }
            }
        }
    }

    public static void mapTModelInstanceDetails(TModelInstanceDetails apiTModelInstDetails, List<TmodelInstanceInfo> modelTModelInstInfoList, BindingTemplate modelBindingTemplate) throws DispositionReportFaultMessage {
        modelTModelInstInfoList.clear();
        if (apiTModelInstDetails != null) {
            List apiTModelInstInfoList = apiTModelInstDetails.getTModelInstanceInfo();
            for (TModelInstanceInfo apiTModelInstInfo : apiTModelInstInfoList) {
                TmodelInstanceInfo modelTModelInstInfo = new TmodelInstanceInfo(modelBindingTemplate, apiTModelInstInfo.getTModelKey());
                MappingApiToModel.mapTModelInstanceInfoDescriptions((List)apiTModelInstInfo.getDescription(), (List)modelTModelInstInfo.getTmodelInstanceInfoDescrs(), (TmodelInstanceInfo)modelTModelInstInfo);
                MappingApiToModel.mapInstanceDetails((InstanceDetails)apiTModelInstInfo.getInstanceDetails(), (TmodelInstanceInfo)modelTModelInstInfo);
                modelTModelInstInfoList.add(modelTModelInstInfo);
            }
        }
    }

    public static void mapTModelInstanceInfoDescriptions(List<Description> apiDescList, List<TmodelInstanceInfoDescr> modelDescList, TmodelInstanceInfo modelTModelInstInfo) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new TmodelInstanceInfoDescr(modelTModelInstInfo, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapInstanceDetails(InstanceDetails apiInstanceDetails, TmodelInstanceInfo modelTmodelInstInfo) throws DispositionReportFaultMessage {
        modelTmodelInstInfo.getInstanceDetailsDescrs().clear();
        if (apiInstanceDetails != null) {
            List descriptions = apiInstanceDetails.getDescription();
            List overviewdocs = apiInstanceDetails.getOverviewDoc();
            for (Description apiDesc : descriptions) {
                InstanceDetailsDescr modelInstanceDetailsDescr = new InstanceDetailsDescr(modelTmodelInstInfo, apiDesc.getLang(), apiDesc.getValue());
                modelTmodelInstInfo.getInstanceDetailsDescrs().add(modelInstanceDetailsDescr);
            }
            for (OverviewDoc apiOverviewDoc : overviewdocs) {
                org.apache.juddi.model.OverviewDoc modelOverviewDoc = new org.apache.juddi.model.OverviewDoc(modelTmodelInstInfo);
                MappingApiToModel.mapOverviewDoc((OverviewDoc)apiOverviewDoc, (org.apache.juddi.model.OverviewDoc)modelOverviewDoc);
                modelTmodelInstInfo.getOverviewDocs().add(modelOverviewDoc);
            }
            modelTmodelInstInfo.setInstanceParms(apiInstanceDetails.getInstanceParms());
        }
    }

    public static void mapOverviewDoc(OverviewDoc apiOverviewDoc, org.apache.juddi.model.OverviewDoc modelOverviewDoc) throws DispositionReportFaultMessage {
        if (apiOverviewDoc != null) {
            List descContent = apiOverviewDoc.getDescription();
            for (Description elem : descContent) {
                Description description = elem;
                if (description == null) continue;
                OverviewDocDescr modelOverviewDocDescr = new OverviewDocDescr(modelOverviewDoc, description.getLang(), description.getValue());
                modelOverviewDoc.getOverviewDocDescrs().add(modelOverviewDocDescr);
            }
            OverviewURL elem = apiOverviewDoc.getOverviewURL();
            if (elem instanceof OverviewURL) {
                OverviewURL overviewURL = elem;
                modelOverviewDoc.setOverviewUrl(overviewURL.getValue());
                modelOverviewDoc.setOverviewUrlUseType(overviewURL.getUseType());
            }
        }
    }

    public static void mapTModel(TModel apiTModel, Tmodel modelTModel) throws DispositionReportFaultMessage {
        modelTModel.setEntityKey(apiTModel.getTModelKey());
        modelTModel.setName(apiTModel.getName().getValue());
        modelTModel.setLangCode(apiTModel.getName().getLang());
        modelTModel.setDeleted(apiTModel.isDeleted());
        MappingApiToModel.mapTModelDescriptions((List)apiTModel.getDescription(), (List)modelTModel.getTmodelDescrs(), (Tmodel)modelTModel);
        MappingApiToModel.mapTModelIdentifiers((IdentifierBag)apiTModel.getIdentifierBag(), (List)modelTModel.getTmodelIdentifiers(), (Tmodel)modelTModel);
        if (apiTModel.getCategoryBag() != null) {
            modelTModel.setCategoryBag(new TmodelCategoryBag(modelTModel));
            MappingApiToModel.mapCategoryBag((org.uddi.api_v3.CategoryBag)apiTModel.getCategoryBag(), (CategoryBag)modelTModel.getCategoryBag());
        }
        MappingApiToModel.mapTModelOverviewDocs((List)apiTModel.getOverviewDoc(), (List)modelTModel.getOverviewDocs(), (Tmodel)modelTModel);
    }

    public static void mapTModelDescriptions(List<Description> apiDescList, List<TmodelDescr> modelDescList, Tmodel modelTModel) throws DispositionReportFaultMessage {
        modelDescList.clear();
        for (Description apiDesc : apiDescList) {
            modelDescList.add(new TmodelDescr(modelTModel, apiDesc.getLang(), apiDesc.getValue()));
        }
    }

    public static void mapTModelIdentifiers(IdentifierBag apiIdentifierBag, List<TmodelIdentifier> modelIdentifierList, Tmodel modelTModel) throws DispositionReportFaultMessage {
        modelIdentifierList.clear();
        if (apiIdentifierBag != null) {
            List apiKeyedRefList = apiIdentifierBag.getKeyedReference();
            for (org.uddi.api_v3.KeyedReference apiKeyedRef : apiKeyedRefList) {
                modelIdentifierList.add(new TmodelIdentifier(modelTModel, apiKeyedRef.getTModelKey(), apiKeyedRef.getKeyName(), apiKeyedRef.getKeyValue()));
            }
        }
    }

    public static void mapTModelOverviewDocs(List<OverviewDoc> apiOverviewDocList, List<org.apache.juddi.model.OverviewDoc> modelOverviewDocList, Tmodel modelTmodel) throws DispositionReportFaultMessage {
        modelOverviewDocList.clear();
        for (OverviewDoc apiOverviewDoc : apiOverviewDocList) {
            org.apache.juddi.model.OverviewDoc modelOverviewDoc = new org.apache.juddi.model.OverviewDoc(modelTmodel);
            MappingApiToModel.mapOverviewDoc((OverviewDoc)apiOverviewDoc, (org.apache.juddi.model.OverviewDoc)modelOverviewDoc);
            modelTmodel.getOverviewDocs().add(modelOverviewDoc);
        }
    }

    public static void mapPublisherAssertion(org.uddi.api_v3.PublisherAssertion apiPubAssertion, PublisherAssertion modelPubAssertion) throws DispositionReportFaultMessage {
        modelPubAssertion.setId(new PublisherAssertionId(apiPubAssertion.getFromKey(), apiPubAssertion.getToKey()));
        BusinessEntity beFrom = new BusinessEntity();
        beFrom.setEntityKey(apiPubAssertion.getFromKey());
        modelPubAssertion.setBusinessEntityByFromKey(beFrom);
        BusinessEntity beTo = new BusinessEntity();
        beFrom.setEntityKey(apiPubAssertion.getToKey());
        modelPubAssertion.setBusinessEntityByToKey(beTo);
        org.uddi.api_v3.KeyedReference apiKeyedRef = apiPubAssertion.getKeyedReference();
        if (apiKeyedRef != null) {
            modelPubAssertion.setTmodelKey(apiKeyedRef.getTModelKey());
            modelPubAssertion.setKeyName(apiKeyedRef.getKeyName());
            modelPubAssertion.setKeyValue(apiKeyedRef.getKeyValue());
        }
    }

    public static void mapSubscription(Subscription apiSubscription, org.apache.juddi.model.Subscription modelSubscription) throws DispositionReportFaultMessage {
        modelSubscription.setSubscriptionKey(apiSubscription.getSubscriptionKey());
        modelSubscription.setBindingKey(apiSubscription.getBindingKey());
        if (apiSubscription.getNotificationInterval() != null) {
            modelSubscription.setNotificationInterval(apiSubscription.getNotificationInterval().toString());
        }
        modelSubscription.setMaxEntities(apiSubscription.getMaxEntities());
        if (apiSubscription.getExpiresAfter() != null) {
            GregorianCalendar gc = apiSubscription.getExpiresAfter().toGregorianCalendar();
            modelSubscription.setExpiresAfter(new Date(gc.getTimeInMillis()));
        }
        if (apiSubscription.isBrief() != null) {
            modelSubscription.setBrief(apiSubscription.isBrief());
        } else {
            modelSubscription.setBrief(new Boolean(false));
        }
        String rawFilter = JAXBMarshaller.marshallToString((Object)new ObjectFactory().createSubscriptionFilter(apiSubscription.getSubscriptionFilter()), (String)"org.uddi.sub_v3");
        logger.debug((Object)("marshalled subscription filter:  " + rawFilter));
        modelSubscription.setSubscriptionFilter(rawFilter);
    }

    public static void mapClientSubscriptionInfo(org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo, ClientSubscriptionInfo modelClientSubscriptionInfo) throws DispositionReportFaultMessage {
        modelClientSubscriptionInfo.setLastNotified(new Date());
        modelClientSubscriptionInfo.setSubscriptionKey(apiClientSubscriptionInfo.getSubscriptionKey());
        if (apiClientSubscriptionInfo.getFromClerk() != null) {
            Clerk modelClerk = new Clerk();
            MappingApiToModel.mapClerk((org.apache.juddi.api_v3.Clerk)apiClientSubscriptionInfo.getFromClerk(), (Clerk)modelClerk);
            modelClientSubscriptionInfo.setFromClerk(modelClerk);
        }
        if (apiClientSubscriptionInfo.getToClerk() != null) {
            Clerk modelToClerk = new Clerk();
            MappingApiToModel.mapClerk((org.apache.juddi.api_v3.Clerk)apiClientSubscriptionInfo.getToClerk(), (Clerk)modelToClerk);
            modelClientSubscriptionInfo.setToClerk(modelToClerk);
        }
    }

    public static void mapClerk(org.apache.juddi.api_v3.Clerk apiClerk, Clerk modelClerk) {
        if (apiClerk != null) {
            modelClerk.setClerkName(apiClerk.getName());
            modelClerk.setCred(apiClerk.getPassword());
            modelClerk.setPublisherId(apiClerk.getPublisher());
            if (apiClerk.getNode() != null) {
                org.apache.juddi.model.Node modelNode = new org.apache.juddi.model.Node();
                MappingApiToModel.mapNode((Node)apiClerk.getNode(), (org.apache.juddi.model.Node)modelNode);
                modelClerk.setNode(modelNode);
            }
        }
    }

    public static void mapNode(Node apiNode, org.apache.juddi.model.Node modelNode) {
        if (apiNode != null) {
            modelNode.setCustodyTransferUrl(apiNode.getCustodyTransferUrl());
            modelNode.setInquiryUrl(apiNode.getInquiryUrl());
            modelNode.setJuddiApiUrl(apiNode.getJuddiApiUrl());
            modelNode.setName(apiNode.getName());
            modelNode.setManagerName(apiNode.getManagerName());
            modelNode.setProxyTransport(apiNode.getProxyTransport());
            modelNode.setPublishUrl(apiNode.getPublishUrl());
            modelNode.setSecurityUrl(apiNode.getSecurityUrl());
            modelNode.setSubscriptionUrl(apiNode.getSubscriptionUrl());
            modelNode.setFactoryInitial(apiNode.getFactoryInitial());
            modelNode.setFactoryNamingProvider(apiNode.getFactoryNamingProvider());
            modelNode.setFactoryURLPkgs(apiNode.getFactoryURLPkgs());
        }
    }
}

