/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.Date;
import java.util.UUID;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.SecurityQuery;
import org.apache.juddi.api.util.UDDIQuery;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.auth.AuthenticatorFactory;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.UnknownUserException;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.DiscardAuthToken;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISecurityPortType;

@WebService(serviceName="UDDISecurityService", endpointInterface="org.uddi.v3_service.UDDISecurityPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDISecurityImpl
extends AuthenticatedService
implements UDDISecurityPortType {
    public static final String AUTH_TOKEN_PREFIX = "authtoken:";
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());

    public void discardAuthToken(DiscardAuthToken body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            org.apache.juddi.model.AuthToken modelAuthToken = (org.apache.juddi.model.AuthToken)em.find(org.apache.juddi.model.AuthToken.class, (Object)body.getAuthInfo());
            if (modelAuthToken != null) {
                modelAuthToken.setLastUsed(new Date());
                modelAuthToken.setNumberOfUses(modelAuthToken.getNumberOfUses() + 1);
                modelAuthToken.setTokenState(0);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)SecurityQuery.DISCARD_AUTHTOKEN, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)SecurityQuery.DISCARD_AUTHTOKEN, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public AuthToken getAuthToken(GetAuthToken body) throws DispositionReportFaultMessage {
        Authenticator authenticator = AuthenticatorFactory.getAuthenticator();
        String publisherId = authenticator.authenticate(body.getUserID(), body.getCred());
        return this.getAuthToken(publisherId);
    }

    public AuthToken getAuthToken(String publisherId) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        if (publisherId == null || publisherId.length() == 0) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials", publisherId));
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            String authInfo = AUTH_TOKEN_PREFIX + UUID.randomUUID();
            org.apache.juddi.model.AuthToken modelAuthToken = new org.apache.juddi.model.AuthToken();
            if (authInfo != null) {
                modelAuthToken.setAuthToken(authInfo);
                modelAuthToken.setCreated(new Date());
                modelAuthToken.setLastUsed(new Date());
                modelAuthToken.setAuthorizedName(publisherId);
                modelAuthToken.setNumberOfUses(0);
                modelAuthToken.setTokenState(1);
                em.persist((Object)modelAuthToken);
            }
            AuthToken apiAuthToken = new AuthToken();
            MappingModelToApi.mapAuthToken((org.apache.juddi.model.AuthToken)modelAuthToken, (AuthToken)apiAuthToken);
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)SecurityQuery.GET_AUTHTOKEN, QueryStatus.SUCCESS, procTime);
            AuthToken authToken = apiAuthToken;
            return authToken;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)SecurityQuery.GET_AUTHTOKEN, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

