/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.CustodyTransferQuery;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.UDDIQuery;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.TransferToken;
import org.apache.juddi.model.TransferTokenKey;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.validation.ValidateCustodyTransfer;
import org.uddi.custody_v3.DiscardTransferToken;
import org.uddi.custody_v3.KeyBag;
import org.uddi.custody_v3.TransferEntities;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDICustodyTransferPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="UDDICustodyTransferService", endpointInterface="org.uddi.v3_service.UDDICustodyTransferPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDICustodyTransferImpl
extends AuthenticatedService
implements UDDICustodyTransferPortType {
    public static final String TRANSFER_TOKEN_PREFIX = "transfertoken:";
    public static final int DEFAULT_TRANSFEREXPIRATION_DAYS = 3;
    private static Log logger = LogFactory.getLog(UDDICustodyTransferImpl.class);
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardTransferToken(DiscardTransferToken body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            KeyBag keyBag;
            String transferTokenId;
            TransferToken modelTransferToken;
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateCustodyTransfer(publisher).validateDiscardTransferToken(em, body);
            org.uddi.custody_v3.TransferToken apiTransferToken = body.getTransferToken();
            if (apiTransferToken != null && (modelTransferToken = (TransferToken)em.find(TransferToken.class, (Object)(transferTokenId = new String(apiTransferToken.getOpaqueToken())))) != null) {
                em.remove((Object)modelTransferToken);
            }
            if ((keyBag = body.getKeyBag()) != null) {
                List keyList = keyBag.getKey();
                Vector<DynamicQuery.Parameter> params = new Vector<DynamicQuery.Parameter>(0);
                for (String key : keyList) {
                    DynamicQuery.Parameter param = new DynamicQuery.Parameter("UPPER(ttk.entityKey)", (Object)key.toUpperCase(), DynamicQuery.PREDICATE_EQUALS);
                    params.add(param);
                }
                DynamicQuery getTokensQry = new DynamicQuery();
                getTokensQry.append("select distinct ttk.transferToken from TransferTokenKey ttk").pad();
                getTokensQry.WHERE().pad().appendGroupedOr(params.toArray(new DynamicQuery.Parameter[0]));
                Query qry = getTokensQry.buildJPAQuery(em);
                List tokensToDelete = qry.getResultList();
                if (tokensToDelete != null && tokensToDelete.size() > 0) {
                    for (TransferToken tt : tokensToDelete) {
                        em.remove((Object)tt);
                    }
                }
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)CustodyTransferQuery.DISCARD_TRANSFERTOKEN, QueryStatus.SUCCESS, procTime);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTransferToken(String authInfo, KeyBag keyBag, Holder<String> nodeID, Holder<XMLGregorianCalendar> expirationTime, Holder<byte[]> opaqueToken) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            new ValidateCustodyTransfer(publisher).validateGetTransferToken(em, keyBag);
            int transferExpirationDays = 3;
            try {
                transferExpirationDays = AppConfig.getConfiguration().getInt("juddi.transfer.expiration.days");
                nodeID.value = AppConfig.getConfiguration().getString("juddi.nodeId");
            }
            catch (ConfigurationException ce) {
                throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval"));
            }
            String transferKey = TRANSFER_TOKEN_PREFIX + UUID.randomUUID();
            TransferToken transferToken = new TransferToken();
            transferToken.setTransferToken(transferKey);
            opaqueToken.value = transferKey.getBytes();
            GregorianCalendar gc = new GregorianCalendar();
            gc.add(5, transferExpirationDays);
            transferToken.setExpirationDate(gc.getTime());
            try {
                DatatypeFactory df = DatatypeFactory.newInstance();
                expirationTime.value = df.newXMLGregorianCalendar(gc);
            }
            catch (DatatypeConfigurationException ce) {
                throw new FatalErrorException(new ErrorMessage("errors.Unspecified"));
            }
            List keyList = keyBag.getKey();
            for (String key : keyList) {
                TransferTokenKey tokenKey = new TransferTokenKey(transferToken, key);
                transferToken.getTransferKeys().add(tokenKey);
            }
            em.persist((Object)transferToken);
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)CustodyTransferQuery.GET_TRANSFERTOKEN, QueryStatus.SUCCESS, procTime);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferEntities(TransferEntities body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateCustodyTransfer(publisher).validateTransferEntities(em, body);
            KeyBag keyBag = body.getKeyBag();
            List keyList = keyBag.getKey();
            for (String key : keyList) {
                UddiEntity uddiEntity = (UddiEntity)em.find(UddiEntity.class, (Object)key);
                uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
                if (!(uddiEntity instanceof BusinessEntity)) continue;
                BusinessEntity be = (BusinessEntity)uddiEntity;
                List bsList = be.getBusinessServices();
                for (BusinessService bs : bsList) {
                    bs.setAuthorizedName(publisher.getAuthorizedName());
                    List btList = bs.getBindingTemplates();
                    for (BindingTemplate bt : btList) {
                        bt.setAuthorizedName(publisher.getAuthorizedName());
                    }
                }
            }
            org.uddi.custody_v3.TransferToken apiTransferToken = body.getTransferToken();
            String transferTokenId = new String(apiTransferToken.getOpaqueToken());
            TransferToken modelTransferToken = (TransferToken)em.find(TransferToken.class, (Object)transferTokenId);
            em.remove((Object)modelTransferToken);
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)CustodyTransferQuery.TRANSFER_ENTITIES, QueryStatus.SUCCESS, procTime);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

