/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.api_v3.SaveNode;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidateNode
extends ValidateUDDIApi {
    public ValidateNode(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateSaveNode(EntityManager em, SaveNode body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List nodes = body.getNode();
        if (nodes == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.saveNodes.NoInput"));
        }
        for (Node clerk : body.getNode()) {
            this.validateNode(clerk);
        }
    }

    public void validateNode(Node node) throws DispositionReportFaultMessage {
        if (node == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NullInput"));
        }
        String name = node.getName();
        if (name == null || name.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.node.NoName"));
        }
    }
}

