/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.error.AuthenticationException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.UnknownUserException;

public class LdapSimpleAuthenticator
implements Authenticator {
    private Log log = LogFactory.getLog(this.getClass());
    private LdapContext ctx = null;
    private Hashtable<String, String> env = null;
    private String url = null;
    private static final String DEFAULT_URL = "ldap://localhost:389";

    public LdapSimpleAuthenticator() throws NamingException {
        String authURL = null;
        try {
            authURL = AppConfig.getConfiguration().getString("juddi.authenticator.url", DEFAULT_URL);
        }
        catch (ConfigurationException ce) {
            this.log.error((Object)"Configuration exception occurred retrieving: juddi.authenticator.url");
        }
        this.init(authURL);
    }

    public LdapSimpleAuthenticator(String url) throws NamingException {
        this.init(url);
    }

    public void init(String url) throws NamingException {
        this.env = new Hashtable();
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.provider.url", url);
        this.url = url;
        try {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (NamingException e) {
            this.log.error((Object)("Naming exception " + e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String authenticate(String authorizedName, String cred) throws AuthenticationException, FatalErrorException {
        if (authorizedName == null || "".equals(authorizedName)) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
        }
        boolean isLdapUser = false;
        try {
            this.env = new Hashtable();
            this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            this.env.put("java.naming.security.authentication", "simple");
            this.env.put("java.naming.provider.url", this.url);
            this.env.put("java.naming.security.principal", authorizedName);
            this.env.put("java.naming.security.credentials", cred);
            this.ctx = new InitialLdapContext(this.env, null);
            this.log.info((Object)(authorizedName + " is authenticated"));
        }
        catch (NamingException e) {
            this.log.error((Object)(authorizedName + " is not authenticated"));
            throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
        }
        finally {
            try {
                this.ctx.close();
            }
            catch (NamingException e) {
                this.log.error((Object)("Context close failure " + e));
            }
        }
        if (!isLdapUser) throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)authorizedName);
            if (publisher != null) return authorizedName;
            this.log.warn((Object)"Publisher was not found, adding the publisher in on the fly.");
            publisher = new Publisher();
            publisher.setAuthorizedName(authorizedName);
            publisher.setIsAdmin("false");
            publisher.setIsEnabled("true");
            publisher.setMaxBindingsPerService(Integer.valueOf(199));
            publisher.setMaxBusinesses(Integer.valueOf(100));
            publisher.setMaxServicesPerBusiness(Integer.valueOf(100));
            publisher.setMaxTmodels(Integer.valueOf(100));
            publisher.setPublisherName("Unknown");
            em.persist((Object)publisher);
            tx.commit();
            return authorizedName;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UddiEntityPublisher identify(String authInfo, String authorizedName) throws AuthenticationException, FatalErrorException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Publisher publisher = (Publisher)em.find(Publisher.class, (Object)authorizedName);
            if (publisher == null) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.NoPublisher", authorizedName));
            }
            Publisher publisher2 = publisher;
            return publisher2;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

