/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.subscription.notify;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.subscription.notify.Notifier;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.Result;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class SMTPNotifier
implements Notifier {
    Log log = LogFactory.getLog(this.getClass());
    String notificationEmailAddress = null;
    String from = null;
    Session session = null;
    String transport = null;

    public SMTPNotifier(BindingTemplate bindingTemplate) throws URISyntaxException, ConfigurationException {
        String accessPointUrl;
        if (!AccessPointType.END_POINT.toString().equalsIgnoreCase(bindingTemplate.getAccessPointType())) {
            this.log.error((Object)("smtp enpoints only support AccessPointType " + AccessPointType.END_POINT));
        }
        if (!(accessPointUrl = bindingTemplate.getAccessPointUrl().toLowerCase()).startsWith("mailto")) {
            this.log.warn((Object)("smtp accessPointUrl for bindingTemplate " + bindingTemplate.getEntityKey() + " should start with 'mailto'"));
        }
        URI accessPointURI = new URI(accessPointUrl);
        this.notificationEmailAddress = accessPointURI.getUserInfo() + "@" + accessPointURI.getHost();
        Properties properties = new Properties();
        String host = AppConfig.getConfiguration().getString("juddi.email.host", "localhost");
        properties.put("mail.smtp.host", host);
        String port = AppConfig.getConfiguration().getString("juddi.email.port", "25");
        properties.put("mail.smtp.port", port);
        boolean isAuth = AppConfig.getConfiguration().getBoolean("juddi.email.auth", false);
        if (isAuth) {
            String user = AppConfig.getConfiguration().getString("juddi.email.user", "juddi");
            properties.put("mail.smtp.user", user);
            String password = AppConfig.getConfiguration().getString("juddi.email.password", "juddi");
            properties.put("mail.smtp.user", password);
        }
        this.session = Session.getDefaultInstance((Properties)properties);
        this.from = AppConfig.getConfiguration().getString("juddi.email.from", "juddi");
        this.transport = AppConfig.getConfiguration().getString("juddi.email.transport", "smtp");
    }

    public DispositionReport notifySubscriptionListener(NotifySubscriptionListener body) throws DispositionReportFaultMessage, RemoteException {
        this.log.info((Object)("Sending notification email to " + this.notificationEmailAddress));
        try {
            MimeMessage message = new MimeMessage(this.session);
            message.setFrom((Address)new InternetAddress(this.from));
            String subscriptionResultXML = JAXBMarshaller.marshallToString((Object)body, (String)"org.uddi.api_v3");
            message.setText(subscriptionResultXML);
            message.setSubject("UDDI Subscription Notification for subscription " + body.getSubscriptionResultsList().getSubscription().getSubscriptionKey());
            Transport.send((Message)message);
        }
        catch (Exception e) {
            throw new DispositionReportFaultMessage(e.getMessage(), null);
        }
        DispositionReport dr = new DispositionReport();
        Result res = new Result();
        dr.getResult().add(res);
        return dr;
    }
}

