/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.model.PublisherAssertion;
import org.apache.juddi.query.PublisherAssertionQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.uddi.api_v3.CompletionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FindPublisherAssertionByBusinessQuery
extends PublisherAssertionQuery {
    private static Log log = LogFactory.getLog(FindPublisherAssertionByBusinessQuery.class);

    public static List<PublisherAssertion> select(EntityManager em, List<?> businessKeys, CompletionStatus completionStatus) {
        if (businessKeys == null || businessKeys.size() == 0) {
            return null;
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        FindPublisherAssertionByBusinessQuery.appendConditions((DynamicQuery)dynamicQry, businessKeys, (CompletionStatus)completionStatus);
        log.debug((Object)dynamicQry);
        Query qry = dynamicQry.buildJPAQuery(em);
        List result = qry.getResultList();
        return result;
    }

    public static void appendConditions(DynamicQuery qry, List<?> businessKeys, CompletionStatus completionStatus) {
        qry.WHERE().pad().openParen().pad();
        qry.appendInList("pa.businessEntityByFromKey.entityKey", businessKeys);
        qry.pad().OR().pad();
        qry.appendInList("pa.businessEntityByToKey.entityKey", businessKeys);
        qry.closeParen().pad();
        if (completionStatus != null) {
            qry.AND().pad().openParen().pad();
            String fromCheckTerm = "UPPER(pa.fromCheck)";
            String toCheckTerm = "UPPER(pa.toCheck)";
            if (completionStatus == CompletionStatus.STATUS_BOTH_INCOMPLETE) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(fromCheckTerm, (Object)"TRUE", DynamicQuery.PREDICATE_NOTEQUALS)});
                qry.AND().pad();
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(toCheckTerm, (Object)"TRUE", DynamicQuery.PREDICATE_NOTEQUALS)});
            } else if (completionStatus == CompletionStatus.STATUS_COMPLETE) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(fromCheckTerm, (Object)"TRUE", DynamicQuery.PREDICATE_EQUALS)});
                qry.AND().pad();
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(toCheckTerm, (Object)"TRUE", DynamicQuery.PREDICATE_EQUALS)});
            } else if (completionStatus == CompletionStatus.STATUS_FROM_KEY_INCOMPLETE) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(fromCheckTerm, (Object)"TRUE", DynamicQuery.PREDICATE_NOTEQUALS)});
                qry.AND().pad();
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(toCheckTerm, (Object)"TRUE", DynamicQuery.PREDICATE_EQUALS)});
            } else if (completionStatus == CompletionStatus.STATUS_TO_KEY_INCOMPLETE) {
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(fromCheckTerm, (Object)"TRUE", DynamicQuery.PREDICATE_EQUALS)});
                qry.AND().pad();
                qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(toCheckTerm, (Object)"TRUE", DynamicQuery.PREDICATE_NOTEQUALS)});
            }
            qry.closeParen().pad();
        }
    }
}

