/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.keygen;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.keygen.KeyGenerator;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class KeyGeneratorFactory {
    private static Log log = LogFactory.getLog(KeyGeneratorFactory.class);
    private static final String DEFAULT_IMPL = "org.apache.juddi.keygen.DefaultKeyGenerator";
    private static KeyGenerator keyGenerator = null;

    public static KeyGenerator getKeyGenerator() {
        if (keyGenerator == null) {
            keyGenerator = KeyGeneratorFactory.createKeyGenerator();
        }
        return keyGenerator;
    }

    private static synchronized KeyGenerator createKeyGenerator() {
        if (keyGenerator != null) {
            return keyGenerator;
        }
        String className = "org.apache.juddi.keygen.DefaultKeyGenerator";
        try {
            className = AppConfig.getConfiguration().getString("juddi.keygenerator", "org.apache.juddi.keygen.DefaultKeyGenerator");
        }
        catch (ConfigurationException ce) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.keygenerator");
        }
        log.debug((Object)("Key Generator Implementation = " + className));
        Class keygenClass = null;
        try {
            keygenClass = ClassUtil.forName((String)className, KeyGeneratorFactory.class);
            keyGenerator = (KeyGenerator)keygenClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("The specified Key Generator class '" + className + "' was not found on classpath.", cnfe);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("The specified Key Generator class '" + className + "' cannot be instantiated.", ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("The specified Key Generator class '" + className + "' cannot be instantiated due to illegal access.", iae);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while attempting to instantiate the implementation of Key Generator: " + keygenClass.getName() + "\n" + e.getMessage());
        }
        return keyGenerator;
    }
}

