/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.config;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.api.impl.UDDIInquiryImpl;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.config.PublisherFileFilter;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.KeyUnavailableException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidatePublish;
import org.apache.juddi.validation.ValidateUDDIKey;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * Exception performing whole class analysis ignored.
 */
public class Install {
    public static final String FILE_BUSINESSENTITY = "_BusinessEntity.xml";
    public static final String FILE_PUBLISHER = "_Publisher.xml";
    public static final String FILE_TMODELKEYGEN = "_tModelKeyGen.xml";
    public static final String FILE_TMODELS = "_tModels.xml";
    public static final String FILE_PERSISTENCE = "persistence.xml";
    public static final String JUDDI_INSTALL_DATA_DIR = "juddi_install_data/";
    public static final String JUDDI_CUSTOM_INSTALL_DATA_DIR = "juddi_custom_install_data/";
    public static Log log = LogFactory.getLog(Install.class);

    protected static void install(Configuration config) throws JAXBException, DispositionReportFaultMessage, IOException, ConfigurationException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        UddiEntityPublisher rootPublisher = null;
        try {
            tx.begin();
            boolean seedAlways = config.getBoolean("juddi.seed.always", false);
            boolean alreadyInstalled = Install.alreadyInstalled((Configuration)config);
            if (!seedAlways && alreadyInstalled) {
                new FatalErrorException(new ErrorMessage("errors.install.AlreadyInstalled"));
            }
            String rootPublisherStr = config.getString("juddi.root.publisher");
            String fileRootTModelKeygen = rootPublisherStr + "_tModelKeyGen.xml";
            TModel rootTModelKeyGen = (TModel)Install.buildInstallEntity((String)fileRootTModelKeygen, (String)"org.uddi.api_v3", (Configuration)config);
            String fileRootBusinessEntity = rootPublisherStr + "_BusinessEntity.xml";
            org.uddi.api_v3.BusinessEntity rootBusinessEntity = (org.uddi.api_v3.BusinessEntity)Install.buildInstallEntity((String)fileRootBusinessEntity, (String)"org.uddi.api_v3", (Configuration)config);
            String rootPartition = Install.getRootPartition((TModel)rootTModelKeyGen);
            String nodeId = Install.getNodeId((String)rootBusinessEntity.getBusinessKey(), (String)rootPartition);
            String fileRootPublisher = rootPublisherStr + "_Publisher.xml";
            if (!alreadyInstalled) {
                log.info((Object)("Loading the root Publisher from file " + fileRootPublisher));
                rootPublisher = Install.installPublisher((EntityManager)em, (String)fileRootPublisher, (Configuration)config);
                Install.installRootPublisherKeyGen((EntityManager)em, (TModel)rootTModelKeyGen, (String)rootPartition, (UddiEntityPublisher)rootPublisher, (String)nodeId);
                rootBusinessEntity.setBusinessKey(nodeId);
                Install.installBusinessEntity((boolean)true, (EntityManager)em, (org.uddi.api_v3.BusinessEntity)rootBusinessEntity, (UddiEntityPublisher)rootPublisher, (String)rootPartition, (Configuration)config);
            } else {
                log.debug((Object)"juddi.seed.always reapplies all seed files except for the root data.");
            }
            List juddiPublishers = Install.getPublishers((Configuration)config);
            for (String publisherStr : juddiPublishers) {
                String filePublisher = publisherStr + "_Publisher.xml";
                String fileTModelKeygen = publisherStr + "_tModelKeyGen.xml";
                TModel tModelKeyGen = (TModel)Install.buildInstallEntity((String)fileTModelKeygen, (String)"org.uddi.api_v3", (Configuration)config);
                String fileBusinessEntity = publisherStr + "_BusinessEntity.xml";
                org.uddi.api_v3.BusinessEntity businessEntity = (org.uddi.api_v3.BusinessEntity)Install.buildInstallEntity((String)fileBusinessEntity, (String)"org.uddi.api_v3", (Configuration)config);
                UddiEntityPublisher publisher = Install.installPublisher((EntityManager)em, (String)filePublisher, (Configuration)config);
                if (publisher == null) {
                    throw new ConfigurationException("File " + filePublisher + " not found.");
                }
                if (tModelKeyGen != null) {
                    Install.installPublisherKeyGen((EntityManager)em, (TModel)tModelKeyGen, (UddiEntityPublisher)publisher, (String)nodeId);
                }
                if (businessEntity != null) {
                    Install.installBusinessEntity((boolean)false, (EntityManager)em, (org.uddi.api_v3.BusinessEntity)businessEntity, (UddiEntityPublisher)publisher, null, (Configuration)config);
                }
                String fileTModels = publisherStr + "_tModels.xml";
                Install.installSaveTModel((EntityManager)em, (String)fileTModels, (UddiEntityPublisher)publisher, (String)nodeId, (Configuration)config);
            }
            tx.commit();
        }
        catch (DispositionReportFaultMessage dr) {
            log.error((Object)dr.getMessage(), (Throwable)dr);
            tx.rollback();
            throw dr;
        }
        catch (JAXBException je) {
            log.error((Object)je.getMessage(), (Throwable)je);
            tx.rollback();
            throw je;
        }
        catch (IOException ie) {
            log.error((Object)ie.getMessage(), (Throwable)ie);
            tx.rollback();
            throw ie;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    protected static void uninstall() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean alreadyInstalled(Configuration config) throws ConfigurationException {
        String rootPublisherStr = config.getString("juddi.root.publisher");
        Publisher publisher = null;
        int numberOfTries = 0;
        while (numberOfTries++ < 100) {
            EntityManager em = PersistenceManager.getEntityManager();
            EntityTransaction tx = em.getTransaction();
            try {
                tx.begin();
                publisher = (Publisher)em.find(Publisher.class, (Object)rootPublisherStr);
                tx.commit();
            }
            finally {
                if (tx.isActive()) {
                    tx.rollback();
                }
                em.close();
            }
            if (publisher != null) {
                return true;
            }
            if (config.getBoolean("juddi.load.install.data", true)) {
                log.debug((Object)"Install data not yet installed.");
                return false;
            }
            try {
                log.info((Object)"Install data not yet installed.");
                log.info((Object)"Going to sleep and retry...");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        throw new ConfigurationException("Could not load the Root node data. Please check for errors.");
    }

    protected static String getRootPartition(TModel rootTModelKeyGen) throws JAXBException, IOException, DispositionReportFaultMessage {
        String result = rootTModelKeyGen.getTModelKey().substring(0, rootTModelKeyGen.getTModelKey().lastIndexOf(":"));
        if (result == null || result.length() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.MalformedKey", result));
        }
        if ((result = result.trim()).endsWith(":") || result.startsWith(":")) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.MalformedKey", result));
        }
        StringTokenizer tokenizer = new StringTokenizer(result.toLowerCase(), ":");
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (count == 0 ? !ValidateUDDIKey.isValidDomainKey((String)nextToken) : !ValidateUDDIKey.isValidKSS((String)nextToken)) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.MalformedKey", result));
            }
            ++count;
        }
        return result;
    }

    protected static String getNodeId(String userNodeId, String rootPartition) throws DispositionReportFaultMessage {
        String result = userNodeId;
        if (result == null || result.length() == 0) {
            result = rootPartition + ":" + UUID.randomUUID();
        } else {
            ValidateUDDIKey.validateUDDIv3Key((String)result);
            String keyPartition = result.substring(0, result.lastIndexOf(":"));
            if (!rootPartition.equalsIgnoreCase(keyPartition)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", userNodeId));
            }
        }
        return result;
    }

    private static String installBusinessEntity(boolean isRoot, EntityManager em, org.uddi.api_v3.BusinessEntity rootBusinessEntity, UddiEntityPublisher rootPublisher, String rootPartition, Configuration config) throws JAXBException, DispositionReportFaultMessage, IOException {
        if (isRoot) {
            Install.validateRootBusinessEntity((org.uddi.api_v3.BusinessEntity)rootBusinessEntity, (UddiEntityPublisher)rootPublisher, (String)rootPartition, (Configuration)config);
        }
        BusinessEntity modelBusinessEntity = new BusinessEntity();
        MappingApiToModel.mapBusinessEntity((org.uddi.api_v3.BusinessEntity)rootBusinessEntity, (BusinessEntity)modelBusinessEntity);
        modelBusinessEntity.setAuthorizedName(rootPublisher.getAuthorizedName());
        Date now = new Date();
        modelBusinessEntity.setCreated(now);
        modelBusinessEntity.setModified(now);
        modelBusinessEntity.setModifiedIncludingChildren(now);
        modelBusinessEntity.setNodeId(modelBusinessEntity.getEntityKey());
        for (BusinessService service : modelBusinessEntity.getBusinessServices()) {
            service.setAuthorizedName(rootPublisher.getAuthorizedName());
            service.setCreated(now);
            service.setModified(now);
            service.setModifiedIncludingChildren(now);
            service.setNodeId(modelBusinessEntity.getEntityKey());
            for (BindingTemplate binding : service.getBindingTemplates()) {
                binding.setAuthorizedName(rootPublisher.getAuthorizedName());
                binding.setCreated(now);
                binding.setModified(now);
                binding.setModifiedIncludingChildren(now);
                binding.setNodeId(modelBusinessEntity.getEntityKey());
            }
        }
        em.persist((Object)modelBusinessEntity);
        return modelBusinessEntity.getEntityKey();
    }

    private static void validateRootBusinessEntity(org.uddi.api_v3.BusinessEntity businessEntity, UddiEntityPublisher rootPublisher, String rootPartition, Configuration config) throws DispositionReportFaultMessage {
        if (businessEntity == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessentity.NullInput"));
        }
        String entityKey = businessEntity.getBusinessKey();
        if (entityKey == null || entityKey.length() == 0) {
            entityKey = rootPartition + ":" + UUID.randomUUID();
            businessEntity.setBusinessKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            businessEntity.setBusinessKey(entityKey);
            ValidateUDDIKey.validateUDDIv3Key((String)entityKey);
            String keyPartition = entityKey.substring(0, entityKey.lastIndexOf(":"));
            if (!rootPartition.equalsIgnoreCase(keyPartition)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
            }
        }
        ValidatePublish validatePublish = new ValidatePublish(rootPublisher);
        validatePublish.validateNames(businessEntity.getName());
        validatePublish.validateDiscoveryUrls(businessEntity.getDiscoveryURLs());
        validatePublish.validateContacts(businessEntity.getContacts());
        validatePublish.validateCategoryBag(businessEntity.getCategoryBag(), config);
        validatePublish.validateIdentifierBag(businessEntity.getIdentifierBag(), config);
        BusinessServices businessServices = businessEntity.getBusinessServices();
        if (businessServices != null) {
            List businessServiceList = businessServices.getBusinessService();
            if (businessServiceList == null || businessServiceList.size() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.businessservices.NoInput"));
            }
            for (org.uddi.api_v3.BusinessService businessService : businessServiceList) {
                Install.validateRootBusinessService((org.uddi.api_v3.BusinessService)businessService, (org.uddi.api_v3.BusinessEntity)businessEntity, (UddiEntityPublisher)rootPublisher, (String)rootPartition, (Configuration)config);
            }
        }
    }

    private static void validateRootBusinessService(org.uddi.api_v3.BusinessService businessService, org.uddi.api_v3.BusinessEntity parent, UddiEntityPublisher rootPublisher, String rootPartition, Configuration config) throws DispositionReportFaultMessage {
        if (businessService == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.businessservice.NullInput"));
        }
        String parentKey = businessService.getBusinessKey();
        if (parentKey != null && parentKey.length() > 0 && !parentKey.equalsIgnoreCase(parent.getBusinessKey())) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentBusinessNotFound", parentKey));
        }
        String entityKey = businessService.getServiceKey();
        if (entityKey == null || entityKey.length() == 0) {
            entityKey = rootPartition + ":" + UUID.randomUUID();
            businessService.setServiceKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            businessService.setServiceKey(entityKey);
            ValidateUDDIKey.validateUDDIv3Key((String)entityKey);
            String keyPartition = entityKey.substring(0, entityKey.lastIndexOf(":"));
            if (!rootPartition.equalsIgnoreCase(keyPartition)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
            }
        }
        ValidatePublish validatePublish = new ValidatePublish(rootPublisher);
        validatePublish.validateNames(businessService.getName());
        validatePublish.validateCategoryBag(businessService.getCategoryBag(), config);
        BindingTemplates bindingTemplates = businessService.getBindingTemplates();
        if (bindingTemplates != null) {
            List bindingTemplateList = bindingTemplates.getBindingTemplate();
            if (bindingTemplateList == null || bindingTemplateList.size() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplates.NoInput"));
            }
            for (org.uddi.api_v3.BindingTemplate bindingTemplate : bindingTemplateList) {
                Install.validateRootBindingTemplate((org.uddi.api_v3.BindingTemplate)bindingTemplate, (org.uddi.api_v3.BusinessService)businessService, (UddiEntityPublisher)rootPublisher, (String)rootPartition, (Configuration)config);
            }
        }
    }

    private static void validateRootBindingTemplate(org.uddi.api_v3.BindingTemplate bindingTemplate, org.uddi.api_v3.BusinessService parent, UddiEntityPublisher rootPublisher, String rootPartition, Configuration config) throws DispositionReportFaultMessage {
        if (bindingTemplate == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.bindingtemplate.NullInput"));
        }
        String parentKey = bindingTemplate.getServiceKey();
        if (parentKey != null && parentKey.length() > 0 && !parentKey.equalsIgnoreCase(parent.getServiceKey())) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ParentServiceNotFound", parentKey));
        }
        String entityKey = bindingTemplate.getBindingKey();
        if (entityKey == null || entityKey.length() == 0) {
            entityKey = rootPartition + ":" + UUID.randomUUID();
            bindingTemplate.setBindingKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            bindingTemplate.setBindingKey(entityKey);
            ValidateUDDIKey.validateUDDIv3Key((String)entityKey);
            String keyPartition = entityKey.substring(0, entityKey.lastIndexOf(":"));
            if (!rootPartition.equalsIgnoreCase(keyPartition)) {
                throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
            }
        }
        ValidatePublish validatePublish = new ValidatePublish(rootPublisher);
        validatePublish.validateCategoryBag(bindingTemplate.getCategoryBag(), config);
        validatePublish.validateTModelInstanceDetails(bindingTemplate.getTModelInstanceDetails());
    }

    private static void installTModels(EntityManager em, List<TModel> apiTModelList, UddiEntityPublisher publisher, String nodeId) throws DispositionReportFaultMessage {
        if (apiTModelList != null) {
            for (TModel apiTModel : apiTModelList) {
                String tModelKey = apiTModel.getTModelKey();
                if (tModelKey.toUpperCase().endsWith("keygenerator".toUpperCase())) {
                    Install.installPublisherKeyGen((EntityManager)em, (TModel)apiTModel, (UddiEntityPublisher)publisher, (String)nodeId);
                    continue;
                }
                Tmodel modelTModel = new Tmodel();
                apiTModel.setTModelKey(apiTModel.getTModelKey().toLowerCase());
                MappingApiToModel.mapTModel((TModel)apiTModel, (Tmodel)modelTModel);
                modelTModel.setAuthorizedName(publisher.getAuthorizedName());
                Date now = new Date();
                modelTModel.setCreated(now);
                modelTModel.setModified(now);
                modelTModel.setModifiedIncludingChildren(now);
                modelTModel.setNodeId(nodeId);
                em.persist((Object)modelTModel);
            }
        }
    }

    private static void installRootPublisherKeyGen(EntityManager em, TModel rootTModelKeyGen, String rootPartition, UddiEntityPublisher publisher, String nodeId) throws DispositionReportFaultMessage {
        rootTModelKeyGen.setTModelKey(rootPartition + ":" + "keygenerator");
        Install.installPublisherKeyGen((EntityManager)em, (TModel)rootTModelKeyGen, (UddiEntityPublisher)publisher, (String)nodeId);
    }

    private static void installPublisherKeyGen(EntityManager em, TModel apiTModel, UddiEntityPublisher publisher, String nodeId) throws DispositionReportFaultMessage {
        Tmodel modelTModel = new Tmodel();
        MappingApiToModel.mapTModel((TModel)apiTModel, (Tmodel)modelTModel);
        modelTModel.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        modelTModel.setCreated(now);
        modelTModel.setModified(now);
        modelTModel.setModifiedIncludingChildren(now);
        modelTModel.setNodeId(nodeId);
        em.persist((Object)modelTModel);
    }

    private static List<String> getPublishers(Configuration config) throws ConfigurationException {
        ArrayList<String> publishers = new ArrayList<String>();
        String basePath = "juddi_custom_install_data/";
        URL url = ClassUtil.getResource((String)"juddi_custom_install_data/", Install.class);
        if (url == null) {
            url = ClassUtil.getResource((String)"juddi_install_data/", Install.class);
            basePath = "juddi_install_data/";
        }
        String path = null;
        if ("vfsfile".equals(url.getProtocol())) {
            try {
                path = url.toURI().getPath();
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException((Throwable)e);
            }
        } else {
            path = url.getPath();
        }
        File dir = new File(path);
        String rootPublisherStr = config.getString("juddi.root.publisher");
        if (dir.exists()) {
            File[] files;
            log.debug((Object)("Discovering the Publisher XML data files in directory: " + path));
            for (File f : files = dir.listFiles((FileFilter)new PublisherFileFilter())) {
                String publisher = f.getName().substring(0, f.getName().indexOf("_Publisher.xml"));
                if (rootPublisherStr.equalsIgnoreCase(publisher)) continue;
                publishers.add(publisher);
            }
        } else {
            String[] paths = new String[]{};
            Enumeration<JarEntry> en = null;
            try {
                if (path.indexOf("!") > 0) {
                    paths = path.split("!");
                    en = new JarFile(new File(new URI(paths[0]))).entries();
                } else if (path.indexOf(".jar") > 0) {
                    paths = path.split(".jar");
                    paths[0] = paths[0] + ".jar";
                    en = new JarFile(new File(paths[0])).entries();
                }
                if (paths.length > 0) {
                    log.debug((Object)("Discovering the Publisher XML data files in jar: " + paths[0]));
                    while (en.hasMoreElements()) {
                        String name = en.nextElement().getName();
                        if (!name.startsWith(basePath) || !name.endsWith("_Publisher.xml")) continue;
                        log.debug((Object)("Found publisher file=" + name));
                        String publisher = name.substring(basePath.length(), name.indexOf("_Publisher.xml"));
                        if (rootPublisherStr.equalsIgnoreCase(publisher)) continue;
                        publishers.add(publisher);
                    }
                }
                log.info((Object)("No custom configuration files where found in " + path));
            }
            catch (IOException e) {
                throw new ConfigurationException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        return publishers;
    }

    private static Object buildInstallEntity(String fileName, String packageName, Configuration config) throws JAXBException, IOException, ConfigurationException {
        int n;
        InputStream resourceStream = null;
        URL url = ClassUtil.getResource((String)("juddi_custom_install_data/" + fileName), Install.class);
        if (url != null) {
            resourceStream = url.openStream();
        }
        if (resourceStream == null) {
            url = ClassUtil.getResource((String)("juddi_install_data/" + fileName), Install.class);
            if (url != null) {
                resourceStream = url.openStream();
            }
            if (url == null || resourceStream == null) {
                if (fileName.endsWith("_Publisher.xml")) {
                    throw new ConfigurationException("Could not locate juddi_install_data/" + fileName);
                }
                log.debug((Object)("Could not locate: " + url));
                return null;
            }
        }
        log.info((Object)("Loading the content of file: " + url));
        StringBuilder xml = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = resourceStream.read(b)) != -1) {
            xml.append(new String(b, 0, n));
        }
        log.debug((Object)("inserting: " + xml.toString()));
        StringReader reader = new StringReader(xml.toString());
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object obj = ((JAXBElement)unmarshaller.unmarshal((Source)new StreamSource(reader))).getValue();
        return obj;
    }

    public static org.uddi.api_v3.BusinessEntity getNodeBusinessEntity(String businessKey) throws DispositionReportFaultMessage {
        List beList;
        UDDIInquiryImpl inquiry = new UDDIInquiryImpl();
        GetBusinessDetail gbd = new GetBusinessDetail();
        gbd.getBusinessKey().add(businessKey);
        BusinessDetail bd = inquiry.getBusinessDetail(gbd);
        if (bd != null && (beList = bd.getBusinessEntity()) != null && beList.size() > 0) {
            return (org.uddi.api_v3.BusinessEntity)beList.get(0);
        }
        return new org.uddi.api_v3.BusinessEntity();
    }

    public static void installSaveTModel(EntityManager em, String fileName, UddiEntityPublisher publisher, String nodeId, Configuration config) throws JAXBException, DispositionReportFaultMessage, IOException, ConfigurationException {
        SaveTModel apiSaveTModel = (SaveTModel)Install.buildInstallEntity((String)fileName, (String)"org.uddi.api_v3", (Configuration)config);
        if (apiSaveTModel != null) {
            Install.installTModels((EntityManager)em, (List)apiSaveTModel.getTModel(), (UddiEntityPublisher)publisher, (String)nodeId);
        }
    }

    public static UddiEntityPublisher installPublisher(EntityManager em, String fileName, Configuration config) throws JAXBException, DispositionReportFaultMessage, IOException, ConfigurationException {
        org.apache.juddi.api_v3.Publisher apiPub = (org.apache.juddi.api_v3.Publisher)Install.buildInstallEntity((String)fileName, (String)"org.apache.juddi.api_v3", (Configuration)config);
        if (apiPub == null) {
            return null;
        }
        Publisher modelPub = new Publisher();
        MappingApiToModel.mapPublisher((org.apache.juddi.api_v3.Publisher)apiPub, (Publisher)modelPub);
        em.persist((Object)modelPub);
        return modelPub;
    }
}

