/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.config;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.ClassUtil;
import org.apache.juddi.Registry;
import org.apache.juddi.config.Install;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.FindBusinessByCategoryQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.KeyedReference;

/*
 * Exception performing whole class analysis ignored.
 */
public class AppConfig {
    private static final String JUDDI_PROPERTIES = "juddiv3.properties";
    private Log log = LogFactory.getLog(AppConfig.class);
    private Configuration config;
    private static AppConfig instance = null;

    private AppConfig() throws ConfigurationException {
        this.loadConfiguration();
    }

    private void loadConfiguration() throws ConfigurationException {
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.addConfiguration((Configuration)new SystemConfiguration());
        PropertiesConfiguration propConfig = null;
        String filename = System.getProperty("juddi.propertiesFile");
        propConfig = filename != null ? new PropertiesConfiguration(filename) : new PropertiesConfiguration("juddiv3.properties");
        URL url = ClassUtil.getResource((String)"juddiv3.properties", this.getClass());
        this.log.info((Object)("Reading from properties file:  " + url));
        long refreshDelay = propConfig.getLong("juddi.configuration.reload.delay", 1000L);
        this.log.debug((Object)("Setting refreshDelay to " + refreshDelay));
        FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
        fileChangedReloadingStrategy.setRefreshDelay(refreshDelay);
        propConfig.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
        compositeConfig.addConfiguration((Configuration)propConfig);
        PersistenceManager.initializeEntityManagerFactory((String)propConfig.getString("juddi.persistenceunit.name"));
        MapConfiguration persistentConfig = new MapConfiguration((Map)this.getPersistentConfiguration((Configuration)compositeConfig));
        compositeConfig.addConfiguration((Configuration)persistentConfig);
        this.config = compositeConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getPersistentConfiguration(Configuration config) throws ConfigurationException {
        Properties result = new Properties();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            boolean seedAlways = config.getBoolean("juddi.seed.always", false);
            if (seedAlways || !Install.alreadyInstalled((Configuration)config)) {
                if (seedAlways) {
                    this.log.info((Object)"Installing UDDI seed data, loading...");
                } else {
                    this.log.info((Object)"The 'root' publisher was not found, loading...");
                }
                try {
                    Install.install((Configuration)config);
                }
                catch (Exception e) {
                    throw new ConfigurationException((Throwable)e);
                }
                catch (Throwable t) {
                    throw new ConfigurationException(t);
                }
            }
            tx.begin();
            String rootPublisherStr = config.getString("juddi.root.publisher");
            UddiEntityPublisher rootPublisher = new UddiEntityPublisher(rootPublisherStr);
            rootPublisher.populateKeyGeneratorKeys(em);
            List rootKeyGenList = rootPublisher.getKeyGeneratorKeys();
            if (rootKeyGenList == null || rootKeyGenList.size() == 0) {
                throw new ConfigurationException("The 'root' publisher key generator was not found.  Please make sure that the application is properly installed.");
            }
            String rootKeyGen = (String)rootKeyGenList.iterator().next();
            rootKeyGen = rootKeyGen.substring(0, rootKeyGen.length() - ":keygenerator".length());
            this.log.debug((Object)("root partition:  " + rootKeyGen));
            result.setProperty("juddi.rootPartition", rootKeyGen);
            String nodeId = "";
            CategoryBag categoryBag = new CategoryBag();
            KeyedReference keyedRef = new KeyedReference();
            keyedRef.setTModelKey("uddi:uddi.org:categorization:nodes");
            keyedRef.setKeyValue("node");
            categoryBag.getKeyedReference().add(keyedRef);
            List keyList = FindBusinessByCategoryQuery.select((EntityManager)em, (FindQualifiers)new FindQualifiers(), (CategoryBag)categoryBag, null);
            if (keyList != null && keyList.size() > 1) {
                throw new ConfigurationException("Only one business entity can be categorized as the node.");
            }
            if (keyList == null || keyList.size() <= 0) {
                throw new ConfigurationException("A node business entity was not found.  Please make sure that the application is properly installed.");
            }
            nodeId = (String)keyList.get(0);
            result.setProperty("juddi.nodeId", nodeId);
            tx.commit();
            Properties properties = result;
            return properties;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public static AppConfig getInstance() throws ConfigurationException {
        if (instance == null) {
            instance = new AppConfig();
        }
        return instance;
    }

    public static void reloadConfig() throws ConfigurationException {
        Registry.stop();
        AppConfig.getInstance().loadConfiguration();
        Registry.start();
    }

    public static Configuration getConfiguration() throws ConfigurationException {
        return AppConfig.getInstance().config;
    }
}

