/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.web.extender;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.osgi.web.extender.WebApplication;
import org.apache.geronimo.osgi.web.extender.WebContainerEventDispatcher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class WebContainerExtender
implements GBeanLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebContainerExtender.class);
    private static final String SYNCHRONOUS_HEADER = "Synchronous-Deploy";
    private static final String SYNCHRONOUS_PROPERTY = "org.apache.geronimo.osgi.web.extender.synchronous";
    private final Kernel kernel;
    private final BundleContext bundleContext;
    private final Environment defaultEnvironment;
    private final AbstractNameQuery serverName;
    private final AbstractNameQuery transactionManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final AbstractNameQuery globalContextAbstractName;
    private final SingleElementCollection<ModuleBuilder> webConfigBuilder;
    private final Collection<? extends Repository> repositories;
    private final ConfigurationManager configurationManager;
    private boolean stopped;
    private Map<String, WebApplications> contextPathMap;
    private WebContainerEventDispatcher eventDispatcher;
    private BundleTracker bt;
    private ExecutorService executor;

    public WebContainerExtender(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="transactionManagerAbstractName") AbstractNameQuery transactionManagerAbstractName, @ParamAttribute(name="connectionTrackerAbstractName") AbstractNameQuery connectionTrackerAbstractName, @ParamAttribute(name="corbaGBeanAbstractName") AbstractNameQuery corbaGBeanAbstractName, @ParamAttribute(name="globalContextAbstractName") AbstractNameQuery globalContextAbstractName, @ParamAttribute(name="serverName") AbstractNameQuery serverName, @ParamReference(name="Repositories", namingType="Repository") Collection<? extends Repository> repositories, @ParamReference(name="WebModuleBuilders", namingType="ModuleBuilder") Collection<ModuleBuilder> webModuleBuilders, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) throws Exception {
        this.defaultEnvironment = defaultEnvironment;
        this.transactionManagerObjectName = transactionManagerAbstractName;
        this.connectionTrackerObjectName = connectionTrackerAbstractName;
        this.corbaGBeanObjectName = corbaGBeanAbstractName;
        this.globalContextAbstractName = globalContextAbstractName;
        this.serverName = serverName;
        this.repositories = repositories;
        this.webConfigBuilder = new SingleElementCollection(webModuleBuilders);
        this.bundleContext = bundleContext;
        this.kernel = kernel;
        this.configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
    }

    AbstractNameQuery getServerName() {
        return this.serverName;
    }

    AbstractNameQuery getTransactionManagerObjectName() {
        return this.transactionManagerObjectName;
    }

    AbstractNameQuery getConnectionTrackerObjectName() {
        return this.connectionTrackerObjectName;
    }

    AbstractNameQuery getCorbaGBeanObjectName() {
        return this.corbaGBeanObjectName;
    }

    AbstractNameQuery getGlobalContextAbstractName() {
        return this.globalContextAbstractName;
    }

    Collection<? extends Repository> getRepositories() {
        return this.repositories;
    }

    Kernel getKernel() {
        return this.kernel;
    }

    ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    ModuleBuilder getWebModuleBuilder() {
        return (ModuleBuilder)this.webConfigBuilder.getElement();
    }

    public void start(BundleContext context) {
        LOGGER.debug("Starting web container extender...");
        this.stopped = false;
        this.executor = Executors.newFixedThreadPool(3);
        this.contextPathMap = Collections.synchronizedMap(new HashMap());
        this.eventDispatcher = new WebContainerEventDispatcher(context);
        this.bt = new BundleTracker(context, 40, (BundleTrackerCustomizer)new WebBundleTrackerCustomizer());
        this.bt.open();
        LOGGER.debug("Web container extender started");
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public WebContainerEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void stop(BundleContext context) {
        LOGGER.debug("Stopping web container extender...");
        this.stopped = true;
        if (this.bt != null) {
            this.bt.close();
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.destroy();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
        LOGGER.debug("Web container extender stopped");
    }

    private void undeploy(WebApplication wab) {
        WebApplications webApplications = this.contextPathMap.get(wab.getContextPath());
        if (wab == webApplications.getDeployed()) {
            wab.undeploy();
        } else {
            webApplications.remove(wab);
        }
    }

    private WebApplication deploy(Bundle bundle) {
        LOGGER.debug("Scanning bundle {} for WAB application", (Object)bundle.getSymbolicName());
        String contextPath = (String)bundle.getHeaders().get("Web-ContextPath");
        if (contextPath == null) {
            LOGGER.debug("No web container application found in bundle {}", (Object)bundle.getSymbolicName());
            return null;
        }
        LOGGER.debug("Found web container application in bundle {} with context path: {}", (Object)bundle.getSymbolicName(), (Object)contextPath);
        WebApplications webApplications = this.getWebApplications(contextPath);
        WebApplication webApp = new WebApplication(this, bundle, contextPath);
        Collection<Long> collisions = webApplications.register(webApp);
        if (!collisions.isEmpty()) {
            this.eventDispatcher.deploying(bundle, contextPath);
            this.eventDispatcher.collision(bundle, contextPath, collisions);
            LOGGER.warn("WAB {} cannot be deployed. WAB {} is already deployed with {} Context-Path.", new Object[]{bundle, webApplications.getDeployed().getBundle(), contextPath});
        }
        return webApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebApplications getWebApplications(String contextPath) {
        Map<String, WebApplications> map = this.contextPathMap;
        synchronized (map) {
            WebApplications webApplications = this.contextPathMap.get(contextPath);
            if (webApplications == null) {
                webApplications = new WebApplications(contextPath);
                this.contextPathMap.put(contextPath, webApplications);
            }
            return webApplications;
        }
    }

    protected void unregisterWebApplication(WebApplication wab) {
        WebApplications webApplications = this.contextPathMap.get(wab.getContextPath());
        webApplications.unregister(wab, !this.stopped);
    }

    protected void start() {
        this.start(this.bundleContext);
    }

    protected void stop() {
        this.stop(this.bundleContext);
    }

    public void doStart() throws Exception {
    }

    public void doFail() {
    }

    public void doStop() throws Exception {
        this.stop();
    }

    private static class WebApplications {
        private String contextPath;
        private WebApplication deployed;
        private List<WebApplication> waiting;

        public WebApplications(String contextPath) {
            this.contextPath = contextPath;
            this.waiting = new LinkedList<WebApplication>();
        }

        private boolean isSynchronous(Bundle bundle) {
            String property = (String)bundle.getHeaders().get(WebContainerExtender.SYNCHRONOUS_HEADER);
            if (property == null) {
                property = bundle.getBundleContext().getProperty(WebContainerExtender.SYNCHRONOUS_PROPERTY);
            }
            return Boolean.parseBoolean(property);
        }

        public synchronized Collection<Long> register(WebApplication webApp) {
            if (this.deployed == null) {
                this.deployed = webApp;
                Bundle bundle = webApp.getBundle();
                if (this.isSynchronous(bundle)) {
                    LOGGER.debug("Deploying web application bundle {} synchronously.", (Object)bundle.getSymbolicName());
                    this.deployed.run();
                } else {
                    LOGGER.debug("Deploying web application bundle {} asynchronously.", (Object)bundle.getSymbolicName());
                    this.deployed.schedule();
                }
                return Collections.emptyList();
            }
            this.waiting.add(webApp);
            ArrayList<Long> bundleIds = new ArrayList<Long>();
            bundleIds.add(this.deployed.getBundle().getBundleId());
            for (WebApplication app : this.waiting) {
                bundleIds.add(app.getBundle().getBundleId());
            }
            return bundleIds;
        }

        public synchronized void unregister(WebApplication webApp, boolean redeploy) {
            if (this.deployed == webApp) {
                this.deployed = null;
                if (redeploy) {
                    WebApplication candidate = null;
                    for (WebApplication app : this.waiting) {
                        if (candidate != null && candidate.getBundle().getBundleId() <= app.getBundle().getBundleId()) continue;
                        candidate = app;
                    }
                    if (candidate != null) {
                        this.waiting.remove(candidate);
                        this.deployed = candidate;
                        this.deployed.schedule();
                    }
                }
            } else {
                this.waiting.remove(webApp);
            }
        }

        public synchronized void remove(WebApplication webApp) {
            this.waiting.remove(webApp);
        }

        public synchronized WebApplication getDeployed() {
            return this.deployed;
        }

        public String toString() {
            return "ContextPath[" + this.contextPath + " " + this.deployed + " " + this.waiting + "]";
        }
    }

    private class WebBundleTrackerCustomizer
    implements BundleTrackerCustomizer {
        private WebBundleTrackerCustomizer() {
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            String activationPolicyHeader;
            if (bundle.getState() == 32) {
                return WebContainerExtender.this.deploy(bundle);
            }
            if (bundle.getState() == 8 && (activationPolicyHeader = (String)bundle.getHeaders().get("Bundle-ActivationPolicy")) != null && activationPolicyHeader.startsWith("lazy")) {
                return WebContainerExtender.this.deploy(bundle);
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object arg) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object arg) {
            WebContainerExtender.this.undeploy((WebApplication)arg);
        }
    }
}

