/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.geronimo.util.asn1.x509;

import org.apache.geronimo.util.asn1.DERBitString;

/**
 * The ReasonFlags object.
 * <pre>
 * ReasonFlags ::= BIT STRING {
 *      unused                  (0),
 *      keyCompromise           (1),
 *      cACompromise            (2),
 *      affiliationChanged      (3),
 *      superseded              (4),
 *      cessationOfOperation    (5),
 *      certificateHold         (6),
 *      privilegeWithdrawn      (7),
 *      aACompromise            (8) }
 * </pre>
 */
public class ReasonFlags
    extends DERBitString
{
    /**
     * @deprecated use lower case version
     */
    public static final int UNUSED                  = (1 << 7);
    /**
     * @deprecated use lower case version
     */
    public static final int KEY_COMPROMISE          = (1 << 6);
    /**
     * @deprecated use lower case version
     */
    public static final int CA_COMPROMISE           = (1 << 5);
    /**
     * @deprecated use lower case version
     */
    public static final int AFFILIATION_CHANGED     = (1 << 4);
    /**
     * @deprecated use lower case version
     */
    public static final int SUPERSEDED              = (1 << 3);
    /**
     * @deprecated use lower case version
     */
    public static final int CESSATION_OF_OPERATION  = (1 << 2);
    /**
     * @deprecated use lower case version
     */
    public static final int CERTIFICATE_HOLD        = (1 << 1);
    /**
     * @deprecated use lower case version
     */
    public static final int PRIVILEGE_WITHDRAWN     = (1 << 0);
    /**
     * @deprecated use lower case version
     */
    public static final int AA_COMPROMISE           = (1 << 15);

    public static final int unused                  = (1 << 7);
    public static final int keyCompromise           = (1 << 6);
    public static final int cACompromise            = (1 << 5);
    public static final int affiliationChanged      = (1 << 4);
    public static final int superseded              = (1 << 3);
    public static final int cessationOfOperation    = (1 << 2);
    public static final int certificateHold         = (1 << 1);
    public static final int privilegeWithdrawn      = (1 << 0);
    public static final int aACompromise            = (1 << 15);

    /**
     * @param reasons - the bitwise OR of the Key Reason flags giving the
     * allowed uses for the key.
     */
    public ReasonFlags(
        int reasons)
    {
        super(getBytes(reasons), getPadBits(reasons));
    }

    public ReasonFlags(
        DERBitString reasons)
    {
        super(reasons.getBytes(), reasons.getPadBits());
    }
}
