/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.util.asn1.ASN1InputStream;
import org.apache.geronimo.util.asn1.ASN1Sequence;
import org.apache.geronimo.util.asn1.DERBitString;
import org.apache.geronimo.util.asn1.DERObject;
import org.apache.geronimo.util.asn1.DERObjectIdentifier;
import org.apache.geronimo.util.asn1.DERSequence;
import org.apache.geronimo.util.asn1.DERString;
import org.apache.geronimo.util.asn1.pkcs.CertificationRequestInfo;
import org.apache.geronimo.util.asn1.pkcs.PKCSObjectIdentifiers;
import org.apache.geronimo.util.asn1.x509.RSAPublicKeyStructure;
import org.apache.geronimo.util.asn1.x509.SubjectPublicKeyInfo;
import org.apache.geronimo.util.asn1.x509.X509CertificateStructure;
import org.apache.geronimo.util.asn1.x509.X509Name;
import org.apache.geronimo.util.encoders.Base64;
import org.apache.geronimo.util.jce.PKCS10CertificationRequest;

public class CaUtils {
    private static final Log log = LogFactory.getLog(CaUtils.class);
    public static final String CERT_HEADER = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_FOOTER = "-----END CERTIFICATE-----";
    public static final String CERT_REQ_HEADER = "-----BEGIN CERTIFICATE REQUEST-----";
    public static final int B64_LINE_SIZE = 76;
    public static final String CERT_REQ_SUBJECT = "subject";
    public static final String CERT_REQ_PUBLICKEY = "publickey";
    public static final String CERT_REQ_PUBLICKEY_OBJ = "publickeyObj";
    public static final String CERT_REQ_VERSION = "version";
    public static final String PKAC_CHALLENGE = "challenge";

    public static String base64Certificate(Certificate cert) throws CertificateEncodingException, Exception {
        return CaUtils.base64Text(cert.getEncoded(), CERT_HEADER, CERT_FOOTER, 76);
    }

    public static String base64Text(byte[] data, String header, String footer, int lineSize) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CaUtils.storeInBase64(bout, data, header, footer, lineSize);
        bout.close();
        return bout.toString();
    }

    public static void storeInBase64(OutputStream fout, byte[] data, String header, String footer, int lineSize) throws Exception {
        PrintWriter out = new PrintWriter(fout);
        if (header != null) {
            out.println(header);
        }
        byte[] encodedData = Base64.encode(data);
        int i = 0;
        do {
            out.println(new String(encodedData, i, Math.min(lineSize, encodedData.length - i)));
        } while ((i += lineSize) < encodedData.length);
        if (footer != null) {
            out.println(footer);
        }
        out.flush();
    }

    public static void storeInBase64(String outfile, byte[] data, String header, String footer, int lineSize) throws Exception {
        FileOutputStream fout = new FileOutputStream(outfile);
        CaUtils.storeInBase64(fout, data, header, footer, lineSize);
        fout.close();
    }

    public static PublicKey getPublicKeyObject(SubjectPublicKeyInfo pubKeyInfo) throws Exception {
        RSAPublicKeyStructure pubkeyStruct = new RSAPublicKeyStructure((ASN1Sequence)pubKeyInfo.getPublicKey());
        RSAPublicKeySpec pubkeySpec = new RSAPublicKeySpec(pubkeyStruct.getModulus(), pubkeyStruct.getPublicExponent());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFactory.generatePublic(pubkeySpec);
        return pubKey;
    }

    public static X509Name getSubjectX509Name(Certificate cert) throws CertificateEncodingException, IOException {
        ASN1InputStream ais = new ASN1InputStream(cert.getEncoded());
        X509CertificateStructure x509Struct = new X509CertificateStructure((ASN1Sequence)ais.readObject());
        ais.close();
        return x509Struct.getSubject();
    }

    public static X509Name getX509Name(X500Principal principal) throws CertificateEncodingException, IOException {
        ASN1InputStream ais = new ASN1InputStream(principal.getEncoded());
        X509Name name = new X509Name((ASN1Sequence)ais.readObject());
        ais.close();
        return name;
    }

    public static Map processPKCS10Request(String certreq) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, Exception {
        byte[] data;
        PKCS10CertificationRequest pkcs10certreq;
        if (certreq.indexOf("-----") != -1) {
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(certreq.getBytes())));
            String line = null;
            String b64data = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith("-----")) continue;
                b64data = b64data + line;
            }
            br.close();
            certreq = b64data;
        }
        if (!(pkcs10certreq = new PKCS10CertificationRequest(data = Base64.decode(certreq))).verify()) {
            throw new Exception("CSR verification failed.");
        }
        CertificationRequestInfo certReqInfo = pkcs10certreq.getCertificationRequestInfo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CERT_REQ_SUBJECT, certReqInfo.getSubject());
        map.put(CERT_REQ_PUBLICKEY, certReqInfo.getSubjectPublicKeyInfo());
        map.put(CERT_REQ_PUBLICKEY_OBJ, CaUtils.getPublicKeyObject(certReqInfo.getSubjectPublicKeyInfo()));
        map.put(CERT_REQ_VERSION, certReqInfo.getVersion());
        return map;
    }

    public static Map processSPKAC(String spkac) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] data = Base64.decode(spkac);
        ASN1InputStream ais = new ASN1InputStream(new ByteArrayInputStream(data));
        DERSequence spkacSeq = (DERSequence)ais.readObject();
        DERSequence pkacSeq = (DERSequence)spkacSeq.getObjectAt(0);
        DERObject pk = (DERObject)pkacSeq.getObjectAt(0);
        DERObject ch = (DERObject)pkacSeq.getObjectAt(1);
        SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo((DERSequence)pk);
        PublicKey pubKey = CaUtils.getPublicKeyObject(pkInfo);
        DERSequence signAlg = (DERSequence)spkacSeq.getObjectAt(1);
        DERObject alg0 = (DERObject)signAlg.getObjectAt(0);
        DERBitString sign = (DERBitString)spkacSeq.getObjectAt(2);
        byte[] signature = sign.getBytes();
        String signAlgString = PKCSObjectIdentifiers.md5WithRSAEncryption.equals(alg0) ? "MD5withRSA" : (PKCSObjectIdentifiers.md2WithRSAEncryption.equals(alg0) ? "MD2withRSA" : (PKCSObjectIdentifiers.sha1WithRSAEncryption.equals(alg0) ? "SHA1withRSA" : null));
        Signature signObj = Signature.getInstance(signAlgString);
        signObj.initVerify(pubKey);
        signObj.update(pkacSeq.getEncoded());
        boolean verified = signObj.verify(signature);
        if (!verified) {
            throw new Exception("SignedPublicKeyAndChallenge verification failed.");
        }
        map.put(CERT_REQ_PUBLICKEY, pkInfo);
        map.put(CERT_REQ_PUBLICKEY_OBJ, pubKey);
        if (((DERString)((Object)ch)).getString() != null) {
            map.put(PKAC_CHALLENGE, ((DERString)((Object)ch)).getString());
        }
        return map;
    }

    public static X509Name getX509Name(String cn, String ou, String o, String l, String st, String c) {
        Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
        Hashtable<DERObjectIdentifier, String> attrmap = new Hashtable<DERObjectIdentifier, String>();
        if (c != null) {
            attrmap.put(X509Name.C, c);
            order.add(X509Name.C);
        }
        if (st != null) {
            attrmap.put(X509Name.ST, st);
            order.add(X509Name.ST);
        }
        if (l != null) {
            attrmap.put(X509Name.L, l);
            order.add(X509Name.L);
        }
        if (o != null) {
            attrmap.put(X509Name.O, o);
            order.add(X509Name.O);
        }
        if (ou != null) {
            attrmap.put(X509Name.OU, ou);
            order.add(X509Name.OU);
        }
        if (cn != null) {
            attrmap.put(X509Name.CN, cn);
            order.add(X509Name.CN);
        }
        return new X509Name(order, attrmap);
    }
}

