/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.util.EncryptionManager;
import org.apache.geronimo.util.encoders.Base64;
import org.apache.geronimo.util.encoders.HexTranslator;

public class PropertiesFileLoginModule
implements LoginModule {
    public static final String USERS_URI = "usersURI";
    public static final String GROUPS_URI = "groupsURI";
    public static final String DIGEST = "digest";
    public static final String ENCODING = "encoding";
    private static Log log = LogFactory.getLog(PropertiesFileLoginModule.class);
    final Properties users = new Properties();
    final Map<String, Set<String>> groups = new HashMap<String, Set<String>>();
    private String digest;
    private String encoding;
    private Subject subject;
    private CallbackHandler handler;
    private String username;
    private String password;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        try {
            ServerInfo serverInfo = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
            String users = (String)options.get(USERS_URI);
            String groups = (String)options.get(GROUPS_URI);
            this.digest = (String)options.get(DIGEST);
            this.encoding = (String)options.get(ENCODING);
            if (this.digest != null && !this.digest.equals("")) {
                try {
                    MessageDigest.getInstance(this.digest);
                }
                catch (NoSuchAlgorithmException e) {
                    log.error((Object)("Initialization failed. Digest algorithm " + this.digest + " is not available."), (Throwable)e);
                    throw new IllegalArgumentException("Unable to configure properties file login module: " + e.getMessage(), e);
                }
                if (this.encoding != null && !"hex".equalsIgnoreCase(this.encoding) && !"base64".equalsIgnoreCase(this.encoding)) {
                    log.error((Object)("Initialization failed. Digest Encoding " + this.encoding + " is not supported."));
                    throw new IllegalArgumentException("Unable to configure properties file login module. Digest Encoding " + this.encoding + " not supported.");
                }
            }
            if (users == null || groups == null) {
                throw new IllegalArgumentException("Both usersURI and groupsURI must be provided!");
            }
            URI usersURI = new URI(users);
            URI groupsURI = new URI(groups);
            this.loadProperties(serverInfo, usersURI, groupsURI);
        }
        catch (Exception e) {
            log.error((Object)"Initialization failed", (Throwable)e);
            throw new IllegalArgumentException("Unable to configure properties file login module: " + e.getMessage(), e);
        }
    }

    public void loadProperties(ServerInfo serverInfo, URI userURI, URI groupURI) throws GeronimoSecurityException {
        try {
            URI userFile = serverInfo.resolveServer(userURI);
            URI groupFile = serverInfo.resolveServer(groupURI);
            InputStream stream = userFile.toURL().openStream();
            this.users.clear();
            this.users.load(stream);
            stream.close();
            Properties temp = new Properties();
            stream = groupFile.toURL().openStream();
            temp.load(stream);
            stream.close();
            Enumeration<Object> e = temp.keys();
            while (e.hasMoreElements()) {
                String groupName = (String)e.nextElement();
                String[] userList = ((String)temp.get(groupName)).split(",");
                Set<String> userset = this.groups.get(groupName);
                if (userset == null) {
                    userset = new HashSet<String>();
                    this.groups.put(groupName, userset);
                }
                for (String user : userList) {
                    userset.add(user);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Properties File Login Module - data load failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        char[] entered;
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        assert (callbacks.length == 2);
        this.username = ((NameCallback)callbacks[0]).getName();
        if (this.username == null || this.username.equals("")) {
            throw new FailedLoginException();
        }
        String realPassword = this.users.getProperty(this.username);
        if (realPassword != null) {
            realPassword = (String)((Object)EncryptionManager.decrypt((String)realPassword));
        }
        String string = this.password = (entered = ((PasswordCallback)callbacks[1]).getPassword()) == null ? null : new String(entered);
        if (!this.checkPassword(realPassword, this.password)) {
            throw new FailedLoginException();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new GeronimoUserPrincipal(this.username));
        block0: for (Map.Entry<String, Set<String>> entry : this.groups.entrySet()) {
            String groupName = entry.getKey();
            Set<String> users = entry.getValue();
            for (String user : users) {
                if (!this.username.equals(user)) continue;
                principals.add(new GeronimoGroupPrincipal(groupName));
                continue block0;
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }

    private boolean checkPassword(String real, String provided) {
        if (real == null && provided == null) {
            return true;
        }
        if (real == null || provided == null) {
            return false;
        }
        if (this.digest == null || this.digest.equals("")) {
            return real.equals(provided);
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.digest);
            byte[] data = md.digest(provided.getBytes());
            if (this.encoding == null || "hex".equalsIgnoreCase(this.encoding)) {
                byte[] hexData = new byte[data.length * 2];
                HexTranslator ht = new HexTranslator();
                ht.encode(data, 0, data.length, hexData, 0);
                return real.equalsIgnoreCase(new String(hexData));
            }
            if ("base64".equalsIgnoreCase(this.encoding)) {
                return real.equals(new String(Base64.encode((byte[])data)));
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Should not occur.  Availability of algorithm has been checked at initialization.", (Throwable)e);
        }
        return false;
    }
}

