/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.DomainPrincipal;
import org.apache.geronimo.security.RealmPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappingLoginModule
implements LoginModule {
    public static final String CLASS_OPTION = WrappingLoginModule.class.getName() + ".LoginModuleClass";
    public static final String DOMAIN_OPTION = WrappingLoginModule.class.getName() + ".DomainName";
    public static final String REALM_OPTION = WrappingLoginModule.class.getName() + ".RealmName";
    private String loginDomainName;
    private String realmName;
    private final Subject localSubject = new Subject();
    private Subject subject;
    private LoginModule delegate;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        Class lmClass = (Class)options.get(CLASS_OPTION);
        try {
            this.delegate = (LoginModule)lmClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create login module instance", e);
        }
        this.delegate.initialize(this.localSubject, callbackHandler, sharedState, options);
        this.loginDomainName = (String)options.get(DOMAIN_OPTION);
        this.realmName = (String)options.get(REALM_OPTION);
    }

    @Override
    public boolean login() throws LoginException {
        return this.delegate.login();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.delegate.abort();
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.delegate.commit();
        HashSet<Principal> wrapped = new HashSet<Principal>();
        for (Principal principal : this.localSubject.getPrincipals()) {
            wrapped.add(new DomainPrincipal(this.loginDomainName, principal));
            wrapped.add(new RealmPrincipal(this.realmName, this.loginDomainName, principal));
        }
        this.localSubject.getPrincipals().addAll(wrapped);
        this.subject.getPrincipals().addAll(this.localSubject.getPrincipals());
        this.subject.getPrivateCredentials().addAll(this.localSubject.getPrivateCredentials());
        this.subject.getPublicCredentials().addAll(this.localSubject.getPublicCredentials());
        return result;
    }

    @Override
    public boolean logout() throws LoginException {
        boolean result = this.delegate.logout();
        this.subject.getPrincipals().removeAll(this.localSubject.getPrincipals());
        this.localSubject.getPrincipals().clear();
        return result;
    }
}

