/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.security.SecurityServiceImpl;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoLoginConfiguration
extends Configuration
implements GBeanLifecycle,
ReferenceCollectionListener {
    private final Log log = LogFactory.getLog(GeronimoLoginConfiguration.class);
    private static Map<String, AppConfigurationEntry[]> entries = new Hashtable<String, AppConfigurationEntry[]>();
    private Configuration oldConfiguration;
    private Collection<ConfigurationEntryFactory> configurations = Collections.emptySet();
    private static final GBeanInfo GBEAN_INFO;

    public Collection getConfigurations() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<ConfigurationEntryFactory> configurations) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        if (configurations instanceof ReferenceCollection) {
            ReferenceCollection ref = (ReferenceCollection)configurations;
            ref.addReferenceCollectionListener((ReferenceCollectionListener)this);
        }
        this.configurations = configurations;
        for (ConfigurationEntryFactory configuration : configurations) {
            this.addConfiguration(configuration);
        }
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return entries.get(name);
    }

    @Override
    public void refresh() {
    }

    public void memberAdded(ReferenceCollectionEvent event) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        ConfigurationEntryFactory factory = (ConfigurationEntryFactory)event.getMember();
        this.addConfiguration(factory);
    }

    public void memberRemoved(ReferenceCollectionEvent event) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityServiceImpl.CONFIGURE);
        }
        ConfigurationEntryFactory factory = (ConfigurationEntryFactory)event.getMember();
        entries.remove(factory.getConfigurationName());
        this.log.debug((Object)("Removed Application Configuration Entry " + factory.getConfigurationName()));
    }

    private void addConfiguration(ConfigurationEntryFactory factory) {
        if (entries.containsKey(factory.getConfigurationName())) {
            throw new IllegalArgumentException("ConfigurationEntry already registered");
        }
        AppConfigurationEntry[] ace = factory.getAppConfigurationEntries();
        entries.put(factory.getConfigurationName(), ace);
        this.log.debug((Object)("Added Application Configuration Entry " + factory.getConfigurationName()));
    }

    public void doStart() throws Exception {
        try {
            this.oldConfiguration = Configuration.getConfiguration();
        }
        catch (SecurityException e) {
            this.oldConfiguration = null;
        }
        Configuration.setConfiguration(this);
        this.log.debug((Object)"Installed Geronimo login configuration");
    }

    public void doStop() throws Exception {
        Configuration.setConfiguration(this.oldConfiguration);
        for (String s : entries.keySet()) {
            this.log.debug((Object)("Removed Application Configuration Entry " + s));
        }
        entries.clear();
        this.log.debug((Object)"Uninstalled Geronimo login configuration");
    }

    public void doFail() {
        Configuration.setConfiguration(this.oldConfiguration);
        this.log.debug((Object)"Uninstalled Geronimo login configuration");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(GeronimoLoginConfiguration.class);
        infoFactory.addReference("Configurations", ConfigurationEntryFactory.class, null);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

