/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.realm.providers.GeronimoPasswordCredential;

public class GeronimoPasswordCredentialLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private GeronimoPasswordCredential geronimoPasswordCredential;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("name"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw (LoginException)new LoginException("Could not determine username and password").initCause(e);
        }
        catch (UnsupportedCallbackException e) {
            throw (LoginException)new LoginException("Unlikely UnsupportedCallbackException").initCause(e);
        }
        this.geronimoPasswordCredential = new GeronimoPasswordCredential(((NameCallback)callbacks[0]).getName(), ((PasswordCallback)callbacks[1]).getPassword());
        return false;
    }

    public boolean commit() throws LoginException {
        this.subject.getPrivateCredentials().add(this.geronimoPasswordCredential);
        return false;
    }

    public boolean abort() throws LoginException {
        this.geronimoPasswordCredential = null;
        return false;
    }

    public boolean logout() throws LoginException {
        this.geronimoPasswordCredential = null;
        return false;
    }
}

