/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas.server;

import java.io.Serializable;
import java.util.Map;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;

public class JaasLoginModuleConfiguration
implements Serializable {
    private final boolean serverSide;
    private final String loginDomainName;
    private final LoginModuleControlFlag flag;
    private final String loginModuleName;
    private final Map options;
    private final boolean wrapPrincipals;
    private final transient ClassLoader classLoader;

    public JaasLoginModuleConfiguration(String loginModuleName, LoginModuleControlFlag flag, Map options, boolean serverSide, String loginDomainName, boolean wrapPrincipals, ClassLoader classLoader) {
        this.serverSide = serverSide;
        this.flag = flag;
        this.loginModuleName = loginModuleName;
        this.options = options;
        this.loginDomainName = loginDomainName;
        this.wrapPrincipals = wrapPrincipals;
        this.classLoader = classLoader;
    }

    public JaasLoginModuleConfiguration(String loginModuleName, LoginModuleControlFlag flag, Map options, boolean serverSide, ClassLoader classLoader) {
        this(loginModuleName, flag, options, serverSide, null, false, classLoader);
    }

    public String getLoginModuleClassName() {
        return this.loginModuleName;
    }

    public LoginModule getLoginModule(ClassLoader loader) throws GeronimoSecurityException {
        if (this.classLoader != null) {
            loader = this.classLoader;
        }
        try {
            return (LoginModule)loader.loadClass(this.loginModuleName).newInstance();
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Unable to instantiate login module", (Throwable)e);
        }
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public LoginModuleControlFlag getFlag() {
        return this.flag;
    }

    public Map getOptions() {
        return this.options;
    }

    public String getLoginDomainName() {
        return this.loginDomainName;
    }

    public boolean isWrapPrincipals() {
        return this.wrapPrincipals;
    }
}

