/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;
import org.apache.geronimo.security.jaas.client.JaasLoginCoordinator;
import org.apache.geronimo.security.jaas.server.JaasLoginModuleConfiguration;
import org.apache.geronimo.security.jaas.server.JaasLoginServiceMBean;

public class ServerRealmConfigurationEntry
implements ConfigurationEntryFactory {
    private final String applicationConfigName;
    private final String realmName;
    private final Kernel kernel;
    private final JaasLoginServiceMBean loginService;
    private boolean wrapPrincipals;
    public static final GBeanInfo GBEAN_INFO;

    public ServerRealmConfigurationEntry() {
        this.applicationConfigName = null;
        this.realmName = null;
        this.kernel = null;
        this.loginService = null;
    }

    public ServerRealmConfigurationEntry(String applicationConfigName, String realmName, Kernel kernel, JaasLoginServiceMBean loginService) {
        this.applicationConfigName = applicationConfigName;
        this.realmName = realmName;
        if (applicationConfigName == null || realmName == null) {
            throw new IllegalArgumentException("applicationConfigName and realmName are required");
        }
        if (applicationConfigName.equals(realmName)) {
            throw new IllegalArgumentException("applicationConfigName must be different than realmName (there's an automatic entry using the same name as the realm name, so you don't need a ServerRealmConfigurationEntry if you're just going to use that!)");
        }
        this.kernel = kernel;
        this.loginService = loginService;
    }

    public String getConfigurationName() {
        return this.applicationConfigName;
    }

    public boolean isWrapPrincipals() {
        return this.wrapPrincipals;
    }

    public void setWrapPrincipals(boolean wrapPrincipals) {
        this.wrapPrincipals = wrapPrincipals;
    }

    public JaasLoginModuleConfiguration generateConfiguration() {
        Properties options = new Properties();
        options.put("realm", this.realmName);
        options.put("kernel", this.kernel.getKernelName());
        if (this.loginService != null) {
            options.put("serviceName", this.loginService.getObjectName());
        }
        options.put("realm", this.realmName);
        options.put("kernel", this.kernel.getKernelName());
        return new JaasLoginModuleConfiguration(JaasLoginCoordinator.class.getName(), LoginModuleControlFlag.REQUIRED, options, true, this.applicationConfigName, this.wrapPrincipals, JaasLoginCoordinator.class.getClassLoader());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)ServerRealmConfigurationEntry.class, (String)"ConfigurationEntry");
        infoFactory.addInterface(ConfigurationEntryFactory.class);
        infoFactory.addAttribute("applicationConfigName", String.class, true);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addReference("LoginService", JaasLoginServiceMBean.class, "JaasLoginService");
        infoFactory.addAttribute("wrapPrincipals", Boolean.TYPE, true);
        infoFactory.setConstructor(new String[]{"applicationConfigName", "realmName", "kernel", "LoginService"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

