/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import org.apache.geronimo.persistence.EntityManagerWrapper;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMPEntityManagerTxScoped
implements EntityManager {
    private final TransactionManagerImpl transactionManager;
    private final String persistenceUnit;
    private final EntityManagerFactory entityManagerFactory;
    private final Map entityManagerProperties;

    public CMPEntityManagerTxScoped(TransactionManagerImpl transactionManager, String persistenceUnit, EntityManagerFactory entityManagerFactory, Map entityManagerProperties) {
        this.transactionManager = transactionManager;
        this.persistenceUnit = persistenceUnit;
        this.entityManagerFactory = entityManagerFactory;
        this.entityManagerProperties = entityManagerProperties;
    }

    private EntityManager getEntityManager(boolean activeRequired) {
        TransactionImpl transaction = (TransactionImpl)this.transactionManager.getTransaction();
        if (activeRequired && (transaction == null || transaction.getStatus() != 0)) {
            throw new TransactionRequiredException("No active transaction");
        }
        if (transaction == null) {
            return null;
        }
        EntityManagerWrapper entityManagerWrapper = (EntityManagerWrapper)transaction.getEntityManager(this.persistenceUnit);
        if (entityManagerWrapper == null) {
            EntityManager entityManager = this.createEntityManager();
            entityManagerWrapper = new EntityManagerWrapperTxScoped(entityManager);
            transaction.setEntityManager(this.persistenceUnit, (Object)entityManagerWrapper);
        }
        return entityManagerWrapper.getEntityManager();
    }

    private EntityManager createEntityManager() {
        EntityManager entityManager = this.entityManagerProperties == null ? this.entityManagerFactory.createEntityManager() : this.entityManagerFactory.createEntityManager(this.entityManagerProperties);
        return entityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object o) {
        EntityManager entityManager = this.getEntityManager(true);
        if (entityManager != null) {
            entityManager.persist(o);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.persist(o);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T t) {
        EntityManager entityManager = this.getEntityManager(true);
        if (entityManager != null) {
            return (T)entityManager.merge(t);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.merge(t);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object o) {
        EntityManager entityManager = this.getEntityManager(true);
        if (entityManager != null) {
            entityManager.remove(o);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.remove(o);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> aClass, Object o) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return (T)entityManager.find(aClass, o);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.find(aClass, o);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> aClass, Object o) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return (T)entityManager.getReference(aClass, o);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.getReference(aClass, o);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.flush();
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.flush();
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushModeType) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.setFlushMode(flushModeType);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.setFlushMode(flushModeType);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.getFlushMode();
        }
        entityManager = this.createEntityManager();
        try {
            FlushModeType flushModeType = entityManager.getFlushMode();
            return flushModeType;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object o, LockModeType lockModeType) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.lock(o, lockModeType);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.lock(o, lockModeType);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object o) {
        EntityManager entityManager = this.getEntityManager(true);
        if (entityManager != null) {
            entityManager.refresh(o);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.refresh(o);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.clear();
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.clear();
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.contains(o);
        }
        entityManager = this.createEntityManager();
        try {
            boolean bl = entityManager.contains(o);
            return bl;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String s) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createQuery(s);
        }
        entityManager = this.createEntityManager();
        try {
            Query query = entityManager.createQuery(s);
            return query;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String s) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createNamedQuery(s);
        }
        entityManager = this.createEntityManager();
        try {
            Query query = entityManager.createNamedQuery(s);
            return query;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String s) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createNativeQuery(s);
        }
        entityManager = this.createEntityManager();
        try {
            Query query = entityManager.createNativeQuery(s);
            return query;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String s, Class aClass) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createNativeQuery(s, aClass);
        }
        entityManager = this.createEntityManager();
        try {
            Query query = entityManager.createNativeQuery(s, aClass);
            return query;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String s, String s1) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createNativeQuery(s, s1);
        }
        entityManager = this.createEntityManager();
        try {
            Query query = entityManager.createNativeQuery(s, s1);
            return query;
        }
        finally {
            entityManager.close();
        }
    }

    public void close() {
        throw new IllegalStateException("You cannot call close on a Container Managed Entity Manager");
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("You cannot call getTransaction on a container managed EntityManager");
    }

    public void joinTransaction() {
        throw new IllegalStateException("You cannot call joinTransaction on a container managed EntityManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.getDelegate();
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.getDelegate();
            return object;
        }
        finally {
            entityManager.close();
        }
    }

    private static class EntityManagerWrapperTxScoped
    implements EntityManagerWrapper {
        private final EntityManager entityManager;

        public EntityManagerWrapperTxScoped(EntityManager entityManager) {
            if (entityManager == null) {
                throw new IllegalArgumentException("Need a non-null entity manager");
            }
            this.entityManager = entityManager;
        }

        public void close() {
            this.entityManager.close();
        }

        public EntityManager getEntityManager() {
            return this.entityManager;
        }
    }
}

