/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.PersistenceContextAnnotationHelper;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.reference.PersistenceContextReference;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceContextRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceContextRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceContextTypeType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPropertyType;
import org.apache.geronimo.xbeans.javaee.PersistenceContextRefType;
import org.apache.geronimo.xbeans.javaee.PropertyType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextRefBuilder
extends AbstractNamingBuilder {
    private static final QName PERSISTENCE_CONTEXT_REF_QNAME = new QName("http://java.sun.com/xml/ns/javaee", "persistence-context-ref");
    private static final QNameSet PERSISTENCE_CONTEXT_REF_QNAME_SET = QNameSet.singleton((QName)PERSISTENCE_CONTEXT_REF_QNAME);
    private static final QName GER_PERSISTENCE_CONTEXT_REF_QNAME = GerPersistenceContextRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_PERSISTENCE_CONTEXT_REF_QNAME_SET = QNameSet.singleton((QName)GER_PERSISTENCE_CONTEXT_REF_QNAME);
    private static final Set<String> PERSISTENCE_UNIT_INTERFACE_TYPES = Collections.singleton("org.apache.geronimo.persistence.PersistenceUnitGBean");
    private final AbstractNameQuery defaultPersistenceUnitAbstractNameQuery;
    private final boolean strictMatching;
    public static final GBeanInfo GBEAN_INFO;

    public PersistenceContextRefBuilder(Environment defaultEnvironment, AbstractNameQuery defaultPersistenceUnitAbstractNameQuery, boolean strictMatching) {
        super(defaultEnvironment);
        this.defaultPersistenceUnitAbstractNameQuery = defaultPersistenceUnitAbstractNameQuery;
        this.strictMatching = strictMatching;
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) throws DeploymentException {
        return plan != null && plan.selectChildren(GER_PERSISTENCE_CONTEXT_REF_QNAME_SET).length > 0;
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        boolean transactionScoped;
        GerPersistenceContextTypeType.Enum persistenceContextType;
        String persistenceContextRefName;
        if (module != null && module.getClassFinder() != null) {
            this.processAnnotations(module);
        }
        List specPersistenceContextRefsUntyped = PersistenceContextRefBuilder.convert((XmlObject[])specDD.selectChildren(PERSISTENCE_CONTEXT_REF_QNAME_SET), (NamespaceElementConverter)JEE_CONVERTER, PersistenceContextRefType.class, (SchemaType)PersistenceContextRefType.type);
        Map<String, GerPersistenceContextRefType> gerPersistenceContextRefsUntyped = this.getGerPersistenceContextRefs(plan);
        ArrayList<DeploymentException> problems = new ArrayList<DeploymentException>();
        Configuration localConfiguration = module.getEarContext().getConfiguration();
        for (PersistenceContextRefType persistenceContextRef : specPersistenceContextRefsUntyped) {
            try {
                AbstractNameQuery persistenceUnitNameQuery;
                persistenceContextRefName = persistenceContextRef.getPersistenceContextRefName().getStringValue().trim();
                this.addInjections(persistenceContextRefName, persistenceContextRef.getInjectionTargetArray(), componentContext);
                persistenceContextType = persistenceContextRef.getPersistenceContextType();
                transactionScoped = persistenceContextType == null || !persistenceContextType.getStringValue().equalsIgnoreCase("extended");
                PropertyType[] propertyTypes = persistenceContextRef.getPersistencePropertyArray();
                HashMap<String, String> properties = new HashMap<String, String>();
                for (PropertyType propertyType : propertyTypes) {
                    String key = propertyType.getName().getStringValue();
                    String value = propertyType.getValue().getStringValue();
                    properties.put(key, value);
                }
                GerPersistenceContextRefType gerPersistenceContextRef = gerPersistenceContextRefsUntyped.remove(persistenceContextRefName);
                if (gerPersistenceContextRef != null) {
                    persistenceUnitNameQuery = this.findPersistenceUnit(gerPersistenceContextRef);
                    this.addProperties(gerPersistenceContextRef, properties);
                    this.checkForGBean(localConfiguration, persistenceUnitNameQuery, true);
                } else if (persistenceContextRef.isSetPersistenceUnitName() && persistenceContextRef.getPersistenceUnitName().getStringValue().trim().length() > 0) {
                    String persistenceUnitName = persistenceContextRef.getPersistenceUnitName().getStringValue().trim();
                    persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.singletonMap("name", persistenceUnitName), PERSISTENCE_UNIT_INTERFACE_TYPES);
                    if (!this.checkForGBean(localConfiguration, persistenceUnitNameQuery, this.strictMatching)) {
                        persistenceUnitName = "persistence/" + persistenceUnitName;
                        persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.singletonMap("name", persistenceUnitName), PERSISTENCE_UNIT_INTERFACE_TYPES);
                        this.checkForGBean(localConfiguration, persistenceUnitNameQuery, true);
                    }
                } else {
                    persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.EMPTY_MAP, PERSISTENCE_UNIT_INTERFACE_TYPES);
                    Set<AbstractNameQuery> patterns = Collections.singleton(persistenceUnitNameQuery);
                    LinkedHashSet gbeans = localConfiguration.findGBeanDatas(localConfiguration, patterns);
                    persistenceUnitNameQuery = this.checkForDefaultPersistenceUnit(gbeans);
                    if (gbeans.isEmpty()) {
                        gbeans = localConfiguration.findGBeanDatas(patterns);
                        persistenceUnitNameQuery = this.checkForDefaultPersistenceUnit(gbeans);
                        if (gbeans.isEmpty()) {
                            if (this.defaultPersistenceUnitAbstractNameQuery == null) {
                                throw new DeploymentException("No default PersistenceUnit specified, and none located");
                            }
                            persistenceUnitNameQuery = this.defaultPersistenceUnitAbstractNameQuery;
                        }
                    }
                    this.checkForGBean(localConfiguration, persistenceUnitNameQuery, true);
                }
                PersistenceContextReference reference = new PersistenceContextReference(module.getConfigId(), persistenceUnitNameQuery, transactionScoped, properties);
                ((Map)NamingBuilder.JNDI_KEY.get(componentContext)).put("env/" + persistenceContextRefName, reference);
            }
            catch (DeploymentException e) {
                problems.add(e);
            }
        }
        for (GerPersistenceContextRefType gerPersistenceContextRef : gerPersistenceContextRefsUntyped.values()) {
            try {
                persistenceContextRefName = gerPersistenceContextRef.getPersistenceContextRefName();
                persistenceContextType = gerPersistenceContextRef.getPersistenceContextType();
                transactionScoped = persistenceContextType == null || !persistenceContextType.equals(GerPersistenceContextTypeType.EXTENDED);
                HashMap<String, String> properties = new HashMap<String, String>();
                this.addProperties(gerPersistenceContextRef, properties);
                AbstractNameQuery persistenceUnitNameQuery = this.findPersistenceUnit(gerPersistenceContextRef);
                this.checkForGBean(localConfiguration, persistenceUnitNameQuery, true);
                PersistenceContextReference reference = new PersistenceContextReference(module.getConfigId(), persistenceUnitNameQuery, transactionScoped, properties);
                this.getJndiContextMap(componentContext).put("env/" + persistenceContextRefName, reference);
            }
            catch (DeploymentException e) {
                problems.add(e);
            }
        }
        if (!problems.isEmpty()) {
            for (DeploymentException e : problems) {
                e.printStackTrace();
            }
        }
    }

    private AbstractNameQuery checkForDefaultPersistenceUnit(LinkedHashSet<GBeanData> gbeans) throws DeploymentException {
        AbstractNameQuery persistenceUnitNameQuery = null;
        Iterator it = gbeans.iterator();
        while (it.hasNext()) {
            GBeanData gbean = (GBeanData)it.next();
            AbstractName name = gbean.getAbstractName();
            Map nameMap = name.getName();
            if ("cmp".equals(nameMap.get("name"))) {
                it.remove();
                continue;
            }
            persistenceUnitNameQuery = new AbstractNameQuery(name);
        }
        if (gbeans.size() > 1) {
            throw new DeploymentException("Too many matches for no-name persistence unit: " + gbeans);
        }
        return persistenceUnitNameQuery;
    }

    private boolean checkForGBean(Configuration localConfiguration, AbstractNameQuery persistenceUnitNameQuery, boolean complainIfMissing) throws DeploymentException {
        try {
            localConfiguration.findGBeanData(persistenceUnitNameQuery);
            return true;
        }
        catch (GBeanNotFoundException e) {
            if (complainIfMissing || e.hasMatches()) {
                String reason = e.hasMatches() ? "More than one GBean reference found." : "No GBeans found.";
                throw new DeploymentException("Could not resolve reference at deploy time for query " + persistenceUnitNameQuery + ". " + reason, (Throwable)e);
            }
            return false;
        }
    }

    private void addProperties(GerPersistenceContextRefType persistenceContextRef, Map<String, String> properties) {
        GerPropertyType[] propertyTypes;
        for (GerPropertyType propertyType : propertyTypes = persistenceContextRef.getPropertyArray()) {
            String key = propertyType.getKey();
            String value = propertyType.getValue();
            properties.put(key, value);
        }
    }

    private Map<String, GerPersistenceContextRefType> getGerPersistenceContextRefs(XmlObject plan) throws DeploymentException {
        HashMap<String, GerPersistenceContextRefType> map = new HashMap<String, GerPersistenceContextRefType>();
        if (plan != null) {
            List refs = PersistenceContextRefBuilder.convert((XmlObject[])plan.selectChildren(GER_PERSISTENCE_CONTEXT_REF_QNAME_SET), (NamespaceElementConverter)NAMING_CONVERTER, GerPersistenceContextRefType.class, (SchemaType)GerPersistenceContextRefType.type);
            for (GerPersistenceContextRefType ref : refs) {
                map.put(ref.getPersistenceContextRefName().trim(), ref);
            }
        }
        return map;
    }

    private AbstractNameQuery findPersistenceUnit(GerPersistenceContextRefType persistenceContextRef) {
        AbstractNameQuery persistenceUnitNameQuery;
        if (persistenceContextRef.isSetPersistenceUnitName()) {
            String persistenceUnitName = persistenceContextRef.getPersistenceUnitName();
            persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.singletonMap("name", persistenceUnitName), PERSISTENCE_UNIT_INTERFACE_TYPES);
        } else {
            GerPatternType gbeanLocator = persistenceContextRef.getPattern();
            persistenceUnitNameQuery = PersistenceContextRefBuilder.buildAbstractNameQuery((GerPatternType)gbeanLocator, null, null, PERSISTENCE_UNIT_INTERFACE_TYPES);
        }
        return persistenceUnitNameQuery;
    }

    private void processAnnotations(Module module) throws DeploymentException {
        PersistenceContextAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder());
    }

    public QNameSet getSpecQNameSet() {
        SchemaConversionUtils.registerNamespaceConversions(Collections.singletonMap(GER_PERSISTENCE_CONTEXT_REF_QNAME.getLocalPart(), new NamespaceElementConverter(GER_PERSISTENCE_CONTEXT_REF_QNAME.getNamespaceURI())));
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return GER_PERSISTENCE_CONTEXT_REF_QNAME_SET;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(PersistenceContextRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultPersistenceUnitAbstractNameQuery", AbstractNameQuery.class, true, true);
        infoBuilder.addAttribute("strictMatching", Boolean.TYPE, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "defaultPersistenceUnitAbstractNameQuery", "strictMatching"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

