/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.PersistenceUnitAnnotationHelper;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.reference.PersistenceUnitReference;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceUnitRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceUnitRefType;
import org.apache.geronimo.xbeans.javaee.PersistenceUnitRefType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitRefBuilder
extends AbstractNamingBuilder {
    private static final QName PERSISTENCE_UNIT_REF_QNAME = new QName("http://java.sun.com/xml/ns/javaee", "persistence-unit-ref");
    private static final QNameSet PERSISTENCE_UNIT_REF_QNAME_SET = QNameSet.singleton((QName)PERSISTENCE_UNIT_REF_QNAME);
    private static final QName GER_PERSISTENCE_UNIT_REF_QNAME = GerPersistenceUnitRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_PERSISTENCE_UNIT_REF_QNAME_SET = QNameSet.singleton((QName)GER_PERSISTENCE_UNIT_REF_QNAME);
    private static final Set PERSISTENCE_UNIT_INTERFACE_TYPES = Collections.singleton("org.apache.geronimo.persistence.PersistenceUnitGBean");
    private final AbstractNameQuery defaultPersistenceUnitAbstractNameQuery;
    private final boolean strictMatching;
    public static final GBeanInfo GBEAN_INFO;

    public PersistenceUnitRefBuilder(Environment defaultEnvironment, AbstractNameQuery defaultPersistenceUnitAbstractNameQuery, boolean strictMatching) {
        super(defaultEnvironment);
        this.defaultPersistenceUnitAbstractNameQuery = defaultPersistenceUnitAbstractNameQuery;
        this.strictMatching = strictMatching;
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) throws DeploymentException {
        if (specDD != null && specDD.selectChildren(PERSISTENCE_UNIT_REF_QNAME_SET).length > 0) {
            return true;
        }
        return plan != null && plan.selectChildren(GER_PERSISTENCE_UNIT_REF_QNAME_SET).length > 0;
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        AbstractNameQuery persistenceUnitNameQuery;
        Configuration localConfiguration = module.getEarContext().getConfiguration();
        if (module.getClassFinder() != null) {
            this.processAnnotations(module);
        }
        List specPersistenceUnitRefsUntyped = PersistenceUnitRefBuilder.convert((XmlObject[])specDD.selectChildren(PERSISTENCE_UNIT_REF_QNAME_SET), (NamespaceElementConverter)JEE_CONVERTER, PersistenceUnitRefType.class, (SchemaType)PersistenceUnitRefType.type);
        Map<String, GerPersistenceUnitRefType> gerPersistenceUnitRefsUntyped = this.getGerPersistenceUnitRefs(plan);
        ArrayList<DeploymentException> problems = new ArrayList<DeploymentException>();
        for (PersistenceUnitRefType persistenceUnitRef : specPersistenceUnitRefsUntyped) {
            try {
                String persistenceUnitRefName = persistenceUnitRef.getPersistenceUnitRefName().getStringValue().trim();
                this.addInjections(persistenceUnitRefName, persistenceUnitRef.getInjectionTargetArray(), componentContext);
                GerPersistenceUnitRefType gerPersistenceUnitRef = gerPersistenceUnitRefsUntyped.remove(persistenceUnitRefName);
                if (gerPersistenceUnitRef != null) {
                    persistenceUnitNameQuery = this.findPersistenceUnit(gerPersistenceUnitRef);
                    this.checkForGBean(localConfiguration, persistenceUnitNameQuery, true);
                } else if (persistenceUnitRef.isSetPersistenceUnitName() && persistenceUnitRef.getPersistenceUnitName().getStringValue().trim().length() > 0) {
                    String persistenceUnitName = persistenceUnitRef.getPersistenceUnitName().getStringValue().trim();
                    persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.singletonMap("name", persistenceUnitName), PERSISTENCE_UNIT_INTERFACE_TYPES);
                    if (!this.checkForGBean(localConfiguration, persistenceUnitNameQuery, this.strictMatching)) {
                        persistenceUnitName = "persistence/" + persistenceUnitName;
                        persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.singletonMap("name", persistenceUnitName), PERSISTENCE_UNIT_INTERFACE_TYPES);
                        this.checkForGBean(localConfiguration, persistenceUnitNameQuery, true);
                    }
                } else {
                    persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.EMPTY_MAP, PERSISTENCE_UNIT_INTERFACE_TYPES);
                    Set<AbstractNameQuery> patterns = Collections.singleton(persistenceUnitNameQuery);
                    LinkedHashSet gbeans = localConfiguration.findGBeanDatas(localConfiguration, patterns);
                    persistenceUnitNameQuery = this.checkForDefaultPersistenceUnit(gbeans);
                    if (gbeans.isEmpty()) {
                        gbeans = localConfiguration.findGBeanDatas(patterns);
                        persistenceUnitNameQuery = this.checkForDefaultPersistenceUnit(gbeans);
                        if (gbeans.isEmpty()) {
                            if (this.defaultPersistenceUnitAbstractNameQuery == null) {
                                throw new DeploymentException("No default PersistenceUnit specified, and none located");
                            }
                            persistenceUnitNameQuery = this.defaultPersistenceUnitAbstractNameQuery;
                        }
                    }
                }
                this.checkForGBean(localConfiguration, persistenceUnitNameQuery, true);
                PersistenceUnitReference reference = new PersistenceUnitReference(module.getConfigId(), persistenceUnitNameQuery);
                ((Map)NamingBuilder.JNDI_KEY.get(componentContext)).put("env/" + persistenceUnitRefName, reference);
            }
            catch (DeploymentException e) {
                problems.add(e);
            }
        }
        for (GerPersistenceUnitRefType gerPersistenceUnitRef : gerPersistenceUnitRefsUntyped.values()) {
            try {
                String PersistenceUnitRefName = gerPersistenceUnitRef.getPersistenceUnitRefName();
                persistenceUnitNameQuery = this.findPersistenceUnit(gerPersistenceUnitRef);
                this.checkForGBean(localConfiguration, persistenceUnitNameQuery, true);
                PersistenceUnitReference reference = new PersistenceUnitReference(module.getConfigId(), persistenceUnitNameQuery);
                ((Map)NamingBuilder.JNDI_KEY.get(componentContext)).put("env/" + PersistenceUnitRefName, reference);
            }
            catch (DeploymentException e) {
                problems.add(e);
            }
        }
        if (!problems.isEmpty()) {
            throw new DeploymentException("At least one deployment problem:" + problems);
        }
    }

    private AbstractNameQuery checkForDefaultPersistenceUnit(LinkedHashSet<GBeanData> gbeans) throws DeploymentException {
        AbstractNameQuery persistenceUnitNameQuery = null;
        Iterator it = gbeans.iterator();
        while (it.hasNext()) {
            GBeanData gbean = (GBeanData)it.next();
            AbstractName name = gbean.getAbstractName();
            Map nameMap = name.getName();
            if ("cmp".equals(nameMap.get("name"))) {
                it.remove();
                continue;
            }
            persistenceUnitNameQuery = new AbstractNameQuery(name);
        }
        if (gbeans.size() > 1) {
            throw new DeploymentException("Too many matches for no-name persistence unit: " + gbeans);
        }
        return persistenceUnitNameQuery;
    }

    private boolean checkForGBean(Configuration localConfiguration, AbstractNameQuery persistenceUnitNameQuery, boolean complainIfMissing) throws DeploymentException {
        try {
            localConfiguration.findGBeanData(persistenceUnitNameQuery);
            return true;
        }
        catch (GBeanNotFoundException e) {
            if (complainIfMissing || e.hasMatches()) {
                String reason = e.hasMatches() ? "More than one GBean reference found." : "No GBean references found.";
                throw new DeploymentException("Could not resolve reference at deploy time for query " + persistenceUnitNameQuery + ". " + reason, (Throwable)e);
            }
            return false;
        }
    }

    private void processAnnotations(Module module) throws DeploymentException {
        PersistenceUnitAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder());
    }

    private AbstractNameQuery findPersistenceUnit(GerPersistenceUnitRefType gerPersistenceUnitRef) {
        AbstractNameQuery persistenceUnitNameQuery;
        if (gerPersistenceUnitRef.isSetPersistenceUnitName()) {
            String persistenceUnitName = gerPersistenceUnitRef.getPersistenceUnitName();
            persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.singletonMap("name", persistenceUnitName), PERSISTENCE_UNIT_INTERFACE_TYPES);
        } else {
            GerPatternType gbeanLocator = gerPersistenceUnitRef.getPattern();
            persistenceUnitNameQuery = PersistenceUnitRefBuilder.buildAbstractNameQuery((GerPatternType)gbeanLocator, null, null, (Set)PERSISTENCE_UNIT_INTERFACE_TYPES);
        }
        return persistenceUnitNameQuery;
    }

    public QNameSet getSpecQNameSet() {
        SchemaConversionUtils.registerNamespaceConversions(Collections.singletonMap(GER_PERSISTENCE_UNIT_REF_QNAME.getLocalPart(), new NamespaceElementConverter(GER_PERSISTENCE_UNIT_REF_QNAME.getNamespaceURI())));
        return PERSISTENCE_UNIT_REF_QNAME_SET;
    }

    public QNameSet getPlanQNameSet() {
        return GER_PERSISTENCE_UNIT_REF_QNAME_SET;
    }

    private Map<String, GerPersistenceUnitRefType> getGerPersistenceUnitRefs(XmlObject plan) throws DeploymentException {
        HashMap<String, GerPersistenceUnitRefType> map = new HashMap<String, GerPersistenceUnitRefType>();
        if (plan != null) {
            List refs = PersistenceUnitRefBuilder.convert((XmlObject[])plan.selectChildren(GER_PERSISTENCE_UNIT_REF_QNAME_SET), (NamespaceElementConverter)NAMING_CONVERTER, GerPersistenceUnitRefType.class, (SchemaType)GerPersistenceUnitRefType.type);
            for (GerPersistenceUnitRefType ref : refs) {
                map.put(ref.getPersistenceUnitRefName().trim(), ref);
            }
        }
        return map;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(PersistenceUnitRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultPersistenceUnitAbstractNameQuery", AbstractNameQuery.class, true, true);
        infoBuilder.addAttribute("strictMatching", Boolean.TYPE, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "defaultPersistenceUnitAbstractNameQuery", "strictMatching"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

