/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedEjbJar;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.openejb.EntityDeploymentGBean;
import org.apache.geronimo.openejb.MessageDrivenDeploymentGBean;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.openejb.StatefulDeploymentGBean;
import org.apache.geronimo.openejb.StatelessDeploymentGBean;
import org.apache.geronimo.openejb.deployment.EjbInterface;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.openejb.deployment.SecurityBuilder;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbGeronimoEjbJarType;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.javaee.EjbJarType;
import org.apache.geronimo.xbeans.javaee.EnterpriseBeansType;
import org.apache.geronimo.xbeans.javaee.ResourceRefType;
import org.apache.geronimo.xbeans.javaee.SessionBeanType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.SecurityIdentity;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlObject;

public class EjbDeploymentBuilder {
    private final EARContext earContext;
    private final EjbModule ejbModule;
    private final NamingBuilder namingBuilder;
    private final ResourceEnvironmentSetter resourceEnvironmentSetter;
    private final Map<String, GBeanData> gbeans = new TreeMap<String, GBeanData>();

    public EjbDeploymentBuilder(EARContext earContext, EjbModule ejbModule, NamingBuilder namingBuilder, ResourceEnvironmentSetter resourceEnvironmentSetter) {
        this.earContext = earContext;
        this.ejbModule = ejbModule;
        this.namingBuilder = namingBuilder;
        this.resourceEnvironmentSetter = resourceEnvironmentSetter;
    }

    public void initContext() throws DeploymentException {
        for (EnterpriseBean enterpriseBean : this.ejbModule.getEjbJar().getEnterpriseBeans()) {
            AbstractName abstractName = this.createEjbName(enterpriseBean);
            GBeanData gbean = null;
            if (enterpriseBean instanceof SessionBean) {
                SessionBean sessionBean = (SessionBean)enterpriseBean;
                switch (sessionBean.getSessionType()) {
                    case STATELESS: {
                        gbean = new GBeanData(abstractName, StatelessDeploymentGBean.GBEAN_INFO);
                        break;
                    }
                    case STATEFUL: {
                        gbean = new GBeanData(abstractName, StatefulDeploymentGBean.GBEAN_INFO);
                    }
                }
            } else if (enterpriseBean instanceof EntityBean) {
                gbean = new GBeanData(abstractName, EntityDeploymentGBean.GBEAN_INFO);
            } else if (enterpriseBean instanceof MessageDrivenBean) {
                gbean = new GBeanData(abstractName, MessageDrivenDeploymentGBean.GBEAN_INFO);
            }
            if (gbean == null) {
                throw new DeploymentException("Unknown enterprise bean type " + enterpriseBean.getClass().getName());
            }
            String ejbName = enterpriseBean.getEjbName();
            EjbDeployment ejbDeployment = (EjbDeployment)this.ejbModule.getOpenejbJar().getDeploymentsByEjbName().get(ejbName);
            if (ejbDeployment == null) {
                throw new DeploymentException("OpenEJB configuration not found for ejb " + ejbName);
            }
            gbean.setAttribute("deploymentId", (Object)ejbDeployment.getDeploymentId());
            gbean.setAttribute("ejbName", (Object)ejbName);
            if (enterpriseBean instanceof RemoteBean) {
                RemoteBean remoteBean = (RemoteBean)enterpriseBean;
                if (remoteBean.getRemote() != null) {
                    String remoteInterfaceName = remoteBean.getRemote();
                    EjbDeploymentBuilder.assureEJBObjectInterface(remoteInterfaceName, this.ejbModule.getClassLoader());
                    gbean.setAttribute(EjbInterface.REMOTE.getAttributeName(), (Object)remoteInterfaceName);
                    String homeInterfaceName = remoteBean.getHome();
                    EjbDeploymentBuilder.assureEJBHomeInterface(homeInterfaceName, this.ejbModule.getClassLoader());
                    gbean.setAttribute(EjbInterface.HOME.getAttributeName(), (Object)homeInterfaceName);
                }
                if (remoteBean.getLocal() != null) {
                    String localInterfaceName = remoteBean.getLocal();
                    EjbDeploymentBuilder.assureEJBLocalObjectInterface(localInterfaceName, this.ejbModule.getClassLoader());
                    gbean.setAttribute(EjbInterface.LOCAL.getAttributeName(), (Object)localInterfaceName);
                    String localHomeInterfaceName = remoteBean.getLocalHome();
                    EjbDeploymentBuilder.assureEJBLocalHomeInterface(localHomeInterfaceName, this.ejbModule.getClassLoader());
                    gbean.setAttribute(EjbInterface.LOCAL_HOME.getAttributeName(), (Object)localHomeInterfaceName);
                }
                if (enterpriseBean instanceof SessionBean && ((SessionBean)enterpriseBean).getSessionType() == SessionType.STATELESS) {
                    SessionBean statelessBean = (SessionBean)enterpriseBean;
                    gbean.setAttribute(EjbInterface.SERVICE_ENDPOINT.getAttributeName(), (Object)statelessBean.getServiceEndpoint());
                }
            }
            gbean.setReferencePattern("TrackedConnectionAssociator", new AbstractNameQuery(null, Collections.EMPTY_MAP, TrackedConnectionAssociator.class.getName()));
            gbean.setReferencePattern("OpenEjbSystem", new AbstractNameQuery(null, Collections.EMPTY_MAP, OpenEjbSystem.class.getName()));
            try {
                this.earContext.addGBean(gbean);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Could not add entity bean to context", (Throwable)e);
            }
            this.gbeans.put(ejbName, gbean);
        }
    }

    public void addEjbModuleDependency(AbstractName ejbModuleName) {
        for (GBeanData gbean : this.gbeans.values()) {
            gbean.addDependency(ejbModuleName);
        }
    }

    public ComponentPermissions buildComponentPermissions() throws DeploymentException {
        ComponentPermissions componentPermissions = new ComponentPermissions((PermissionCollection)new Permissions(), (PermissionCollection)new Permissions(), new HashMap());
        for (EnterpriseBean enterpriseBean : this.ejbModule.getEjbJar().getEnterpriseBeans()) {
            this.addSecurityData(enterpriseBean, componentPermissions);
        }
        return componentPermissions;
    }

    private void addSecurityData(EnterpriseBean enterpriseBean, ComponentPermissions componentPermissions) throws DeploymentException {
        SecurityConfiguration securityConfiguration = (SecurityConfiguration)this.earContext.getSecurityConfiguration();
        if (securityConfiguration != null) {
            String runAsName;
            SecurityIdentity securityIdentity;
            GBeanData gbean = this.getEjbGBean(enterpriseBean.getEjbName());
            if (enterpriseBean instanceof RemoteBean) {
                RemoteBean remoteBean = (RemoteBean)enterpriseBean;
                SecurityBuilder securityBuilder = new SecurityBuilder();
                Permissions permissions = new Permissions();
                securityBuilder.addToPermissions(permissions, remoteBean.getEjbName(), EjbInterface.HOME.getJaccInterfaceName(), remoteBean.getHome(), this.ejbModule.getClassLoader());
                securityBuilder.addToPermissions(permissions, remoteBean.getEjbName(), EjbInterface.REMOTE.getJaccInterfaceName(), remoteBean.getRemote(), this.ejbModule.getClassLoader());
                securityBuilder.addToPermissions(permissions, remoteBean.getEjbName(), EjbInterface.LOCAL.getJaccInterfaceName(), remoteBean.getLocal(), this.ejbModule.getClassLoader());
                securityBuilder.addToPermissions(permissions, remoteBean.getEjbName(), EjbInterface.LOCAL_HOME.getJaccInterfaceName(), remoteBean.getLocalHome(), this.ejbModule.getClassLoader());
                if (remoteBean instanceof SessionBean) {
                    securityBuilder.addToPermissions(permissions, remoteBean.getEjbName(), EjbInterface.SERVICE_ENDPOINT.getJaccInterfaceName(), ((SessionBean)remoteBean).getServiceEndpoint(), this.ejbModule.getClassLoader());
                }
                if (remoteBean.getBusinessRemote() != null && !remoteBean.getBusinessRemote().isEmpty()) {
                    for (String businessRemote : remoteBean.getBusinessRemote()) {
                        securityBuilder.addToPermissions(permissions, remoteBean.getEjbName(), EjbInterface.REMOTE.getJaccInterfaceName(), businessRemote, this.ejbModule.getClassLoader());
                    }
                    securityBuilder.addToPermissions(componentPermissions.getUncheckedPermissions(), remoteBean.getEjbName(), EjbInterface.HOME.getJaccInterfaceName(), DeploymentInfo.BusinessRemoteHome.class.getName(), this.ejbModule.getClassLoader());
                }
                if (remoteBean.getBusinessLocal() != null && !remoteBean.getBusinessLocal().isEmpty()) {
                    for (String businessLocal : remoteBean.getBusinessLocal()) {
                        securityBuilder.addToPermissions(permissions, remoteBean.getEjbName(), EjbInterface.LOCAL.getJaccInterfaceName(), businessLocal, this.ejbModule.getClassLoader());
                    }
                    securityBuilder.addToPermissions(componentPermissions.getUncheckedPermissions(), remoteBean.getEjbName(), EjbInterface.LOCAL_HOME.getJaccInterfaceName(), DeploymentInfo.BusinessLocalHome.class.getName(), this.ejbModule.getClassLoader());
                }
                String defaultRole = securityConfiguration.getDefaultRole();
                securityBuilder.addComponentPermissions(defaultRole, permissions, this.ejbModule.getEjbJar().getAssemblyDescriptor(), enterpriseBean.getEjbName(), remoteBean.getSecurityRoleRef(), componentPermissions);
            }
            if ((securityIdentity = enterpriseBean.getSecurityIdentity()) != null && securityIdentity.getRunAs() != null && (runAsName = securityIdentity.getRunAs()) != null) {
                gbean.setAttribute("runAsRole", (Object)runAsName);
            }
            gbean.setAttribute("securityEnabled", (Object)true);
            gbean.setReferencePattern("RunAsSource", this.earContext.getJaccManagerName());
        }
    }

    public void buildEnc() throws DeploymentException {
        EnterpriseBeansType enterpriseBeans;
        EjbJarType ejbJarType = (EjbJarType)this.ejbModule.getSpecDD();
        if (!ejbJarType.getMetadataComplete()) {
            this.ejbModule.setClassFinder(this.createEjbJarClassFinder(this.ejbModule));
        }
        if ((enterpriseBeans = ejbJarType.getEnterpriseBeans()) != null) {
            ResourceRefType[] resourceRefs;
            GBeanData gbean;
            String ejbName;
            for (SessionBeanType sessionBeanType : enterpriseBeans.getSessionArray()) {
                ejbName = sessionBeanType.getEjbName().getStringValue().trim();
                gbean = this.getEjbGBean(ejbName);
                resourceRefs = sessionBeanType.getResourceRefArray();
                this.addEnc(gbean, (XmlObject)sessionBeanType, resourceRefs);
            }
            for (SessionBeanType sessionBeanType : enterpriseBeans.getMessageDrivenArray()) {
                ejbName = sessionBeanType.getEjbName().getStringValue().trim();
                gbean = this.getEjbGBean(ejbName);
                resourceRefs = sessionBeanType.getResourceRefArray();
                this.addEnc(gbean, (XmlObject)sessionBeanType, resourceRefs);
            }
            for (SessionBeanType sessionBeanType : enterpriseBeans.getEntityArray()) {
                ejbName = sessionBeanType.getEjbName().getStringValue().trim();
                gbean = this.getEjbGBean(ejbName);
                resourceRefs = sessionBeanType.getResourceRefArray();
                this.addEnc(gbean, (XmlObject)sessionBeanType, resourceRefs);
            }
        }
        if (!ejbJarType.getMetadataComplete()) {
            ejbJarType.setMetadataComplete(true);
            this.ejbModule.setOriginalSpecDD(this.ejbModule.getSpecDD().toString());
        }
    }

    private void addEnc(GBeanData gbean, XmlObject xmlbeansEjb, ResourceRefType[] resourceRefs) throws DeploymentException {
        OpenejbGeronimoEjbJarType geronimoOpenejb = this.ejbModule.getVendorDD();
        HashMap<NamingBuilder.Key, AbstractName> buildingContext = new HashMap<NamingBuilder.Key, AbstractName>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, gbean.getAbstractName());
        ((AnnotatedEjbJar)this.ejbModule.getAnnotatedApp()).setBean(xmlbeansEjb);
        this.namingBuilder.buildNaming(xmlbeansEjb, (XmlObject)geronimoOpenejb, (Module)this.ejbModule, buildingContext);
        Map compContext = (Map)NamingBuilder.JNDI_KEY.get(buildingContext);
        gbean.setAttribute("componentContextMap", (Object)compContext);
        GerResourceRefType[] gerResourceRefs = null;
        if (geronimoOpenejb != null) {
            gerResourceRefs = geronimoOpenejb.getResourceRefArray();
        }
        GBeanResourceEnvironmentBuilder refBuilder = new GBeanResourceEnvironmentBuilder(gbean);
        this.resourceEnvironmentSetter.setResourceEnvironment((ResourceEnvironmentBuilder)refBuilder, (XmlObject[])resourceRefs, gerResourceRefs);
    }

    private ClassFinder createEjbJarClassFinder(EjbModule ejbModule) throws DeploymentException {
        try {
            ClassLoader classLoader = ejbModule.getEarContext().getClassLoader();
            ArrayList classes = new ArrayList();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                classes.add(classLoader.loadClass(bean.getEjbClass()));
            }
            return new ClassFinder(classes);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Unable to load bean class.", (Throwable)e);
        }
    }

    private GBeanData getEjbGBean(String ejbName) throws DeploymentException {
        GBeanData gbean = this.gbeans.get(ejbName);
        if (gbean == null) {
            throw new DeploymentException("EJB not gbean not found " + ejbName);
        }
        return gbean;
    }

    private AbstractName createEjbName(EnterpriseBean enterpriseBean) {
        String ejbName = enterpriseBean.getEjbName();
        String type = null;
        if (enterpriseBean instanceof SessionBean) {
            SessionBean sessionBean = (SessionBean)enterpriseBean;
            switch (sessionBean.getSessionType()) {
                case STATELESS: {
                    type = "StatelessSessionBean";
                    break;
                }
                case STATEFUL: {
                    type = "StatefulSessionBean";
                }
            }
        } else if (enterpriseBean instanceof EntityBean) {
            type = "EntityBean";
        } else if (enterpriseBean instanceof MessageDrivenBean) {
            type = "MessageDrivenBean";
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown enterprise bean type XXX " + enterpriseBean.getClass().getName());
        }
        return this.earContext.getNaming().createChildName(this.ejbModule.getModuleName(), ejbName, type);
    }

    private static Class assureEJBObjectInterface(String remote, ClassLoader cl) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)remote, (String)"javax.ejb.EJBObject", (String)"Remote", (ClassLoader)cl);
    }

    private static Class assureEJBHomeInterface(String home, ClassLoader cl) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)home, (String)"javax.ejb.EJBHome", (String)"Home", (ClassLoader)cl);
    }

    public static Class assureEJBLocalObjectInterface(String local, ClassLoader cl) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)local, (String)"javax.ejb.EJBLocalObject", (String)"Local", (ClassLoader)cl);
    }

    public static Class assureEJBLocalHomeInterface(String localHome, ClassLoader cl) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)localHome, (String)"javax.ejb.EJBLocalHome", (String)"LocalHome", (ClassLoader)cl);
    }
}

