/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.deployment;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.farm.config.ClusterInfo;
import org.apache.geronimo.farm.config.NodeInfo;
import org.apache.geronimo.farm.deployment.BasicClusterConfigurationController;
import org.apache.geronimo.farm.deployment.BasicConfigurationNameBuilder;
import org.apache.geronimo.farm.deployment.ClusterConfigurationStoreClient;
import org.apache.geronimo.farm.deployment.ConfigurationNameBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean(j2eeType="ConfigurationStore")
public class MasterConfigurationStore
implements ConfigurationStore {
    private static final Logger log = LoggerFactory.getLogger(MasterConfigurationStore.class);
    private final ConfigurationStore delegate;
    private final Environment defaultEnvironment;
    private final ClusterInfo clusterInfo;
    private final AbstractName clusterInfoName;
    private final ClusterConfigurationStoreClient storeDelegate;
    private final ConfigurationNameBuilder configNameBuilder;
    public static final String GBEAN_J2EE_TYPE = "ConfigurationStore";
    public static final String GBEAN_ATTR_DEFAULT_ENV = "defaultEnvironment";
    public static final String GBEAN_REF_REPOSITORY = "Repository";
    public static final String GBEAN_REF_CLUSTER_INFO = "ClusterInfo";
    public static final String GBEAN_REF_CLUSTER_CONF_STORE_CLIENT = "ClusterConfigurationStoreClient";

    public MasterConfigurationStore(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abstractName, @ParamReference(name="Repository", namingType="Repository") WritableListableRepository repository, @ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamReference(name="ClusterInfo") ClusterInfo clusterInfo, @ParamReference(name="ClusterConfigurationStoreClient") ClusterConfigurationStoreClient storeDelegate) {
        if (null == kernel) {
            throw new IllegalArgumentException("kernel is required");
        }
        if (null == objectName) {
            throw new IllegalArgumentException("objectName is required");
        }
        if (null == repository) {
            throw new IllegalArgumentException("repository is required");
        }
        if (null == defaultEnvironment) {
            throw new IllegalArgumentException("defaultEnvironment is required");
        }
        if (null == clusterInfo) {
            throw new IllegalArgumentException("clusterInfo is required");
        }
        if (null == storeDelegate) {
            throw new IllegalArgumentException("storeDelegate is required");
        }
        this.defaultEnvironment = defaultEnvironment;
        this.clusterInfo = clusterInfo;
        this.storeDelegate = storeDelegate;
        this.configNameBuilder = this.newMasterConfigurationNameBuilder();
        this.clusterInfoName = kernel.getAbstractNameFor((Object)clusterInfo);
        this.delegate = this.newConfigurationStore(kernel, objectName, abstractName, repository);
    }

    public boolean containsConfiguration(Artifact configId) {
        if (!this.configNameBuilder.isMasterConfigurationName(configId)) {
            return false;
        }
        return this.delegate.containsConfiguration(configId);
    }

    public File createNewConfigurationDir(Artifact configId) throws ConfigurationAlreadyExistsException {
        return this.delegate.createNewConfigurationDir(configId);
    }

    public void exportConfiguration(Artifact configId, OutputStream output) throws IOException, NoSuchConfigException {
        this.ensureArtifactForMasterConfiguration(configId);
        this.delegate.exportConfiguration(configId, output);
    }

    public AbstractName getAbstractName() {
        return this.delegate.getAbstractName();
    }

    public String getObjectName() {
        return this.delegate.getObjectName();
    }

    public void install(ConfigurationData configurationData) throws IOException, InvalidConfigException {
        this.storeDelegate.install(this.clusterInfo, configurationData);
        this.installSlaveConfiguration(configurationData);
        Environment environment = configurationData.getEnvironment();
        Artifact slaveConfigId = environment.getConfigId();
        Artifact masterConfigId = this.configNameBuilder.buildMasterConfigurationName(slaveConfigId);
        environment.setConfigId(masterConfigId);
        this.installMasterConfiguration(configurationData, slaveConfigId);
    }

    public boolean isInPlaceConfiguration(Artifact configId) throws NoSuchConfigException, IOException {
        this.ensureArtifactForMasterConfiguration(configId);
        return false;
    }

    public List<ConfigurationInfo> listConfigurations() {
        List configurationInfos = this.delegate.listConfigurations();
        ArrayList<ConfigurationInfo> filteredConfigurationInfos = new ArrayList<ConfigurationInfo>();
        for (ConfigurationInfo configurationInfo : configurationInfos) {
            if (!this.configNameBuilder.isMasterConfigurationName(configurationInfo.getConfigID())) continue;
            filteredConfigurationInfos.add(configurationInfo);
        }
        return filteredConfigurationInfos;
    }

    public ConfigurationData loadConfiguration(Artifact configId) throws NoSuchConfigException, IOException, InvalidConfigException {
        this.ensureArtifactForMasterConfiguration(configId);
        return this.delegate.loadConfiguration(configId);
    }

    public Set<URL> resolve(Artifact configId, String moduleName, String path) throws NoSuchConfigException, MalformedURLException {
        this.ensureArtifactForMasterConfiguration(configId);
        return this.delegate.resolve(configId, moduleName, path);
    }

    public void uninstall(Artifact configId) throws NoSuchConfigException, IOException {
        this.ensureArtifactForMasterConfiguration(configId);
        Artifact slaveConfigId = this.configNameBuilder.buildSlaveConfigurationName(configId);
        this.storeDelegate.uninstall(this.clusterInfo, slaveConfigId);
        try {
            this.delegate.uninstall(slaveConfigId);
        }
        catch (Exception e) {
            log.warn("Exception when uninstalling [" + slaveConfigId + "]", (Throwable)e);
        }
        this.delegate.uninstall(configId);
    }

    protected void ensureArtifactForMasterConfiguration(Artifact configId) throws NoSuchConfigException {
        if (!this.configNameBuilder.isMasterConfigurationName(configId)) {
            throw new NoSuchConfigException(configId);
        }
    }

    protected ConfigurationStore newConfigurationStore(Kernel kernel, String objectName, AbstractName abstractName, WritableListableRepository repository) {
        return new RepositoryConfigurationStore(kernel, objectName, abstractName, repository);
    }

    protected ConfigurationNameBuilder newMasterConfigurationNameBuilder() {
        return new BasicConfigurationNameBuilder();
    }

    protected void installMasterConfiguration(ConfigurationData configurationData, Artifact slaveConfigId) throws IOException, InvalidConfigException {
        ConfigurationData masterConfigurationData = this.buildMasterConfigurationData(configurationData, slaveConfigId);
        try {
            this.delegate.install(masterConfigurationData);
        }
        catch (Exception e) {
            this.storeDelegate.uninstall(this.clusterInfo, slaveConfigId);
            try {
                this.delegate.uninstall(slaveConfigId);
            }
            catch (NoSuchConfigException nestedE) {
                // empty catch block
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof InvalidConfigException) {
                throw (InvalidConfigException)e;
            }
            throw (IOException)new IOException("See nested").initCause(e);
        }
    }

    protected void installSlaveConfiguration(ConfigurationData configurationData) throws IOException, InvalidConfigException {
        try {
            this.delegate.install(configurationData);
        }
        catch (Exception e) {
            this.storeDelegate.uninstall(this.clusterInfo, configurationData.getId());
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof InvalidConfigException) {
                throw (InvalidConfigException)e;
            }
            throw (IOException)new IOException("See nested").initCause(e);
        }
    }

    protected ConfigurationData buildMasterConfigurationData(ConfigurationData configurationData, Artifact slaveConfigId) {
        Environment environment = this.buildEnvironment(configurationData);
        Artifact configId = environment.getConfigId();
        List<GBeanData> gbeans = this.buildControllerGBeans(configId, slaveConfigId);
        File configurationDir = this.delegate.createNewConfigurationDir(configId);
        return new ConfigurationData(ConfigurationModuleType.CAR, new LinkedHashSet(), gbeans, Collections.EMPTY_MAP, environment, configurationDir, null, configurationData.getNaming());
    }

    protected Environment buildEnvironment(ConfigurationData configurationData) {
        Environment environment = new Environment(this.defaultEnvironment);
        environment.setConfigId(configurationData.getId());
        return environment;
    }

    protected List<GBeanData> buildControllerGBeans(Artifact configId, Artifact slaveConfigId) {
        ArrayList<GBeanData> gbeans = new ArrayList<GBeanData>();
        for (NodeInfo nodeInfo : this.clusterInfo.getNodeInfos()) {
            GBeanData gbean = this.buildControllerGBean(configId, nodeInfo, slaveConfigId);
            gbeans.add(gbean);
        }
        return gbeans;
    }

    protected GBeanData buildControllerGBean(Artifact configId, NodeInfo nodeInfo, Artifact slaveConfigId) {
        AbstractName controllerName = this.buildControllerName(configId, nodeInfo);
        GBeanData gbean = new GBeanData(controllerName, BasicClusterConfigurationController.class);
        gbean.setAttribute("artifact", (Object)slaveConfigId);
        gbean.setAttribute("ignoreStartConfigurationFailureUponStart", (Object)Boolean.TRUE);
        gbean.setAttribute("nodeName", (Object)nodeInfo.getName());
        gbean.setAttribute("startConfigurationUponStart", (Object)Boolean.TRUE);
        gbean.setReferencePattern(GBEAN_REF_CLUSTER_INFO, this.clusterInfoName);
        return gbean;
    }

    protected AbstractName buildControllerName(Artifact configId, NodeInfo nodeInfo) {
        Hashtable<String, String> nameMap = new Hashtable<String, String>();
        nameMap.put("nodeName", nodeInfo.getName());
        nameMap.put("appName", configId.getArtifactId());
        return new AbstractName(configId, nameMap);
    }
}

