/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.geronimo.deployment.plugin.remote.FileUploadClient;
import org.apache.geronimo.deployment.plugin.remote.FileUploadProgress;
import org.apache.geronimo.deployment.plugin.remote.FileUploadServletClient;
import org.apache.geronimo.farm.config.ClusterInfo;
import org.apache.geronimo.farm.config.ExtendedJMXConnectorInfo;
import org.apache.geronimo.farm.config.NodeInfo;
import org.apache.geronimo.farm.deployment.ClusterConfigurationStoreClient;
import org.apache.geronimo.farm.deployment.DirectoryPackager;
import org.apache.geronimo.farm.deployment.ZipDirectoryPackager;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicClusterConfigurationStoreClient
implements ClusterConfigurationStoreClient {
    private static final Logger log = LoggerFactory.getLogger(BasicClusterConfigurationStoreClient.class);
    private static final String[] METHOD_SIGNATURE_INSTALL = new String[]{ConfigurationData.class.getName(), File.class.getName()};
    private static final String[] METHOD_SIGNATURE_UNINSTALL = new String[]{Artifact.class.getName()};
    private final AbstractNameQuery clusterConfigurationStoreNameQuery;
    private final DirectoryPackager packager;
    private final FileUploadClient fileUploadClient;
    public static final String GBEAN_ATTR_CLUSTER_CONF_STORE_NAME_QUERY = "clusterConfigurationStoreNameQuery";

    public BasicClusterConfigurationStoreClient(@ParamAttribute(name="clusterConfigurationStoreNameQuery") AbstractNameQuery clusterConfigurationStoreNameQuery) {
        if (null == clusterConfigurationStoreNameQuery) {
            throw new IllegalArgumentException("clusterConfigurationStoreNameQuery is required");
        }
        this.clusterConfigurationStoreNameQuery = clusterConfigurationStoreNameQuery;
        this.packager = this.newDirectoryPackager();
        this.fileUploadClient = this.newFileUploadClient();
    }

    @Override
    public void install(ClusterInfo clusterInfo, ConfigurationData configurationData) throws IOException, InvalidConfigException {
        Collection nodeInfos = clusterInfo.getNodeInfos();
        ArrayList<NodeInfo> installedToNodeInfos = new ArrayList<NodeInfo>();
        for (NodeInfo nodeInfo : nodeInfos) {
            try {
                this.install(nodeInfo, configurationData);
                installedToNodeInfos.add(nodeInfo);
            }
            catch (Exception e) {
                this.uninstall(clusterInfo, configurationData.getId(), installedToNodeInfos);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof InvalidConfigException) {
                    throw (InvalidConfigException)e;
                }
                throw (IOException)new IOException("See nested").initCause(e);
            }
        }
    }

    @Override
    public void uninstall(ClusterInfo clusterInfo, Artifact configId) {
        this.uninstall(clusterInfo, configId, clusterInfo.getNodeInfos());
    }

    protected void uninstall(ClusterInfo clusterInfo, Artifact configId, Collection<NodeInfo> installedToNodeInfos) {
        for (NodeInfo nodeInfo : installedToNodeInfos) {
            try {
                this.uninstall(nodeInfo, configId);
            }
            catch (Exception e) {
                log.info("Ignoring error while uninstalling [" + configId + "]from [" + nodeInfo + "]", (Throwable)e);
            }
        }
    }

    protected void install(NodeInfo nodeInfo, ConfigurationData configurationData) throws IOException {
        Kernel kernel = nodeInfo.newKernel();
        AbstractName clusterConfigurationStoreName = this.searchClusterConfigurationStore(kernel);
        File configurationDataFile = this.uploadConfiguration(kernel, nodeInfo, configurationData);
        boolean inVMCall = nodeInfo.getConnectorInfo().isLocal();
        File oldConfigurationDir = null;
        if (inVMCall) {
            oldConfigurationDir = configurationData.getConfigurationDir();
        }
        Object[] params = new Object[]{configurationData, configurationDataFile};
        try {
            kernel.invoke(clusterConfigurationStoreName, "install", params, METHOD_SIGNATURE_INSTALL);
        }
        catch (Exception e) {
            throw (IOException)new IOException("See nested").initCause(e);
        }
        finally {
            if (inVMCall) {
                configurationData.setConfigurationDir(oldConfigurationDir);
            }
        }
    }

    protected void uninstall(NodeInfo nodeInfo, Artifact configId) throws IOException {
        Kernel kernel = nodeInfo.newKernel();
        AbstractName clusterConfigurationStoreName = this.searchClusterConfigurationStore(kernel);
        Object[] params = new Object[]{configId};
        try {
            kernel.invoke(clusterConfigurationStoreName, "uninstall", params, METHOD_SIGNATURE_UNINSTALL);
        }
        catch (Exception e) {
            throw (IOException)new IOException("See nested").initCause(e);
        }
    }

    protected File uploadConfiguration(Kernel kernel, NodeInfo nodeInfo, ConfigurationData configurationData) throws IOException {
        File packedConfigurationDir = this.packager.pack(configurationData.getConfigurationDir());
        if (nodeInfo.getConnectorInfo().isLocal()) {
            return packedConfigurationDir;
        }
        URL remoteDeployUploadURL = this.fileUploadClient.getRemoteDeployUploadURL(kernel);
        ConfigurationUploadProgress configurationUploadProgress = new ConfigurationUploadProgress(configurationData);
        File[] configurationDataFiles = new File[]{packedConfigurationDir};
        ExtendedJMXConnectorInfo connectorInfo = nodeInfo.getConnectorInfo();
        this.fileUploadClient.uploadFilesToServer(remoteDeployUploadURL, connectorInfo.getUsername(), connectorInfo.getPassword(), configurationDataFiles, (FileUploadProgress)configurationUploadProgress);
        if (configurationUploadProgress.failure) {
            if (null != configurationUploadProgress.exception) {
                throw (IOException)new IOException("See nested").initCause(configurationUploadProgress.exception);
            }
            throw new IOException(configurationUploadProgress.failureMessage);
        }
        return configurationDataFiles[0];
    }

    protected DirectoryPackager newDirectoryPackager() {
        return new ZipDirectoryPackager();
    }

    protected FileUploadClient newFileUploadClient() {
        return new FileUploadServletClient();
    }

    protected AbstractName searchClusterConfigurationStore(Kernel kernel) throws IOException {
        Set clusterConfigurationStoreNames = kernel.listGBeans(this.clusterConfigurationStoreNameQuery);
        if (1 != clusterConfigurationStoreNames.size()) {
            throw new IOException("Cannot locate remote store. Found [" + clusterConfigurationStoreNames + "]");
        }
        return (AbstractName)clusterConfigurationStoreNames.iterator().next();
    }

    protected class ConfigurationUploadProgress
    implements FileUploadProgress {
        private final ConfigurationData configurationData;
        private boolean failure;
        private Exception exception;
        private String failureMessage;

        public ConfigurationUploadProgress(ConfigurationData configurationData) {
            this.configurationData = configurationData;
        }

        public void fail(String message) {
            this.failure = true;
            this.failureMessage = "Upload of configuration [" + this.configurationData.getId() + "] - [" + message + "]";
            log.error("Upload of configuration [" + this.configurationData.getId() + "] - [" + message + "]");
        }

        public void fail(Exception exception) {
            this.failure = true;
            this.exception = exception;
            log.error("Upload of configuration [" + this.configurationData.getId() + "]", (Throwable)exception);
        }

        public void updateStatus(String message) {
            log.info("Upload of configuration [" + this.configurationData.getId() + "] - [" + message + "]");
        }
    }
}

