/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.deployment;

import org.apache.geronimo.farm.config.ClusterInfo;
import org.apache.geronimo.farm.config.NodeInfo;
import org.apache.geronimo.farm.deployment.ClusterConfigurationController;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ClusterConfigurationController")
public class BasicClusterConfigurationController
implements GBeanLifecycle,
ClusterConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(BasicClusterConfigurationController.class);
    private final ClusterInfo clusterInfo;
    private final String nodeName;
    private final Artifact artifact;
    private boolean startConfigurationUponStart;
    private boolean ignoreStartConfigurationFailureUponStart;
    public static final String GBEAN_J2EE_TYPE = "ClusterConfigurationController";
    public static final String GBEAN_ATTR_NODE_NAME = "nodeName";
    public static final String GBEAN_ATTR_ARTIFACT = "artifact";
    public static final String GBEAN_ATTR_START_CONF_UPON_START = "startConfigurationUponStart";
    public static final String GBEAN_ATTR_IGNORE_START_CONF_FAIL_UPON_START = "ignoreStartConfigurationFailureUponStart";
    public static final String GBEAN_REF_CLUSTER_INFO = "ClusterInfo";

    public BasicClusterConfigurationController(@ParamReference(name="ClusterInfo") ClusterInfo clusterInfo, @ParamAttribute(name="nodeName") String nodeName, @ParamAttribute(name="artifact") Artifact artifact, @ParamAttribute(name="startConfigurationUponStart") boolean startConfigurationUponStart, @ParamAttribute(name="ignoreStartConfigurationFailureUponStart") boolean ignoreStartConfigurationFailureUponStart) {
        if (null == clusterInfo) {
            throw new IllegalArgumentException("clusterInfo is required");
        }
        if (null == nodeName) {
            throw new IllegalArgumentException("nodeName is required");
        }
        if (null == artifact) {
            throw new IllegalArgumentException("artifact is required");
        }
        this.clusterInfo = clusterInfo;
        this.nodeName = nodeName;
        this.artifact = artifact;
        this.startConfigurationUponStart = startConfigurationUponStart;
        this.ignoreStartConfigurationFailureUponStart = ignoreStartConfigurationFailureUponStart;
    }

    public void doStart() throws Exception {
        if (this.startConfigurationUponStart) {
            try {
                this.startConfiguration();
            }
            catch (Exception e) {
                if (this.ignoreStartConfigurationFailureUponStart) {
                    log.info("Exception while starting configuration [" + this.artifact + "] on [" + this.nodeName + "]. Ignoring.", (Throwable)e);
                }
                log.error("Exception while starting configuration [" + this.artifact + "] on [" + this.nodeName + "].", (Throwable)e);
                throw e;
            }
        }
    }

    public void doFail() {
        try {
            this.stopConfiguration();
        }
        catch (Exception e) {
            log.error("Exception while stopping configuration [" + this.artifact + "] on [" + this.nodeName + "].", (Throwable)e);
        }
    }

    public void doStop() throws Exception {
        try {
            this.stopConfiguration();
        }
        catch (Exception e) {
            log.error("Exception while stopping configuration [" + this.artifact + "] on [" + this.nodeName + "].", (Throwable)e);
            throw e;
        }
    }

    public void startConfiguration() throws Exception {
        for (NodeInfo nodeInfo : this.clusterInfo.getNodeInfos()) {
            if (!nodeInfo.getName().equals(this.nodeName)) continue;
            Kernel kernel = nodeInfo.newKernel();
            ConfigurationManager configurationManager = this.newConfigurationManager(kernel);
            if (!configurationManager.isLoaded(this.artifact)) {
                configurationManager.loadConfiguration(this.artifact);
            }
            configurationManager.startConfiguration(this.artifact);
        }
    }

    public void stopConfiguration() throws Exception {
        for (NodeInfo nodeInfo : this.clusterInfo.getNodeInfos()) {
            if (!nodeInfo.getName().equals(this.nodeName)) continue;
            Kernel kernel = nodeInfo.newKernel();
            ConfigurationManager configurationManager = this.newConfigurationManager(kernel);
            configurationManager.stopConfiguration(this.artifact);
        }
    }

    protected ConfigurationManager newConfigurationManager(Kernel kernel) {
        return ConfigurationUtil.getConfigurationManager((Kernel)kernel);
    }
}

