/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import org.apache.geronimo.clustering.AbstractNode;
import org.apache.geronimo.clustering.wadi.NodeConnectionInfo;
import org.apache.geronimo.clustering.wadi.NodeService;
import org.codehaus.wadi.group.Peer;

public class RemoteNode
extends AbstractNode {
    private static final String ADAPTOR_KEY = "ADAPTOR_KEY";
    private final Peer peer;
    private final NodeService nodeService;
    private NodeConnectionInfo connectionInfo;

    public static RemoteNode retrieveOptionalAdaptor(Peer peer) {
        return (RemoteNode)((Object)peer.getLocalStateMap().get(ADAPTOR_KEY));
    }

    public static RemoteNode retrieveAdaptor(Peer peer) {
        RemoteNode node = (RemoteNode)((Object)peer.getLocalStateMap().get(ADAPTOR_KEY));
        if (null == node) {
            throw new IllegalStateException("No registered adaptor");
        }
        return node;
    }

    public RemoteNode(Peer peer, NodeService nodeService) {
        super(peer.getName());
        if (null == nodeService) {
            throw new IllegalArgumentException("nodeService is required");
        }
        this.peer = peer;
        this.nodeService = nodeService;
        peer.getLocalStateMap().put(ADAPTOR_KEY, this);
    }

    public Peer getPeer() {
        return this.peer;
    }

    protected String getHost() {
        if (null == this.connectionInfo) {
            this.connectionInfo = this.nodeService.getConnectionInfo();
        }
        return this.connectionInfo.getHost();
    }

    protected int getPort() {
        if (null == this.connectionInfo) {
            this.connectionInfo = this.nodeService.getConnectionInfo();
        }
        return this.connectionInfo.getPort();
    }
}

